/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.os.Build;
import android.os.LocaleList;
import androidx.annotation.DoNotInline;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.Size;
import androidx.core.os.LocaleListCompatWrapper;
import androidx.core.os.LocaleListInterface;
import androidx.core.os.LocaleListPlatformWrapper;
import androidx.core.text.ICUCompat;
import java.util.Locale;

public final class LocaleListCompat {
    private static final LocaleListCompat sEmptyLocaleList = LocaleListCompat.create(new Locale[0]);
    private final LocaleListInterface mImpl;

    private LocaleListCompat(LocaleListInterface impl) {
        this.mImpl = impl;
    }

    @Deprecated
    @RequiresApi(value=24)
    public static LocaleListCompat wrap(Object localeList) {
        return LocaleListCompat.wrap((LocaleList)localeList);
    }

    @RequiresApi(value=24)
    @NonNull
    public static LocaleListCompat wrap(@NonNull LocaleList localeList) {
        return new LocaleListCompat(new LocaleListPlatformWrapper(localeList));
    }

    @Nullable
    public Object unwrap() {
        return this.mImpl.getLocaleList();
    }

    @NonNull
    public static LocaleListCompat create(Locale ... localeList) {
        if (Build.VERSION.SDK_INT >= 24) {
            return LocaleListCompat.wrap(Api24Impl.createLocaleList(localeList));
        }
        return new LocaleListCompat(new LocaleListCompatWrapper(localeList));
    }

    @Nullable
    public Locale get(int index) {
        return this.mImpl.get(index);
    }

    public boolean isEmpty() {
        return this.mImpl.isEmpty();
    }

    @IntRange(from=0L)
    public int size() {
        return this.mImpl.size();
    }

    @IntRange(from=-1L)
    public int indexOf(@Nullable Locale locale) {
        return this.mImpl.indexOf(locale);
    }

    @NonNull
    public String toLanguageTags() {
        return this.mImpl.toLanguageTags();
    }

    @Nullable
    public Locale getFirstMatch(@NonNull String[] supportedLocales) {
        return this.mImpl.getFirstMatch(supportedLocales);
    }

    @NonNull
    public static LocaleListCompat getEmptyLocaleList() {
        return sEmptyLocaleList;
    }

    @NonNull
    public static LocaleListCompat forLanguageTags(@Nullable String list) {
        if (list == null || list.isEmpty()) {
            return LocaleListCompat.getEmptyLocaleList();
        }
        String[] tags = list.split(",", -1);
        Locale[] localeArray = new Locale[tags.length];
        for (int i = 0; i < localeArray.length; ++i) {
            localeArray[i] = Build.VERSION.SDK_INT >= 21 ? Api21Impl.forLanguageTag(tags[i]) : LocaleListCompat.forLanguageTagCompat(tags[i]);
        }
        return LocaleListCompat.create(localeArray);
    }

    static Locale forLanguageTagCompat(String str) {
        if (str.contains("-")) {
            String[] args2 = str.split("-", -1);
            if (args2.length > 2) {
                return new Locale(args2[0], args2[1], args2[2]);
            }
            if (args2.length > 1) {
                return new Locale(args2[0], args2[1]);
            }
            if (args2.length == 1) {
                return new Locale(args2[0]);
            }
        } else if (str.contains("_")) {
            String[] args3 = str.split("_", -1);
            if (args3.length > 2) {
                return new Locale(args3[0], args3[1], args3[2]);
            }
            if (args3.length > 1) {
                return new Locale(args3[0], args3[1]);
            }
            if (args3.length == 1) {
                return new Locale(args3[0]);
            }
        } else {
            return new Locale(str);
        }
        throw new IllegalArgumentException("Can not parse language tag: [" + str + "]");
    }

    @NonNull
    @Size(min=1L)
    public static LocaleListCompat getAdjustedDefault() {
        if (Build.VERSION.SDK_INT >= 24) {
            return LocaleListCompat.wrap(Api24Impl.getAdjustedDefault());
        }
        return LocaleListCompat.create(Locale.getDefault());
    }

    @NonNull
    @Size(min=1L)
    public static LocaleListCompat getDefault() {
        if (Build.VERSION.SDK_INT >= 24) {
            return LocaleListCompat.wrap(Api24Impl.getDefault());
        }
        return LocaleListCompat.create(Locale.getDefault());
    }

    @RequiresApi(value=21)
    public static boolean matchesLanguageAndScript(@NonNull Locale supported, @NonNull Locale desired) {
        if (Build.VERSION.SDK_INT >= 33) {
            return LocaleList.matchesLanguageAndScript((Locale)supported, (Locale)desired);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            return Api21Impl.matchesLanguageAndScript(supported, desired);
        }
        throw new UnsupportedOperationException("This method is only supported on API level 21+");
    }

    public boolean equals(Object other) {
        return other instanceof LocaleListCompat && this.mImpl.equals(((LocaleListCompat)other).mImpl);
    }

    public int hashCode() {
        return this.mImpl.hashCode();
    }

    @NonNull
    public String toString() {
        return this.mImpl.toString();
    }

    @RequiresApi(value=24)
    static class Api24Impl {
        private Api24Impl() {
        }

        @DoNotInline
        static LocaleList createLocaleList(Locale ... list) {
            return new LocaleList(list);
        }

        @DoNotInline
        static LocaleList getAdjustedDefault() {
            return LocaleList.getAdjustedDefault();
        }

        @DoNotInline
        static LocaleList getDefault() {
            return LocaleList.getDefault();
        }
    }

    @RequiresApi(value=21)
    static class Api21Impl {
        private static final Locale[] PSEUDO_LOCALE = new Locale[]{new Locale("en", "XA"), new Locale("ar", "XB")};

        private Api21Impl() {
        }

        @DoNotInline
        static boolean matchesLanguageAndScript(@NonNull Locale supported, @NonNull Locale desired) {
            if (supported.equals(desired)) {
                return true;
            }
            if (!supported.getLanguage().equals(desired.getLanguage())) {
                return false;
            }
            if (Api21Impl.isPseudoLocale(supported) || Api21Impl.isPseudoLocale(desired)) {
                return false;
            }
            String supportedScr = ICUCompat.maximizeAndGetScript(supported);
            if (supportedScr.isEmpty()) {
                String supportedRegion = supported.getCountry();
                return supportedRegion.isEmpty() || supportedRegion.equals(desired.getCountry());
            }
            String desiredScr = ICUCompat.maximizeAndGetScript(desired);
            return supportedScr.equals(desiredScr);
        }

        private static boolean isPseudoLocale(Locale locale) {
            for (Locale pseudoLocale : PSEUDO_LOCALE) {
                if (!pseudoLocale.equals(locale)) continue;
                return true;
            }
            return false;
        }

        @DoNotInline
        static Locale forLanguageTag(String languageTag) {
            return Locale.forLanguageTag(languageTag);
        }
    }
}

