/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.provider;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Typeface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.LruCache;
import androidx.collection.SimpleArrayMap;
import androidx.core.graphics.TypefaceCompat;
import androidx.core.provider.CallbackWithHandler;
import androidx.core.provider.FontProvider;
import androidx.core.provider.FontRequest;
import androidx.core.provider.FontsContractCompat;
import androidx.core.provider.RequestExecutor;
import androidx.core.util.Consumer;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

class FontRequestWorker {
    static final LruCache<String, Typeface> sTypefaceCache = new LruCache(16);
    private static final ExecutorService DEFAULT_EXECUTOR_SERVICE = RequestExecutor.createDefaultExecutor("fonts-androidx", 10, 10000);
    static final Object LOCK = new Object();
    @GuardedBy(value="LOCK")
    static final SimpleArrayMap<String, ArrayList<Consumer<TypefaceResult>>> PENDING_REPLIES = new SimpleArrayMap();

    private FontRequestWorker() {
    }

    static void resetTypefaceCache() {
        sTypefaceCache.evictAll();
    }

    static Typeface requestFontSync(final @NonNull Context context, final @NonNull FontRequest request, @NonNull CallbackWithHandler callback2, final int style2, int timeoutInMillis) {
        final String id2 = FontRequestWorker.createCacheId(request, style2);
        Typeface cached = sTypefaceCache.get(id2);
        if (cached != null) {
            callback2.onTypefaceResult(new TypefaceResult(cached));
            return cached;
        }
        if (timeoutInMillis == -1) {
            TypefaceResult typefaceResult = FontRequestWorker.getFontSync(id2, context, request, style2);
            callback2.onTypefaceResult(typefaceResult);
            return typefaceResult.mTypeface;
        }
        Callable<TypefaceResult> fetcher = new Callable<TypefaceResult>(){

            @Override
            public TypefaceResult call() {
                return FontRequestWorker.getFontSync(id2, context, request, style2);
            }
        };
        try {
            TypefaceResult typefaceResult = RequestExecutor.submit(DEFAULT_EXECUTOR_SERVICE, fetcher, timeoutInMillis);
            callback2.onTypefaceResult(typefaceResult);
            return typefaceResult.mTypeface;
        }
        catch (InterruptedException e) {
            callback2.onTypefaceResult(new TypefaceResult(-3));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Typeface requestFontAsync(final @NonNull Context context, final @NonNull FontRequest request, final int style2, @Nullable Executor executor, final @NonNull CallbackWithHandler callback2) {
        final String id2 = FontRequestWorker.createCacheId(request, style2);
        Typeface cached = sTypefaceCache.get(id2);
        if (cached != null) {
            callback2.onTypefaceResult(new TypefaceResult(cached));
            return cached;
        }
        Consumer<TypefaceResult> reply = new Consumer<TypefaceResult>(){

            @Override
            public void accept(TypefaceResult typefaceResult) {
                if (typefaceResult == null) {
                    typefaceResult = new TypefaceResult(-3);
                }
                callback2.onTypefaceResult(typefaceResult);
            }
        };
        Object object = LOCK;
        synchronized (object) {
            ArrayList<Consumer<TypefaceResult>> pendingReplies = PENDING_REPLIES.get(id2);
            if (pendingReplies != null) {
                pendingReplies.add(reply);
                return null;
            }
            pendingReplies = new ArrayList();
            pendingReplies.add(reply);
            PENDING_REPLIES.put(id2, pendingReplies);
        }
        Callable<TypefaceResult> fetcher = new Callable<TypefaceResult>(){

            @Override
            public TypefaceResult call() {
                try {
                    return FontRequestWorker.getFontSync(id2, context, request, style2);
                }
                catch (Throwable t) {
                    return new TypefaceResult(-3);
                }
            }
        };
        Executor finalExecutor = executor == null ? DEFAULT_EXECUTOR_SERVICE : executor;
        RequestExecutor.execute(finalExecutor, fetcher, new Consumer<TypefaceResult>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(TypefaceResult typefaceResult) {
                ArrayList<Consumer<TypefaceResult>> replies;
                Object object = LOCK;
                synchronized (object) {
                    replies = PENDING_REPLIES.get(id2);
                    if (replies == null) {
                        return;
                    }
                    PENDING_REPLIES.remove(id2);
                }
                for (int i = 0; i < replies.size(); ++i) {
                    replies.get(i).accept(typefaceResult);
                }
            }
        });
        return null;
    }

    private static String createCacheId(@NonNull FontRequest request, int style2) {
        return request.getId() + "-" + style2;
    }

    @NonNull
    static TypefaceResult getFontSync(@NonNull String cacheId, @NonNull Context context, @NonNull FontRequest request, int style2) {
        FontsContractCompat.FontFamilyResult result2;
        Typeface cached = sTypefaceCache.get(cacheId);
        if (cached != null) {
            return new TypefaceResult(cached);
        }
        try {
            result2 = FontProvider.getFontFamilyResult(context, request, null);
        }
        catch (PackageManager.NameNotFoundException e) {
            return new TypefaceResult(-1);
        }
        int fontFamilyResultStatus = FontRequestWorker.getFontFamilyResultStatus(result2);
        if (fontFamilyResultStatus != 0) {
            return new TypefaceResult(fontFamilyResultStatus);
        }
        Typeface typeface = TypefaceCompat.createFromFontInfo(context, null, result2.getFonts(), style2);
        if (typeface != null) {
            sTypefaceCache.put(cacheId, typeface);
            return new TypefaceResult(typeface);
        }
        return new TypefaceResult(-3);
    }

    @SuppressLint(value={"WrongConstant"})
    private static int getFontFamilyResultStatus(@NonNull FontsContractCompat.FontFamilyResult fontFamilyResult) {
        if (fontFamilyResult.getStatusCode() != 0) {
            switch (fontFamilyResult.getStatusCode()) {
                case 1: {
                    return -2;
                }
            }
            return -3;
        }
        FontsContractCompat.FontInfo[] fonts = fontFamilyResult.getFonts();
        if (fonts == null || fonts.length == 0) {
            return 1;
        }
        for (FontsContractCompat.FontInfo font : fonts) {
            int resultCode = font.getResultCode();
            if (resultCode == 0) continue;
            return resultCode < 0 ? -3 : resultCode;
        }
        return 0;
    }

    static final class TypefaceResult {
        final Typeface mTypeface;
        final int mResult;

        TypefaceResult(int result2) {
            this.mTypeface = null;
            this.mResult = result2;
        }

        @SuppressLint(value={"WrongConstant"})
        TypefaceResult(@NonNull Typeface typeface) {
            this.mTypeface = typeface;
            this.mResult = 0;
        }

        @SuppressLint(value={"WrongConstant"})
        boolean isSuccess() {
            return this.mResult == 0;
        }
    }
}

