/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.text;

import android.annotation.SuppressLint;
import android.icu.util.ULocale;
import android.os.Build;
import android.util.Log;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;

public final class ICUCompat {
    private static final String TAG = "ICUCompat";
    private static Method sGetScriptMethod;
    private static Method sAddLikelySubtagsMethod;

    @Nullable
    public static String maximizeAndGetScript(@NonNull Locale locale) {
        if (Build.VERSION.SDK_INT >= 24) {
            ULocale uLocale = Api24Impl.addLikelySubtags(Api24Impl.forLocale(locale));
            return Api24Impl.getScript(uLocale);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                Object[] args2 = new Object[]{locale};
                return Api21Impl.getScript((Locale)sAddLikelySubtagsMethod.invoke(null, args2));
            }
            catch (InvocationTargetException e) {
                Log.w((String)TAG, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                Log.w((String)TAG, (Throwable)e);
            }
            return Api21Impl.getScript(locale);
        }
        String localeWithSubtags = ICUCompat.addLikelySubtagsBelowApi21(locale);
        if (localeWithSubtags != null) {
            return ICUCompat.getScriptBelowApi21(localeWithSubtags);
        }
        return null;
    }

    @SuppressLint(value={"BanUncheckedReflection"})
    private static String getScriptBelowApi21(String localeStr) {
        try {
            if (sGetScriptMethod != null) {
                Object[] args2 = new Object[]{localeStr};
                return (String)sGetScriptMethod.invoke(null, args2);
            }
        }
        catch (IllegalAccessException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        return null;
    }

    @SuppressLint(value={"BanUncheckedReflection"})
    private static String addLikelySubtagsBelowApi21(Locale locale) {
        String localeStr = locale.toString();
        try {
            if (sAddLikelySubtagsMethod != null) {
                Object[] args2 = new Object[]{localeStr};
                return (String)sAddLikelySubtagsMethod.invoke(null, args2);
            }
        }
        catch (IllegalAccessException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        return localeStr;
    }

    private ICUCompat() {
    }

    static {
        if (Build.VERSION.SDK_INT < 21) {
            try {
                Class<?> clazz = Class.forName("libcore.icu.ICU");
                sGetScriptMethod = clazz.getMethod("getScript", String.class);
                sAddLikelySubtagsMethod = clazz.getMethod("addLikelySubtags", String.class);
            }
            catch (Exception e) {
                sGetScriptMethod = null;
                sAddLikelySubtagsMethod = null;
                Log.w((String)TAG, (Throwable)e);
            }
        } else if (Build.VERSION.SDK_INT < 24) {
            try {
                Class<?> clazz = Class.forName("libcore.icu.ICU");
                sAddLikelySubtagsMethod = clazz.getMethod("addLikelySubtags", Locale.class);
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @RequiresApi(value=24)
    static class Api24Impl {
        private Api24Impl() {
        }

        @DoNotInline
        static ULocale forLocale(Locale loc) {
            return ULocale.forLocale((Locale)loc);
        }

        @DoNotInline
        static ULocale addLikelySubtags(Object loc) {
            return ULocale.addLikelySubtags((ULocale)((ULocale)loc));
        }

        @DoNotInline
        static String getScript(Object uLocale) {
            return ((ULocale)uLocale).getScript();
        }
    }

    @RequiresApi(value=21)
    static class Api21Impl {
        private Api21Impl() {
        }

        @DoNotInline
        static String getScript(Locale locale) {
            return locale.getScript();
        }
    }
}

