/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.text.method;

import android.text.Layout;
import android.text.Selection;
import android.text.Spannable;
import android.text.method.LinkMovementMethod;
import android.text.method.Touch;
import android.view.MotionEvent;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.core.os.BuildCompat;

public class LinkMovementMethodCompat
extends LinkMovementMethod {
    private static LinkMovementMethodCompat sInstance;

    private LinkMovementMethodCompat() {
    }

    @OptIn(markerClass={BuildCompat.PrereleaseSdkCheck.class})
    public boolean onTouchEvent(@Nullable TextView widget, @Nullable Spannable buffer, @Nullable MotionEvent event) {
        int action;
        if (!(BuildCompat.isAtLeastV() || (action = event.getAction()) != 1 && action != 0)) {
            boolean isOutOfLineBounds;
            int x = (int)event.getX();
            int y = (int)event.getY();
            x -= widget.getTotalPaddingLeft();
            y -= widget.getTotalPaddingTop();
            x += widget.getScrollX();
            Layout layout2 = widget.getLayout();
            if ((y += widget.getScrollY()) < 0 || y > layout2.getHeight()) {
                isOutOfLineBounds = true;
            } else {
                int line = layout2.getLineForVertical(y);
                boolean bl = isOutOfLineBounds = (float)x < layout2.getLineLeft(line) || (float)x > layout2.getLineRight(line);
            }
            if (isOutOfLineBounds) {
                Selection.removeSelection((Spannable)buffer);
                return Touch.onTouchEvent((TextView)widget, (Spannable)buffer, (MotionEvent)event);
            }
        }
        return super.onTouchEvent(widget, buffer, event);
    }

    @NonNull
    public static LinkMovementMethodCompat getInstance() {
        if (sInstance == null) {
            sInstance = new LinkMovementMethodCompat();
        }
        return sInstance;
    }
}

