/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.text.util;

import android.os.Build;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.method.LinkMovementMethod;
import android.text.method.MovementMethod;
import android.text.style.URLSpan;
import android.text.util.Linkify;
import android.webkit.WebView;
import android.widget.TextView;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.text.util.FindAddress;
import androidx.core.util.PatternsCompat;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class LinkifyCompat {
    private static final String[] EMPTY_STRING = new String[0];
    private static final Comparator<LinkSpec> COMPARATOR = (a, b) -> {
        if (a.start < b.start) {
            return -1;
        }
        if (a.start > b.start) {
            return 1;
        }
        return Integer.compare(b.end, a.end);
    };

    public static boolean addLinks(@NonNull Spannable text, int mask) {
        if (LinkifyCompat.shouldAddLinksFallbackToFramework()) {
            return Linkify.addLinks((Spannable)text, (int)mask);
        }
        if (mask == 0) {
            return false;
        }
        URLSpan[] old = (URLSpan[])text.getSpans(0, text.length(), URLSpan.class);
        for (int i = old.length - 1; i >= 0; --i) {
            text.removeSpan((Object)old[i]);
        }
        if ((mask & 4) != 0) {
            Linkify.addLinks((Spannable)text, (int)4);
        }
        ArrayList<LinkSpec> links = new ArrayList<LinkSpec>();
        if ((mask & 1) != 0) {
            LinkifyCompat.gatherLinks(links, text, PatternsCompat.AUTOLINK_WEB_URL, new String[]{"http://", "https://", "rtsp://"}, Linkify.sUrlMatchFilter, null);
        }
        if ((mask & 2) != 0) {
            LinkifyCompat.gatherLinks(links, text, PatternsCompat.AUTOLINK_EMAIL_ADDRESS, new String[]{"mailto:"}, null, null);
        }
        if ((mask & 8) != 0) {
            LinkifyCompat.gatherMapLinks(links, text);
        }
        LinkifyCompat.pruneOverlaps(links, text);
        if (links.size() == 0) {
            return false;
        }
        for (LinkSpec link : links) {
            if (link.frameworkAddedSpan != null) continue;
            LinkifyCompat.applyLink(link.url, link.start, link.end, text);
        }
        return true;
    }

    public static boolean addLinks(@NonNull TextView text, int mask) {
        if (LinkifyCompat.shouldAddLinksFallbackToFramework()) {
            return Linkify.addLinks((TextView)text, (int)mask);
        }
        if (mask == 0) {
            return false;
        }
        CharSequence t = text.getText();
        if (t instanceof Spannable) {
            if (LinkifyCompat.addLinks((Spannable)t, mask)) {
                LinkifyCompat.addLinkMovementMethod(text);
                return true;
            }
        } else {
            SpannableString s = SpannableString.valueOf((CharSequence)t);
            if (LinkifyCompat.addLinks((Spannable)s, mask)) {
                LinkifyCompat.addLinkMovementMethod(text);
                text.setText((CharSequence)s);
                return true;
            }
        }
        return false;
    }

    public static void addLinks(@NonNull TextView text, @NonNull Pattern pattern, @Nullable String scheme) {
        if (LinkifyCompat.shouldAddLinksFallbackToFramework()) {
            Linkify.addLinks((TextView)text, (Pattern)pattern, (String)scheme);
            return;
        }
        LinkifyCompat.addLinks(text, pattern, scheme, null, null, null);
    }

    public static void addLinks(@NonNull TextView text, @NonNull Pattern pattern, @Nullable String scheme, @Nullable Linkify.MatchFilter matchFilter, @Nullable Linkify.TransformFilter transformFilter) {
        if (LinkifyCompat.shouldAddLinksFallbackToFramework()) {
            Linkify.addLinks((TextView)text, (Pattern)pattern, (String)scheme, (Linkify.MatchFilter)matchFilter, (Linkify.TransformFilter)transformFilter);
            return;
        }
        LinkifyCompat.addLinks(text, pattern, scheme, null, matchFilter, transformFilter);
    }

    public static void addLinks(@NonNull TextView text, @NonNull Pattern pattern, @Nullable String defaultScheme, @Nullable String[] schemes, @Nullable Linkify.MatchFilter matchFilter, @Nullable Linkify.TransformFilter transformFilter) {
        if (LinkifyCompat.shouldAddLinksFallbackToFramework()) {
            Api24Impl.addLinks(text, pattern, defaultScheme, schemes, matchFilter, transformFilter);
            return;
        }
        SpannableString spannable = SpannableString.valueOf((CharSequence)text.getText());
        boolean linksAdded = LinkifyCompat.addLinks((Spannable)spannable, pattern, defaultScheme, schemes, matchFilter, transformFilter);
        if (linksAdded) {
            text.setText((CharSequence)spannable);
            LinkifyCompat.addLinkMovementMethod(text);
        }
    }

    public static boolean addLinks(@NonNull Spannable text, @NonNull Pattern pattern, @Nullable String scheme) {
        if (LinkifyCompat.shouldAddLinksFallbackToFramework()) {
            return Linkify.addLinks((Spannable)text, (Pattern)pattern, (String)scheme);
        }
        return LinkifyCompat.addLinks(text, pattern, scheme, null, null, null);
    }

    public static boolean addLinks(@NonNull Spannable spannable, @NonNull Pattern pattern, @Nullable String scheme, @Nullable Linkify.MatchFilter matchFilter, @Nullable Linkify.TransformFilter transformFilter) {
        if (LinkifyCompat.shouldAddLinksFallbackToFramework()) {
            return Linkify.addLinks((Spannable)spannable, (Pattern)pattern, (String)scheme, (Linkify.MatchFilter)matchFilter, (Linkify.TransformFilter)transformFilter);
        }
        return LinkifyCompat.addLinks(spannable, pattern, scheme, null, matchFilter, transformFilter);
    }

    public static boolean addLinks(@NonNull Spannable spannable, @NonNull Pattern pattern, @Nullable String defaultScheme, @Nullable String[] schemes, @Nullable Linkify.MatchFilter matchFilter, @Nullable Linkify.TransformFilter transformFilter) {
        if (LinkifyCompat.shouldAddLinksFallbackToFramework()) {
            return Api24Impl.addLinks(spannable, pattern, defaultScheme, schemes, matchFilter, transformFilter);
        }
        if (defaultScheme == null) {
            defaultScheme = "";
        }
        if (schemes == null || schemes.length < 1) {
            schemes = EMPTY_STRING;
        }
        String[] schemesCopy = new String[schemes.length + 1];
        schemesCopy[0] = defaultScheme.toLowerCase(Locale.ROOT);
        for (int index = 0; index < schemes.length; ++index) {
            String scheme = schemes[index];
            schemesCopy[index + 1] = scheme == null ? "" : scheme.toLowerCase(Locale.ROOT);
        }
        boolean hasMatches = false;
        Matcher m = pattern.matcher((CharSequence)spannable);
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            String match = m.group(0);
            boolean allowed = true;
            if (matchFilter != null) {
                allowed = matchFilter.acceptMatch((CharSequence)spannable, start, end);
            }
            if (!allowed || match == null) continue;
            String url = LinkifyCompat.makeUrl(match, schemesCopy, m, transformFilter);
            LinkifyCompat.applyLink(url, start, end, spannable);
            hasMatches = true;
        }
        return hasMatches;
    }

    private static boolean shouldAddLinksFallbackToFramework() {
        return Build.VERSION.SDK_INT >= 28;
    }

    private static void addLinkMovementMethod(@NonNull TextView t) {
        MovementMethod m = t.getMovementMethod();
        if (!(m instanceof LinkMovementMethod) && t.getLinksClickable()) {
            t.setMovementMethod(LinkMovementMethod.getInstance());
        }
    }

    private static String makeUrl(@NonNull String url, @NonNull String[] prefixes, Matcher matcher, @Nullable Linkify.TransformFilter filter2) {
        if (filter2 != null) {
            url = filter2.transformUrl(matcher, url);
        }
        boolean hasPrefix = false;
        for (String prefix : prefixes) {
            if (!url.regionMatches(true, 0, prefix, 0, prefix.length())) continue;
            hasPrefix = true;
            if (url.regionMatches(false, 0, prefix, 0, prefix.length())) break;
            url = prefix + url.substring(prefix.length());
            break;
        }
        if (!hasPrefix && prefixes.length > 0) {
            url = prefixes[0] + url;
        }
        return url;
    }

    private static void gatherLinks(ArrayList<LinkSpec> links, Spannable s, Pattern pattern, String[] schemes, Linkify.MatchFilter matchFilter, Linkify.TransformFilter transformFilter) {
        Matcher m = pattern.matcher((CharSequence)s);
        while (m.find()) {
            int start = m.start();
            int end = m.end();
            String match = m.group(0);
            if (matchFilter != null && !matchFilter.acceptMatch((CharSequence)s, start, end) || match == null) continue;
            LinkSpec spec = new LinkSpec();
            spec.url = LinkifyCompat.makeUrl(match, schemes, m, transformFilter);
            spec.start = start;
            spec.end = end;
            links.add(spec);
        }
    }

    private static void applyLink(String url, int start, int end, Spannable text) {
        URLSpan span = new URLSpan(url);
        text.setSpan((Object)span, start, end, 33);
    }

    private static void gatherMapLinks(ArrayList<LinkSpec> links, Spannable s) {
        String string2 = s.toString();
        int base = 0;
        try {
            int start;
            String address;
            while ((address = LinkifyCompat.findAddress(string2)) != null && (start = string2.indexOf(address)) >= 0) {
                String encodedAddress;
                LinkSpec spec = new LinkSpec();
                int length = address.length();
                int end = start + length;
                spec.start = base + start;
                spec.end = base + end;
                string2 = string2.substring(end);
                base += end;
                try {
                    encodedAddress = URLEncoder.encode(address, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    continue;
                }
                spec.url = "geo:0,0?q=" + encodedAddress;
                links.add(spec);
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    private static String findAddress(String addr) {
        if (Build.VERSION.SDK_INT >= 28) {
            return WebView.findAddress((String)addr);
        }
        return FindAddress.findAddress(addr);
    }

    private static void pruneOverlaps(ArrayList<LinkSpec> links, Spannable text) {
        URLSpan[] urlSpans;
        for (URLSpan urlSpan : urlSpans = (URLSpan[])text.getSpans(0, text.length(), URLSpan.class)) {
            LinkSpec spec = new LinkSpec();
            spec.frameworkAddedSpan = urlSpan;
            spec.start = text.getSpanStart((Object)urlSpan);
            spec.end = text.getSpanEnd((Object)urlSpan);
            links.add(spec);
        }
        Collections.sort(links, COMPARATOR);
        int len = links.size();
        int i = 0;
        while (i < len - 1) {
            LinkSpec a = links.get(i);
            LinkSpec b = links.get(i + 1);
            int remove = -1;
            if (a.start <= b.start && a.end > b.start) {
                if (b.end <= a.end) {
                    remove = i + 1;
                } else if (a.end - a.start > b.end - b.start) {
                    remove = i + 1;
                } else if (a.end - a.start < b.end - b.start) {
                    remove = i;
                }
                if (remove != -1) {
                    URLSpan span = links.get((int)remove).frameworkAddedSpan;
                    if (span != null) {
                        text.removeSpan((Object)span);
                    }
                    links.remove(remove);
                    --len;
                    continue;
                }
            }
            ++i;
        }
    }

    private LinkifyCompat() {
    }

    private static class LinkSpec {
        URLSpan frameworkAddedSpan;
        String url;
        int start;
        int end;

        LinkSpec() {
        }
    }

    @RequiresApi(value=24)
    static class Api24Impl {
        private Api24Impl() {
        }

        @DoNotInline
        static void addLinks(TextView text, Pattern pattern, String defaultScheme, String[] schemes, Linkify.MatchFilter matchFilter, Linkify.TransformFilter transformFilter) {
            Linkify.addLinks((TextView)text, (Pattern)pattern, (String)defaultScheme, (String[])schemes, (Linkify.MatchFilter)matchFilter, (Linkify.TransformFilter)transformFilter);
        }

        @DoNotInline
        static boolean addLinks(Spannable spannable, Pattern pattern, String defaultScheme, String[] schemes, Linkify.MatchFilter matchFilter, Linkify.TransformFilter transformFilter) {
            return Linkify.addLinks((Spannable)spannable, (Pattern)pattern, (String)defaultScheme, (String[])schemes, (Linkify.MatchFilter)matchFilter, (Linkify.TransformFilter)transformFilter);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static @interface LinkifyMask {
    }
}

