/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.annotation.SuppressLint;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import androidx.annotation.NonNull;
import androidx.core.view.MenuProvider;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleOwner;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class MenuHostHelper {
    private final Runnable mOnInvalidateMenuCallback;
    private final CopyOnWriteArrayList<MenuProvider> mMenuProviders = new CopyOnWriteArrayList();
    private final Map<MenuProvider, LifecycleContainer> mProviderToLifecycleContainers = new HashMap<MenuProvider, LifecycleContainer>();

    public MenuHostHelper(@NonNull Runnable onInvalidateMenuCallback) {
        this.mOnInvalidateMenuCallback = onInvalidateMenuCallback;
    }

    public void onPrepareMenu(@NonNull Menu menu2) {
        for (MenuProvider menuProvider : this.mMenuProviders) {
            menuProvider.onPrepareMenu(menu2);
        }
    }

    public void onCreateMenu(@NonNull Menu menu2, @NonNull MenuInflater menuInflater) {
        for (MenuProvider menuProvider : this.mMenuProviders) {
            menuProvider.onCreateMenu(menu2, menuInflater);
        }
    }

    public boolean onMenuItemSelected(@NonNull MenuItem item) {
        for (MenuProvider menuProvider : this.mMenuProviders) {
            if (!menuProvider.onMenuItemSelected(item)) continue;
            return true;
        }
        return false;
    }

    public void onMenuClosed(@NonNull Menu menu2) {
        for (MenuProvider menuProvider : this.mMenuProviders) {
            menuProvider.onMenuClosed(menu2);
        }
    }

    public void addMenuProvider(@NonNull MenuProvider provider) {
        this.mMenuProviders.add(provider);
        this.mOnInvalidateMenuCallback.run();
    }

    public void addMenuProvider(@NonNull MenuProvider provider, @NonNull LifecycleOwner owner2) {
        this.addMenuProvider(provider);
        Lifecycle lifecycle = owner2.getLifecycle();
        LifecycleContainer lifecycleContainer = this.mProviderToLifecycleContainers.remove(provider);
        if (lifecycleContainer != null) {
            lifecycleContainer.clearObservers();
        }
        LifecycleEventObserver observer2 = (source, event) -> {
            if (event == Lifecycle.Event.ON_DESTROY) {
                this.removeMenuProvider(provider);
            }
        };
        this.mProviderToLifecycleContainers.put(provider, new LifecycleContainer(lifecycle, observer2));
    }

    @SuppressLint(value={"LambdaLast"})
    public void addMenuProvider(@NonNull MenuProvider provider, @NonNull LifecycleOwner owner2, @NonNull Lifecycle.State state) {
        Lifecycle lifecycle = owner2.getLifecycle();
        LifecycleContainer lifecycleContainer = this.mProviderToLifecycleContainers.remove(provider);
        if (lifecycleContainer != null) {
            lifecycleContainer.clearObservers();
        }
        LifecycleEventObserver observer2 = (source, event) -> {
            if (event == Lifecycle.Event.upTo(state)) {
                this.addMenuProvider(provider);
            } else if (event == Lifecycle.Event.ON_DESTROY) {
                this.removeMenuProvider(provider);
            } else if (event == Lifecycle.Event.downFrom(state)) {
                this.mMenuProviders.remove(provider);
                this.mOnInvalidateMenuCallback.run();
            }
        };
        this.mProviderToLifecycleContainers.put(provider, new LifecycleContainer(lifecycle, observer2));
    }

    public void removeMenuProvider(@NonNull MenuProvider provider) {
        this.mMenuProviders.remove(provider);
        LifecycleContainer lifecycleContainer = this.mProviderToLifecycleContainers.remove(provider);
        if (lifecycleContainer != null) {
            lifecycleContainer.clearObservers();
        }
        this.mOnInvalidateMenuCallback.run();
    }

    private static class LifecycleContainer {
        final Lifecycle mLifecycle;
        private LifecycleEventObserver mObserver;

        LifecycleContainer(@NonNull Lifecycle lifecycle, @NonNull LifecycleEventObserver observer2) {
            this.mLifecycle = lifecycle;
            this.mObserver = observer2;
            this.mLifecycle.addObserver(observer2);
        }

        void clearObservers() {
            this.mLifecycle.removeObserver(this.mObserver);
            this.mObserver = null;
        }
    }
}

