/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.os.Build;
import android.util.Log;
import android.view.View;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.core.view.NestedScrollingParent;
import androidx.core.view.NestedScrollingParent2;
import androidx.core.view.NestedScrollingParent3;

public final class ViewParentCompat {
    private static final String TAG = "ViewParentCompat";
    private static int[] sTempNestedScrollConsumed;

    private ViewParentCompat() {
    }

    @Deprecated
    public static boolean requestSendAccessibilityEvent(ViewParent parent, View child, AccessibilityEvent event) {
        return parent.requestSendAccessibilityEvent(child, event);
    }

    public static boolean onStartNestedScroll(@NonNull ViewParent parent, @NonNull View child, @NonNull View target, int nestedScrollAxes) {
        return ViewParentCompat.onStartNestedScroll(parent, child, target, nestedScrollAxes, 0);
    }

    public static void onNestedScrollAccepted(@NonNull ViewParent parent, @NonNull View child, @NonNull View target, int nestedScrollAxes) {
        ViewParentCompat.onNestedScrollAccepted(parent, child, target, nestedScrollAxes, 0);
    }

    public static void onStopNestedScroll(@NonNull ViewParent parent, @NonNull View target) {
        ViewParentCompat.onStopNestedScroll(parent, target, 0);
    }

    public static void onNestedScroll(@NonNull ViewParent parent, @NonNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed) {
        ViewParentCompat.onNestedScroll(parent, target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, 0, ViewParentCompat.getTempNestedScrollConsumed());
    }

    public static void onNestedScroll(@NonNull ViewParent parent, @NonNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type) {
        ViewParentCompat.onNestedScroll(parent, target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, type, ViewParentCompat.getTempNestedScrollConsumed());
    }

    public static void onNestedPreScroll(@NonNull ViewParent parent, @NonNull View target, int dx, int dy, @NonNull int[] consumed) {
        ViewParentCompat.onNestedPreScroll(parent, target, dx, dy, consumed, 0);
    }

    public static boolean onStartNestedScroll(@NonNull ViewParent parent, @NonNull View child, @NonNull View target, int nestedScrollAxes, int type) {
        if (parent instanceof NestedScrollingParent2) {
            return ((NestedScrollingParent2)parent).onStartNestedScroll(child, target, nestedScrollAxes, type);
        }
        if (type == 0) {
            if (Build.VERSION.SDK_INT >= 21) {
                try {
                    return Api21Impl.onStartNestedScroll(parent, child, target, nestedScrollAxes);
                }
                catch (AbstractMethodError e) {
                    Log.e((String)TAG, (String)("ViewParent " + parent + " does not implement interface method onStartNestedScroll"), (Throwable)e);
                }
            } else if (parent instanceof NestedScrollingParent) {
                return ((NestedScrollingParent)parent).onStartNestedScroll(child, target, nestedScrollAxes);
            }
        }
        return false;
    }

    public static void onNestedScrollAccepted(@NonNull ViewParent parent, @NonNull View child, @NonNull View target, int nestedScrollAxes, int type) {
        if (parent instanceof NestedScrollingParent2) {
            ((NestedScrollingParent2)parent).onNestedScrollAccepted(child, target, nestedScrollAxes, type);
        } else if (type == 0) {
            if (Build.VERSION.SDK_INT >= 21) {
                try {
                    Api21Impl.onNestedScrollAccepted(parent, child, target, nestedScrollAxes);
                }
                catch (AbstractMethodError e) {
                    Log.e((String)TAG, (String)("ViewParent " + parent + " does not implement interface method onNestedScrollAccepted"), (Throwable)e);
                }
            } else if (parent instanceof NestedScrollingParent) {
                ((NestedScrollingParent)parent).onNestedScrollAccepted(child, target, nestedScrollAxes);
            }
        }
    }

    public static void onStopNestedScroll(@NonNull ViewParent parent, @NonNull View target, int type) {
        if (parent instanceof NestedScrollingParent2) {
            ((NestedScrollingParent2)parent).onStopNestedScroll(target, type);
        } else if (type == 0) {
            if (Build.VERSION.SDK_INT >= 21) {
                try {
                    Api21Impl.onStopNestedScroll(parent, target);
                }
                catch (AbstractMethodError e) {
                    Log.e((String)TAG, (String)("ViewParent " + parent + " does not implement interface method onStopNestedScroll"), (Throwable)e);
                }
            } else if (parent instanceof NestedScrollingParent) {
                ((NestedScrollingParent)parent).onStopNestedScroll(target);
            }
        }
    }

    public static void onNestedScroll(@NonNull ViewParent parent, @NonNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type, @NonNull int[] consumed) {
        if (parent instanceof NestedScrollingParent3) {
            ((NestedScrollingParent3)parent).onNestedScroll(target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, type, consumed);
        } else {
            consumed[0] = consumed[0] + dxUnconsumed;
            consumed[1] = consumed[1] + dyUnconsumed;
            if (parent instanceof NestedScrollingParent2) {
                ((NestedScrollingParent2)parent).onNestedScroll(target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed, type);
            } else if (type == 0) {
                if (Build.VERSION.SDK_INT >= 21) {
                    try {
                        Api21Impl.onNestedScroll(parent, target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed);
                    }
                    catch (AbstractMethodError e) {
                        Log.e((String)TAG, (String)("ViewParent " + parent + " does not implement interface method onNestedScroll"), (Throwable)e);
                    }
                } else if (parent instanceof NestedScrollingParent) {
                    ((NestedScrollingParent)parent).onNestedScroll(target, dxConsumed, dyConsumed, dxUnconsumed, dyUnconsumed);
                }
            }
        }
    }

    public static void onNestedPreScroll(@NonNull ViewParent parent, @NonNull View target, int dx, int dy, @NonNull int[] consumed, int type) {
        if (parent instanceof NestedScrollingParent2) {
            ((NestedScrollingParent2)parent).onNestedPreScroll(target, dx, dy, consumed, type);
        } else if (type == 0) {
            if (Build.VERSION.SDK_INT >= 21) {
                try {
                    Api21Impl.onNestedPreScroll(parent, target, dx, dy, consumed);
                }
                catch (AbstractMethodError e) {
                    Log.e((String)TAG, (String)("ViewParent " + parent + " does not implement interface method onNestedPreScroll"), (Throwable)e);
                }
            } else if (parent instanceof NestedScrollingParent) {
                ((NestedScrollingParent)parent).onNestedPreScroll(target, dx, dy, consumed);
            }
        }
    }

    public static boolean onNestedFling(@NonNull ViewParent parent, @NonNull View target, float velocityX, float velocityY, boolean consumed) {
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                return Api21Impl.onNestedFling(parent, target, velocityX, velocityY, consumed);
            }
            catch (AbstractMethodError e) {
                Log.e((String)TAG, (String)("ViewParent " + parent + " does not implement interface method onNestedFling"), (Throwable)e);
            }
        } else if (parent instanceof NestedScrollingParent) {
            return ((NestedScrollingParent)parent).onNestedFling(target, velocityX, velocityY, consumed);
        }
        return false;
    }

    public static boolean onNestedPreFling(@NonNull ViewParent parent, @NonNull View target, float velocityX, float velocityY) {
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                return Api21Impl.onNestedPreFling(parent, target, velocityX, velocityY);
            }
            catch (AbstractMethodError e) {
                Log.e((String)TAG, (String)("ViewParent " + parent + " does not implement interface method onNestedPreFling"), (Throwable)e);
            }
        } else if (parent instanceof NestedScrollingParent) {
            return ((NestedScrollingParent)parent).onNestedPreFling(target, velocityX, velocityY);
        }
        return false;
    }

    public static void notifySubtreeAccessibilityStateChanged(@NonNull ViewParent parent, @NonNull View child, @NonNull View source, int changeType) {
        parent.notifySubtreeAccessibilityStateChanged(child, source, changeType);
    }

    private static int[] getTempNestedScrollConsumed() {
        if (sTempNestedScrollConsumed == null) {
            sTempNestedScrollConsumed = new int[2];
        } else {
            ViewParentCompat.sTempNestedScrollConsumed[0] = 0;
            ViewParentCompat.sTempNestedScrollConsumed[1] = 0;
        }
        return sTempNestedScrollConsumed;
    }

    @RequiresApi(value=21)
    static class Api21Impl {
        private Api21Impl() {
        }

        @DoNotInline
        static boolean onStartNestedScroll(ViewParent viewParent, View view, View view1, int i) {
            return viewParent.onStartNestedScroll(view, view1, i);
        }

        @DoNotInline
        static void onNestedScrollAccepted(ViewParent viewParent, View view, View view1, int i) {
            viewParent.onNestedScrollAccepted(view, view1, i);
        }

        @DoNotInline
        static void onStopNestedScroll(ViewParent viewParent, View view) {
            viewParent.onStopNestedScroll(view);
        }

        @DoNotInline
        static void onNestedScroll(ViewParent viewParent, View view, int i, int i1, int i2, int i3) {
            viewParent.onNestedScroll(view, i, i1, i2, i3);
        }

        @DoNotInline
        static void onNestedPreScroll(ViewParent viewParent, View view, int i, int i1, int[] ints) {
            viewParent.onNestedPreScroll(view, i, i1, ints);
        }

        @DoNotInline
        static boolean onNestedFling(ViewParent viewParent, View view, float v, float v1, boolean b) {
            return viewParent.onNestedFling(view, v, v1, b);
        }

        @DoNotInline
        static boolean onNestedPreFling(ViewParent viewParent, View view, float v, float v1) {
            return viewParent.onNestedPreFling(view, v, v1);
        }
    }
}

