/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view.contentcapture;

import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.ViewStructure;
import android.view.autofill.AutofillId;
import android.view.contentcapture.ContentCaptureSession;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.view.ViewCompat;
import androidx.core.view.ViewStructureCompat;
import java.util.List;
import java.util.Objects;

public class ContentCaptureSessionCompat {
    private static final String KEY_VIEW_TREE_APPEARING = "TREAT_AS_VIEW_TREE_APPEARING";
    private static final String KEY_VIEW_TREE_APPEARED = "TREAT_AS_VIEW_TREE_APPEARED";
    private final Object mWrappedObj;
    private final View mView;

    @RequiresApi(value=29)
    @NonNull
    public static ContentCaptureSessionCompat toContentCaptureSessionCompat(@NonNull ContentCaptureSession contentCaptureSession, @NonNull View host) {
        return new ContentCaptureSessionCompat(contentCaptureSession, host);
    }

    @RequiresApi(value=29)
    @NonNull
    public ContentCaptureSession toContentCaptureSession() {
        return (ContentCaptureSession)this.mWrappedObj;
    }

    @RequiresApi(value=29)
    private ContentCaptureSessionCompat(@NonNull ContentCaptureSession contentCaptureSession, @NonNull View host) {
        this.mWrappedObj = contentCaptureSession;
        this.mView = host;
    }

    @Nullable
    public AutofillId newAutofillId(long virtualChildId) {
        if (Build.VERSION.SDK_INT >= 29) {
            return Api29Impl.newAutofillId((ContentCaptureSession)this.mWrappedObj, Objects.requireNonNull(ViewCompat.getAutofillId(this.mView)).toAutofillId(), virtualChildId);
        }
        return null;
    }

    @Nullable
    public ViewStructureCompat newVirtualViewStructure(@NonNull AutofillId parentId, long virtualId) {
        if (Build.VERSION.SDK_INT >= 29) {
            return ViewStructureCompat.toViewStructureCompat(Api29Impl.newVirtualViewStructure((ContentCaptureSession)this.mWrappedObj, parentId, virtualId));
        }
        return null;
    }

    public void notifyViewsAppeared(@NonNull List<ViewStructure> appearedNodes) {
        if (Build.VERSION.SDK_INT >= 34) {
            Api34Impl.notifyViewsAppeared((ContentCaptureSession)this.mWrappedObj, appearedNodes);
        } else if (Build.VERSION.SDK_INT >= 29) {
            ViewStructure treeAppearing = Api29Impl.newViewStructure((ContentCaptureSession)this.mWrappedObj, this.mView);
            Api23Impl.getExtras(treeAppearing).putBoolean(KEY_VIEW_TREE_APPEARING, true);
            Api29Impl.notifyViewAppeared((ContentCaptureSession)this.mWrappedObj, treeAppearing);
            for (int i = 0; i < appearedNodes.size(); ++i) {
                Api29Impl.notifyViewAppeared((ContentCaptureSession)this.mWrappedObj, appearedNodes.get(i));
            }
            ViewStructure treeAppeared = Api29Impl.newViewStructure((ContentCaptureSession)this.mWrappedObj, this.mView);
            Api23Impl.getExtras(treeAppeared).putBoolean(KEY_VIEW_TREE_APPEARED, true);
            Api29Impl.notifyViewAppeared((ContentCaptureSession)this.mWrappedObj, treeAppeared);
        }
    }

    public void notifyViewsDisappeared(@NonNull long[] virtualIds) {
        if (Build.VERSION.SDK_INT >= 34) {
            Api29Impl.notifyViewsDisappeared((ContentCaptureSession)this.mWrappedObj, Objects.requireNonNull(ViewCompat.getAutofillId(this.mView)).toAutofillId(), virtualIds);
        } else if (Build.VERSION.SDK_INT >= 29) {
            ViewStructure treeAppearing = Api29Impl.newViewStructure((ContentCaptureSession)this.mWrappedObj, this.mView);
            Api23Impl.getExtras(treeAppearing).putBoolean(KEY_VIEW_TREE_APPEARING, true);
            Api29Impl.notifyViewAppeared((ContentCaptureSession)this.mWrappedObj, treeAppearing);
            Api29Impl.notifyViewsDisappeared((ContentCaptureSession)this.mWrappedObj, Objects.requireNonNull(ViewCompat.getAutofillId(this.mView)).toAutofillId(), virtualIds);
            ViewStructure treeAppeared = Api29Impl.newViewStructure((ContentCaptureSession)this.mWrappedObj, this.mView);
            Api23Impl.getExtras(treeAppeared).putBoolean(KEY_VIEW_TREE_APPEARED, true);
            Api29Impl.notifyViewAppeared((ContentCaptureSession)this.mWrappedObj, treeAppeared);
        }
    }

    public void notifyViewTextChanged(@NonNull AutofillId id2, @Nullable CharSequence text) {
        if (Build.VERSION.SDK_INT >= 29) {
            Api29Impl.notifyViewTextChanged((ContentCaptureSession)this.mWrappedObj, id2, text);
        }
    }

    @RequiresApi(value=29)
    private static class Api29Impl {
        private Api29Impl() {
        }

        @DoNotInline
        static void notifyViewsDisappeared(ContentCaptureSession contentCaptureSession, AutofillId hostId, long[] virtualIds) {
            contentCaptureSession.notifyViewsDisappeared(hostId, virtualIds);
        }

        @DoNotInline
        static void notifyViewAppeared(ContentCaptureSession contentCaptureSession, ViewStructure node) {
            contentCaptureSession.notifyViewAppeared(node);
        }

        @DoNotInline
        static ViewStructure newViewStructure(ContentCaptureSession contentCaptureSession, View view) {
            return contentCaptureSession.newViewStructure(view);
        }

        @DoNotInline
        static ViewStructure newVirtualViewStructure(ContentCaptureSession contentCaptureSession, AutofillId parentId, long virtualId) {
            return contentCaptureSession.newVirtualViewStructure(parentId, virtualId);
        }

        @DoNotInline
        static AutofillId newAutofillId(ContentCaptureSession contentCaptureSession, AutofillId hostId, long virtualChildId) {
            return contentCaptureSession.newAutofillId(hostId, virtualChildId);
        }

        @DoNotInline
        public static void notifyViewTextChanged(ContentCaptureSession contentCaptureSession, AutofillId id2, CharSequence charSequence) {
            contentCaptureSession.notifyViewTextChanged(id2, charSequence);
        }
    }

    @RequiresApi(value=34)
    private static class Api34Impl {
        private Api34Impl() {
        }

        @DoNotInline
        static void notifyViewsAppeared(ContentCaptureSession contentCaptureSession, List<ViewStructure> appearedNodes) {
            contentCaptureSession.notifyViewsAppeared(appearedNodes);
        }
    }

    @RequiresApi(value=23)
    private static class Api23Impl {
        private Api23Impl() {
        }

        @DoNotInline
        static Bundle getExtras(ViewStructure viewStructure) {
            return viewStructure.getExtras();
        }
    }
}

