/*
 * Decompiled with CFR 0.152.
 */
package androidx.customview.widget;

import android.graphics.Rect;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

class FocusStrategy {
    public static <L, T> T findNextFocusInRelativeDirection(@NonNull L focusables, @NonNull CollectionAdapter<L, T> collectionAdapter, @NonNull BoundsAdapter<T> adapter, @Nullable T focused, int direction, boolean isLayoutRtl, boolean wrap) {
        int count2 = collectionAdapter.size(focusables);
        ArrayList<T> sortedFocusables = new ArrayList<T>(count2);
        for (int i = 0; i < count2; ++i) {
            sortedFocusables.add(collectionAdapter.get(focusables, i));
        }
        SequentialComparator<T> comparator = new SequentialComparator<T>(isLayoutRtl, adapter);
        Collections.sort(sortedFocusables, comparator);
        switch (direction) {
            case 2: {
                return FocusStrategy.getNextFocusable(focused, sortedFocusables, wrap);
            }
            case 1: {
                return FocusStrategy.getPreviousFocusable(focused, sortedFocusables, wrap);
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_FORWARD, FOCUS_BACKWARD}.");
    }

    private static <T> T getNextFocusable(T focused, ArrayList<T> focusables, boolean wrap) {
        int count2;
        int position = (focused == null ? -1 : focusables.lastIndexOf(focused)) + 1;
        if (position < (count2 = focusables.size())) {
            return focusables.get(position);
        }
        if (wrap && count2 > 0) {
            return focusables.get(0);
        }
        return null;
    }

    private static <T> T getPreviousFocusable(T focused, ArrayList<T> focusables, boolean wrap) {
        int count2 = focusables.size();
        int position = (focused == null ? count2 : focusables.indexOf(focused)) - 1;
        if (position >= 0) {
            return focusables.get(position);
        }
        if (wrap && count2 > 0) {
            return focusables.get(count2 - 1);
        }
        return null;
    }

    public static <L, T> T findNextFocusInAbsoluteDirection(@NonNull L focusables, @NonNull CollectionAdapter<L, T> collectionAdapter, @NonNull BoundsAdapter<T> adapter, @Nullable T focused, @NonNull Rect focusedRect, int direction) {
        Rect bestCandidateRect = new Rect(focusedRect);
        switch (direction) {
            case 17: {
                bestCandidateRect.offset(focusedRect.width() + 1, 0);
                break;
            }
            case 66: {
                bestCandidateRect.offset(-(focusedRect.width() + 1), 0);
                break;
            }
            case 33: {
                bestCandidateRect.offset(0, focusedRect.height() + 1);
                break;
            }
            case 130: {
                bestCandidateRect.offset(0, -(focusedRect.height() + 1));
                break;
            }
            default: {
                throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
            }
        }
        T closest = null;
        int count2 = collectionAdapter.size(focusables);
        Rect focusableRect = new Rect();
        for (int i = 0; i < count2; ++i) {
            T focusable = collectionAdapter.get(focusables, i);
            if (focusable == focused) continue;
            adapter.obtainBounds(focusable, focusableRect);
            if (!FocusStrategy.isBetterCandidate(direction, focusedRect, focusableRect, bestCandidateRect)) continue;
            bestCandidateRect.set(focusableRect);
            closest = focusable;
        }
        return closest;
    }

    private static boolean isBetterCandidate(int direction, @NonNull Rect source, @NonNull Rect candidate, @NonNull Rect currentBest) {
        int currentBestDist;
        if (!FocusStrategy.isCandidate(source, candidate, direction)) {
            return false;
        }
        if (!FocusStrategy.isCandidate(source, currentBest, direction)) {
            return true;
        }
        if (FocusStrategy.beamBeats(direction, source, candidate, currentBest)) {
            return true;
        }
        if (FocusStrategy.beamBeats(direction, source, currentBest, candidate)) {
            return false;
        }
        int candidateDist = FocusStrategy.getWeightedDistanceFor(FocusStrategy.majorAxisDistance(direction, source, candidate), FocusStrategy.minorAxisDistance(direction, source, candidate));
        return candidateDist < (currentBestDist = FocusStrategy.getWeightedDistanceFor(FocusStrategy.majorAxisDistance(direction, source, currentBest), FocusStrategy.minorAxisDistance(direction, source, currentBest)));
    }

    private static boolean beamBeats(int direction, @NonNull Rect source, @NonNull Rect rect1, @NonNull Rect rect2) {
        boolean rect1InSrcBeam = FocusStrategy.beamsOverlap(direction, source, rect1);
        boolean rect2InSrcBeam = FocusStrategy.beamsOverlap(direction, source, rect2);
        if (rect2InSrcBeam || !rect1InSrcBeam) {
            return false;
        }
        if (!FocusStrategy.isToDirectionOf(direction, source, rect2)) {
            return true;
        }
        if (direction == 17 || direction == 66) {
            return true;
        }
        return FocusStrategy.majorAxisDistance(direction, source, rect1) < FocusStrategy.majorAxisDistanceToFarEdge(direction, source, rect2);
    }

    private static int getWeightedDistanceFor(int majorAxisDistance, int minorAxisDistance) {
        return 13 * majorAxisDistance * majorAxisDistance + minorAxisDistance * minorAxisDistance;
    }

    private static boolean isCandidate(@NonNull Rect srcRect, @NonNull Rect destRect, int direction) {
        switch (direction) {
            case 17: {
                return (srcRect.right > destRect.right || srcRect.left >= destRect.right) && srcRect.left > destRect.left;
            }
            case 66: {
                return (srcRect.left < destRect.left || srcRect.right <= destRect.left) && srcRect.right < destRect.right;
            }
            case 33: {
                return (srcRect.bottom > destRect.bottom || srcRect.top >= destRect.bottom) && srcRect.top > destRect.top;
            }
            case 130: {
                return (srcRect.top < destRect.top || srcRect.bottom <= destRect.top) && srcRect.bottom < destRect.bottom;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    private static boolean beamsOverlap(int direction, @NonNull Rect rect1, @NonNull Rect rect2) {
        switch (direction) {
            case 17: 
            case 66: {
                return rect2.bottom >= rect1.top && rect2.top <= rect1.bottom;
            }
            case 33: 
            case 130: {
                return rect2.right >= rect1.left && rect2.left <= rect1.right;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    private static boolean isToDirectionOf(int direction, @NonNull Rect src, @NonNull Rect dest) {
        switch (direction) {
            case 17: {
                return src.left >= dest.right;
            }
            case 66: {
                return src.right <= dest.left;
            }
            case 33: {
                return src.top >= dest.bottom;
            }
            case 130: {
                return src.bottom <= dest.top;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    private static int majorAxisDistance(int direction, @NonNull Rect source, @NonNull Rect dest) {
        return Math.max(0, FocusStrategy.majorAxisDistanceRaw(direction, source, dest));
    }

    private static int majorAxisDistanceRaw(int direction, @NonNull Rect source, @NonNull Rect dest) {
        switch (direction) {
            case 17: {
                return source.left - dest.right;
            }
            case 66: {
                return dest.left - source.right;
            }
            case 33: {
                return source.top - dest.bottom;
            }
            case 130: {
                return dest.top - source.bottom;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    private static int majorAxisDistanceToFarEdge(int direction, @NonNull Rect source, @NonNull Rect dest) {
        return Math.max(1, FocusStrategy.majorAxisDistanceToFarEdgeRaw(direction, source, dest));
    }

    private static int majorAxisDistanceToFarEdgeRaw(int direction, @NonNull Rect source, @NonNull Rect dest) {
        switch (direction) {
            case 17: {
                return source.left - dest.left;
            }
            case 66: {
                return dest.right - source.right;
            }
            case 33: {
                return source.top - dest.top;
            }
            case 130: {
                return dest.bottom - source.bottom;
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    private static int minorAxisDistance(int direction, @NonNull Rect source, @NonNull Rect dest) {
        switch (direction) {
            case 17: 
            case 66: {
                return Math.abs(source.top + source.height() / 2 - (dest.top + dest.height() / 2));
            }
            case 33: 
            case 130: {
                return Math.abs(source.left + source.width() / 2 - (dest.left + dest.width() / 2));
            }
        }
        throw new IllegalArgumentException("direction must be one of {FOCUS_UP, FOCUS_DOWN, FOCUS_LEFT, FOCUS_RIGHT}.");
    }

    private FocusStrategy() {
    }

    public static interface CollectionAdapter<T, V> {
        public V get(T var1, int var2);

        public int size(T var1);
    }

    public static interface BoundsAdapter<T> {
        public void obtainBounds(T var1, Rect var2);
    }

    private static class SequentialComparator<T>
    implements Comparator<T> {
        private final Rect mTemp1 = new Rect();
        private final Rect mTemp2 = new Rect();
        private final boolean mIsLayoutRtl;
        private final BoundsAdapter<T> mAdapter;

        SequentialComparator(boolean isLayoutRtl, BoundsAdapter<T> adapter) {
            this.mIsLayoutRtl = isLayoutRtl;
            this.mAdapter = adapter;
        }

        @Override
        public int compare(T first2, T second2) {
            Rect firstRect = this.mTemp1;
            Rect secondRect = this.mTemp2;
            this.mAdapter.obtainBounds(first2, firstRect);
            this.mAdapter.obtainBounds(second2, secondRect);
            if (firstRect.top < secondRect.top) {
                return -1;
            }
            if (firstRect.top > secondRect.top) {
                return 1;
            }
            if (firstRect.left < secondRect.left) {
                return this.mIsLayoutRtl ? 1 : -1;
            }
            if (firstRect.left > secondRect.left) {
                return this.mIsLayoutRtl ? -1 : 1;
            }
            if (firstRect.bottom < secondRect.bottom) {
                return -1;
            }
            if (firstRect.bottom > secondRect.bottom) {
                return 1;
            }
            if (firstRect.right < secondRect.right) {
                return this.mIsLayoutRtl ? 1 : -1;
            }
            if (firstRect.right > secondRect.right) {
                return this.mIsLayoutRtl ? -1 : 1;
            }
            return 0;
        }
    }
}

