/*
 * Decompiled with CFR 0.152.
 */
package androidx.documentfile.provider;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.DocumentsContract;
import android.util.Log;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.documentfile.provider.DocumentFile;
import androidx.documentfile.provider.DocumentsContractApi19;
import java.util.ArrayList;

@RequiresApi(value=21)
class TreeDocumentFile
extends DocumentFile {
    private Context mContext;
    private Uri mUri;

    TreeDocumentFile(@Nullable DocumentFile parent, Context context, Uri uri) {
        super(parent);
        this.mContext = context;
        this.mUri = uri;
    }

    @Override
    @Nullable
    public DocumentFile createFile(String mimeType, String displayName) {
        Uri result2 = TreeDocumentFile.createFile(this.mContext, this.mUri, mimeType, displayName);
        return result2 != null ? new TreeDocumentFile(this, this.mContext, result2) : null;
    }

    @Nullable
    private static Uri createFile(Context context, Uri self, String mimeType, String displayName) {
        try {
            return DocumentsContract.createDocument((ContentResolver)context.getContentResolver(), (Uri)self, (String)mimeType, (String)displayName);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    @Nullable
    public DocumentFile createDirectory(String displayName) {
        Uri result2 = TreeDocumentFile.createFile(this.mContext, this.mUri, "vnd.android.document/directory", displayName);
        return result2 != null ? new TreeDocumentFile(this, this.mContext, result2) : null;
    }

    @Override
    public Uri getUri() {
        return this.mUri;
    }

    @Override
    @Nullable
    public String getName() {
        return DocumentsContractApi19.getName(this.mContext, this.mUri);
    }

    @Override
    @Nullable
    public String getType() {
        return DocumentsContractApi19.getType(this.mContext, this.mUri);
    }

    @Override
    public boolean isDirectory() {
        return DocumentsContractApi19.isDirectory(this.mContext, this.mUri);
    }

    @Override
    public boolean isFile() {
        return DocumentsContractApi19.isFile(this.mContext, this.mUri);
    }

    @Override
    public boolean isVirtual() {
        return DocumentsContractApi19.isVirtual(this.mContext, this.mUri);
    }

    @Override
    public long lastModified() {
        return DocumentsContractApi19.lastModified(this.mContext, this.mUri);
    }

    @Override
    public long length() {
        return DocumentsContractApi19.length(this.mContext, this.mUri);
    }

    @Override
    public boolean canRead() {
        return DocumentsContractApi19.canRead(this.mContext, this.mUri);
    }

    @Override
    public boolean canWrite() {
        return DocumentsContractApi19.canWrite(this.mContext, this.mUri);
    }

    @Override
    public boolean delete() {
        try {
            return DocumentsContract.deleteDocument((ContentResolver)this.mContext.getContentResolver(), (Uri)this.mUri);
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public boolean exists() {
        return DocumentsContractApi19.exists(this.mContext, this.mUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DocumentFile[] listFiles() {
        ContentResolver resolver = this.mContext.getContentResolver();
        Uri childrenUri = DocumentsContract.buildChildDocumentsUriUsingTree((Uri)this.mUri, (String)DocumentsContract.getDocumentId((Uri)this.mUri));
        ArrayList<Uri> results = new ArrayList<Uri>();
        Cursor c = null;
        try {
            c = resolver.query(childrenUri, new String[]{"document_id"}, null, null, null);
            while (c.moveToNext()) {
                String documentId = c.getString(0);
                Uri documentUri = DocumentsContract.buildDocumentUriUsingTree((Uri)this.mUri, (String)documentId);
                results.add(documentUri);
            }
        }
        catch (Exception e) {
            try {
                Log.w((String)"DocumentFile", (String)("Failed query: " + e));
            }
            catch (Throwable throwable) {
                TreeDocumentFile.closeQuietly(c);
                throw throwable;
            }
            TreeDocumentFile.closeQuietly((AutoCloseable)c);
        }
        TreeDocumentFile.closeQuietly((AutoCloseable)c);
        Uri[] result2 = results.toArray(new Uri[results.size()]);
        DocumentFile[] resultFiles = new DocumentFile[result2.length];
        for (int i = 0; i < result2.length; ++i) {
            resultFiles[i] = new TreeDocumentFile(this, this.mContext, result2[i]);
        }
        return resultFiles;
    }

    private static void closeQuietly(@Nullable AutoCloseable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (RuntimeException rethrown) {
                throw rethrown;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean renameTo(String displayName) {
        try {
            Uri result2 = DocumentsContract.renameDocument((ContentResolver)this.mContext.getContentResolver(), (Uri)this.mUri, (String)displayName);
            if (result2 != null) {
                this.mUri = result2;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

