/*
 * Decompiled with CFR 0.152.
 */
package androidx.dynamicanimation.animation;

import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.Choreographer;
import androidx.annotation.RequiresApi;
import androidx.collection.SimpleArrayMap;
import java.util.ArrayList;

class AnimationHandler {
    private static final long FRAME_DELAY_MS = 10L;
    public static final ThreadLocal<AnimationHandler> sAnimatorHandler = new ThreadLocal();
    private final SimpleArrayMap<AnimationFrameCallback, Long> mDelayedCallbackStartTime = new SimpleArrayMap();
    final ArrayList<AnimationFrameCallback> mAnimationCallbacks = new ArrayList();
    private final AnimationCallbackDispatcher mCallbackDispatcher = new AnimationCallbackDispatcher();
    private AnimationFrameCallbackProvider mProvider;
    long mCurrentFrameTime = 0L;
    private boolean mListDirty = false;

    AnimationHandler() {
    }

    public static AnimationHandler getInstance() {
        if (sAnimatorHandler.get() == null) {
            sAnimatorHandler.set(new AnimationHandler());
        }
        return sAnimatorHandler.get();
    }

    public static long getFrameTime() {
        if (sAnimatorHandler.get() == null) {
            return 0L;
        }
        return AnimationHandler.sAnimatorHandler.get().mCurrentFrameTime;
    }

    public void setProvider(AnimationFrameCallbackProvider provider) {
        this.mProvider = provider;
    }

    AnimationFrameCallbackProvider getProvider() {
        if (this.mProvider == null) {
            this.mProvider = Build.VERSION.SDK_INT >= 16 ? new FrameCallbackProvider16(this.mCallbackDispatcher) : new FrameCallbackProvider14(this.mCallbackDispatcher);
        }
        return this.mProvider;
    }

    public void addAnimationFrameCallback(AnimationFrameCallback callback2, long delay) {
        if (this.mAnimationCallbacks.size() == 0) {
            this.getProvider().postFrameCallback();
        }
        if (!this.mAnimationCallbacks.contains(callback2)) {
            this.mAnimationCallbacks.add(callback2);
        }
        if (delay > 0L) {
            this.mDelayedCallbackStartTime.put(callback2, SystemClock.uptimeMillis() + delay);
        }
    }

    public void removeCallback(AnimationFrameCallback callback2) {
        this.mDelayedCallbackStartTime.remove(callback2);
        int id2 = this.mAnimationCallbacks.indexOf(callback2);
        if (id2 >= 0) {
            this.mAnimationCallbacks.set(id2, null);
            this.mListDirty = true;
        }
    }

    void doAnimationFrame(long frameTime) {
        long currentTime = SystemClock.uptimeMillis();
        for (int i = 0; i < this.mAnimationCallbacks.size(); ++i) {
            AnimationFrameCallback callback2 = this.mAnimationCallbacks.get(i);
            if (callback2 == null || !this.isCallbackDue(callback2, currentTime)) continue;
            callback2.doAnimationFrame(frameTime);
        }
        this.cleanUpList();
    }

    private boolean isCallbackDue(AnimationFrameCallback callback2, long currentTime) {
        Long startTime = this.mDelayedCallbackStartTime.get(callback2);
        if (startTime == null) {
            return true;
        }
        if (startTime < currentTime) {
            this.mDelayedCallbackStartTime.remove(callback2);
            return true;
        }
        return false;
    }

    private void cleanUpList() {
        if (this.mListDirty) {
            for (int i = this.mAnimationCallbacks.size() - 1; i >= 0; --i) {
                if (this.mAnimationCallbacks.get(i) != null) continue;
                this.mAnimationCallbacks.remove(i);
            }
            this.mListDirty = false;
        }
    }

    static abstract class AnimationFrameCallbackProvider {
        final AnimationCallbackDispatcher mDispatcher;

        AnimationFrameCallbackProvider(AnimationCallbackDispatcher dispatcher) {
            this.mDispatcher = dispatcher;
        }

        abstract void postFrameCallback();
    }

    private static class FrameCallbackProvider14
    extends AnimationFrameCallbackProvider {
        private final Runnable mRunnable = new Runnable(){

            @Override
            public void run() {
                FrameCallbackProvider14.this.mLastFrameTime = SystemClock.uptimeMillis();
                FrameCallbackProvider14.this.mDispatcher.dispatchAnimationFrame();
            }
        };
        private final Handler mHandler = new Handler(Looper.myLooper());
        long mLastFrameTime = -1L;

        FrameCallbackProvider14(AnimationCallbackDispatcher dispatcher) {
            super(dispatcher);
        }

        @Override
        void postFrameCallback() {
            long delay = 10L - (SystemClock.uptimeMillis() - this.mLastFrameTime);
            delay = Math.max(delay, 0L);
            this.mHandler.postDelayed(this.mRunnable, delay);
        }
    }

    @RequiresApi(value=16)
    private static class FrameCallbackProvider16
    extends AnimationFrameCallbackProvider {
        private final Choreographer mChoreographer = Choreographer.getInstance();
        private final Choreographer.FrameCallback mChoreographerCallback = new Choreographer.FrameCallback(){

            public void doFrame(long frameTimeNanos) {
                FrameCallbackProvider16.this.mDispatcher.dispatchAnimationFrame();
            }
        };

        FrameCallbackProvider16(AnimationCallbackDispatcher dispatcher) {
            super(dispatcher);
        }

        @Override
        void postFrameCallback() {
            this.mChoreographer.postFrameCallback(this.mChoreographerCallback);
        }
    }

    class AnimationCallbackDispatcher {
        AnimationCallbackDispatcher() {
        }

        void dispatchAnimationFrame() {
            AnimationHandler.this.mCurrentFrameTime = SystemClock.uptimeMillis();
            AnimationHandler.this.doAnimationFrame(AnimationHandler.this.mCurrentFrameTime);
            if (AnimationHandler.this.mAnimationCallbacks.size() > 0) {
                AnimationHandler.this.getProvider().postFrameCallback();
            }
        }
    }

    static interface AnimationFrameCallback {
        public boolean doAnimationFrame(long var1);
    }
}

