/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.text;

import android.graphics.Paint;
import android.os.Build;
import android.text.TextPaint;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.PaintCompat;
import androidx.emoji2.text.EmojiCompat;

@AnyThread
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
class DefaultGlyphChecker
implements EmojiCompat.GlyphChecker {
    private static final int PAINT_TEXT_SIZE = 10;
    private static final ThreadLocal<StringBuilder> sStringBuilder = new ThreadLocal();
    private final TextPaint mTextPaint = new TextPaint();

    DefaultGlyphChecker() {
        this.mTextPaint.setTextSize(10.0f);
    }

    @Override
    public boolean hasGlyph(@NonNull CharSequence charSequence, int start, int end, int sdkAdded) {
        if (Build.VERSION.SDK_INT < 23 && sdkAdded > Build.VERSION.SDK_INT) {
            return false;
        }
        StringBuilder builder = DefaultGlyphChecker.getStringBuilder();
        builder.setLength(0);
        while (start < end) {
            builder.append(charSequence.charAt(start));
            ++start;
        }
        return PaintCompat.hasGlyph((Paint)this.mTextPaint, builder.toString());
    }

    private static StringBuilder getStringBuilder() {
        if (sStringBuilder.get() == null) {
            sStringBuilder.set(new StringBuilder());
        }
        return sStringBuilder.get();
    }
}

