/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.text;

import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.util.SparseArray;
import androidx.annotation.AnyThread;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.core.os.TraceCompat;
import androidx.core.util.Preconditions;
import androidx.emoji2.text.MetadataListReader;
import androidx.emoji2.text.TypefaceEmojiRasterizer;
import androidx.emoji2.text.flatbuffer.MetadataList;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

@AnyThread
@RequiresApi(value=19)
public final class MetadataRepo {
    private static final int DEFAULT_ROOT_SIZE = 1024;
    private static final String S_TRACE_CREATE_REPO = "EmojiCompat.MetadataRepo.create";
    @NonNull
    private final MetadataList mMetadataList;
    @NonNull
    private final char[] mEmojiCharArray;
    @NonNull
    private final Node mRootNode;
    @NonNull
    private final Typeface mTypeface;

    private MetadataRepo(@NonNull Typeface typeface, @NonNull MetadataList metadataList) {
        this.mTypeface = typeface;
        this.mMetadataList = metadataList;
        this.mRootNode = new Node(1024);
        this.mEmojiCharArray = new char[this.mMetadataList.listLength() * 2];
        this.constructIndex(this.mMetadataList);
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.TESTS})
    public static MetadataRepo create(@NonNull Typeface typeface) {
        try {
            TraceCompat.beginSection(S_TRACE_CREATE_REPO);
            MetadataRepo metadataRepo = new MetadataRepo(typeface, new MetadataList());
            return metadataRepo;
        }
        finally {
            TraceCompat.endSection();
        }
    }

    @NonNull
    public static MetadataRepo create(@NonNull Typeface typeface, @NonNull InputStream inputStream) throws IOException {
        try {
            TraceCompat.beginSection(S_TRACE_CREATE_REPO);
            MetadataRepo metadataRepo = new MetadataRepo(typeface, MetadataListReader.read(inputStream));
            return metadataRepo;
        }
        finally {
            TraceCompat.endSection();
        }
    }

    @NonNull
    public static MetadataRepo create(@NonNull Typeface typeface, @NonNull ByteBuffer byteBuffer) throws IOException {
        try {
            TraceCompat.beginSection(S_TRACE_CREATE_REPO);
            MetadataRepo metadataRepo = new MetadataRepo(typeface, MetadataListReader.read(byteBuffer));
            return metadataRepo;
        }
        finally {
            TraceCompat.endSection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    public static MetadataRepo create(@NonNull AssetManager assetManager, @NonNull String assetPath) throws IOException {
        try {
            TraceCompat.beginSection(S_TRACE_CREATE_REPO);
            Typeface typeface = Typeface.createFromAsset((AssetManager)assetManager, (String)assetPath);
            MetadataRepo metadataRepo = new MetadataRepo(typeface, MetadataListReader.read(assetManager, assetPath));
            return metadataRepo;
        }
        finally {
            TraceCompat.endSection();
        }
    }

    private void constructIndex(MetadataList metadataList) {
        int length = metadataList.listLength();
        for (int i = 0; i < length; ++i) {
            TypefaceEmojiRasterizer metadata = new TypefaceEmojiRasterizer(this, i);
            Character.toChars(metadata.getId(), this.mEmojiCharArray, i * 2);
            this.put(metadata);
        }
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    Typeface getTypeface() {
        return this.mTypeface;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    int getMetadataVersion() {
        return this.mMetadataList.version();
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    Node getRootNode() {
        return this.mRootNode;
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public char[] getEmojiCharArray() {
        return this.mEmojiCharArray;
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public MetadataList getMetadataList() {
        return this.mMetadataList;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @VisibleForTesting
    void put(@NonNull TypefaceEmojiRasterizer data) {
        Preconditions.checkNotNull(data, "emoji metadata cannot be null");
        Preconditions.checkArgument(data.getCodepointsLength() > 0, "invalid metadata codepoint length");
        this.mRootNode.put(data, 0, data.getCodepointsLength() - 1);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    static class Node {
        private final SparseArray<Node> mChildren;
        private TypefaceEmojiRasterizer mData;

        private Node() {
            this(1);
        }

        Node(int defaultChildrenSize) {
            this.mChildren = new SparseArray(defaultChildrenSize);
        }

        Node get(int key) {
            return this.mChildren == null ? null : (Node)this.mChildren.get(key);
        }

        final TypefaceEmojiRasterizer getData() {
            return this.mData;
        }

        void put(@NonNull TypefaceEmojiRasterizer data, int start, int end) {
            Node node = this.get(data.getCodepointAt(start));
            if (node == null) {
                node = new Node();
                this.mChildren.put(data.getCodepointAt(start), (Object)node);
            }
            if (end > start) {
                node.put(data, start + 1, end);
            } else {
                node.mData = data;
            }
        }
    }
}

