/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.text;

import android.annotation.SuppressLint;
import android.os.Build;
import android.text.Editable;
import android.text.SpanWatcher;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextWatcher;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.util.Preconditions;
import androidx.emoji2.text.EmojiSpan;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class SpannableBuilder
extends SpannableStringBuilder {
    @NonNull
    private final Class<?> mWatcherClass;
    @NonNull
    private final List<WatcherWrapper> mWatchers = new ArrayList<WatcherWrapper>();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    SpannableBuilder(@NonNull Class<?> watcherClass) {
        Preconditions.checkNotNull(watcherClass, "watcherClass cannot be null");
        this.mWatcherClass = watcherClass;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    SpannableBuilder(@NonNull Class<?> watcherClass, @NonNull CharSequence text) {
        super(text);
        Preconditions.checkNotNull(watcherClass, "watcherClass cannot be null");
        this.mWatcherClass = watcherClass;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    SpannableBuilder(@NonNull Class<?> watcherClass, @NonNull CharSequence text, int start, int end) {
        super(text, start, end);
        Preconditions.checkNotNull(watcherClass, "watcherClass cannot be null");
        this.mWatcherClass = watcherClass;
    }

    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static SpannableBuilder create(@NonNull Class<?> clazz, @NonNull CharSequence text) {
        return new SpannableBuilder(clazz, text);
    }

    private boolean isWatcher(@Nullable Object object) {
        return object != null && this.isWatcher(object.getClass());
    }

    private boolean isWatcher(@NonNull Class<?> clazz) {
        return this.mWatcherClass == clazz;
    }

    @SuppressLint(value={"UnknownNullness"})
    public CharSequence subSequence(int start, int end) {
        return new SpannableBuilder(this.mWatcherClass, (CharSequence)((Object)this), start, end);
    }

    public void setSpan(@Nullable Object what, int start, int end, int flags) {
        if (this.isWatcher(what)) {
            WatcherWrapper span = new WatcherWrapper(what);
            this.mWatchers.add(span);
            what = span;
        }
        super.setSpan(what, start, end, flags);
    }

    @SuppressLint(value={"UnknownNullness"})
    public <T> T[] getSpans(int queryStart, int queryEnd, @NonNull Class<T> kind) {
        if (this.isWatcher(kind)) {
            WatcherWrapper[] spans = (WatcherWrapper[])super.getSpans(queryStart, queryEnd, WatcherWrapper.class);
            Object[] result2 = (Object[])Array.newInstance(kind, spans.length);
            for (int i = 0; i < spans.length; ++i) {
                result2[i] = spans[i].mObject;
            }
            return result2;
        }
        return super.getSpans(queryStart, queryEnd, kind);
    }

    public void removeSpan(@Nullable Object what) {
        WatcherWrapper watcher;
        if (this.isWatcher(what)) {
            watcher = this.getWatcherFor(what);
            if (watcher != null) {
                what = watcher;
            }
        } else {
            watcher = null;
        }
        super.removeSpan(what);
        if (watcher != null) {
            this.mWatchers.remove(watcher);
        }
    }

    public int getSpanStart(@Nullable Object tag) {
        WatcherWrapper watcher;
        if (this.isWatcher(tag) && (watcher = this.getWatcherFor(tag)) != null) {
            tag = watcher;
        }
        return super.getSpanStart(tag);
    }

    public int getSpanEnd(@Nullable Object tag) {
        WatcherWrapper watcher;
        if (this.isWatcher(tag) && (watcher = this.getWatcherFor(tag)) != null) {
            tag = watcher;
        }
        return super.getSpanEnd(tag);
    }

    public int getSpanFlags(@Nullable Object tag) {
        WatcherWrapper watcher;
        if (this.isWatcher(tag) && (watcher = this.getWatcherFor(tag)) != null) {
            tag = watcher;
        }
        return super.getSpanFlags(tag);
    }

    public int nextSpanTransition(int start, int limit, @Nullable Class type) {
        if (type == null || this.isWatcher(type)) {
            type = WatcherWrapper.class;
        }
        return super.nextSpanTransition(start, limit, type);
    }

    private WatcherWrapper getWatcherFor(Object object) {
        for (int i = 0; i < this.mWatchers.size(); ++i) {
            WatcherWrapper watcher = this.mWatchers.get(i);
            if (watcher.mObject != object) continue;
            return watcher;
        }
        return null;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void beginBatchEdit() {
        this.blockWatchers();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public void endBatchEdit() {
        this.unblockwatchers();
        this.fireWatchers();
    }

    private void blockWatchers() {
        for (int i = 0; i < this.mWatchers.size(); ++i) {
            this.mWatchers.get(i).blockCalls();
        }
    }

    private void unblockwatchers() {
        for (int i = 0; i < this.mWatchers.size(); ++i) {
            this.mWatchers.get(i).unblockCalls();
        }
    }

    private void fireWatchers() {
        for (int i = 0; i < this.mWatchers.size(); ++i) {
            this.mWatchers.get(i).onTextChanged((CharSequence)((Object)this), 0, this.length(), this.length());
        }
    }

    @SuppressLint(value={"UnknownNullness"})
    public SpannableStringBuilder replace(int start, int end, CharSequence tb) {
        this.blockWatchers();
        super.replace(start, end, tb);
        this.unblockwatchers();
        return this;
    }

    @SuppressLint(value={"UnknownNullness"})
    public SpannableStringBuilder replace(int start, int end, CharSequence tb, int tbstart, int tbend) {
        this.blockWatchers();
        super.replace(start, end, tb, tbstart, tbend);
        this.unblockwatchers();
        return this;
    }

    @SuppressLint(value={"UnknownNullness"})
    public SpannableStringBuilder insert(int where, CharSequence tb) {
        super.insert(where, tb);
        return this;
    }

    @SuppressLint(value={"UnknownNullness"})
    public SpannableStringBuilder insert(int where, CharSequence tb, int start, int end) {
        super.insert(where, tb, start, end);
        return this;
    }

    @SuppressLint(value={"UnknownNullness"})
    public SpannableStringBuilder delete(int start, int end) {
        super.delete(start, end);
        return this;
    }

    @NonNull
    public SpannableStringBuilder append(@SuppressLint(value={"UnknownNullness"}) CharSequence text) {
        super.append(text);
        return this;
    }

    @NonNull
    public SpannableStringBuilder append(char text) {
        super.append(text);
        return this;
    }

    @NonNull
    public SpannableStringBuilder append(@SuppressLint(value={"UnknownNullness"}) CharSequence text, int start, int end) {
        super.append(text, start, end);
        return this;
    }

    @SuppressLint(value={"UnknownNullness"})
    public SpannableStringBuilder append(CharSequence text, Object what, int flags) {
        super.append(text, what, flags);
        return this;
    }

    private static class WatcherWrapper
    implements TextWatcher,
    SpanWatcher {
        final Object mObject;
        private final AtomicInteger mBlockCalls = new AtomicInteger(0);

        WatcherWrapper(Object object) {
            this.mObject = object;
        }

        public void beforeTextChanged(CharSequence s, int start, int count2, int after) {
            ((TextWatcher)this.mObject).beforeTextChanged(s, start, count2, after);
        }

        public void onTextChanged(CharSequence s, int start, int before, int count2) {
            ((TextWatcher)this.mObject).onTextChanged(s, start, before, count2);
        }

        public void afterTextChanged(Editable s) {
            ((TextWatcher)this.mObject).afterTextChanged(s);
        }

        public void onSpanAdded(Spannable text, Object what, int start, int end) {
            if (this.mBlockCalls.get() > 0 && this.isEmojiSpan(what)) {
                return;
            }
            ((SpanWatcher)this.mObject).onSpanAdded(text, what, start, end);
        }

        public void onSpanRemoved(Spannable text, Object what, int start, int end) {
            if (this.mBlockCalls.get() > 0 && this.isEmojiSpan(what)) {
                return;
            }
            ((SpanWatcher)this.mObject).onSpanRemoved(text, what, start, end);
        }

        public void onSpanChanged(Spannable text, Object what, int ostart, int oend, int nstart, int nend) {
            if (this.mBlockCalls.get() > 0 && this.isEmojiSpan(what)) {
                return;
            }
            if (Build.VERSION.SDK_INT < 28) {
                if (ostart > oend) {
                    ostart = 0;
                }
                if (nstart > nend) {
                    nstart = 0;
                }
            }
            ((SpanWatcher)this.mObject).onSpanChanged(text, what, ostart, oend, nstart, nend);
        }

        final void blockCalls() {
            this.mBlockCalls.incrementAndGet();
        }

        final void unblockCalls() {
            this.mBlockCalls.decrementAndGet();
        }

        private boolean isEmojiSpan(Object span) {
            return span instanceof EmojiSpan;
        }
    }
}

