/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.fragment.app.LogWriter;
import androidx.lifecycle.Lifecycle;
import java.io.PrintWriter;
import java.util.ArrayList;

final class BackStackRecord
extends FragmentTransaction
implements FragmentManager.BackStackEntry,
FragmentManager.OpGenerator {
    private static final String TAG = "FragmentManager";
    final FragmentManager mManager;
    boolean mCommitted;
    int mIndex = -1;
    boolean mBeingSaved = false;

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("BackStackEntry{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        if (this.mIndex >= 0) {
            sb.append(" #");
            sb.append(this.mIndex);
        }
        if (this.mName != null) {
            sb.append(" ");
            sb.append(this.mName);
        }
        sb.append("}");
        return sb.toString();
    }

    public void dump(String prefix, PrintWriter writer) {
        this.dump(prefix, writer, true);
    }

    public void dump(String prefix, PrintWriter writer, boolean full) {
        if (full) {
            writer.print(prefix);
            writer.print("mName=");
            writer.print(this.mName);
            writer.print(" mIndex=");
            writer.print(this.mIndex);
            writer.print(" mCommitted=");
            writer.println(this.mCommitted);
            if (this.mTransition != 0) {
                writer.print(prefix);
                writer.print("mTransition=#");
                writer.print(Integer.toHexString(this.mTransition));
            }
            if (this.mEnterAnim != 0 || this.mExitAnim != 0) {
                writer.print(prefix);
                writer.print("mEnterAnim=#");
                writer.print(Integer.toHexString(this.mEnterAnim));
                writer.print(" mExitAnim=#");
                writer.println(Integer.toHexString(this.mExitAnim));
            }
            if (this.mPopEnterAnim != 0 || this.mPopExitAnim != 0) {
                writer.print(prefix);
                writer.print("mPopEnterAnim=#");
                writer.print(Integer.toHexString(this.mPopEnterAnim));
                writer.print(" mPopExitAnim=#");
                writer.println(Integer.toHexString(this.mPopExitAnim));
            }
            if (this.mBreadCrumbTitleRes != 0 || this.mBreadCrumbTitleText != null) {
                writer.print(prefix);
                writer.print("mBreadCrumbTitleRes=#");
                writer.print(Integer.toHexString(this.mBreadCrumbTitleRes));
                writer.print(" mBreadCrumbTitleText=");
                writer.println(this.mBreadCrumbTitleText);
            }
            if (this.mBreadCrumbShortTitleRes != 0 || this.mBreadCrumbShortTitleText != null) {
                writer.print(prefix);
                writer.print("mBreadCrumbShortTitleRes=#");
                writer.print(Integer.toHexString(this.mBreadCrumbShortTitleRes));
                writer.print(" mBreadCrumbShortTitleText=");
                writer.println(this.mBreadCrumbShortTitleText);
            }
        }
        if (!this.mOps.isEmpty()) {
            writer.print(prefix);
            writer.println("Operations:");
            int numOps = this.mOps.size();
            for (int opNum = 0; opNum < numOps; ++opNum) {
                String cmdStr;
                FragmentTransaction.Op op = (FragmentTransaction.Op)this.mOps.get(opNum);
                switch (op.mCmd) {
                    case 0: {
                        cmdStr = "NULL";
                        break;
                    }
                    case 1: {
                        cmdStr = "ADD";
                        break;
                    }
                    case 2: {
                        cmdStr = "REPLACE";
                        break;
                    }
                    case 3: {
                        cmdStr = "REMOVE";
                        break;
                    }
                    case 4: {
                        cmdStr = "HIDE";
                        break;
                    }
                    case 5: {
                        cmdStr = "SHOW";
                        break;
                    }
                    case 6: {
                        cmdStr = "DETACH";
                        break;
                    }
                    case 7: {
                        cmdStr = "ATTACH";
                        break;
                    }
                    case 8: {
                        cmdStr = "SET_PRIMARY_NAV";
                        break;
                    }
                    case 9: {
                        cmdStr = "UNSET_PRIMARY_NAV";
                        break;
                    }
                    case 10: {
                        cmdStr = "OP_SET_MAX_LIFECYCLE";
                        break;
                    }
                    default: {
                        cmdStr = "cmd=" + op.mCmd;
                    }
                }
                writer.print(prefix);
                writer.print("  Op #");
                writer.print(opNum);
                writer.print(": ");
                writer.print(cmdStr);
                writer.print(" ");
                writer.println(op.mFragment);
                if (!full) continue;
                if (op.mEnterAnim != 0 || op.mExitAnim != 0) {
                    writer.print(prefix);
                    writer.print("enterAnim=#");
                    writer.print(Integer.toHexString(op.mEnterAnim));
                    writer.print(" exitAnim=#");
                    writer.println(Integer.toHexString(op.mExitAnim));
                }
                if (op.mPopEnterAnim == 0 && op.mPopExitAnim == 0) continue;
                writer.print(prefix);
                writer.print("popEnterAnim=#");
                writer.print(Integer.toHexString(op.mPopEnterAnim));
                writer.print(" popExitAnim=#");
                writer.println(Integer.toHexString(op.mPopExitAnim));
            }
        }
    }

    BackStackRecord(@NonNull FragmentManager manager) {
        super(manager.getFragmentFactory(), manager.getHost() != null ? manager.getHost().getContext().getClassLoader() : null);
        this.mManager = manager;
    }

    BackStackRecord(@NonNull BackStackRecord bse) {
        super(bse.mManager.getFragmentFactory(), bse.mManager.getHost() != null ? bse.mManager.getHost().getContext().getClassLoader() : null, bse);
        this.mManager = bse.mManager;
        this.mCommitted = bse.mCommitted;
        this.mIndex = bse.mIndex;
        this.mBeingSaved = bse.mBeingSaved;
    }

    @Override
    public int getId() {
        return this.mIndex;
    }

    @Override
    public int getBreadCrumbTitleRes() {
        return this.mBreadCrumbTitleRes;
    }

    @Override
    public int getBreadCrumbShortTitleRes() {
        return this.mBreadCrumbShortTitleRes;
    }

    @Override
    @Nullable
    public CharSequence getBreadCrumbTitle() {
        if (this.mBreadCrumbTitleRes != 0) {
            return this.mManager.getHost().getContext().getText(this.mBreadCrumbTitleRes);
        }
        return this.mBreadCrumbTitleText;
    }

    @Override
    @Nullable
    public CharSequence getBreadCrumbShortTitle() {
        if (this.mBreadCrumbShortTitleRes != 0) {
            return this.mManager.getHost().getContext().getText(this.mBreadCrumbShortTitleRes);
        }
        return this.mBreadCrumbShortTitleText;
    }

    @Override
    void doAddOp(int containerViewId, Fragment fragment, @Nullable String tag, int opcmd) {
        super.doAddOp(containerViewId, fragment, tag, opcmd);
        fragment.mFragmentManager = this.mManager;
    }

    @Override
    @NonNull
    public FragmentTransaction remove(@NonNull Fragment fragment) {
        if (fragment.mFragmentManager != null && fragment.mFragmentManager != this.mManager) {
            throw new IllegalStateException("Cannot remove Fragment attached to a different FragmentManager. Fragment " + fragment.toString() + " is already attached to a FragmentManager.");
        }
        return super.remove(fragment);
    }

    @Override
    @NonNull
    public FragmentTransaction hide(@NonNull Fragment fragment) {
        if (fragment.mFragmentManager != null && fragment.mFragmentManager != this.mManager) {
            throw new IllegalStateException("Cannot hide Fragment attached to a different FragmentManager. Fragment " + fragment.toString() + " is already attached to a FragmentManager.");
        }
        return super.hide(fragment);
    }

    @Override
    @NonNull
    public FragmentTransaction show(@NonNull Fragment fragment) {
        if (fragment.mFragmentManager != null && fragment.mFragmentManager != this.mManager) {
            throw new IllegalStateException("Cannot show Fragment attached to a different FragmentManager. Fragment " + fragment.toString() + " is already attached to a FragmentManager.");
        }
        return super.show(fragment);
    }

    @Override
    @NonNull
    public FragmentTransaction detach(@NonNull Fragment fragment) {
        if (fragment.mFragmentManager != null && fragment.mFragmentManager != this.mManager) {
            throw new IllegalStateException("Cannot detach Fragment attached to a different FragmentManager. Fragment " + fragment.toString() + " is already attached to a FragmentManager.");
        }
        return super.detach(fragment);
    }

    @Override
    @NonNull
    public FragmentTransaction setPrimaryNavigationFragment(@Nullable Fragment fragment) {
        if (fragment != null && fragment.mFragmentManager != null && fragment.mFragmentManager != this.mManager) {
            throw new IllegalStateException("Cannot setPrimaryNavigation for Fragment attached to a different FragmentManager. Fragment " + fragment.toString() + " is already attached to a FragmentManager.");
        }
        return super.setPrimaryNavigationFragment(fragment);
    }

    @Override
    @NonNull
    public FragmentTransaction setMaxLifecycle(@NonNull Fragment fragment, @NonNull Lifecycle.State state) {
        if (fragment.mFragmentManager != this.mManager) {
            throw new IllegalArgumentException("Cannot setMaxLifecycle for Fragment not attached to FragmentManager " + this.mManager);
        }
        if (state == Lifecycle.State.INITIALIZED && fragment.mState > -1) {
            throw new IllegalArgumentException("Cannot set maximum Lifecycle to " + (Object)((Object)state) + " after the Fragment has been created");
        }
        if (state == Lifecycle.State.DESTROYED) {
            throw new IllegalArgumentException("Cannot set maximum Lifecycle to " + (Object)((Object)state) + ". Use remove() to remove the fragment from the FragmentManager and trigger its destruction.");
        }
        return super.setMaxLifecycle(fragment, state);
    }

    void bumpBackStackNesting(int amt) {
        if (!this.mAddToBackStack) {
            return;
        }
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("Bump nesting in " + this + " by " + amt));
        }
        int numOps = this.mOps.size();
        for (int opNum = 0; opNum < numOps; ++opNum) {
            FragmentTransaction.Op op = (FragmentTransaction.Op)this.mOps.get(opNum);
            if (op.mFragment == null) continue;
            op.mFragment.mBackStackNesting += amt;
            if (!FragmentManager.isLoggingEnabled(2)) continue;
            Log.v((String)TAG, (String)("Bump nesting of " + op.mFragment + " to " + op.mFragment.mBackStackNesting));
        }
    }

    public void runOnCommitRunnables() {
        if (this.mCommitRunnables != null) {
            for (int i = 0; i < this.mCommitRunnables.size(); ++i) {
                ((Runnable)this.mCommitRunnables.get(i)).run();
            }
            this.mCommitRunnables = null;
        }
    }

    @Override
    public int commit() {
        return this.commitInternal(false);
    }

    @Override
    public int commitAllowingStateLoss() {
        return this.commitInternal(true);
    }

    @Override
    public void commitNow() {
        this.disallowAddToBackStack();
        this.mManager.execSingleAction(this, false);
    }

    @Override
    public void commitNowAllowingStateLoss() {
        this.disallowAddToBackStack();
        this.mManager.execSingleAction(this, true);
    }

    int commitInternal(boolean allowStateLoss) {
        if (this.mCommitted) {
            throw new IllegalStateException("commit already called");
        }
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("Commit: " + this));
            LogWriter logw = new LogWriter(TAG);
            PrintWriter pw = new PrintWriter(logw);
            this.dump("  ", pw);
            pw.close();
        }
        this.mCommitted = true;
        this.mIndex = this.mAddToBackStack ? this.mManager.allocBackStackIndex() : -1;
        this.mManager.enqueueAction(this, allowStateLoss);
        return this.mIndex;
    }

    @Override
    public boolean generateOps(@NonNull ArrayList<BackStackRecord> records, @NonNull ArrayList<Boolean> isRecordPop) {
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("Run: " + this));
        }
        records.add(this);
        isRecordPop.add(false);
        if (this.mAddToBackStack) {
            this.mManager.addBackStackState(this);
        }
        return true;
    }

    void executeOps() {
        int numOps = this.mOps.size();
        block11: for (int opNum = 0; opNum < numOps; ++opNum) {
            FragmentTransaction.Op op = (FragmentTransaction.Op)this.mOps.get(opNum);
            Fragment f = op.mFragment;
            if (f != null) {
                f.mBeingSaved = this.mBeingSaved;
                f.setPopDirection(false);
                f.setNextTransition(this.mTransition);
                f.setSharedElementNames(this.mSharedElementSourceNames, this.mSharedElementTargetNames);
            }
            switch (op.mCmd) {
                case 1: {
                    f.setAnimations(op.mEnterAnim, op.mExitAnim, op.mPopEnterAnim, op.mPopExitAnim);
                    this.mManager.setExitAnimationOrder(f, false);
                    this.mManager.addFragment(f);
                    continue block11;
                }
                case 3: {
                    f.setAnimations(op.mEnterAnim, op.mExitAnim, op.mPopEnterAnim, op.mPopExitAnim);
                    this.mManager.removeFragment(f);
                    continue block11;
                }
                case 4: {
                    f.setAnimations(op.mEnterAnim, op.mExitAnim, op.mPopEnterAnim, op.mPopExitAnim);
                    this.mManager.hideFragment(f);
                    continue block11;
                }
                case 5: {
                    f.setAnimations(op.mEnterAnim, op.mExitAnim, op.mPopEnterAnim, op.mPopExitAnim);
                    this.mManager.setExitAnimationOrder(f, false);
                    this.mManager.showFragment(f);
                    continue block11;
                }
                case 6: {
                    f.setAnimations(op.mEnterAnim, op.mExitAnim, op.mPopEnterAnim, op.mPopExitAnim);
                    this.mManager.detachFragment(f);
                    continue block11;
                }
                case 7: {
                    f.setAnimations(op.mEnterAnim, op.mExitAnim, op.mPopEnterAnim, op.mPopExitAnim);
                    this.mManager.setExitAnimationOrder(f, false);
                    this.mManager.attachFragment(f);
                    continue block11;
                }
                case 8: {
                    this.mManager.setPrimaryNavigationFragment(f);
                    continue block11;
                }
                case 9: {
                    this.mManager.setPrimaryNavigationFragment(null);
                    continue block11;
                }
                case 10: {
                    this.mManager.setMaxLifecycle(f, op.mCurrentMaxState);
                    continue block11;
                }
                default: {
                    throw new IllegalArgumentException("Unknown cmd: " + op.mCmd);
                }
            }
        }
    }

    void executePopOps() {
        block11: for (int opNum = this.mOps.size() - 1; opNum >= 0; --opNum) {
            FragmentTransaction.Op op = (FragmentTransaction.Op)this.mOps.get(opNum);
            Fragment f = op.mFragment;
            if (f != null) {
                f.mBeingSaved = this.mBeingSaved;
                f.setPopDirection(true);
                f.setNextTransition(FragmentManager.reverseTransit(this.mTransition));
                f.setSharedElementNames(this.mSharedElementTargetNames, this.mSharedElementSourceNames);
            }
            switch (op.mCmd) {
                case 1: {
                    f.setAnimations(op.mEnterAnim, op.mExitAnim, op.mPopEnterAnim, op.mPopExitAnim);
                    this.mManager.setExitAnimationOrder(f, true);
                    this.mManager.removeFragment(f);
                    continue block11;
                }
                case 3: {
                    f.setAnimations(op.mEnterAnim, op.mExitAnim, op.mPopEnterAnim, op.mPopExitAnim);
                    this.mManager.addFragment(f);
                    continue block11;
                }
                case 4: {
                    f.setAnimations(op.mEnterAnim, op.mExitAnim, op.mPopEnterAnim, op.mPopExitAnim);
                    this.mManager.showFragment(f);
                    continue block11;
                }
                case 5: {
                    f.setAnimations(op.mEnterAnim, op.mExitAnim, op.mPopEnterAnim, op.mPopExitAnim);
                    this.mManager.setExitAnimationOrder(f, true);
                    this.mManager.hideFragment(f);
                    continue block11;
                }
                case 6: {
                    f.setAnimations(op.mEnterAnim, op.mExitAnim, op.mPopEnterAnim, op.mPopExitAnim);
                    this.mManager.attachFragment(f);
                    continue block11;
                }
                case 7: {
                    f.setAnimations(op.mEnterAnim, op.mExitAnim, op.mPopEnterAnim, op.mPopExitAnim);
                    this.mManager.setExitAnimationOrder(f, true);
                    this.mManager.detachFragment(f);
                    continue block11;
                }
                case 8: {
                    this.mManager.setPrimaryNavigationFragment(null);
                    continue block11;
                }
                case 9: {
                    this.mManager.setPrimaryNavigationFragment(f);
                    continue block11;
                }
                case 10: {
                    this.mManager.setMaxLifecycle(f, op.mOldMaxState);
                    continue block11;
                }
                default: {
                    throw new IllegalArgumentException("Unknown cmd: " + op.mCmd);
                }
            }
        }
    }

    Fragment expandOps(ArrayList<Fragment> added, Fragment oldPrimaryNav) {
        block6: for (int opNum = 0; opNum < this.mOps.size(); ++opNum) {
            FragmentTransaction.Op op = (FragmentTransaction.Op)this.mOps.get(opNum);
            switch (op.mCmd) {
                case 1: 
                case 7: {
                    added.add(op.mFragment);
                    continue block6;
                }
                case 3: 
                case 6: {
                    added.remove(op.mFragment);
                    if (op.mFragment != oldPrimaryNav) continue block6;
                    this.mOps.add(opNum, new FragmentTransaction.Op(9, op.mFragment));
                    ++opNum;
                    oldPrimaryNav = null;
                    continue block6;
                }
                case 2: {
                    Fragment f = op.mFragment;
                    int containerId = f.mContainerId;
                    boolean alreadyAdded = false;
                    for (int i = added.size() - 1; i >= 0; --i) {
                        Fragment old = added.get(i);
                        if (old.mContainerId != containerId) continue;
                        if (old == f) {
                            alreadyAdded = true;
                            continue;
                        }
                        if (old == oldPrimaryNav) {
                            this.mOps.add(opNum, new FragmentTransaction.Op(9, old, true));
                            ++opNum;
                            oldPrimaryNav = null;
                        }
                        FragmentTransaction.Op removeOp = new FragmentTransaction.Op(3, old, true);
                        removeOp.mEnterAnim = op.mEnterAnim;
                        removeOp.mPopEnterAnim = op.mPopEnterAnim;
                        removeOp.mExitAnim = op.mExitAnim;
                        removeOp.mPopExitAnim = op.mPopExitAnim;
                        this.mOps.add(opNum, removeOp);
                        added.remove(old);
                        ++opNum;
                    }
                    if (alreadyAdded) {
                        this.mOps.remove(opNum);
                        --opNum;
                        continue block6;
                    }
                    op.mCmd = 1;
                    op.mFromExpandedOp = true;
                    added.add(f);
                    continue block6;
                }
                case 8: {
                    this.mOps.add(opNum, new FragmentTransaction.Op(9, oldPrimaryNav, true));
                    op.mFromExpandedOp = true;
                    ++opNum;
                    oldPrimaryNav = op.mFragment;
                }
            }
        }
        return oldPrimaryNav;
    }

    Fragment trackAddedFragmentsInPop(ArrayList<Fragment> added, Fragment oldPrimaryNav) {
        block7: for (int opNum = this.mOps.size() - 1; opNum >= 0; --opNum) {
            FragmentTransaction.Op op = (FragmentTransaction.Op)this.mOps.get(opNum);
            switch (op.mCmd) {
                case 1: 
                case 7: {
                    added.remove(op.mFragment);
                    continue block7;
                }
                case 3: 
                case 6: {
                    added.add(op.mFragment);
                    continue block7;
                }
                case 9: {
                    oldPrimaryNav = op.mFragment;
                    continue block7;
                }
                case 8: {
                    oldPrimaryNav = null;
                    continue block7;
                }
                case 10: {
                    op.mCurrentMaxState = op.mOldMaxState;
                }
            }
        }
        return oldPrimaryNav;
    }

    void collapseOps() {
        for (int opNum = this.mOps.size() - 1; opNum >= 0; --opNum) {
            FragmentTransaction.Op op = (FragmentTransaction.Op)this.mOps.get(opNum);
            if (!op.mFromExpandedOp) continue;
            if (op.mCmd == 8) {
                op.mFromExpandedOp = false;
                this.mOps.remove(opNum - 1);
                --opNum;
                continue;
            }
            int containerId = op.mFragment.mContainerId;
            op.mCmd = 2;
            op.mFromExpandedOp = false;
            for (int replaceOpNum = opNum - 1; replaceOpNum >= 0; --replaceOpNum) {
                FragmentTransaction.Op potentialReplaceOp = (FragmentTransaction.Op)this.mOps.get(replaceOpNum);
                if (!potentialReplaceOp.mFromExpandedOp || potentialReplaceOp.mFragment.mContainerId != containerId) continue;
                this.mOps.remove(replaceOpNum);
                --opNum;
            }
        }
    }

    @Override
    @Nullable
    public String getName() {
        return this.mName;
    }

    @Override
    public boolean isEmpty() {
        return this.mOps.isEmpty();
    }
}

