/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.animation.Animator;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.ComponentCallbacks;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentSender;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.ContextMenu;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultCaller;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.ActivityResultRegistry;
import androidx.activity.result.ActivityResultRegistryOwner;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.annotation.AnimRes;
import androidx.annotation.CallSuper;
import androidx.annotation.ContentView;
import androidx.annotation.LayoutRes;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.annotation.UiThread;
import androidx.arch.core.util.Function;
import androidx.core.app.ActivityOptionsCompat;
import androidx.core.app.SharedElementCallback;
import androidx.core.view.LayoutInflaterCompat;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentContainer;
import androidx.fragment.app.FragmentFactory;
import androidx.fragment.app.FragmentHostCallback;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentManagerImpl;
import androidx.fragment.app.FragmentViewLifecycleOwner;
import androidx.fragment.app.SpecialEffectsController;
import androidx.fragment.app.SuperNotCalledException;
import androidx.fragment.app.strictmode.FragmentStrictMode;
import androidx.lifecycle.HasDefaultViewModelProviderFactory;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistry;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.SavedStateHandleSupport;
import androidx.lifecycle.SavedStateViewModelFactory;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.lifecycle.ViewTreeLifecycleOwner;
import androidx.lifecycle.ViewTreeViewModelStoreOwner;
import androidx.lifecycle.viewmodel.CreationExtras;
import androidx.lifecycle.viewmodel.MutableCreationExtras;
import androidx.loader.app.LoaderManager;
import androidx.savedstate.SavedStateRegistry;
import androidx.savedstate.SavedStateRegistryController;
import androidx.savedstate.SavedStateRegistryOwner;
import androidx.savedstate.ViewTreeSavedStateRegistryOwner;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

public class Fragment
implements ComponentCallbacks,
View.OnCreateContextMenuListener,
LifecycleOwner,
ViewModelStoreOwner,
HasDefaultViewModelProviderFactory,
SavedStateRegistryOwner,
ActivityResultCaller {
    static final Object USE_DEFAULT_TRANSITION = new Object();
    static final int INITIALIZING = -1;
    static final int ATTACHED = 0;
    static final int CREATED = 1;
    static final int VIEW_CREATED = 2;
    static final int AWAITING_EXIT_EFFECTS = 3;
    static final int ACTIVITY_CREATED = 4;
    static final int STARTED = 5;
    static final int AWAITING_ENTER_EFFECTS = 6;
    static final int RESUMED = 7;
    int mState = -1;
    Bundle mSavedFragmentState;
    SparseArray<Parcelable> mSavedViewState;
    Bundle mSavedViewRegistryState;
    @Nullable
    Boolean mSavedUserVisibleHint;
    @NonNull
    String mWho = UUID.randomUUID().toString();
    Bundle mArguments;
    Fragment mTarget;
    String mTargetWho = null;
    int mTargetRequestCode;
    private Boolean mIsPrimaryNavigationFragment = null;
    boolean mAdded;
    boolean mRemoving;
    boolean mTransitioning;
    boolean mBeingSaved;
    boolean mFromLayout;
    boolean mInLayout;
    boolean mInDynamicContainer;
    boolean mRestored;
    boolean mPerformedCreateView;
    int mBackStackNesting;
    FragmentManager mFragmentManager;
    FragmentHostCallback<?> mHost;
    @NonNull
    FragmentManager mChildFragmentManager = new FragmentManagerImpl();
    Fragment mParentFragment;
    int mFragmentId;
    int mContainerId;
    String mTag;
    boolean mHidden;
    boolean mDetached;
    boolean mRetainInstance;
    boolean mRetainInstanceChangedWhileDetached;
    boolean mHasMenu;
    boolean mMenuVisible = true;
    private boolean mCalled;
    ViewGroup mContainer;
    View mView;
    boolean mDeferStart;
    boolean mUserVisibleHint = true;
    AnimationInfo mAnimationInfo;
    Handler mPostponedHandler;
    Runnable mPostponedDurationRunnable = new Runnable(){

        @Override
        public void run() {
            Fragment.this.startPostponedEnterTransition();
        }
    };
    boolean mHiddenChanged;
    LayoutInflater mLayoutInflater;
    boolean mIsCreated;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public String mPreviousWho;
    Lifecycle.State mMaxState = Lifecycle.State.RESUMED;
    LifecycleRegistry mLifecycleRegistry;
    @Nullable
    FragmentViewLifecycleOwner mViewLifecycleOwner;
    MutableLiveData<LifecycleOwner> mViewLifecycleOwnerLiveData = new MutableLiveData();
    ViewModelProvider.Factory mDefaultFactory;
    SavedStateRegistryController mSavedStateRegistryController;
    @LayoutRes
    private int mContentLayoutId;
    private final AtomicInteger mNextLocalRequestCode = new AtomicInteger();
    private final ArrayList<OnPreAttachedListener> mOnPreAttachedListeners = new ArrayList();
    private final OnPreAttachedListener mSavedStateAttachListener = new OnPreAttachedListener(){

        @Override
        void onPreAttached() {
            Fragment.this.mSavedStateRegistryController.performAttach();
            SavedStateHandleSupport.enableSavedStateHandles(Fragment.this);
            Bundle savedStateRegistryState = Fragment.this.mSavedFragmentState != null ? Fragment.this.mSavedFragmentState.getBundle("registryState") : null;
            Fragment.this.mSavedStateRegistryController.performRestore(savedStateRegistryState);
        }
    };

    @Override
    @NonNull
    public Lifecycle getLifecycle() {
        return this.mLifecycleRegistry;
    }

    @MainThread
    @NonNull
    public LifecycleOwner getViewLifecycleOwner() {
        if (this.mViewLifecycleOwner == null) {
            throw new IllegalStateException("Can't access the Fragment View's LifecycleOwner for " + this + " when getView() is null i.e., before onCreateView() or after onDestroyView()");
        }
        return this.mViewLifecycleOwner;
    }

    @NonNull
    public LiveData<LifecycleOwner> getViewLifecycleOwnerLiveData() {
        return this.mViewLifecycleOwnerLiveData;
    }

    @Override
    @NonNull
    public ViewModelStore getViewModelStore() {
        if (this.mFragmentManager == null) {
            throw new IllegalStateException("Can't access ViewModels from detached fragment");
        }
        if (this.getMinimumMaxLifecycleState() == Lifecycle.State.INITIALIZED.ordinal()) {
            throw new IllegalStateException("Calling getViewModelStore() before a Fragment reaches onCreate() when using setMaxLifecycle(INITIALIZED) is not supported");
        }
        return this.mFragmentManager.getViewModelStore(this);
    }

    private int getMinimumMaxLifecycleState() {
        if (this.mMaxState == Lifecycle.State.INITIALIZED || this.mParentFragment == null) {
            return this.mMaxState.ordinal();
        }
        return Math.min(this.mMaxState.ordinal(), this.mParentFragment.getMinimumMaxLifecycleState());
    }

    @Override
    @NonNull
    public ViewModelProvider.Factory getDefaultViewModelProviderFactory() {
        if (this.mFragmentManager == null) {
            throw new IllegalStateException("Can't access ViewModels from detached fragment");
        }
        if (this.mDefaultFactory == null) {
            Application application = null;
            Context appContext = this.requireContext().getApplicationContext();
            while (appContext instanceof ContextWrapper) {
                if (appContext instanceof Application) {
                    application = (Application)appContext;
                    break;
                }
                appContext = ((ContextWrapper)appContext).getBaseContext();
            }
            if (application == null && FragmentManager.isLoggingEnabled(3)) {
                Log.d((String)"FragmentManager", (String)("Could not find Application instance from Context " + this.requireContext().getApplicationContext() + ", you will need CreationExtras to use AndroidViewModel with the default ViewModelProvider.Factory"));
            }
            this.mDefaultFactory = new SavedStateViewModelFactory(application, this, this.getArguments());
        }
        return this.mDefaultFactory;
    }

    @Override
    @NonNull
    @CallSuper
    public CreationExtras getDefaultViewModelCreationExtras() {
        Application application = null;
        Context appContext = this.requireContext().getApplicationContext();
        while (appContext instanceof ContextWrapper) {
            if (appContext instanceof Application) {
                application = (Application)appContext;
                break;
            }
            appContext = ((ContextWrapper)appContext).getBaseContext();
        }
        if (application == null && FragmentManager.isLoggingEnabled(3)) {
            Log.d((String)"FragmentManager", (String)("Could not find Application instance from Context " + this.requireContext().getApplicationContext() + ", you will not be able to use AndroidViewModel with the default ViewModelProvider.Factory"));
        }
        MutableCreationExtras extras = new MutableCreationExtras();
        if (application != null) {
            extras.set(ViewModelProvider.AndroidViewModelFactory.APPLICATION_KEY, application);
        }
        extras.set(SavedStateHandleSupport.SAVED_STATE_REGISTRY_OWNER_KEY, this);
        extras.set(SavedStateHandleSupport.VIEW_MODEL_STORE_OWNER_KEY, this);
        if (this.getArguments() != null) {
            extras.set(SavedStateHandleSupport.DEFAULT_ARGS_KEY, this.getArguments());
        }
        return extras;
    }

    @Override
    @NonNull
    public final SavedStateRegistry getSavedStateRegistry() {
        return this.mSavedStateRegistryController.getSavedStateRegistry();
    }

    public Fragment() {
        this.initLifecycle();
    }

    @ContentView
    public Fragment(@LayoutRes int contentLayoutId) {
        this();
        this.mContentLayoutId = contentLayoutId;
    }

    private void initLifecycle() {
        this.mLifecycleRegistry = new LifecycleRegistry(this);
        this.mSavedStateRegistryController = SavedStateRegistryController.create(this);
        this.mDefaultFactory = null;
        if (!this.mOnPreAttachedListeners.contains(this.mSavedStateAttachListener)) {
            this.registerOnPreAttachListener(this.mSavedStateAttachListener);
        }
    }

    @Deprecated
    @NonNull
    public static Fragment instantiate(@NonNull Context context, @NonNull String fname) {
        return Fragment.instantiate(context, fname, null);
    }

    @Deprecated
    @NonNull
    public static Fragment instantiate(@NonNull Context context, @NonNull String fname, @Nullable Bundle args2) {
        try {
            Class<? extends Fragment> clazz = FragmentFactory.loadFragmentClass(context.getClassLoader(), fname);
            Fragment f = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (args2 != null) {
                args2.setClassLoader(f.getClass().getClassLoader());
                f.setArguments(args2);
            }
            return f;
        }
        catch (java.lang.InstantiationException e) {
            throw new InstantiationException("Unable to instantiate fragment " + fname + ": make sure class name exists, is public, and has an empty constructor that is public", e);
        }
        catch (IllegalAccessException e) {
            throw new InstantiationException("Unable to instantiate fragment " + fname + ": make sure class name exists, is public, and has an empty constructor that is public", e);
        }
        catch (NoSuchMethodException e) {
            throw new InstantiationException("Unable to instantiate fragment " + fname + ": could not find Fragment constructor", e);
        }
        catch (InvocationTargetException e) {
            throw new InstantiationException("Unable to instantiate fragment " + fname + ": calling Fragment constructor caused an exception", e);
        }
    }

    final void restoreViewState(Bundle savedInstanceState) {
        if (this.mSavedViewState != null) {
            this.mView.restoreHierarchyState(this.mSavedViewState);
            this.mSavedViewState = null;
        }
        this.mCalled = false;
        this.onViewStateRestored(savedInstanceState);
        if (!this.mCalled) {
            throw new SuperNotCalledException("Fragment " + this + " did not call through to super.onViewStateRestored()");
        }
        if (this.mView != null) {
            this.mViewLifecycleOwner.handleLifecycleEvent(Lifecycle.Event.ON_CREATE);
        }
    }

    final boolean isInBackStack() {
        return this.mBackStackNesting > 0;
    }

    public final boolean equals(@Nullable Object o) {
        return super.equals(o);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        Class<?> cls = this.getClass();
        sb.append(cls.getSimpleName());
        sb.append("{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append("}");
        sb.append(" (");
        sb.append(this.mWho);
        if (this.mFragmentId != 0) {
            sb.append(" id=0x");
            sb.append(Integer.toHexString(this.mFragmentId));
        }
        if (this.mTag != null) {
            sb.append(" tag=");
            sb.append(this.mTag);
        }
        sb.append(")");
        return sb.toString();
    }

    public final int getId() {
        return this.mFragmentId;
    }

    @Nullable
    public final String getTag() {
        return this.mTag;
    }

    public void setArguments(@Nullable Bundle args2) {
        if (this.mFragmentManager != null && this.isStateSaved()) {
            throw new IllegalStateException("Fragment already added and state has been saved");
        }
        this.mArguments = args2;
    }

    @Nullable
    public final Bundle getArguments() {
        return this.mArguments;
    }

    @NonNull
    public final Bundle requireArguments() {
        Bundle arguments = this.getArguments();
        if (arguments == null) {
            throw new IllegalStateException("Fragment " + this + " does not have any arguments.");
        }
        return arguments;
    }

    public final boolean isStateSaved() {
        if (this.mFragmentManager == null) {
            return false;
        }
        return this.mFragmentManager.isStateSaved();
    }

    public void setInitialSavedState(@Nullable SavedState state) {
        if (this.mFragmentManager != null) {
            throw new IllegalStateException("Fragment already added");
        }
        this.mSavedFragmentState = state != null && state.mState != null ? state.mState : null;
    }

    @Deprecated
    public void setTargetFragment(@Nullable Fragment fragment, int requestCode) {
        FragmentManager theirs;
        if (fragment != null) {
            FragmentStrictMode.onSetTargetFragmentUsage(this, fragment, requestCode);
        }
        FragmentManager mine = this.mFragmentManager;
        FragmentManager fragmentManager = theirs = fragment != null ? fragment.mFragmentManager : null;
        if (mine != null && theirs != null && mine != theirs) {
            throw new IllegalArgumentException("Fragment " + fragment + " must share the same FragmentManager to be set as a target fragment");
        }
        for (Fragment check = fragment; check != null; check = check.getTargetFragment(false)) {
            if (!check.equals(this)) continue;
            throw new IllegalArgumentException("Setting " + fragment + " as the target of " + this + " would create a target cycle");
        }
        if (fragment == null) {
            this.mTargetWho = null;
            this.mTarget = null;
        } else if (this.mFragmentManager != null && fragment.mFragmentManager != null) {
            this.mTargetWho = fragment.mWho;
            this.mTarget = null;
        } else {
            this.mTargetWho = null;
            this.mTarget = fragment;
        }
        this.mTargetRequestCode = requestCode;
    }

    @Deprecated
    @Nullable
    public final Fragment getTargetFragment() {
        return this.getTargetFragment(true);
    }

    @Nullable
    private Fragment getTargetFragment(boolean logViolations) {
        if (logViolations) {
            FragmentStrictMode.onGetTargetFragmentUsage(this);
        }
        if (this.mTarget != null) {
            return this.mTarget;
        }
        if (this.mFragmentManager != null && this.mTargetWho != null) {
            return this.mFragmentManager.findActiveFragment(this.mTargetWho);
        }
        return null;
    }

    @Deprecated
    public final int getTargetRequestCode() {
        FragmentStrictMode.onGetTargetFragmentRequestCodeUsage(this);
        return this.mTargetRequestCode;
    }

    @Nullable
    public Context getContext() {
        return this.mHost == null ? null : this.mHost.getContext();
    }

    @NonNull
    public final Context requireContext() {
        Context context = this.getContext();
        if (context == null) {
            throw new IllegalStateException("Fragment " + this + " not attached to a context.");
        }
        return context;
    }

    @Nullable
    public final FragmentActivity getActivity() {
        return this.mHost == null ? null : (FragmentActivity)this.mHost.getActivity();
    }

    @NonNull
    public final FragmentActivity requireActivity() {
        FragmentActivity activity = this.getActivity();
        if (activity == null) {
            throw new IllegalStateException("Fragment " + this + " not attached to an activity.");
        }
        return activity;
    }

    @Nullable
    public final Object getHost() {
        return this.mHost == null ? null : this.mHost.onGetHost();
    }

    @NonNull
    public final Object requireHost() {
        Object host = this.getHost();
        if (host == null) {
            throw new IllegalStateException("Fragment " + this + " not attached to a host.");
        }
        return host;
    }

    @NonNull
    public final Resources getResources() {
        return this.requireContext().getResources();
    }

    @NonNull
    public final CharSequence getText(@StringRes int resId) {
        return this.getResources().getText(resId);
    }

    @NonNull
    public final String getString(@StringRes int resId) {
        return this.getResources().getString(resId);
    }

    @NonNull
    public final String getString(@StringRes int resId, Object ... formatArgs) {
        return this.getResources().getString(resId, formatArgs);
    }

    @Deprecated
    @Nullable
    public final FragmentManager getFragmentManager() {
        return this.mFragmentManager;
    }

    @NonNull
    public final FragmentManager getParentFragmentManager() {
        FragmentManager fragmentManager = this.mFragmentManager;
        if (fragmentManager == null) {
            throw new IllegalStateException("Fragment " + this + " not associated with a fragment manager.");
        }
        return fragmentManager;
    }

    @Deprecated
    @NonNull
    public final FragmentManager requireFragmentManager() {
        return this.getParentFragmentManager();
    }

    @NonNull
    public final FragmentManager getChildFragmentManager() {
        if (this.mHost == null) {
            throw new IllegalStateException("Fragment " + this + " has not been attached yet.");
        }
        return this.mChildFragmentManager;
    }

    @Nullable
    public final Fragment getParentFragment() {
        return this.mParentFragment;
    }

    @NonNull
    public final Fragment requireParentFragment() {
        Fragment parentFragment = this.getParentFragment();
        if (parentFragment == null) {
            Context context = this.getContext();
            if (context == null) {
                throw new IllegalStateException("Fragment " + this + " is not attached to any Fragment or host");
            }
            throw new IllegalStateException("Fragment " + this + " is not a child Fragment, it is directly attached to " + this.getContext());
        }
        return parentFragment;
    }

    public final boolean isAdded() {
        return this.mHost != null && this.mAdded;
    }

    public final boolean isDetached() {
        return this.mDetached;
    }

    public final boolean isRemoving() {
        return this.mRemoving;
    }

    public final boolean isInLayout() {
        return this.mInLayout;
    }

    public final boolean isResumed() {
        return this.mState >= 7;
    }

    public final boolean isVisible() {
        return this.isAdded() && !this.isHidden() && this.mView != null && this.mView.getWindowToken() != null && this.mView.getVisibility() == 0;
    }

    public final boolean isHidden() {
        return this.mHidden || this.mFragmentManager != null && this.mFragmentManager.isParentHidden(this.mParentFragment);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @SuppressLint(value={"KotlinPropertyAccess"})
    public final boolean hasOptionsMenu() {
        return this.mHasMenu;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public final boolean isMenuVisible() {
        return this.mMenuVisible && (this.mFragmentManager == null || this.mFragmentManager.isParentMenuVisible(this.mParentFragment));
    }

    @MainThread
    public void onHiddenChanged(boolean hidden) {
    }

    @Deprecated
    public void setRetainInstance(boolean retain) {
        FragmentStrictMode.onSetRetainInstanceUsage(this);
        this.mRetainInstance = retain;
        if (this.mFragmentManager != null) {
            if (retain) {
                this.mFragmentManager.addRetainedFragment(this);
            } else {
                this.mFragmentManager.removeRetainedFragment(this);
            }
        } else {
            this.mRetainInstanceChangedWhileDetached = true;
        }
    }

    @Deprecated
    public final boolean getRetainInstance() {
        FragmentStrictMode.onGetRetainInstanceUsage(this);
        return this.mRetainInstance;
    }

    @Deprecated
    public void setHasOptionsMenu(boolean hasMenu) {
        if (this.mHasMenu != hasMenu) {
            this.mHasMenu = hasMenu;
            if (this.isAdded() && !this.isHidden()) {
                this.mHost.onSupportInvalidateOptionsMenu();
            }
        }
    }

    public void setMenuVisibility(boolean menuVisible) {
        if (this.mMenuVisible != menuVisible) {
            this.mMenuVisible = menuVisible;
            if (this.mHasMenu && this.isAdded() && !this.isHidden()) {
                this.mHost.onSupportInvalidateOptionsMenu();
            }
        }
    }

    @Deprecated
    public void setUserVisibleHint(boolean isVisibleToUser) {
        FragmentStrictMode.onSetUserVisibleHint(this, isVisibleToUser);
        if (!this.mUserVisibleHint && isVisibleToUser && this.mState < 5 && this.mFragmentManager != null && this.isAdded() && this.mIsCreated) {
            this.mFragmentManager.performPendingDeferredStart(this.mFragmentManager.createOrGetFragmentStateManager(this));
        }
        this.mUserVisibleHint = isVisibleToUser;
        boolean bl = this.mDeferStart = this.mState < 5 && !isVisibleToUser;
        if (this.mSavedFragmentState != null) {
            this.mSavedUserVisibleHint = isVisibleToUser;
        }
    }

    @Deprecated
    public boolean getUserVisibleHint() {
        return this.mUserVisibleHint;
    }

    @Deprecated
    @NonNull
    public LoaderManager getLoaderManager() {
        return LoaderManager.getInstance(this);
    }

    public void startActivity(@NonNull Intent intent) {
        this.startActivity(intent, null);
    }

    public void startActivity(@NonNull Intent intent, @Nullable Bundle options) {
        if (this.mHost == null) {
            throw new IllegalStateException("Fragment " + this + " not attached to Activity");
        }
        this.mHost.onStartActivityFromFragment(this, intent, -1, options);
    }

    @Deprecated
    public void startActivityForResult(@NonNull Intent intent, int requestCode) {
        this.startActivityForResult(intent, requestCode, null);
    }

    @Deprecated
    public void startActivityForResult(@NonNull Intent intent, int requestCode, @Nullable Bundle options) {
        if (this.mHost == null) {
            throw new IllegalStateException("Fragment " + this + " not attached to Activity");
        }
        this.getParentFragmentManager().launchStartActivityForResult(this, intent, requestCode, options);
    }

    @Deprecated
    public void startIntentSenderForResult(@NonNull IntentSender intent, int requestCode, @Nullable Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, @Nullable Bundle options) throws IntentSender.SendIntentException {
        if (this.mHost == null) {
            throw new IllegalStateException("Fragment " + this + " not attached to Activity");
        }
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)"FragmentManager", (String)("Fragment " + this + " received the following in startIntentSenderForResult() requestCode: " + requestCode + " IntentSender: " + intent + " fillInIntent: " + fillInIntent + " options: " + options));
        }
        this.getParentFragmentManager().launchStartIntentSenderForResult(this, intent, requestCode, fillInIntent, flagsMask, flagsValues, extraFlags, options);
    }

    @Deprecated
    public void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)"FragmentManager", (String)("Fragment " + this + " received the following in onActivityResult(): requestCode: " + requestCode + " resultCode: " + resultCode + " data: " + data));
        }
    }

    @Deprecated
    public final void requestPermissions(@NonNull String[] permissions, int requestCode) {
        if (this.mHost == null) {
            throw new IllegalStateException("Fragment " + this + " not attached to Activity");
        }
        this.getParentFragmentManager().launchRequestPermissions(this, permissions, requestCode);
    }

    @Deprecated
    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
    }

    public boolean shouldShowRequestPermissionRationale(@NonNull String permission2) {
        if (this.mHost != null) {
            return this.mHost.onShouldShowRequestPermissionRationale(permission2);
        }
        return false;
    }

    @NonNull
    public LayoutInflater onGetLayoutInflater(@Nullable Bundle savedInstanceState) {
        return this.getLayoutInflater(savedInstanceState);
    }

    @NonNull
    public final LayoutInflater getLayoutInflater() {
        if (this.mLayoutInflater == null) {
            return this.performGetLayoutInflater(null);
        }
        return this.mLayoutInflater;
    }

    @NonNull
    LayoutInflater performGetLayoutInflater(@Nullable Bundle savedInstanceState) {
        this.mLayoutInflater = this.onGetLayoutInflater(savedInstanceState);
        return this.mLayoutInflater;
    }

    @Deprecated
    @NonNull
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public LayoutInflater getLayoutInflater(@Nullable Bundle savedFragmentState) {
        if (this.mHost == null) {
            throw new IllegalStateException("onGetLayoutInflater() cannot be executed until the Fragment is attached to the FragmentManager.");
        }
        LayoutInflater result2 = this.mHost.onGetLayoutInflater();
        LayoutInflaterCompat.setFactory2(result2, this.mChildFragmentManager.getLayoutInflaterFactory());
        return result2;
    }

    @UiThread
    @CallSuper
    public void onInflate(@NonNull Context context, @NonNull AttributeSet attrs, @Nullable Bundle savedInstanceState) {
        Activity hostActivity;
        this.mCalled = true;
        Activity activity = hostActivity = this.mHost == null ? null : this.mHost.getActivity();
        if (hostActivity != null) {
            this.mCalled = false;
            this.onInflate(hostActivity, attrs, savedInstanceState);
        }
    }

    @Deprecated
    @UiThread
    @CallSuper
    public void onInflate(@NonNull Activity activity, @NonNull AttributeSet attrs, @Nullable Bundle savedInstanceState) {
        this.mCalled = true;
    }

    @Deprecated
    @MainThread
    public void onAttachFragment(@NonNull Fragment childFragment) {
    }

    @MainThread
    @CallSuper
    public void onAttach(@NonNull Context context) {
        Activity hostActivity;
        this.mCalled = true;
        Activity activity = hostActivity = this.mHost == null ? null : this.mHost.getActivity();
        if (hostActivity != null) {
            this.mCalled = false;
            this.onAttach(hostActivity);
        }
    }

    @Deprecated
    @MainThread
    @CallSuper
    public void onAttach(@NonNull Activity activity) {
        this.mCalled = true;
    }

    @MainThread
    @Nullable
    public Animation onCreateAnimation(int transit, boolean enter, int nextAnim) {
        return null;
    }

    @MainThread
    @Nullable
    public Animator onCreateAnimator(int transit, boolean enter, int nextAnim) {
        return null;
    }

    @MainThread
    @CallSuper
    public void onCreate(@Nullable Bundle savedInstanceState) {
        this.mCalled = true;
        this.restoreChildFragmentState();
        if (!this.mChildFragmentManager.isStateAtLeast(1)) {
            this.mChildFragmentManager.dispatchCreate();
        }
    }

    void restoreChildFragmentState() {
        Bundle childFragmentManagerState;
        if (this.mSavedFragmentState != null && (childFragmentManagerState = this.mSavedFragmentState.getBundle("childFragmentManager")) != null) {
            this.mChildFragmentManager.restoreSaveStateInternal((Parcelable)childFragmentManagerState);
            this.mChildFragmentManager.dispatchCreate();
        }
    }

    @MainThread
    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        if (this.mContentLayoutId != 0) {
            return inflater.inflate(this.mContentLayoutId, container, false);
        }
        return null;
    }

    @MainThread
    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
    }

    @Nullable
    public View getView() {
        return this.mView;
    }

    @NonNull
    public final View requireView() {
        View view = this.getView();
        if (view == null) {
            throw new IllegalStateException("Fragment " + this + " did not return a View from onCreateView() or this was called before onCreateView().");
        }
        return view;
    }

    @Deprecated
    @MainThread
    @CallSuper
    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        this.mCalled = true;
    }

    @MainThread
    @CallSuper
    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        this.mCalled = true;
    }

    @MainThread
    @CallSuper
    public void onStart() {
        this.mCalled = true;
    }

    @MainThread
    @CallSuper
    public void onResume() {
        this.mCalled = true;
    }

    @MainThread
    public void onSaveInstanceState(@NonNull Bundle outState) {
    }

    public void onMultiWindowModeChanged(boolean isInMultiWindowMode) {
    }

    public void onPictureInPictureModeChanged(boolean isInPictureInPictureMode) {
    }

    @CallSuper
    public void onConfigurationChanged(@NonNull Configuration newConfig) {
        this.mCalled = true;
    }

    @MainThread
    public void onPrimaryNavigationFragmentChanged(boolean isPrimaryNavigationFragment) {
    }

    @MainThread
    @CallSuper
    public void onPause() {
        this.mCalled = true;
    }

    @MainThread
    @CallSuper
    public void onStop() {
        this.mCalled = true;
    }

    @MainThread
    @CallSuper
    public void onLowMemory() {
        this.mCalled = true;
    }

    @MainThread
    @CallSuper
    public void onDestroyView() {
        this.mCalled = true;
    }

    @MainThread
    @CallSuper
    public void onDestroy() {
        this.mCalled = true;
    }

    void initState() {
        this.initLifecycle();
        this.mPreviousWho = this.mWho;
        this.mWho = UUID.randomUUID().toString();
        this.mAdded = false;
        this.mRemoving = false;
        this.mFromLayout = false;
        this.mInLayout = false;
        this.mRestored = false;
        this.mBackStackNesting = 0;
        this.mFragmentManager = null;
        this.mChildFragmentManager = new FragmentManagerImpl();
        this.mHost = null;
        this.mFragmentId = 0;
        this.mContainerId = 0;
        this.mTag = null;
        this.mHidden = false;
        this.mDetached = false;
    }

    @MainThread
    @CallSuper
    public void onDetach() {
        this.mCalled = true;
    }

    @Deprecated
    @MainThread
    public void onCreateOptionsMenu(@NonNull Menu menu2, @NonNull MenuInflater inflater) {
    }

    @Deprecated
    @MainThread
    public void onPrepareOptionsMenu(@NonNull Menu menu2) {
    }

    @Deprecated
    @MainThread
    public void onDestroyOptionsMenu() {
    }

    @Deprecated
    @MainThread
    public boolean onOptionsItemSelected(@NonNull MenuItem item) {
        return false;
    }

    @Deprecated
    @MainThread
    public void onOptionsMenuClosed(@NonNull Menu menu2) {
    }

    @MainThread
    public void onCreateContextMenu(@NonNull ContextMenu menu2, @NonNull View v, @Nullable ContextMenu.ContextMenuInfo menuInfo) {
        this.requireActivity().onCreateContextMenu(menu2, v, menuInfo);
    }

    public void registerForContextMenu(@NonNull View view) {
        view.setOnCreateContextMenuListener((View.OnCreateContextMenuListener)this);
    }

    public void unregisterForContextMenu(@NonNull View view) {
        view.setOnCreateContextMenuListener(null);
    }

    @MainThread
    public boolean onContextItemSelected(@NonNull MenuItem item) {
        return false;
    }

    public void setEnterSharedElementCallback(@Nullable SharedElementCallback callback2) {
        this.ensureAnimationInfo().mEnterTransitionCallback = callback2;
    }

    public void setExitSharedElementCallback(@Nullable SharedElementCallback callback2) {
        this.ensureAnimationInfo().mExitTransitionCallback = callback2;
    }

    public void setEnterTransition(@Nullable Object transition) {
        this.ensureAnimationInfo().mEnterTransition = transition;
    }

    @Nullable
    public Object getEnterTransition() {
        if (this.mAnimationInfo == null) {
            return null;
        }
        return this.mAnimationInfo.mEnterTransition;
    }

    public void setReturnTransition(@Nullable Object transition) {
        this.ensureAnimationInfo().mReturnTransition = transition;
    }

    @Nullable
    public Object getReturnTransition() {
        if (this.mAnimationInfo == null) {
            return null;
        }
        return this.mAnimationInfo.mReturnTransition == USE_DEFAULT_TRANSITION ? this.getEnterTransition() : this.mAnimationInfo.mReturnTransition;
    }

    public void setExitTransition(@Nullable Object transition) {
        this.ensureAnimationInfo().mExitTransition = transition;
    }

    @Nullable
    public Object getExitTransition() {
        if (this.mAnimationInfo == null) {
            return null;
        }
        return this.mAnimationInfo.mExitTransition;
    }

    public void setReenterTransition(@Nullable Object transition) {
        this.ensureAnimationInfo().mReenterTransition = transition;
    }

    @Nullable
    public Object getReenterTransition() {
        if (this.mAnimationInfo == null) {
            return null;
        }
        return this.mAnimationInfo.mReenterTransition == USE_DEFAULT_TRANSITION ? this.getExitTransition() : this.mAnimationInfo.mReenterTransition;
    }

    public void setSharedElementEnterTransition(@Nullable Object transition) {
        this.ensureAnimationInfo().mSharedElementEnterTransition = transition;
    }

    @Nullable
    public Object getSharedElementEnterTransition() {
        if (this.mAnimationInfo == null) {
            return null;
        }
        return this.mAnimationInfo.mSharedElementEnterTransition;
    }

    public void setSharedElementReturnTransition(@Nullable Object transition) {
        this.ensureAnimationInfo().mSharedElementReturnTransition = transition;
    }

    @Nullable
    public Object getSharedElementReturnTransition() {
        if (this.mAnimationInfo == null) {
            return null;
        }
        return this.mAnimationInfo.mSharedElementReturnTransition == USE_DEFAULT_TRANSITION ? this.getSharedElementEnterTransition() : this.mAnimationInfo.mSharedElementReturnTransition;
    }

    public void setAllowEnterTransitionOverlap(boolean allow) {
        this.ensureAnimationInfo().mAllowEnterTransitionOverlap = allow;
    }

    public boolean getAllowEnterTransitionOverlap() {
        return this.mAnimationInfo == null || this.mAnimationInfo.mAllowEnterTransitionOverlap == null ? true : this.mAnimationInfo.mAllowEnterTransitionOverlap;
    }

    public void setAllowReturnTransitionOverlap(boolean allow) {
        this.ensureAnimationInfo().mAllowReturnTransitionOverlap = allow;
    }

    public boolean getAllowReturnTransitionOverlap() {
        return this.mAnimationInfo == null || this.mAnimationInfo.mAllowReturnTransitionOverlap == null ? true : this.mAnimationInfo.mAllowReturnTransitionOverlap;
    }

    public void postponeEnterTransition() {
        this.ensureAnimationInfo().mEnterTransitionPostponed = true;
    }

    public final void postponeEnterTransition(long duration, @NonNull TimeUnit timeUnit) {
        this.ensureAnimationInfo().mEnterTransitionPostponed = true;
        if (this.mPostponedHandler != null) {
            this.mPostponedHandler.removeCallbacks(this.mPostponedDurationRunnable);
        }
        this.mPostponedHandler = this.mFragmentManager != null ? this.mFragmentManager.getHost().getHandler() : new Handler(Looper.getMainLooper());
        this.mPostponedHandler.removeCallbacks(this.mPostponedDurationRunnable);
        this.mPostponedHandler.postDelayed(this.mPostponedDurationRunnable, timeUnit.toMillis(duration));
    }

    public void startPostponedEnterTransition() {
        if (this.mAnimationInfo == null || !this.ensureAnimationInfo().mEnterTransitionPostponed) {
            return;
        }
        if (this.mHost == null) {
            this.ensureAnimationInfo().mEnterTransitionPostponed = false;
        } else if (Looper.myLooper() != this.mHost.getHandler().getLooper()) {
            this.mHost.getHandler().postAtFrontOfQueue(new Runnable(){

                @Override
                public void run() {
                    Fragment.this.callStartTransitionListener(false);
                }
            });
        } else {
            this.callStartTransitionListener(true);
        }
    }

    void callStartTransitionListener(boolean calledDirectly) {
        if (this.mAnimationInfo != null) {
            this.mAnimationInfo.mEnterTransitionPostponed = false;
        }
        if (this.mView != null && this.mContainer != null && this.mFragmentManager != null) {
            final SpecialEffectsController controller = SpecialEffectsController.getOrCreateController(this.mContainer, this.mFragmentManager);
            controller.markPostponedState();
            if (calledDirectly) {
                this.mHost.getHandler().post(new Runnable(){

                    @Override
                    public void run() {
                        if (controller.isPendingExecute()) {
                            controller.executePendingOperations();
                        }
                    }
                });
            } else {
                controller.executePendingOperations();
            }
            if (this.mPostponedHandler != null) {
                this.mPostponedHandler.removeCallbacks(this.mPostponedDurationRunnable);
                this.mPostponedHandler = null;
            }
        }
    }

    public void dump(@NonNull String prefix, @Nullable FileDescriptor fd, @NonNull PrintWriter writer, @Nullable String[] args2) {
        Fragment target;
        writer.print(prefix);
        writer.print("mFragmentId=#");
        writer.print(Integer.toHexString(this.mFragmentId));
        writer.print(" mContainerId=#");
        writer.print(Integer.toHexString(this.mContainerId));
        writer.print(" mTag=");
        writer.println(this.mTag);
        writer.print(prefix);
        writer.print("mState=");
        writer.print(this.mState);
        writer.print(" mWho=");
        writer.print(this.mWho);
        writer.print(" mBackStackNesting=");
        writer.println(this.mBackStackNesting);
        writer.print(prefix);
        writer.print("mAdded=");
        writer.print(this.mAdded);
        writer.print(" mRemoving=");
        writer.print(this.mRemoving);
        writer.print(" mFromLayout=");
        writer.print(this.mFromLayout);
        writer.print(" mInLayout=");
        writer.println(this.mInLayout);
        writer.print(prefix);
        writer.print("mHidden=");
        writer.print(this.mHidden);
        writer.print(" mDetached=");
        writer.print(this.mDetached);
        writer.print(" mMenuVisible=");
        writer.print(this.mMenuVisible);
        writer.print(" mHasMenu=");
        writer.println(this.mHasMenu);
        writer.print(prefix);
        writer.print("mRetainInstance=");
        writer.print(this.mRetainInstance);
        writer.print(" mUserVisibleHint=");
        writer.println(this.mUserVisibleHint);
        if (this.mFragmentManager != null) {
            writer.print(prefix);
            writer.print("mFragmentManager=");
            writer.println(this.mFragmentManager);
        }
        if (this.mHost != null) {
            writer.print(prefix);
            writer.print("mHost=");
            writer.println(this.mHost);
        }
        if (this.mParentFragment != null) {
            writer.print(prefix);
            writer.print("mParentFragment=");
            writer.println(this.mParentFragment);
        }
        if (this.mArguments != null) {
            writer.print(prefix);
            writer.print("mArguments=");
            writer.println(this.mArguments);
        }
        if (this.mSavedFragmentState != null) {
            writer.print(prefix);
            writer.print("mSavedFragmentState=");
            writer.println(this.mSavedFragmentState);
        }
        if (this.mSavedViewState != null) {
            writer.print(prefix);
            writer.print("mSavedViewState=");
            writer.println(this.mSavedViewState);
        }
        if (this.mSavedViewRegistryState != null) {
            writer.print(prefix);
            writer.print("mSavedViewRegistryState=");
            writer.println(this.mSavedViewRegistryState);
        }
        if ((target = this.getTargetFragment(false)) != null) {
            writer.print(prefix);
            writer.print("mTarget=");
            writer.print(target);
            writer.print(" mTargetRequestCode=");
            writer.println(this.mTargetRequestCode);
        }
        writer.print(prefix);
        writer.print("mPopDirection=");
        writer.println(this.getPopDirection());
        if (this.getEnterAnim() != 0) {
            writer.print(prefix);
            writer.print("getEnterAnim=");
            writer.println(this.getEnterAnim());
        }
        if (this.getExitAnim() != 0) {
            writer.print(prefix);
            writer.print("getExitAnim=");
            writer.println(this.getExitAnim());
        }
        if (this.getPopEnterAnim() != 0) {
            writer.print(prefix);
            writer.print("getPopEnterAnim=");
            writer.println(this.getPopEnterAnim());
        }
        if (this.getPopExitAnim() != 0) {
            writer.print(prefix);
            writer.print("getPopExitAnim=");
            writer.println(this.getPopExitAnim());
        }
        if (this.mContainer != null) {
            writer.print(prefix);
            writer.print("mContainer=");
            writer.println(this.mContainer);
        }
        if (this.mView != null) {
            writer.print(prefix);
            writer.print("mView=");
            writer.println(this.mView);
        }
        if (this.getAnimatingAway() != null) {
            writer.print(prefix);
            writer.print("mAnimatingAway=");
            writer.println(this.getAnimatingAway());
        }
        if (this.getContext() != null) {
            LoaderManager.getInstance(this).dump(prefix, fd, writer, args2);
        }
        writer.print(prefix);
        writer.println("Child " + this.mChildFragmentManager + ":");
        this.mChildFragmentManager.dump(prefix + "  ", fd, writer, args2);
    }

    @Nullable
    Fragment findFragmentByWho(@NonNull String who) {
        if (who.equals(this.mWho)) {
            return this;
        }
        return this.mChildFragmentManager.findFragmentByWho(who);
    }

    @NonNull
    FragmentContainer createFragmentContainer() {
        return new FragmentContainer(){

            @Override
            @Nullable
            public View onFindViewById(int id2) {
                if (Fragment.this.mView == null) {
                    throw new IllegalStateException("Fragment " + Fragment.this + " does not have a view");
                }
                return Fragment.this.mView.findViewById(id2);
            }

            @Override
            public boolean onHasView() {
                return Fragment.this.mView != null;
            }
        };
    }

    void performAttach() {
        for (OnPreAttachedListener listener2 : this.mOnPreAttachedListeners) {
            listener2.onPreAttached();
        }
        this.mOnPreAttachedListeners.clear();
        this.mChildFragmentManager.attachController(this.mHost, this.createFragmentContainer(), this);
        this.mState = 0;
        this.mCalled = false;
        this.onAttach(this.mHost.getContext());
        if (!this.mCalled) {
            throw new SuperNotCalledException("Fragment " + this + " did not call through to super.onAttach()");
        }
        this.mFragmentManager.dispatchOnAttachFragment(this);
        this.mChildFragmentManager.dispatchAttach();
    }

    void performCreate(Bundle savedInstanceState) {
        this.mChildFragmentManager.noteStateNotSaved();
        this.mState = 1;
        this.mCalled = false;
        this.mLifecycleRegistry.addObserver(new LifecycleEventObserver(){

            @Override
            public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
                if (event == Lifecycle.Event.ON_STOP && Fragment.this.mView != null) {
                    Fragment.this.mView.cancelPendingInputEvents();
                }
            }
        });
        this.onCreate(savedInstanceState);
        this.mIsCreated = true;
        if (!this.mCalled) {
            throw new SuperNotCalledException("Fragment " + this + " did not call through to super.onCreate()");
        }
        this.mLifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_CREATE);
    }

    void performCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        this.mChildFragmentManager.noteStateNotSaved();
        this.mPerformedCreateView = true;
        this.mViewLifecycleOwner = new FragmentViewLifecycleOwner(this, this.getViewModelStore(), () -> {
            this.mViewLifecycleOwner.performRestore(this.mSavedViewRegistryState);
            this.mSavedViewRegistryState = null;
        });
        this.mView = this.onCreateView(inflater, container, savedInstanceState);
        if (this.mView != null) {
            this.mViewLifecycleOwner.initialize();
            if (FragmentManager.isLoggingEnabled(3)) {
                Log.d((String)"FragmentManager", (String)("Setting ViewLifecycleOwner on View " + this.mView + " for Fragment " + this));
            }
            ViewTreeLifecycleOwner.set(this.mView, this.mViewLifecycleOwner);
            ViewTreeViewModelStoreOwner.set(this.mView, this.mViewLifecycleOwner);
            ViewTreeSavedStateRegistryOwner.set(this.mView, this.mViewLifecycleOwner);
            this.mViewLifecycleOwnerLiveData.setValue(this.mViewLifecycleOwner);
        } else {
            if (this.mViewLifecycleOwner.isInitialized()) {
                throw new IllegalStateException("Called getViewLifecycleOwner() but onCreateView() returned null");
            }
            this.mViewLifecycleOwner = null;
        }
    }

    void performViewCreated() {
        Bundle savedInstanceState = null;
        if (this.mSavedFragmentState != null) {
            savedInstanceState = this.mSavedFragmentState.getBundle("savedInstanceState");
        }
        this.onViewCreated(this.mView, savedInstanceState);
        this.mChildFragmentManager.dispatchViewCreated();
    }

    void performActivityCreated(Bundle savedInstanceState) {
        this.mChildFragmentManager.noteStateNotSaved();
        this.mState = 3;
        this.mCalled = false;
        this.onActivityCreated(savedInstanceState);
        if (!this.mCalled) {
            throw new SuperNotCalledException("Fragment " + this + " did not call through to super.onActivityCreated()");
        }
        this.restoreViewState();
        this.mChildFragmentManager.dispatchActivityCreated();
    }

    private void restoreViewState() {
        if (FragmentManager.isLoggingEnabled(3)) {
            Log.d((String)"FragmentManager", (String)("moveto RESTORE_VIEW_STATE: " + this));
        }
        if (this.mView != null) {
            Bundle savedInstanceState = null;
            if (this.mSavedFragmentState != null) {
                savedInstanceState = this.mSavedFragmentState.getBundle("savedInstanceState");
            }
            this.restoreViewState(savedInstanceState);
        }
        this.mSavedFragmentState = null;
    }

    void performStart() {
        this.mChildFragmentManager.noteStateNotSaved();
        this.mChildFragmentManager.execPendingActions(true);
        this.mState = 5;
        this.mCalled = false;
        this.onStart();
        if (!this.mCalled) {
            throw new SuperNotCalledException("Fragment " + this + " did not call through to super.onStart()");
        }
        this.mLifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_START);
        if (this.mView != null) {
            this.mViewLifecycleOwner.handleLifecycleEvent(Lifecycle.Event.ON_START);
        }
        this.mChildFragmentManager.dispatchStart();
    }

    void performResume() {
        this.mChildFragmentManager.noteStateNotSaved();
        this.mChildFragmentManager.execPendingActions(true);
        this.mState = 7;
        this.mCalled = false;
        this.onResume();
        if (!this.mCalled) {
            throw new SuperNotCalledException("Fragment " + this + " did not call through to super.onResume()");
        }
        this.mLifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_RESUME);
        if (this.mView != null) {
            this.mViewLifecycleOwner.handleLifecycleEvent(Lifecycle.Event.ON_RESUME);
        }
        this.mChildFragmentManager.dispatchResume();
    }

    void noteStateNotSaved() {
        this.mChildFragmentManager.noteStateNotSaved();
    }

    void performPrimaryNavigationFragmentChanged() {
        boolean isPrimaryNavigationFragment = this.mFragmentManager.isPrimaryNavigation(this);
        if (this.mIsPrimaryNavigationFragment == null || this.mIsPrimaryNavigationFragment != isPrimaryNavigationFragment) {
            this.mIsPrimaryNavigationFragment = isPrimaryNavigationFragment;
            this.onPrimaryNavigationFragmentChanged(isPrimaryNavigationFragment);
            this.mChildFragmentManager.dispatchPrimaryNavigationFragmentChanged();
        }
    }

    void performMultiWindowModeChanged(boolean isInMultiWindowMode) {
        this.onMultiWindowModeChanged(isInMultiWindowMode);
    }

    void performPictureInPictureModeChanged(boolean isInPictureInPictureMode) {
        this.onPictureInPictureModeChanged(isInPictureInPictureMode);
    }

    void performConfigurationChanged(@NonNull Configuration newConfig) {
        this.onConfigurationChanged(newConfig);
    }

    void performLowMemory() {
        this.onLowMemory();
    }

    boolean performCreateOptionsMenu(@NonNull Menu menu2, @NonNull MenuInflater inflater) {
        boolean show = false;
        if (!this.mHidden) {
            if (this.mHasMenu && this.mMenuVisible) {
                show = true;
                this.onCreateOptionsMenu(menu2, inflater);
            }
            show |= this.mChildFragmentManager.dispatchCreateOptionsMenu(menu2, inflater);
        }
        return show;
    }

    boolean performPrepareOptionsMenu(@NonNull Menu menu2) {
        boolean show = false;
        if (!this.mHidden) {
            if (this.mHasMenu && this.mMenuVisible) {
                show = true;
                this.onPrepareOptionsMenu(menu2);
            }
            show |= this.mChildFragmentManager.dispatchPrepareOptionsMenu(menu2);
        }
        return show;
    }

    boolean performOptionsItemSelected(@NonNull MenuItem item) {
        if (!this.mHidden) {
            if (this.mHasMenu && this.mMenuVisible && this.onOptionsItemSelected(item)) {
                return true;
            }
            return this.mChildFragmentManager.dispatchOptionsItemSelected(item);
        }
        return false;
    }

    boolean performContextItemSelected(@NonNull MenuItem item) {
        if (!this.mHidden) {
            if (this.onContextItemSelected(item)) {
                return true;
            }
            return this.mChildFragmentManager.dispatchContextItemSelected(item);
        }
        return false;
    }

    void performOptionsMenuClosed(@NonNull Menu menu2) {
        if (!this.mHidden) {
            if (this.mHasMenu && this.mMenuVisible) {
                this.onOptionsMenuClosed(menu2);
            }
            this.mChildFragmentManager.dispatchOptionsMenuClosed(menu2);
        }
    }

    void performSaveInstanceState(Bundle outState) {
        this.onSaveInstanceState(outState);
    }

    void performPause() {
        this.mChildFragmentManager.dispatchPause();
        if (this.mView != null) {
            this.mViewLifecycleOwner.handleLifecycleEvent(Lifecycle.Event.ON_PAUSE);
        }
        this.mLifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_PAUSE);
        this.mState = 6;
        this.mCalled = false;
        this.onPause();
        if (!this.mCalled) {
            throw new SuperNotCalledException("Fragment " + this + " did not call through to super.onPause()");
        }
    }

    void performStop() {
        this.mChildFragmentManager.dispatchStop();
        if (this.mView != null) {
            this.mViewLifecycleOwner.handleLifecycleEvent(Lifecycle.Event.ON_STOP);
        }
        this.mLifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_STOP);
        this.mState = 4;
        this.mCalled = false;
        this.onStop();
        if (!this.mCalled) {
            throw new SuperNotCalledException("Fragment " + this + " did not call through to super.onStop()");
        }
    }

    void performDestroyView() {
        this.mChildFragmentManager.dispatchDestroyView();
        if (this.mView != null && this.mViewLifecycleOwner.getLifecycle().getCurrentState().isAtLeast(Lifecycle.State.CREATED)) {
            this.mViewLifecycleOwner.handleLifecycleEvent(Lifecycle.Event.ON_DESTROY);
        }
        this.mState = 1;
        this.mCalled = false;
        this.onDestroyView();
        if (!this.mCalled) {
            throw new SuperNotCalledException("Fragment " + this + " did not call through to super.onDestroyView()");
        }
        LoaderManager.getInstance(this).markForRedelivery();
        this.mPerformedCreateView = false;
    }

    void performDestroy() {
        this.mChildFragmentManager.dispatchDestroy();
        this.mLifecycleRegistry.handleLifecycleEvent(Lifecycle.Event.ON_DESTROY);
        this.mState = 0;
        this.mCalled = false;
        this.mIsCreated = false;
        this.onDestroy();
        if (!this.mCalled) {
            throw new SuperNotCalledException("Fragment " + this + " did not call through to super.onDestroy()");
        }
    }

    void performDetach() {
        this.mState = -1;
        this.mCalled = false;
        this.onDetach();
        this.mLayoutInflater = null;
        if (!this.mCalled) {
            throw new SuperNotCalledException("Fragment " + this + " did not call through to super.onDetach()");
        }
        if (!this.mChildFragmentManager.isDestroyed()) {
            this.mChildFragmentManager.dispatchDestroy();
            this.mChildFragmentManager = new FragmentManagerImpl();
        }
    }

    private AnimationInfo ensureAnimationInfo() {
        if (this.mAnimationInfo == null) {
            this.mAnimationInfo = new AnimationInfo();
        }
        return this.mAnimationInfo;
    }

    void setAnimations(@AnimRes int enter, @AnimRes int exit, @AnimRes int popEnter, @AnimRes int popExit) {
        if (this.mAnimationInfo == null && enter == 0 && exit == 0 && popEnter == 0 && popExit == 0) {
            return;
        }
        this.ensureAnimationInfo().mEnterAnim = enter;
        this.ensureAnimationInfo().mExitAnim = exit;
        this.ensureAnimationInfo().mPopEnterAnim = popEnter;
        this.ensureAnimationInfo().mPopExitAnim = popExit;
    }

    @AnimRes
    int getEnterAnim() {
        if (this.mAnimationInfo == null) {
            return 0;
        }
        return this.mAnimationInfo.mEnterAnim;
    }

    @AnimRes
    int getExitAnim() {
        if (this.mAnimationInfo == null) {
            return 0;
        }
        return this.mAnimationInfo.mExitAnim;
    }

    @AnimRes
    int getPopEnterAnim() {
        if (this.mAnimationInfo == null) {
            return 0;
        }
        return this.mAnimationInfo.mPopEnterAnim;
    }

    @AnimRes
    int getPopExitAnim() {
        if (this.mAnimationInfo == null) {
            return 0;
        }
        return this.mAnimationInfo.mPopExitAnim;
    }

    boolean getPopDirection() {
        if (this.mAnimationInfo == null) {
            return false;
        }
        return this.mAnimationInfo.mIsPop;
    }

    void setPopDirection(boolean isPop) {
        if (this.mAnimationInfo == null) {
            return;
        }
        this.ensureAnimationInfo().mIsPop = isPop;
    }

    int getNextTransition() {
        if (this.mAnimationInfo == null) {
            return 0;
        }
        return this.mAnimationInfo.mNextTransition;
    }

    void setNextTransition(int nextTransition) {
        if (this.mAnimationInfo == null && nextTransition == 0) {
            return;
        }
        this.ensureAnimationInfo();
        this.mAnimationInfo.mNextTransition = nextTransition;
    }

    @NonNull
    ArrayList<String> getSharedElementSourceNames() {
        if (this.mAnimationInfo == null || this.mAnimationInfo.mSharedElementSourceNames == null) {
            return new ArrayList<String>();
        }
        return this.mAnimationInfo.mSharedElementSourceNames;
    }

    @NonNull
    ArrayList<String> getSharedElementTargetNames() {
        if (this.mAnimationInfo == null || this.mAnimationInfo.mSharedElementTargetNames == null) {
            return new ArrayList<String>();
        }
        return this.mAnimationInfo.mSharedElementTargetNames;
    }

    void setSharedElementNames(@Nullable ArrayList<String> sharedElementSourceNames, @Nullable ArrayList<String> sharedElementTargetNames) {
        this.ensureAnimationInfo();
        this.mAnimationInfo.mSharedElementSourceNames = sharedElementSourceNames;
        this.mAnimationInfo.mSharedElementTargetNames = sharedElementTargetNames;
    }

    SharedElementCallback getEnterTransitionCallback() {
        if (this.mAnimationInfo == null) {
            return null;
        }
        return this.mAnimationInfo.mEnterTransitionCallback;
    }

    SharedElementCallback getExitTransitionCallback() {
        if (this.mAnimationInfo == null) {
            return null;
        }
        return this.mAnimationInfo.mExitTransitionCallback;
    }

    View getAnimatingAway() {
        if (this.mAnimationInfo == null) {
            return null;
        }
        return this.mAnimationInfo.mAnimatingAway;
    }

    void setPostOnViewCreatedAlpha(float alpha) {
        this.ensureAnimationInfo().mPostOnViewCreatedAlpha = alpha;
    }

    float getPostOnViewCreatedAlpha() {
        if (this.mAnimationInfo == null) {
            return 1.0f;
        }
        return this.mAnimationInfo.mPostOnViewCreatedAlpha;
    }

    void setFocusedView(View view) {
        this.ensureAnimationInfo().mFocusedView = view;
    }

    View getFocusedView() {
        if (this.mAnimationInfo == null) {
            return null;
        }
        return this.mAnimationInfo.mFocusedView;
    }

    boolean isPostponed() {
        if (this.mAnimationInfo == null) {
            return false;
        }
        return this.mAnimationInfo.mEnterTransitionPostponed;
    }

    @Override
    @MainThread
    @NonNull
    public final <I, O> ActivityResultLauncher<I> registerForActivityResult(@NonNull ActivityResultContract<I, O> contract, @NonNull ActivityResultCallback<O> callback2) {
        return this.prepareCallInternal(contract, new Function<Void, ActivityResultRegistry>(){

            @Override
            public ActivityResultRegistry apply(Void input) {
                if (Fragment.this.mHost instanceof ActivityResultRegistryOwner) {
                    return ((ActivityResultRegistryOwner)((Object)Fragment.this.mHost)).getActivityResultRegistry();
                }
                return Fragment.this.requireActivity().getActivityResultRegistry();
            }
        }, callback2);
    }

    @Override
    @MainThread
    @NonNull
    public final <I, O> ActivityResultLauncher<I> registerForActivityResult(@NonNull ActivityResultContract<I, O> contract, final @NonNull ActivityResultRegistry registry, @NonNull ActivityResultCallback<O> callback2) {
        return this.prepareCallInternal(contract, new Function<Void, ActivityResultRegistry>(){

            @Override
            public ActivityResultRegistry apply(Void input) {
                return registry;
            }
        }, callback2);
    }

    @NonNull
    private <I, O> ActivityResultLauncher<I> prepareCallInternal(final @NonNull ActivityResultContract<I, O> contract, final @NonNull Function<Void, ActivityResultRegistry> registryProvider, final @NonNull ActivityResultCallback<O> callback2) {
        if (this.mState > 1) {
            throw new IllegalStateException("Fragment " + this + " is attempting to registerForActivityResult after being created. Fragments must call registerForActivityResult() before they are created (i.e. initialization, onAttach(), or onCreate()).");
        }
        final AtomicReference ref = new AtomicReference();
        this.registerOnPreAttachListener(new OnPreAttachedListener(){

            @Override
            void onPreAttached() {
                String key = Fragment.this.generateActivityResultKey();
                ActivityResultRegistry registry = (ActivityResultRegistry)registryProvider.apply(null);
                ref.set(registry.register(key, Fragment.this, contract, callback2));
            }
        });
        return new ActivityResultLauncher<I>(){

            @Override
            public void launch(I input, @Nullable ActivityOptionsCompat options) {
                ActivityResultLauncher delegate = (ActivityResultLauncher)ref.get();
                if (delegate == null) {
                    throw new IllegalStateException("Operation cannot be started before fragment is in created state");
                }
                delegate.launch(input, options);
            }

            @Override
            public void unregister() {
                ActivityResultLauncher delegate = ref.getAndSet(null);
                if (delegate != null) {
                    delegate.unregister();
                }
            }

            @Override
            @NonNull
            public ActivityResultContract<I, ?> getContract() {
                return contract;
            }
        };
    }

    private void registerOnPreAttachListener(@NonNull OnPreAttachedListener callback2) {
        if (this.mState >= 0) {
            callback2.onPreAttached();
        } else {
            this.mOnPreAttachedListeners.add(callback2);
        }
    }

    @NonNull
    String generateActivityResultKey() {
        return "fragment_" + this.mWho + "_rq#" + this.mNextLocalRequestCode.getAndIncrement();
    }

    private static abstract class OnPreAttachedListener {
        private OnPreAttachedListener() {
        }

        abstract void onPreAttached();
    }

    public static class InstantiationException
    extends RuntimeException {
        public InstantiationException(@NonNull String msg, @Nullable Exception cause) {
            super(msg, cause);
        }
    }

    @SuppressLint(value={"BanParcelableUsage, ParcelClassLoader"})
    public static class SavedState
    implements Parcelable {
        final Bundle mState;
        @NonNull
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in, null);
            }

            public SavedState createFromParcel(Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Bundle state) {
            this.mState = state;
        }

        SavedState(@NonNull Parcel in, @Nullable ClassLoader loader) {
            this.mState = in.readBundle();
            if (loader != null && this.mState != null) {
                this.mState.setClassLoader(loader);
            }
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeBundle(this.mState);
        }
    }

    static class AnimationInfo {
        View mAnimatingAway;
        boolean mIsPop;
        @AnimRes
        int mEnterAnim;
        @AnimRes
        int mExitAnim;
        @AnimRes
        int mPopEnterAnim;
        @AnimRes
        int mPopExitAnim;
        int mNextTransition;
        ArrayList<String> mSharedElementSourceNames;
        ArrayList<String> mSharedElementTargetNames;
        Object mEnterTransition = null;
        Object mReturnTransition = USE_DEFAULT_TRANSITION;
        Object mExitTransition = null;
        Object mReenterTransition = USE_DEFAULT_TRANSITION;
        Object mSharedElementEnterTransition = null;
        Object mSharedElementReturnTransition = USE_DEFAULT_TRANSITION;
        Boolean mAllowReturnTransitionOverlap;
        Boolean mAllowEnterTransitionOverlap;
        SharedElementCallback mEnterTransitionCallback = null;
        SharedElementCallback mExitTransitionCallback = null;
        float mPostOnViewCreatedAlpha = 1.0f;
        View mFocusedView = null;
        boolean mEnterTransitionPostponed;

        AnimationInfo() {
        }
    }
}

