/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.SimpleArrayMap;
import androidx.core.util.Preconditions;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentHostCallback;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentManagerNonConfig;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.loader.app.LoaderManager;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;

public class FragmentController {
    private final FragmentHostCallback<?> mHost;

    @NonNull
    public static FragmentController createController(@NonNull FragmentHostCallback<?> callbacks) {
        return new FragmentController(Preconditions.checkNotNull(callbacks, "callbacks == null"));
    }

    private FragmentController(FragmentHostCallback<?> callbacks) {
        this.mHost = callbacks;
    }

    @NonNull
    public FragmentManager getSupportFragmentManager() {
        return this.mHost.getFragmentManager();
    }

    @Deprecated
    @SuppressLint(value={"UnknownNullness"})
    public LoaderManager getSupportLoaderManager() {
        throw new UnsupportedOperationException("Loaders are managed separately from FragmentController, use LoaderManager.getInstance() to obtain a LoaderManager.");
    }

    @Nullable
    public Fragment findFragmentByWho(@NonNull String who) {
        return this.mHost.getFragmentManager().findFragmentByWho(who);
    }

    public int getActiveFragmentsCount() {
        return this.mHost.getFragmentManager().getActiveFragmentCount();
    }

    @NonNull
    public List<Fragment> getActiveFragments(@SuppressLint(value={"UnknownNullness"}) List<Fragment> actives) {
        return this.mHost.getFragmentManager().getActiveFragments();
    }

    public void attachHost(@Nullable Fragment parent) {
        this.mHost.getFragmentManager().attachController(this.mHost, this.mHost, parent);
    }

    @Nullable
    public View onCreateView(@Nullable View parent, @NonNull String name, @NonNull Context context, @NonNull AttributeSet attrs) {
        return this.mHost.getFragmentManager().getLayoutInflaterFactory().onCreateView(parent, name, context, attrs);
    }

    public void noteStateNotSaved() {
        this.mHost.getFragmentManager().noteStateNotSaved();
    }

    @Deprecated
    @Nullable
    public Parcelable saveAllState() {
        return this.mHost.getFragmentManager().saveAllState();
    }

    @Deprecated
    public void restoreAllState(@Nullable Parcelable state, @Nullable List<Fragment> nonConfigList) {
        this.mHost.getFragmentManager().restoreAllState(state, new FragmentManagerNonConfig(nonConfigList, null, null));
    }

    @Deprecated
    public void restoreAllState(@Nullable Parcelable state, @Nullable FragmentManagerNonConfig nonConfig) {
        this.mHost.getFragmentManager().restoreAllState(state, nonConfig);
    }

    @Deprecated
    public void restoreSaveState(@Nullable Parcelable state) {
        if (!(this.mHost instanceof ViewModelStoreOwner)) {
            throw new IllegalStateException("Your FragmentHostCallback must implement ViewModelStoreOwner to call restoreSaveState(). Call restoreAllState()  if you're still using retainNestedNonConfig().");
        }
        this.mHost.getFragmentManager().restoreSaveState(state);
    }

    @Deprecated
    @Nullable
    public List<Fragment> retainNonConfig() {
        FragmentManagerNonConfig nonconf = this.mHost.getFragmentManager().retainNonConfig();
        return nonconf != null && nonconf.getFragments() != null ? new ArrayList<Fragment>(nonconf.getFragments()) : null;
    }

    @Deprecated
    @Nullable
    public FragmentManagerNonConfig retainNestedNonConfig() {
        return this.mHost.getFragmentManager().retainNonConfig();
    }

    public void dispatchCreate() {
        this.mHost.getFragmentManager().dispatchCreate();
    }

    public void dispatchActivityCreated() {
        this.mHost.getFragmentManager().dispatchActivityCreated();
    }

    public void dispatchStart() {
        this.mHost.getFragmentManager().dispatchStart();
    }

    public void dispatchResume() {
        this.mHost.getFragmentManager().dispatchResume();
    }

    public void dispatchPause() {
        this.mHost.getFragmentManager().dispatchPause();
    }

    public void dispatchStop() {
        this.mHost.getFragmentManager().dispatchStop();
    }

    @Deprecated
    public void dispatchReallyStop() {
    }

    public void dispatchDestroyView() {
        this.mHost.getFragmentManager().dispatchDestroyView();
    }

    public void dispatchDestroy() {
        this.mHost.getFragmentManager().dispatchDestroy();
    }

    @Deprecated
    public void dispatchMultiWindowModeChanged(boolean isInMultiWindowMode) {
        this.mHost.getFragmentManager().dispatchMultiWindowModeChanged(isInMultiWindowMode, true);
    }

    @Deprecated
    public void dispatchPictureInPictureModeChanged(boolean isInPictureInPictureMode) {
        this.mHost.getFragmentManager().dispatchPictureInPictureModeChanged(isInPictureInPictureMode, true);
    }

    @Deprecated
    public void dispatchConfigurationChanged(@NonNull Configuration newConfig) {
        this.mHost.getFragmentManager().dispatchConfigurationChanged(newConfig, true);
    }

    @Deprecated
    public void dispatchLowMemory() {
        this.mHost.getFragmentManager().dispatchLowMemory(true);
    }

    @Deprecated
    public boolean dispatchCreateOptionsMenu(@NonNull Menu menu2, @NonNull MenuInflater inflater) {
        return this.mHost.getFragmentManager().dispatchCreateOptionsMenu(menu2, inflater);
    }

    @Deprecated
    public boolean dispatchPrepareOptionsMenu(@NonNull Menu menu2) {
        return this.mHost.getFragmentManager().dispatchPrepareOptionsMenu(menu2);
    }

    @Deprecated
    public boolean dispatchOptionsItemSelected(@NonNull MenuItem item) {
        return this.mHost.getFragmentManager().dispatchOptionsItemSelected(item);
    }

    public boolean dispatchContextItemSelected(@NonNull MenuItem item) {
        return this.mHost.getFragmentManager().dispatchContextItemSelected(item);
    }

    @Deprecated
    public void dispatchOptionsMenuClosed(@NonNull Menu menu2) {
        this.mHost.getFragmentManager().dispatchOptionsMenuClosed(menu2);
    }

    public boolean execPendingActions() {
        return this.mHost.getFragmentManager().execPendingActions(true);
    }

    @Deprecated
    public void doLoaderStart() {
    }

    @Deprecated
    public void doLoaderStop(boolean retain) {
    }

    @Deprecated
    public void doLoaderRetain() {
    }

    @Deprecated
    public void doLoaderDestroy() {
    }

    @Deprecated
    public void reportLoaderStart() {
    }

    @Deprecated
    @Nullable
    public SimpleArrayMap<String, LoaderManager> retainLoaderNonConfig() {
        return null;
    }

    @Deprecated
    public void restoreLoaderNonConfig(@SuppressLint(value={"UnknownNullness"}) SimpleArrayMap<String, LoaderManager> loaderManagers) {
    }

    @Deprecated
    public void dumpLoaders(@NonNull String prefix, @Nullable FileDescriptor fd, @NonNull PrintWriter writer, @Nullable String[] args2) {
    }
}

