/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.os.Bundle;
import android.os.Handler;
import android.view.LayoutInflater;
import android.view.View;
import androidx.annotation.RestrictTo;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentContainer;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentManagerImpl;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u000f\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB)\b\u0000\u0012\b\u0010\n\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000eJ7\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 2\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\"H\u0016\u00a2\u0006\u0002\u0010#J\u0012\u0010$\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\bH\u0016J\r\u0010'\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010(J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\bH\u0016J\b\u0010,\u001a\u00020-H\u0016J\b\u0010.\u001a\u00020-H\u0016J+\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001c0\"2\u0006\u00103\u001a\u00020\bH\u0017\u00a2\u0006\u0002\u00104J\u0010\u00105\u001a\u00020-2\u0006\u00100\u001a\u000201H\u0016J\u0010\u00106\u001a\u00020-2\u0006\u00107\u001a\u00020\u001cH\u0016J \u00108\u001a\u00020\u001a2\u0006\u00100\u001a\u0002012\u0006\u00109\u001a\u00020:2\u0006\u00103\u001a\u00020\bH\u0016J*\u00108\u001a\u00020\u001a2\u0006\u00100\u001a\u0002012\u0006\u00109\u001a\u00020:2\u0006\u00103\u001a\u00020\b2\b\u0010;\u001a\u0004\u0018\u00010<H\u0016JL\u0010=\u001a\u00020\u001a2\u0006\u00100\u001a\u0002012\u0006\u00109\u001a\u00020>2\u0006\u00103\u001a\u00020\b2\b\u0010?\u001a\u0004\u0018\u00010:2\u0006\u0010@\u001a\u00020\b2\u0006\u0010A\u001a\u00020\b2\u0006\u0010B\u001a\u00020\b2\b\u0010;\u001a\u0004\u0018\u00010<H\u0017J\b\u0010C\u001a\u00020\u001aH\u0016R\u0015\u0010\n\u001a\u0004\u0018\u00010\r8\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0003\u001a\u00020\u00048\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0013\u001a\u00020\u00148G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0013\u0010\u0005\u001a\u00020\u00068\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006D"}, d2={"Landroidx/fragment/app/FragmentHostCallback;", "H", "Landroidx/fragment/app/FragmentContainer;", "context", "Landroid/content/Context;", "handler", "Landroid/os/Handler;", "windowAnimations", "", "(Landroid/content/Context;Landroid/os/Handler;I)V", "activity", "Landroidx/fragment/app/FragmentActivity;", "(Landroidx/fragment/app/FragmentActivity;)V", "Landroid/app/Activity;", "(Landroid/app/Activity;Landroid/content/Context;Landroid/os/Handler;I)V", "getActivity", "()Landroid/app/Activity;", "getContext", "()Landroid/content/Context;", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "getFragmentManager", "()Landroidx/fragment/app/FragmentManager;", "getHandler", "()Landroid/os/Handler;", "onDump", "", "prefix", "", "fd", "Ljava/io/FileDescriptor;", "writer", "Ljava/io/PrintWriter;", "args", "", "(Ljava/lang/String;Ljava/io/FileDescriptor;Ljava/io/PrintWriter;[Ljava/lang/String;)V", "onFindViewById", "Landroid/view/View;", "id", "onGetHost", "()Ljava/lang/Object;", "onGetLayoutInflater", "Landroid/view/LayoutInflater;", "onGetWindowAnimations", "onHasView", "", "onHasWindowAnimations", "onRequestPermissionsFromFragment", "fragment", "Landroidx/fragment/app/Fragment;", "permissions", "requestCode", "(Landroidx/fragment/app/Fragment;[Ljava/lang/String;I)V", "onShouldSaveFragmentState", "onShouldShowRequestPermissionRationale", "permission", "onStartActivityFromFragment", "intent", "Landroid/content/Intent;", "options", "Landroid/os/Bundle;", "onStartIntentSenderFromFragment", "Landroid/content/IntentSender;", "fillInIntent", "flagsMask", "flagsValues", "extraFlags", "onSupportInvalidateOptionsMenu", "fragment_release"})
public abstract class FragmentHostCallback<H>
extends FragmentContainer {
    @Nullable
    private final Activity activity;
    @NotNull
    private final Context context;
    @NotNull
    private final Handler handler;
    private final int windowAnimations;
    @NotNull
    private final FragmentManager fragmentManager;

    public FragmentHostCallback(@Nullable Activity activity, @NotNull Context context, @NotNull Handler handler, int windowAnimations) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(handler, "handler");
        this.activity = activity;
        this.context = context;
        this.handler = handler;
        this.windowAnimations = windowAnimations;
        this.fragmentManager = new FragmentManagerImpl();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @Nullable
    public final Activity getActivity() {
        return this.activity;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NotNull
    public final Context getContext() {
        return this.context;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NotNull
    public final Handler getHandler() {
        return this.handler;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NotNull
    public final FragmentManager getFragmentManager() {
        return this.fragmentManager;
    }

    public FragmentHostCallback(@NotNull Context context, @NotNull Handler handler, int windowAnimations) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(handler, "handler");
        this(context instanceof Activity ? (Activity)context : null, context, handler, windowAnimations);
    }

    public FragmentHostCallback(@NotNull FragmentActivity activity) {
        Intrinsics.checkNotNullParameter(activity, "activity");
        this(activity, (Context)activity, new Handler(), 0);
    }

    public void onDump(@NotNull String prefix, @Nullable FileDescriptor fd, @NotNull PrintWriter writer, @Nullable String[] args2) {
        Intrinsics.checkNotNullParameter(prefix, "prefix");
        Intrinsics.checkNotNullParameter(writer, "writer");
    }

    public boolean onShouldSaveFragmentState(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter(fragment, "fragment");
        return true;
    }

    @NotNull
    public LayoutInflater onGetLayoutInflater() {
        LayoutInflater layoutInflater = LayoutInflater.from((Context)this.context);
        Intrinsics.checkNotNullExpressionValue(layoutInflater, "from(context)");
        return layoutInflater;
    }

    public abstract H onGetHost();

    public void onSupportInvalidateOptionsMenu() {
    }

    public void onStartActivityFromFragment(@NotNull Fragment fragment, @NotNull Intent intent, int requestCode) {
        Intrinsics.checkNotNullParameter(fragment, "fragment");
        Intrinsics.checkNotNullParameter(intent, "intent");
        this.onStartActivityFromFragment(fragment, intent, requestCode, null);
    }

    public void onStartActivityFromFragment(@NotNull Fragment fragment, @NotNull Intent intent, int requestCode, @Nullable Bundle options) {
        Intrinsics.checkNotNullParameter(fragment, "fragment");
        Intrinsics.checkNotNullParameter(intent, "intent");
        if (!(requestCode == -1)) {
            boolean bl = false;
            String string2 = "Starting activity with a requestCode requires a FragmentActivity host";
            throw new IllegalStateException(string2.toString());
        }
        ContextCompat.startActivity(this.context, intent, options);
    }

    @Deprecated(message="Have your FragmentHostCallback implement {@link ActivityResultRegistryOwner}\n      to allow Fragments to use\n      {@link Fragment#registerForActivityResult(ActivityResultContract, ActivityResultCallback)}\n      with {@link StartIntentSenderForResult}. This method will still be called when Fragments\n      call the deprecated <code>startIntentSenderForResult()</code> method.")
    public void onStartIntentSenderFromFragment(@NotNull Fragment fragment, @NotNull IntentSender intent, int requestCode, @Nullable Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, @Nullable Bundle options) throws IntentSender.SendIntentException {
        Intrinsics.checkNotNullParameter(fragment, "fragment");
        Intrinsics.checkNotNullParameter(intent, "intent");
        if (!(requestCode == -1)) {
            boolean bl = false;
            String string2 = "Starting intent sender with a requestCode requires a FragmentActivity host";
            throw new IllegalStateException(string2.toString());
        }
        Activity activity = this.activity;
        if (activity == null) {
            boolean bl = false;
            String string3 = "Starting intent sender with a requestCode requires a FragmentActivity host";
            throw new IllegalStateException(string3.toString());
        }
        Activity activity2 = activity;
        ActivityCompat.startIntentSenderForResult(activity2, intent, requestCode, fillInIntent, flagsMask, flagsValues, extraFlags, options);
    }

    @Deprecated(message="Have your FragmentHostCallback implement {@link ActivityResultRegistryOwner}\n      to allow Fragments to use\n      {@link Fragment#registerForActivityResult(ActivityResultContract, ActivityResultCallback)}\n      with {@link RequestMultiplePermissions}. This method will still be called when Fragments\n      call the deprecated <code>requestPermissions()</code> method.")
    public void onRequestPermissionsFromFragment(@NotNull Fragment fragment, @NotNull String[] permissions, int requestCode) {
        Intrinsics.checkNotNullParameter(fragment, "fragment");
        Intrinsics.checkNotNullParameter(permissions, "permissions");
    }

    public boolean onShouldShowRequestPermissionRationale(@NotNull String permission2) {
        Intrinsics.checkNotNullParameter(permission2, "permission");
        return false;
    }

    public boolean onHasWindowAnimations() {
        return true;
    }

    public int onGetWindowAnimations() {
        return this.windowAnimations;
    }

    @Override
    @Nullable
    public View onFindViewById(int id2) {
        return null;
    }

    @Override
    public boolean onHasView() {
        return true;
    }
}

