/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.Intent;
import android.content.IntentSender;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Looper;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.activity.BackEventCompat;
import androidx.activity.OnBackPressedCallback;
import androidx.activity.OnBackPressedDispatcher;
import androidx.activity.OnBackPressedDispatcherOwner;
import androidx.activity.result.ActivityResult;
import androidx.activity.result.ActivityResultCallback;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.ActivityResultRegistry;
import androidx.activity.result.ActivityResultRegistryOwner;
import androidx.activity.result.IntentSenderRequest;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.annotation.IdRes;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.core.app.MultiWindowModeChangedInfo;
import androidx.core.app.OnMultiWindowModeChangedProvider;
import androidx.core.app.OnPictureInPictureModeChangedProvider;
import androidx.core.app.PictureInPictureModeChangedInfo;
import androidx.core.content.OnConfigurationChangedProvider;
import androidx.core.content.OnTrimMemoryProvider;
import androidx.core.util.Consumer;
import androidx.core.view.MenuHost;
import androidx.core.view.MenuProvider;
import androidx.fragment.R;
import androidx.fragment.app.BackStackRecord;
import androidx.fragment.app.BackStackRecordState;
import androidx.fragment.app.BackStackState;
import androidx.fragment.app.DefaultSpecialEffectsController;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentContainer;
import androidx.fragment.app.FragmentContainerView;
import androidx.fragment.app.FragmentFactory;
import androidx.fragment.app.FragmentHostCallback;
import androidx.fragment.app.FragmentLayoutInflaterFactory;
import androidx.fragment.app.FragmentLifecycleCallbacksDispatcher;
import androidx.fragment.app.FragmentManagerNonConfig;
import androidx.fragment.app.FragmentManagerState;
import androidx.fragment.app.FragmentManagerViewModel;
import androidx.fragment.app.FragmentOnAttachListener;
import androidx.fragment.app.FragmentResultListener;
import androidx.fragment.app.FragmentResultOwner;
import androidx.fragment.app.FragmentState;
import androidx.fragment.app.FragmentStateManager;
import androidx.fragment.app.FragmentStore;
import androidx.fragment.app.FragmentTransaction;
import androidx.fragment.app.LogWriter;
import androidx.fragment.app.PredictiveBackControl;
import androidx.fragment.app.SpecialEffectsController;
import androidx.fragment.app.SpecialEffectsControllerFactory;
import androidx.fragment.app.strictmode.FragmentStrictMode;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModelStore;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.savedstate.SavedStateRegistry;
import androidx.savedstate.SavedStateRegistryOwner;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class FragmentManager
implements FragmentResultOwner {
    private static final String SAVED_STATE_KEY = "android:support:fragments";
    private static final String FRAGMENT_MANAGER_STATE_KEY = "state";
    private static final String RESULT_KEY_PREFIX = "result_";
    private static final String FRAGMENT_KEY_PREFIX = "fragment_";
    private static boolean DEBUG = false;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final String TAG = "FragmentManager";
    static boolean USE_PREDICTIVE_BACK = true;
    public static final int POP_BACK_STACK_INCLUSIVE = 1;
    private final ArrayList<OpGenerator> mPendingActions = new ArrayList();
    private boolean mExecutingActions;
    private final FragmentStore mFragmentStore = new FragmentStore();
    ArrayList<BackStackRecord> mBackStack = new ArrayList();
    private ArrayList<Fragment> mCreatedMenus;
    private final FragmentLayoutInflaterFactory mLayoutInflaterFactory = new FragmentLayoutInflaterFactory(this);
    private OnBackPressedDispatcher mOnBackPressedDispatcher;
    BackStackRecord mTransitioningOp = null;
    boolean mBackStarted = false;
    private final OnBackPressedCallback mOnBackPressedCallback = new OnBackPressedCallback(false){

        @Override
        public void handleOnBackStarted(@NonNull BackEventCompat backEvent) {
            if (FragmentManager.isLoggingEnabled(3)) {
                Log.d((String)FragmentManager.TAG, (String)("handleOnBackStarted. PREDICTIVE_BACK = " + USE_PREDICTIVE_BACK + " fragment manager " + FragmentManager.this));
            }
            if (USE_PREDICTIVE_BACK) {
                FragmentManager.this.endAnimatingAwayFragments();
                FragmentManager.this.prepareBackStackTransition();
            }
        }

        @Override
        public void handleOnBackProgressed(@NonNull BackEventCompat backEvent) {
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)FragmentManager.TAG, (String)("handleOnBackProgressed. PREDICTIVE_BACK = " + USE_PREDICTIVE_BACK + " fragment manager " + FragmentManager.this));
            }
            if (FragmentManager.this.mTransitioningOp != null) {
                Set<SpecialEffectsController> changedControllers = FragmentManager.this.collectChangedControllers(new ArrayList<BackStackRecord>(Collections.singletonList(FragmentManager.this.mTransitioningOp)), 0, 1);
                for (SpecialEffectsController controller : changedControllers) {
                    controller.processProgress(backEvent);
                }
                for (OnBackStackChangedListener listener2 : FragmentManager.this.mBackStackChangeListeners) {
                    listener2.onBackStackChangeProgressed(backEvent);
                }
            }
        }

        @Override
        public void handleOnBackPressed() {
            if (FragmentManager.isLoggingEnabled(3)) {
                Log.d((String)FragmentManager.TAG, (String)("handleOnBackPressed. PREDICTIVE_BACK = " + USE_PREDICTIVE_BACK + " fragment manager " + FragmentManager.this));
            }
            FragmentManager.this.handleOnBackPressed();
        }

        @Override
        public void handleOnBackCancelled() {
            if (FragmentManager.isLoggingEnabled(3)) {
                Log.d((String)FragmentManager.TAG, (String)("handleOnBackCancelled. PREDICTIVE_BACK = " + USE_PREDICTIVE_BACK + " fragment manager " + FragmentManager.this));
            }
            if (USE_PREDICTIVE_BACK) {
                FragmentManager.this.cancelBackStackTransition();
                FragmentManager.this.mTransitioningOp = null;
            }
        }
    };
    private final AtomicInteger mBackStackIndex = new AtomicInteger();
    private final Map<String, BackStackState> mBackStackStates = Collections.synchronizedMap(new HashMap());
    private final Map<String, Bundle> mResults = Collections.synchronizedMap(new HashMap());
    private final Map<String, LifecycleAwareResultListener> mResultListeners = Collections.synchronizedMap(new HashMap());
    ArrayList<OnBackStackChangedListener> mBackStackChangeListeners = new ArrayList();
    private final FragmentLifecycleCallbacksDispatcher mLifecycleCallbacksDispatcher = new FragmentLifecycleCallbacksDispatcher(this);
    private final CopyOnWriteArrayList<FragmentOnAttachListener> mOnAttachListeners = new CopyOnWriteArrayList();
    private final Consumer<Configuration> mOnConfigurationChangedListener = newConfig -> {
        if (this.isParentAdded()) {
            this.dispatchConfigurationChanged((Configuration)newConfig, false);
        }
    };
    private final Consumer<Integer> mOnTrimMemoryListener = level -> {
        if (this.isParentAdded() && level == 80) {
            this.dispatchLowMemory(false);
        }
    };
    private final Consumer<MultiWindowModeChangedInfo> mOnMultiWindowModeChangedListener = info -> {
        if (this.isParentAdded()) {
            this.dispatchMultiWindowModeChanged(info.isInMultiWindowMode(), false);
        }
    };
    private final Consumer<PictureInPictureModeChangedInfo> mOnPictureInPictureModeChangedListener = info -> {
        if (this.isParentAdded()) {
            this.dispatchPictureInPictureModeChanged(info.isInPictureInPictureMode(), false);
        }
    };
    private final MenuProvider mMenuProvider = new MenuProvider(){

        @Override
        public void onPrepareMenu(@NonNull Menu menu2) {
            FragmentManager.this.dispatchPrepareOptionsMenu(menu2);
        }

        @Override
        public void onCreateMenu(@NonNull Menu menu2, @NonNull MenuInflater menuInflater) {
            FragmentManager.this.dispatchCreateOptionsMenu(menu2, menuInflater);
        }

        @Override
        public boolean onMenuItemSelected(@NonNull MenuItem menuItem) {
            return FragmentManager.this.dispatchOptionsItemSelected(menuItem);
        }

        @Override
        public void onMenuClosed(@NonNull Menu menu2) {
            FragmentManager.this.dispatchOptionsMenuClosed(menu2);
        }
    };
    int mCurState = -1;
    private FragmentHostCallback<?> mHost;
    private FragmentContainer mContainer;
    private Fragment mParent;
    @Nullable
    Fragment mPrimaryNav;
    private FragmentFactory mFragmentFactory = null;
    private FragmentFactory mHostFragmentFactory = new FragmentFactory(){

        @Override
        @NonNull
        public Fragment instantiate(@NonNull ClassLoader classLoader, @NonNull String className) {
            return FragmentManager.this.getHost().instantiate(FragmentManager.this.getHost().getContext(), className, null);
        }
    };
    private SpecialEffectsControllerFactory mSpecialEffectsControllerFactory = null;
    private SpecialEffectsControllerFactory mDefaultSpecialEffectsControllerFactory = new SpecialEffectsControllerFactory(){

        @Override
        @NonNull
        public SpecialEffectsController createController(@NonNull ViewGroup container) {
            return new DefaultSpecialEffectsController(container);
        }
    };
    private ActivityResultLauncher<Intent> mStartActivityForResult;
    private ActivityResultLauncher<IntentSenderRequest> mStartIntentSenderForResult;
    private ActivityResultLauncher<String[]> mRequestPermissions;
    ArrayDeque<LaunchedFragmentInfo> mLaunchedFragments = new ArrayDeque();
    private static final String EXTRA_CREATED_FILLIN_INTENT = "androidx.fragment.extra.ACTIVITY_OPTIONS_BUNDLE";
    private boolean mNeedMenuInvalidate;
    private boolean mStateSaved;
    private boolean mStopped;
    private boolean mDestroyed;
    private boolean mHavePendingDeferredStart;
    private ArrayList<BackStackRecord> mTmpRecords;
    private ArrayList<Boolean> mTmpIsPop;
    private ArrayList<Fragment> mTmpAddedFragments;
    private FragmentManagerViewModel mNonConfig;
    private FragmentStrictMode.Policy mStrictModePolicy;
    private Runnable mExecCommit = new Runnable(){

        @Override
        public void run() {
            FragmentManager.this.execPendingActions(true);
        }
    };

    @PredictiveBackControl
    public static void enablePredictiveBack(boolean enabled) {
        USE_PREDICTIVE_BACK = enabled;
    }

    @Deprecated
    public static void enableDebugLogging(boolean enabled) {
        DEBUG = enabled;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static boolean isLoggingEnabled(int level) {
        return DEBUG || Log.isLoggable((String)TAG, (int)level);
    }

    private void throwException(RuntimeException ex) {
        Log.e((String)TAG, (String)ex.getMessage());
        Log.e((String)TAG, (String)"Activity state:");
        LogWriter logw = new LogWriter(TAG);
        PrintWriter pw = new PrintWriter(logw);
        if (this.mHost != null) {
            try {
                this.mHost.onDump("  ", null, pw, new String[0]);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Failed dumping state", (Throwable)e);
            }
        } else {
            try {
                this.dump("  ", null, pw, new String[0]);
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Failed dumping state", (Throwable)e);
            }
        }
        throw ex;
    }

    @Deprecated
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @NonNull
    public FragmentTransaction openTransaction() {
        return this.beginTransaction();
    }

    @NonNull
    public FragmentTransaction beginTransaction() {
        return new BackStackRecord(this);
    }

    @MainThread
    public boolean executePendingTransactions() {
        boolean updates = this.execPendingActions(true);
        this.forcePostponedTransactions();
        return updates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateOnBackPressedCallbackEnabled() {
        boolean isEnabled;
        ArrayList<OpGenerator> arrayList = this.mPendingActions;
        synchronized (arrayList) {
            if (!this.mPendingActions.isEmpty()) {
                this.mOnBackPressedCallback.setEnabled(true);
                if (FragmentManager.isLoggingEnabled(3)) {
                    Log.d((String)TAG, (String)("FragmentManager " + this + " enabling OnBackPressedCallback, caused by non-empty pending actions"));
                }
                return;
            }
        }
        boolean bl = isEnabled = this.getBackStackEntryCount() > 0 && this.isPrimaryNavigation(this.mParent);
        if (FragmentManager.isLoggingEnabled(3)) {
            Log.d((String)TAG, (String)("OnBackPressedCallback for FragmentManager " + this + " enabled state is " + isEnabled));
        }
        this.mOnBackPressedCallback.setEnabled(isEnabled);
    }

    boolean isPrimaryNavigation(@Nullable Fragment parent) {
        if (parent == null) {
            return true;
        }
        FragmentManager parentFragmentManager = parent.mFragmentManager;
        Fragment primaryNavigationFragment = parentFragmentManager.getPrimaryNavigationFragment();
        return parent.equals(primaryNavigationFragment) && this.isPrimaryNavigation(parentFragmentManager.mParent);
    }

    boolean isParentMenuVisible(@Nullable Fragment parent) {
        if (parent == null) {
            return true;
        }
        return parent.isMenuVisible();
    }

    boolean isParentHidden(@Nullable Fragment parent) {
        if (parent == null) {
            return false;
        }
        return parent.isHidden();
    }

    void handleOnBackPressed() {
        this.execPendingActions(true);
        if (USE_PREDICTIVE_BACK && this.mTransitioningOp != null) {
            if (!this.mBackStackChangeListeners.isEmpty()) {
                LinkedHashSet<Fragment> fragments = new LinkedHashSet<Fragment>(this.fragmentsFromRecord(this.mTransitioningOp));
                for (OnBackStackChangedListener listener2 : this.mBackStackChangeListeners) {
                    Iterator iterator2 = fragments.iterator();
                    while (iterator2.hasNext()) {
                        Fragment fragment = (Fragment)iterator2.next();
                        listener2.onBackStackChangeCommitted(fragment, true);
                    }
                }
            }
            for (FragmentTransaction.Op op : this.mTransitioningOp.mOps) {
                Fragment fragment = op.mFragment;
                if (fragment == null) continue;
                fragment.mTransitioning = false;
            }
            Set<SpecialEffectsController> changedControllers = this.collectChangedControllers(new ArrayList<BackStackRecord>(Collections.singletonList(this.mTransitioningOp)), 0, 1);
            for (SpecialEffectsController controller : changedControllers) {
                controller.completeBack();
            }
            for (FragmentTransaction.Op op : this.mTransitioningOp.mOps) {
                Fragment fragment = op.mFragment;
                if (fragment == null || fragment.mContainer != null) continue;
                FragmentStateManager stateManager = this.createOrGetFragmentStateManager(fragment);
                stateManager.moveToExpectedState();
            }
            this.mTransitioningOp = null;
            this.updateOnBackPressedCallbackEnabled();
            if (FragmentManager.isLoggingEnabled(3)) {
                Log.d((String)TAG, (String)"Op is being set to null");
                Log.d((String)TAG, (String)("OnBackPressedCallback enabled=" + this.mOnBackPressedCallback.isEnabled() + " for  FragmentManager " + this));
            }
        } else if (this.mOnBackPressedCallback.isEnabled()) {
            if (FragmentManager.isLoggingEnabled(3)) {
                Log.d((String)TAG, (String)"Calling popBackStackImmediate via onBackPressed callback");
            }
            this.popBackStackImmediate();
        } else {
            if (FragmentManager.isLoggingEnabled(3)) {
                Log.d((String)TAG, (String)"Calling onBackPressed via onBackPressed callback");
            }
            this.mOnBackPressedDispatcher.onBackPressed();
        }
    }

    public void restoreBackStack(@NonNull String name) {
        this.enqueueAction(new RestoreBackStackState(name), false);
    }

    public void saveBackStack(@NonNull String name) {
        this.enqueueAction(new SaveBackStackState(name), false);
    }

    public void clearBackStack(@NonNull String name) {
        this.enqueueAction(new ClearBackStackState(name), false);
    }

    public void popBackStack() {
        this.enqueueAction(new PopBackStackState(null, -1, 0), false);
    }

    @MainThread
    public boolean popBackStackImmediate() {
        return this.popBackStackImmediate(null, -1, 0);
    }

    public void popBackStack(@Nullable String name, int flags) {
        this.enqueueAction(new PopBackStackState(name, -1, flags), false);
    }

    @MainThread
    public boolean popBackStackImmediate(@Nullable String name, int flags) {
        return this.popBackStackImmediate(name, -1, flags);
    }

    public void popBackStack(int id2, int flags) {
        this.popBackStack(id2, flags, false);
    }

    void popBackStack(int id2, int flags, boolean allowStateLoss) {
        if (id2 < 0) {
            throw new IllegalArgumentException("Bad id: " + id2);
        }
        this.enqueueAction(new PopBackStackState(null, id2, flags), allowStateLoss);
    }

    void prepareBackStackTransition() {
        this.enqueueAction(new PrepareBackStackTransitionState(), false);
    }

    void cancelBackStackTransition() {
        if (this.mTransitioningOp != null) {
            this.mTransitioningOp.mCommitted = false;
            this.mTransitioningOp.runOnCommitInternal(true, () -> {
                for (OnBackStackChangedListener listener2 : this.mBackStackChangeListeners) {
                    listener2.onBackStackChangeCancelled();
                }
            });
            this.mTransitioningOp.commit();
            this.executePendingTransactions();
        }
    }

    public boolean popBackStackImmediate(int id2, int flags) {
        if (id2 < 0) {
            throw new IllegalArgumentException("Bad id: " + id2);
        }
        return this.popBackStackImmediate(null, id2, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean popBackStackImmediate(@Nullable String name, int id2, int flags) {
        FragmentManager childManager;
        this.execPendingActions(false);
        this.ensureExecReady(true);
        if (this.mPrimaryNav != null && id2 < 0 && name == null && (childManager = this.mPrimaryNav.getChildFragmentManager()).popBackStackImmediate()) {
            return true;
        }
        boolean executePop = this.popBackStackState(this.mTmpRecords, this.mTmpIsPop, name, id2, flags);
        if (executePop) {
            this.mExecutingActions = true;
            try {
                this.removeRedundantOperationsAndExecute(this.mTmpRecords, this.mTmpIsPop);
            }
            finally {
                this.cleanupExec();
            }
        }
        this.updateOnBackPressedCallbackEnabled();
        this.doPendingDeferredStart();
        this.mFragmentStore.burpActive();
        return executePop;
    }

    public int getBackStackEntryCount() {
        return this.mBackStack.size() + (this.mTransitioningOp != null ? 1 : 0);
    }

    @NonNull
    public BackStackEntry getBackStackEntryAt(int index) {
        if (index == this.mBackStack.size()) {
            if (this.mTransitioningOp == null) {
                throw new IndexOutOfBoundsException();
            }
            return this.mTransitioningOp;
        }
        return this.mBackStack.get(index);
    }

    public void addOnBackStackChangedListener(@NonNull OnBackStackChangedListener listener2) {
        this.mBackStackChangeListeners.add(listener2);
    }

    public void removeOnBackStackChangedListener(@NonNull OnBackStackChangedListener listener2) {
        this.mBackStackChangeListeners.remove(listener2);
    }

    @Override
    public final void setFragmentResult(@NonNull String requestKey, @NonNull Bundle result2) {
        LifecycleAwareResultListener resultListener = this.mResultListeners.get(requestKey);
        if (resultListener != null && resultListener.isAtLeast(Lifecycle.State.STARTED)) {
            resultListener.onFragmentResult(requestKey, result2);
        } else {
            this.mResults.put(requestKey, result2);
        }
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("Setting fragment result with key " + requestKey + " and result " + result2));
        }
    }

    @Override
    public final void clearFragmentResult(@NonNull String requestKey) {
        this.mResults.remove(requestKey);
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("Clearing fragment result with key " + requestKey));
        }
    }

    @Override
    public final void setFragmentResultListener(final @NonNull String requestKey, @NonNull LifecycleOwner lifecycleOwner, final @NonNull FragmentResultListener listener2) {
        final Lifecycle lifecycle = lifecycleOwner.getLifecycle();
        if (lifecycle.getCurrentState() == Lifecycle.State.DESTROYED) {
            return;
        }
        LifecycleEventObserver observer2 = new LifecycleEventObserver(){

            @Override
            public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
                Bundle storedResult;
                if (event == Lifecycle.Event.ON_START && (storedResult = (Bundle)FragmentManager.this.mResults.get(requestKey)) != null) {
                    listener2.onFragmentResult(requestKey, storedResult);
                    FragmentManager.this.clearFragmentResult(requestKey);
                }
                if (event == Lifecycle.Event.ON_DESTROY) {
                    lifecycle.removeObserver(this);
                    FragmentManager.this.mResultListeners.remove(requestKey);
                }
            }
        };
        LifecycleAwareResultListener storedListener = this.mResultListeners.put(requestKey, new LifecycleAwareResultListener(lifecycle, listener2, observer2));
        if (storedListener != null) {
            storedListener.removeObserver();
        }
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("Setting FragmentResultListener with key " + requestKey + " lifecycleOwner " + lifecycle + " and listener " + listener2));
        }
        lifecycle.addObserver(observer2);
    }

    @Override
    public final void clearFragmentResultListener(@NonNull String requestKey) {
        LifecycleAwareResultListener listener2 = this.mResultListeners.remove(requestKey);
        if (listener2 != null) {
            listener2.removeObserver();
        }
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("Clearing FragmentResultListener for key " + requestKey));
        }
    }

    public void putFragment(@NonNull Bundle bundle, @NonNull String key, @NonNull Fragment fragment) {
        if (fragment.mFragmentManager != this) {
            this.throwException(new IllegalStateException("Fragment " + fragment + " is not currently in the FragmentManager"));
        }
        bundle.putString(key, fragment.mWho);
    }

    @Nullable
    public Fragment getFragment(@NonNull Bundle bundle, @NonNull String key) {
        String who = bundle.getString(key);
        if (who == null) {
            return null;
        }
        Fragment f = this.findActiveFragment(who);
        if (f == null) {
            this.throwException(new IllegalStateException("Fragment no longer exists for key " + key + ": unique id " + who));
        }
        return f;
    }

    @NonNull
    public static <F extends Fragment> F findFragment(@NonNull View view) {
        Fragment fragment = FragmentManager.findViewFragment(view);
        if (fragment == null) {
            throw new IllegalStateException("View " + view + " does not have a Fragment set");
        }
        return (F)fragment;
    }

    @Nullable
    static Fragment findViewFragment(@NonNull View view) {
        while (view != null) {
            Fragment fragment = FragmentManager.getViewFragment(view);
            if (fragment != null) {
                return fragment;
            }
            ViewParent parent = view.getParent();
            view = parent instanceof View ? (View)parent : null;
        }
        return null;
    }

    @Nullable
    static Fragment getViewFragment(@NonNull View view) {
        Object tag = view.getTag(R.id.fragment_container_view_tag);
        if (tag instanceof Fragment) {
            return (Fragment)tag;
        }
        return null;
    }

    public final void onContainerAvailable(@NonNull FragmentContainerView container) {
        for (FragmentStateManager fragmentStateManager : this.mFragmentStore.getActiveFragmentStateManagers()) {
            Fragment fragment = fragmentStateManager.getFragment();
            if (fragment.mContainerId != container.getId() || fragment.mView == null || fragment.mView.getParent() != null) continue;
            fragment.mContainer = container;
            fragmentStateManager.addViewToContainer();
            fragmentStateManager.moveToExpectedState();
        }
    }

    @NonNull
    public static FragmentManager findFragmentManager(@NonNull View view) {
        FragmentManager fm;
        Fragment fragment = FragmentManager.findViewFragment(view);
        if (fragment != null) {
            if (!fragment.isAdded()) {
                throw new IllegalStateException("The Fragment " + fragment + " that owns View " + view + " has already been destroyed. Nested fragments should always use the child FragmentManager.");
            }
            fm = fragment.getChildFragmentManager();
        } else {
            Context context = view.getContext();
            FragmentActivity fragmentActivity = null;
            while (context instanceof ContextWrapper) {
                if (context instanceof FragmentActivity) {
                    fragmentActivity = (FragmentActivity)context;
                    break;
                }
                context = ((ContextWrapper)context).getBaseContext();
            }
            if (fragmentActivity != null) {
                fm = fragmentActivity.getSupportFragmentManager();
            } else {
                throw new IllegalStateException("View " + view + " is not within a subclass of FragmentActivity.");
            }
        }
        return fm;
    }

    @NonNull
    public List<Fragment> getFragments() {
        return this.mFragmentStore.getFragments();
    }

    @NonNull
    ViewModelStore getViewModelStore(@NonNull Fragment f) {
        return this.mNonConfig.getViewModelStore(f);
    }

    @NonNull
    private FragmentManagerViewModel getChildNonConfig(@NonNull Fragment f) {
        return this.mNonConfig.getChildNonConfig(f);
    }

    void addRetainedFragment(@NonNull Fragment f) {
        this.mNonConfig.addRetainedFragment(f);
    }

    void removeRetainedFragment(@NonNull Fragment f) {
        this.mNonConfig.removeRetainedFragment(f);
    }

    @NonNull
    List<Fragment> getActiveFragments() {
        return this.mFragmentStore.getActiveFragments();
    }

    int getActiveFragmentCount() {
        return this.mFragmentStore.getActiveFragmentCount();
    }

    @Nullable
    public Fragment.SavedState saveFragmentInstanceState(@NonNull Fragment fragment) {
        FragmentStateManager fragmentStateManager = this.mFragmentStore.getFragmentStateManager(fragment.mWho);
        if (fragmentStateManager == null || !fragmentStateManager.getFragment().equals(fragment)) {
            this.throwException(new IllegalStateException("Fragment " + fragment + " is not currently in the FragmentManager"));
        }
        return fragmentStateManager.saveInstanceState();
    }

    private void clearBackStackStateViewModels() {
        Activity activity;
        boolean shouldClear = this.mHost instanceof ViewModelStoreOwner ? this.mFragmentStore.getNonConfig().isCleared() : (this.mHost.getContext() instanceof Activity ? !(activity = (Activity)this.mHost.getContext()).isChangingConfigurations() : true);
        if (shouldClear) {
            for (BackStackState backStackState : this.mBackStackStates.values()) {
                for (String who : backStackState.mFragments) {
                    this.mFragmentStore.getNonConfig().clearNonConfigState(who, false);
                }
            }
        }
    }

    public boolean isDestroyed() {
        return this.mDestroyed;
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("FragmentManager{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" in ");
        if (this.mParent != null) {
            Class<?> cls = this.mParent.getClass();
            sb.append(cls.getSimpleName());
            sb.append("{");
            sb.append(Integer.toHexString(System.identityHashCode(this.mParent)));
            sb.append("}");
        } else if (this.mHost != null) {
            Class<?> cls = this.mHost.getClass();
            sb.append(cls.getSimpleName());
            sb.append("{");
            sb.append(Integer.toHexString(System.identityHashCode(this.mHost)));
            sb.append("}");
        } else {
            sb.append("null");
        }
        sb.append("}}");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(@NonNull String prefix, @Nullable FileDescriptor fd, @NonNull PrintWriter writer, @Nullable String[] args2) {
        int i;
        int count2;
        String innerPrefix = prefix + "    ";
        this.mFragmentStore.dump(prefix, fd, writer, args2);
        if (this.mCreatedMenus != null && (count2 = this.mCreatedMenus.size()) > 0) {
            writer.print(prefix);
            writer.println("Fragments Created Menus:");
            for (i = 0; i < count2; ++i) {
                Fragment f = this.mCreatedMenus.get(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i);
                writer.print(": ");
                writer.println(f.toString());
            }
        }
        if ((count2 = this.mBackStack.size()) > 0) {
            writer.print(prefix);
            writer.println("Back Stack:");
            for (i = 0; i < count2; ++i) {
                BackStackRecord bs = this.mBackStack.get(i);
                writer.print(prefix);
                writer.print("  #");
                writer.print(i);
                writer.print(": ");
                writer.println(bs.toString());
                bs.dump(innerPrefix, writer);
            }
        }
        writer.print(prefix);
        writer.println("Back Stack Index: " + this.mBackStackIndex.get());
        ArrayList<OpGenerator> arrayList = this.mPendingActions;
        synchronized (arrayList) {
            count2 = this.mPendingActions.size();
            if (count2 > 0) {
                writer.print(prefix);
                writer.println("Pending Actions:");
                for (int i2 = 0; i2 < count2; ++i2) {
                    OpGenerator r = this.mPendingActions.get(i2);
                    writer.print(prefix);
                    writer.print("  #");
                    writer.print(i2);
                    writer.print(": ");
                    writer.println(r);
                }
            }
        }
        writer.print(prefix);
        writer.println("FragmentManager misc state:");
        writer.print(prefix);
        writer.print("  mHost=");
        writer.println(this.mHost);
        writer.print(prefix);
        writer.print("  mContainer=");
        writer.println(this.mContainer);
        if (this.mParent != null) {
            writer.print(prefix);
            writer.print("  mParent=");
            writer.println(this.mParent);
        }
        writer.print(prefix);
        writer.print("  mCurState=");
        writer.print(this.mCurState);
        writer.print(" mStateSaved=");
        writer.print(this.mStateSaved);
        writer.print(" mStopped=");
        writer.print(this.mStopped);
        writer.print(" mDestroyed=");
        writer.println(this.mDestroyed);
        if (this.mNeedMenuInvalidate) {
            writer.print(prefix);
            writer.print("  mNeedMenuInvalidate=");
            writer.println(this.mNeedMenuInvalidate);
        }
    }

    void performPendingDeferredStart(@NonNull FragmentStateManager fragmentStateManager) {
        Fragment f = fragmentStateManager.getFragment();
        if (f.mDeferStart) {
            if (this.mExecutingActions) {
                this.mHavePendingDeferredStart = true;
                return;
            }
            f.mDeferStart = false;
            fragmentStateManager.moveToExpectedState();
        }
    }

    boolean isStateAtLeast(int state) {
        return this.mCurState >= state;
    }

    void setExitAnimationOrder(@NonNull Fragment f, boolean isPop) {
        ViewGroup container = this.getFragmentContainer(f);
        if (container != null && container instanceof FragmentContainerView) {
            ((FragmentContainerView)container).setDrawDisappearingViewsLast(!isPop);
        }
    }

    void moveToState(int newState, boolean always) {
        if (this.mHost == null && newState != -1) {
            throw new IllegalStateException("No activity");
        }
        if (!always && newState == this.mCurState) {
            return;
        }
        this.mCurState = newState;
        this.mFragmentStore.moveToExpectedState();
        this.startPendingDeferredFragments();
        if (this.mNeedMenuInvalidate && this.mHost != null && this.mCurState == 7) {
            this.mHost.onSupportInvalidateOptionsMenu();
            this.mNeedMenuInvalidate = false;
        }
    }

    private void startPendingDeferredFragments() {
        for (FragmentStateManager fragmentStateManager : this.mFragmentStore.getActiveFragmentStateManagers()) {
            this.performPendingDeferredStart(fragmentStateManager);
        }
    }

    @NonNull
    FragmentStateManager createOrGetFragmentStateManager(@NonNull Fragment f) {
        FragmentStateManager existing = this.mFragmentStore.getFragmentStateManager(f.mWho);
        if (existing != null) {
            return existing;
        }
        FragmentStateManager fragmentStateManager = new FragmentStateManager(this.mLifecycleCallbacksDispatcher, this.mFragmentStore, f);
        fragmentStateManager.restoreState(this.mHost.getContext().getClassLoader());
        fragmentStateManager.setFragmentManagerState(this.mCurState);
        return fragmentStateManager;
    }

    FragmentStateManager addFragment(@NonNull Fragment fragment) {
        if (fragment.mPreviousWho != null) {
            FragmentStrictMode.onFragmentReuse(fragment, fragment.mPreviousWho);
        }
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("add: " + fragment));
        }
        FragmentStateManager fragmentStateManager = this.createOrGetFragmentStateManager(fragment);
        fragment.mFragmentManager = this;
        this.mFragmentStore.makeActive(fragmentStateManager);
        if (!fragment.mDetached) {
            this.mFragmentStore.addFragment(fragment);
            fragment.mRemoving = false;
            if (fragment.mView == null) {
                fragment.mHiddenChanged = false;
            }
            if (this.isMenuAvailable(fragment)) {
                this.mNeedMenuInvalidate = true;
            }
        }
        return fragmentStateManager;
    }

    void removeFragment(@NonNull Fragment fragment) {
        boolean inactive;
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("remove: " + fragment + " nesting=" + fragment.mBackStackNesting));
        }
        boolean bl = inactive = !fragment.isInBackStack();
        if (!fragment.mDetached || inactive) {
            this.mFragmentStore.removeFragment(fragment);
            if (this.isMenuAvailable(fragment)) {
                this.mNeedMenuInvalidate = true;
            }
            fragment.mRemoving = true;
            this.setVisibleRemovingFragment(fragment);
        }
    }

    void hideFragment(@NonNull Fragment fragment) {
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("hide: " + fragment));
        }
        if (!fragment.mHidden) {
            fragment.mHidden = true;
            fragment.mHiddenChanged = !fragment.mHiddenChanged;
            this.setVisibleRemovingFragment(fragment);
        }
    }

    void showFragment(@NonNull Fragment fragment) {
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("show: " + fragment));
        }
        if (fragment.mHidden) {
            fragment.mHidden = false;
            fragment.mHiddenChanged = !fragment.mHiddenChanged;
        }
    }

    void detachFragment(@NonNull Fragment fragment) {
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("detach: " + fragment));
        }
        if (!fragment.mDetached) {
            fragment.mDetached = true;
            if (fragment.mAdded) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)TAG, (String)("remove from detach: " + fragment));
                }
                this.mFragmentStore.removeFragment(fragment);
                if (this.isMenuAvailable(fragment)) {
                    this.mNeedMenuInvalidate = true;
                }
                this.setVisibleRemovingFragment(fragment);
            }
        }
    }

    void attachFragment(@NonNull Fragment fragment) {
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("attach: " + fragment));
        }
        if (fragment.mDetached) {
            fragment.mDetached = false;
            if (!fragment.mAdded) {
                this.mFragmentStore.addFragment(fragment);
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)TAG, (String)("add from attach: " + fragment));
                }
                if (this.isMenuAvailable(fragment)) {
                    this.mNeedMenuInvalidate = true;
                }
            }
        }
    }

    @Nullable
    public Fragment findFragmentById(@IdRes int id2) {
        return this.mFragmentStore.findFragmentById(id2);
    }

    @Nullable
    public Fragment findFragmentByTag(@Nullable String tag) {
        return this.mFragmentStore.findFragmentByTag(tag);
    }

    Fragment findFragmentByWho(@NonNull String who) {
        return this.mFragmentStore.findFragmentByWho(who);
    }

    @Nullable
    Fragment findActiveFragment(@NonNull String who) {
        return this.mFragmentStore.findActiveFragment(who);
    }

    private void checkStateLoss() {
        if (this.isStateSaved()) {
            throw new IllegalStateException("Can not perform this action after onSaveInstanceState");
        }
    }

    public boolean isStateSaved() {
        return this.mStateSaved || this.mStopped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enqueueAction(@NonNull OpGenerator action, boolean allowStateLoss) {
        if (!allowStateLoss) {
            if (this.mHost == null) {
                if (this.mDestroyed) {
                    throw new IllegalStateException("FragmentManager has been destroyed");
                }
                throw new IllegalStateException("FragmentManager has not been attached to a host.");
            }
            this.checkStateLoss();
        }
        ArrayList<OpGenerator> arrayList = this.mPendingActions;
        synchronized (arrayList) {
            if (this.mHost == null) {
                if (allowStateLoss) {
                    return;
                }
                throw new IllegalStateException("Activity has been destroyed");
            }
            this.mPendingActions.add(action);
            this.scheduleCommit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleCommit() {
        ArrayList<OpGenerator> arrayList = this.mPendingActions;
        synchronized (arrayList) {
            boolean pendingReady;
            boolean bl = pendingReady = this.mPendingActions.size() == 1;
            if (pendingReady) {
                this.mHost.getHandler().removeCallbacks(this.mExecCommit);
                this.mHost.getHandler().post(this.mExecCommit);
                this.updateOnBackPressedCallbackEnabled();
            }
        }
    }

    int allocBackStackIndex() {
        return this.mBackStackIndex.getAndIncrement();
    }

    private void ensureExecReady(boolean allowStateLoss) {
        if (this.mExecutingActions) {
            throw new IllegalStateException("FragmentManager is already executing transactions");
        }
        if (this.mHost == null) {
            if (this.mDestroyed) {
                throw new IllegalStateException("FragmentManager has been destroyed");
            }
            throw new IllegalStateException("FragmentManager has not been attached to a host.");
        }
        if (Looper.myLooper() != this.mHost.getHandler().getLooper()) {
            throw new IllegalStateException("Must be called from main thread of fragment host");
        }
        if (!allowStateLoss) {
            this.checkStateLoss();
        }
        if (this.mTmpRecords == null) {
            this.mTmpRecords = new ArrayList();
            this.mTmpIsPop = new ArrayList();
        }
    }

    void execSingleAction(@NonNull OpGenerator action, boolean allowStateLoss) {
        if (allowStateLoss && (this.mHost == null || this.mDestroyed)) {
            return;
        }
        this.ensureExecReady(allowStateLoss);
        if (action.generateOps(this.mTmpRecords, this.mTmpIsPop)) {
            this.mExecutingActions = true;
            try {
                this.removeRedundantOperationsAndExecute(this.mTmpRecords, this.mTmpIsPop);
            }
            finally {
                this.cleanupExec();
            }
        }
        this.updateOnBackPressedCallbackEnabled();
        this.doPendingDeferredStart();
        this.mFragmentStore.burpActive();
    }

    private void cleanupExec() {
        this.mExecutingActions = false;
        this.mTmpIsPop.clear();
        this.mTmpRecords.clear();
    }

    boolean execPendingActions(boolean allowStateLoss) {
        this.ensureExecReady(allowStateLoss);
        boolean didSomething = false;
        while (this.generateOpsForPendingActions(this.mTmpRecords, this.mTmpIsPop)) {
            this.mExecutingActions = true;
            try {
                this.removeRedundantOperationsAndExecute(this.mTmpRecords, this.mTmpIsPop);
            }
            finally {
                this.cleanupExec();
            }
            didSomething = true;
        }
        this.updateOnBackPressedCallbackEnabled();
        this.doPendingDeferredStart();
        this.mFragmentStore.burpActive();
        return didSomething;
    }

    private void removeRedundantOperationsAndExecute(@NonNull ArrayList<BackStackRecord> records, @NonNull ArrayList<Boolean> isRecordPop) {
        if (records.isEmpty()) {
            return;
        }
        if (records.size() != isRecordPop.size()) {
            throw new IllegalStateException("Internal error with the back stack records");
        }
        int numRecords = records.size();
        int startIndex = 0;
        for (int recordNum = 0; recordNum < numRecords; ++recordNum) {
            int reorderingEnd;
            boolean canReorder = records.get((int)recordNum).mReorderingAllowed;
            if (canReorder) continue;
            if (startIndex != recordNum) {
                this.executeOpsTogether(records, isRecordPop, startIndex, recordNum);
            }
            if (isRecordPop.get(recordNum).booleanValue()) {
                for (reorderingEnd = recordNum + 1; reorderingEnd < numRecords && isRecordPop.get(reorderingEnd).booleanValue() && !records.get((int)reorderingEnd).mReorderingAllowed; ++reorderingEnd) {
                }
            }
            this.executeOpsTogether(records, isRecordPop, recordNum, reorderingEnd);
            startIndex = reorderingEnd;
            recordNum = reorderingEnd - 1;
        }
        if (startIndex != numRecords) {
            this.executeOpsTogether(records, isRecordPop, startIndex, numRecords);
        }
    }

    private void executeOpsTogether(@NonNull ArrayList<BackStackRecord> records, @NonNull ArrayList<Boolean> isRecordPop, int startIndex, int endIndex) {
        BackStackRecord record;
        boolean allowReordering = records.get((int)startIndex).mReorderingAllowed;
        boolean addToBackStack = false;
        if (this.mTmpAddedFragments == null) {
            this.mTmpAddedFragments = new ArrayList();
        } else {
            this.mTmpAddedFragments.clear();
        }
        this.mTmpAddedFragments.addAll(this.mFragmentStore.getFragments());
        Fragment oldPrimaryNav = this.getPrimaryNavigationFragment();
        for (int recordNum = startIndex; recordNum < endIndex; ++recordNum) {
            record = records.get(recordNum);
            boolean isPop = isRecordPop.get(recordNum);
            oldPrimaryNav = !isPop ? record.expandOps(this.mTmpAddedFragments, oldPrimaryNav) : record.trackAddedFragmentsInPop(this.mTmpAddedFragments, oldPrimaryNav);
            addToBackStack = addToBackStack || record.mAddToBackStack;
        }
        this.mTmpAddedFragments.clear();
        if (!allowReordering && this.mCurState >= 1) {
            for (int index = startIndex; index < endIndex; ++index) {
                record = records.get(index);
                for (FragmentTransaction.Op op : record.mOps) {
                    Fragment fragment = op.mFragment;
                    if (fragment == null || fragment.mFragmentManager == null) continue;
                    FragmentStateManager fragmentStateManager = this.createOrGetFragmentStateManager(fragment);
                    this.mFragmentStore.makeActive(fragmentStateManager);
                }
            }
        }
        FragmentManager.executeOps(records, isRecordPop, startIndex, endIndex);
        boolean isPop = isRecordPop.get(endIndex - 1);
        if (addToBackStack && !this.mBackStackChangeListeners.isEmpty()) {
            LinkedHashSet<Fragment> fragments = new LinkedHashSet<Fragment>();
            for (BackStackRecord record2 : records) {
                fragments.addAll(this.fragmentsFromRecord(record2));
            }
            if (this.mTransitioningOp == null) {
                for (OnBackStackChangedListener listener2 : this.mBackStackChangeListeners) {
                    for (Fragment fragment : fragments) {
                        listener2.onBackStackChangeStarted(fragment, isPop);
                    }
                }
                for (OnBackStackChangedListener listener2 : this.mBackStackChangeListeners) {
                    for (Fragment fragment : fragments) {
                        listener2.onBackStackChangeCommitted(fragment, isPop);
                    }
                }
            }
        }
        for (int index = startIndex; index < endIndex; ++index) {
            FragmentStateManager fragmentStateManager;
            Fragment fragment;
            BackStackRecord record3 = records.get(index);
            if (isPop) {
                for (int opIndex = record3.mOps.size() - 1; opIndex >= 0; --opIndex) {
                    FragmentTransaction.Op op = (FragmentTransaction.Op)record3.mOps.get(opIndex);
                    fragment = op.mFragment;
                    if (fragment == null) continue;
                    fragmentStateManager = this.createOrGetFragmentStateManager(fragment);
                    fragmentStateManager.moveToExpectedState();
                }
                continue;
            }
            for (FragmentTransaction.Op op : record3.mOps) {
                fragment = op.mFragment;
                if (fragment == null) continue;
                fragmentStateManager = this.createOrGetFragmentStateManager(fragment);
                fragmentStateManager.moveToExpectedState();
            }
        }
        this.moveToState(this.mCurState, true);
        Set<SpecialEffectsController> changedControllers = this.collectChangedControllers(records, startIndex, endIndex);
        for (SpecialEffectsController controller : changedControllers) {
            controller.updateOperationDirection(isPop);
            controller.markPostponedState();
            controller.executePendingOperations();
        }
        for (int recordNum = startIndex; recordNum < endIndex; ++recordNum) {
            BackStackRecord record4 = records.get(recordNum);
            isPop = isRecordPop.get(recordNum);
            if (isPop && record4.mIndex >= 0) {
                record4.mIndex = -1;
            }
            record4.runOnCommitRunnables();
        }
        if (addToBackStack) {
            this.reportBackStackChanged();
        }
    }

    Set<SpecialEffectsController> collectChangedControllers(@NonNull ArrayList<BackStackRecord> records, int startIndex, int endIndex) {
        HashSet<SpecialEffectsController> controllers = new HashSet<SpecialEffectsController>();
        for (int index = startIndex; index < endIndex; ++index) {
            BackStackRecord record = records.get(index);
            for (FragmentTransaction.Op op : record.mOps) {
                ViewGroup container;
                Fragment fragment = op.mFragment;
                if (fragment == null || (container = fragment.mContainer) == null) continue;
                controllers.add(SpecialEffectsController.getOrCreateController(container, this));
            }
        }
        return controllers;
    }

    private static void executeOps(@NonNull ArrayList<BackStackRecord> records, @NonNull ArrayList<Boolean> isRecordPop, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            BackStackRecord record = records.get(i);
            boolean isPop = isRecordPop.get(i);
            if (isPop) {
                record.bumpBackStackNesting(-1);
                record.executePopOps();
                continue;
            }
            record.bumpBackStackNesting(1);
            record.executeOps();
        }
    }

    private void setVisibleRemovingFragment(@NonNull Fragment f) {
        ViewGroup container = this.getFragmentContainer(f);
        if (container != null && f.getEnterAnim() + f.getExitAnim() + f.getPopEnterAnim() + f.getPopExitAnim() > 0) {
            if (container.getTag(R.id.visible_removing_fragment_view_tag) == null) {
                container.setTag(R.id.visible_removing_fragment_view_tag, (Object)f);
            }
            ((Fragment)container.getTag(R.id.visible_removing_fragment_view_tag)).setPopDirection(f.getPopDirection());
        }
    }

    private ViewGroup getFragmentContainer(@NonNull Fragment f) {
        View view;
        if (f.mContainer != null) {
            return f.mContainer;
        }
        if (f.mContainerId <= 0) {
            return null;
        }
        if (this.mContainer.onHasView() && (view = this.mContainer.onFindViewById(f.mContainerId)) instanceof ViewGroup) {
            return (ViewGroup)view;
        }
        return null;
    }

    private void forcePostponedTransactions() {
        Set<SpecialEffectsController> controllers = this.collectAllSpecialEffectsController();
        for (SpecialEffectsController controller : controllers) {
            controller.forcePostponedExecutePendingOperations();
        }
    }

    private void endAnimatingAwayFragments() {
        Set<SpecialEffectsController> controllers = this.collectAllSpecialEffectsController();
        for (SpecialEffectsController controller : controllers) {
            controller.forceCompleteAllOperations();
        }
    }

    private Set<SpecialEffectsController> collectAllSpecialEffectsController() {
        HashSet<SpecialEffectsController> controllers = new HashSet<SpecialEffectsController>();
        for (FragmentStateManager fragmentStateManager : this.mFragmentStore.getActiveFragmentStateManagers()) {
            ViewGroup container = fragmentStateManager.getFragment().mContainer;
            if (container == null) continue;
            controllers.add(SpecialEffectsController.getOrCreateController(container, this.getSpecialEffectsControllerFactory()));
        }
        return controllers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generateOpsForPendingActions(@NonNull ArrayList<BackStackRecord> records, @NonNull ArrayList<Boolean> isPop) {
        boolean didSomething = false;
        ArrayList<OpGenerator> arrayList = this.mPendingActions;
        synchronized (arrayList) {
            if (this.mPendingActions.isEmpty()) {
                return false;
            }
            try {
                int numActions = this.mPendingActions.size();
                for (int i = 0; i < numActions; ++i) {
                    didSomething |= this.mPendingActions.get(i).generateOps(records, isPop);
                }
            }
            finally {
                this.mPendingActions.clear();
                this.mHost.getHandler().removeCallbacks(this.mExecCommit);
            }
        }
        return didSomething;
    }

    private void doPendingDeferredStart() {
        if (this.mHavePendingDeferredStart) {
            this.mHavePendingDeferredStart = false;
            this.startPendingDeferredFragments();
        }
    }

    private void reportBackStackChanged() {
        for (int i = 0; i < this.mBackStackChangeListeners.size(); ++i) {
            this.mBackStackChangeListeners.get(i).onBackStackChanged();
        }
    }

    Set<Fragment> fragmentsFromRecord(@NonNull BackStackRecord record) {
        HashSet<Fragment> fragments = new HashSet<Fragment>();
        for (int i = 0; i < record.mOps.size(); ++i) {
            Fragment f = ((FragmentTransaction.Op)record.mOps.get((int)i)).mFragment;
            if (f == null || !record.mAddToBackStack) continue;
            fragments.add(f);
        }
        return fragments;
    }

    void addBackStackState(BackStackRecord state) {
        this.mBackStack.add(state);
    }

    boolean restoreBackStackState(@NonNull ArrayList<BackStackRecord> records, @NonNull ArrayList<Boolean> isRecordPop, @NonNull String name) {
        BackStackState backStackState = this.mBackStackStates.remove(name);
        if (backStackState == null) {
            return false;
        }
        HashMap<String, Fragment> pendingSavedFragments = new HashMap<String, Fragment>();
        for (BackStackRecord record : records) {
            if (!record.mBeingSaved) continue;
            for (FragmentTransaction.Op op : record.mOps) {
                if (op.mFragment == null) continue;
                pendingSavedFragments.put(op.mFragment.mWho, op.mFragment);
            }
        }
        List<BackStackRecord> backStackRecords = backStackState.instantiate(this, pendingSavedFragments);
        boolean added = false;
        for (BackStackRecord record : backStackRecords) {
            added = record.generateOps(records, isRecordPop) || added;
        }
        return added;
    }

    boolean saveBackStackState(@NonNull ArrayList<BackStackRecord> records, @NonNull ArrayList<Boolean> isRecordPop, @NonNull String name) {
        int index = this.findBackStackIndex(name, -1, true);
        if (index < 0) {
            return false;
        }
        for (int i = index; i < this.mBackStack.size(); ++i) {
            BackStackRecord record = this.mBackStack.get(i);
            if (record.mReorderingAllowed) continue;
            this.throwException(new IllegalArgumentException("saveBackStack(\"" + name + "\") included FragmentTransactions must use setReorderingAllowed(true) to ensure that the back stack can be restored as an atomic operation. Found " + record + " that did not use setReorderingAllowed(true)."));
        }
        HashSet<Fragment> allFragments = new HashSet<Fragment>();
        for (int i = index; i < this.mBackStack.size(); ++i) {
            BackStackRecord record = this.mBackStack.get(i);
            Iterator<Fragment> affectedFragments = new HashSet();
            HashSet<Fragment> addedFragments = new HashSet<Fragment>();
            for (FragmentTransaction.Op op : record.mOps) {
                Fragment f = op.mFragment;
                if (f == null) continue;
                if (!op.mFromExpandedOp || op.mCmd == 1 || op.mCmd == 2 || op.mCmd == 8) {
                    allFragments.add(f);
                    ((HashSet)((Object)affectedFragments)).add(f);
                }
                if (op.mCmd != 1 && op.mCmd != 2) continue;
                addedFragments.add(f);
            }
            ((AbstractSet)((Object)affectedFragments)).removeAll(addedFragments);
            if (((HashSet)((Object)affectedFragments)).isEmpty()) continue;
            this.throwException(new IllegalArgumentException("saveBackStack(\"" + name + "\") must be self contained and not reference fragments from non-saved FragmentTransactions. Found reference to fragment" + (((HashSet)((Object)affectedFragments)).size() == 1 ? " " + ((HashSet)((Object)affectedFragments)).iterator().next() : "s " + affectedFragments) + " in " + record + " that were previously added to the FragmentManager through a separate FragmentTransaction."));
        }
        ArrayDeque<Fragment> fragmentsToSearch = new ArrayDeque<Fragment>(allFragments);
        while (!fragmentsToSearch.isEmpty()) {
            Fragment currentFragment = (Fragment)fragmentsToSearch.removeFirst();
            if (currentFragment.mRetainInstance) {
                this.throwException(new IllegalArgumentException("saveBackStack(\"" + name + "\") must not contain retained fragments. Found " + (allFragments.contains(currentFragment) ? "direct reference to retained " : "retained child ") + "fragment " + currentFragment));
            }
            for (Fragment f : currentFragment.mChildFragmentManager.getActiveFragments()) {
                if (f == null) continue;
                fragmentsToSearch.addLast(f);
            }
        }
        ArrayList<String> fragments = new ArrayList<String>();
        for (Fragment f : allFragments) {
            fragments.add(f.mWho);
        }
        ArrayList<BackStackRecordState> backStackRecordStates = new ArrayList<BackStackRecordState>(this.mBackStack.size() - index);
        for (int i = index; i < this.mBackStack.size(); ++i) {
            backStackRecordStates.add(null);
        }
        BackStackState backStackState = new BackStackState(fragments, backStackRecordStates);
        for (int i = this.mBackStack.size() - 1; i >= index; --i) {
            BackStackRecord record = this.mBackStack.remove(i);
            BackStackRecord copy = new BackStackRecord(record);
            copy.collapseOps();
            BackStackRecordState state = new BackStackRecordState(copy);
            backStackRecordStates.set(i - index, state);
            record.mBeingSaved = true;
            records.add(record);
            isRecordPop.add(true);
        }
        this.mBackStackStates.put(name, backStackState);
        return true;
    }

    boolean clearBackStackState(@NonNull ArrayList<BackStackRecord> records, @NonNull ArrayList<Boolean> isRecordPop, @NonNull String name) {
        boolean restoredBackStackState = this.restoreBackStackState(records, isRecordPop, name);
        if (!restoredBackStackState) {
            return false;
        }
        return this.popBackStackState(records, isRecordPop, name, -1, 1);
    }

    boolean popBackStackState(@NonNull ArrayList<BackStackRecord> records, @NonNull ArrayList<Boolean> isRecordPop, @Nullable String name, int id2, int flags) {
        int index = this.findBackStackIndex(name, id2, (flags & 1) != 0);
        if (index < 0) {
            return false;
        }
        for (int i = this.mBackStack.size() - 1; i >= index; --i) {
            records.add(this.mBackStack.remove(i));
            isRecordPop.add(true);
        }
        return true;
    }

    boolean prepareBackStackState(@NonNull ArrayList<BackStackRecord> records, @NonNull ArrayList<Boolean> isRecordPop) {
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("FragmentManager has the following pending actions inside of prepareBackStackState: " + this.mPendingActions));
        }
        if (this.mBackStack.isEmpty()) {
            Log.i((String)TAG, (String)"Ignoring call to start back stack pop because the back stack is empty.");
            return false;
        }
        this.mTransitioningOp = this.mBackStack.get(this.mBackStack.size() - 1);
        for (FragmentTransaction.Op op : this.mTransitioningOp.mOps) {
            if (op.mFragment == null) continue;
            op.mFragment.mTransitioning = true;
        }
        return this.popBackStackState(records, isRecordPop, null, -1, 0);
    }

    private int findBackStackIndex(@Nullable String name, int id2, boolean inclusive) {
        BackStackRecord bss;
        int index;
        if (this.mBackStack.isEmpty()) {
            return -1;
        }
        if (name == null && id2 < 0) {
            if (inclusive) {
                return 0;
            }
            return this.mBackStack.size() - 1;
        }
        for (index = this.mBackStack.size() - 1; index >= 0; --index) {
            bss = this.mBackStack.get(index);
            if (name != null && name.equals(bss.getName()) || id2 >= 0 && id2 == bss.mIndex) break;
        }
        if (index < 0) {
            return index;
        }
        if (inclusive) {
            while (index > 0) {
                bss = this.mBackStack.get(index - 1);
                if (name != null && name.equals(bss.getName()) || id2 >= 0 && id2 == bss.mIndex) {
                    --index;
                    continue;
                }
                break;
            }
        } else {
            if (index == this.mBackStack.size() - 1) {
                return -1;
            }
            ++index;
        }
        return index;
    }

    @Deprecated
    FragmentManagerNonConfig retainNonConfig() {
        if (this.mHost instanceof ViewModelStoreOwner) {
            this.throwException(new IllegalStateException("You cannot use retainNonConfig when your FragmentHostCallback implements ViewModelStoreOwner."));
        }
        return this.mNonConfig.getSnapshot();
    }

    Parcelable saveAllState() {
        Bundle savedState;
        if (this.mHost instanceof SavedStateRegistryOwner) {
            this.throwException(new IllegalStateException("You cannot use saveAllState when your FragmentHostCallback implements SavedStateRegistryOwner."));
        }
        return (savedState = this.saveAllStateInternal()).isEmpty() ? null : savedState;
    }

    @NonNull
    Bundle saveAllStateInternal() {
        Bundle bundle = new Bundle();
        this.forcePostponedTransactions();
        this.endAnimatingAwayFragments();
        this.execPendingActions(true);
        this.mStateSaved = true;
        this.mNonConfig.setIsStateSaved(true);
        ArrayList<String> active = this.mFragmentStore.saveActiveFragments();
        HashMap<String, Bundle> savedState = this.mFragmentStore.getAllSavedState();
        if (savedState.isEmpty()) {
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)TAG, (String)"saveAllState: no fragments!");
            }
        } else {
            ArrayList<String> added = this.mFragmentStore.saveAddedFragments();
            BackStackRecordState[] backStack = null;
            int size = this.mBackStack.size();
            if (size > 0) {
                backStack = new BackStackRecordState[size];
                for (int i = 0; i < size; ++i) {
                    backStack[i] = new BackStackRecordState(this.mBackStack.get(i));
                    if (!FragmentManager.isLoggingEnabled(2)) continue;
                    Log.v((String)TAG, (String)("saveAllState: adding back stack #" + i + ": " + this.mBackStack.get(i)));
                }
            }
            FragmentManagerState fms = new FragmentManagerState();
            fms.mActive = active;
            fms.mAdded = added;
            fms.mBackStack = backStack;
            fms.mBackStackIndex = this.mBackStackIndex.get();
            if (this.mPrimaryNav != null) {
                fms.mPrimaryNavActiveWho = this.mPrimaryNav.mWho;
            }
            fms.mBackStackStateKeys.addAll(this.mBackStackStates.keySet());
            fms.mBackStackStates.addAll(this.mBackStackStates.values());
            fms.mLaunchedFragments = new ArrayList<LaunchedFragmentInfo>(this.mLaunchedFragments);
            bundle.putParcelable(FRAGMENT_MANAGER_STATE_KEY, (Parcelable)fms);
            for (String resultName : this.mResults.keySet()) {
                bundle.putBundle(RESULT_KEY_PREFIX + resultName, this.mResults.get(resultName));
            }
            for (String fWho : savedState.keySet()) {
                bundle.putBundle(FRAGMENT_KEY_PREFIX + fWho, savedState.get(fWho));
            }
        }
        return bundle;
    }

    void restoreAllState(@Nullable Parcelable state, @Nullable FragmentManagerNonConfig nonConfig) {
        if (this.mHost instanceof ViewModelStoreOwner) {
            this.throwException(new IllegalStateException("You must use restoreSaveState when your FragmentHostCallback implements ViewModelStoreOwner"));
        }
        this.mNonConfig.restoreFromSnapshot(nonConfig);
        this.restoreSaveStateInternal(state);
    }

    void restoreSaveState(@Nullable Parcelable state) {
        if (this.mHost instanceof SavedStateRegistryOwner) {
            this.throwException(new IllegalStateException("You cannot use restoreSaveState when your FragmentHostCallback implements SavedStateRegistryOwner."));
        }
        this.restoreSaveStateInternal(state);
    }

    void restoreSaveStateInternal(@Nullable Parcelable state) {
        ArrayList<String> savedBackStackStateKeys;
        if (state == null) {
            return;
        }
        Bundle bundle = (Bundle)state;
        for (Object bundleKey : bundle.keySet()) {
            Bundle savedResult;
            if (!((String)bundleKey).startsWith(RESULT_KEY_PREFIX) || (savedResult = bundle.getBundle((String)bundleKey)) == null) continue;
            savedResult.setClassLoader(this.mHost.getContext().getClassLoader());
            String resultKey = ((String)bundleKey).substring(RESULT_KEY_PREFIX.length());
            this.mResults.put(resultKey, savedResult);
        }
        HashMap<String, Bundle> allStateBundles = new HashMap<String, Bundle>();
        for (Object bundleKey : bundle.keySet()) {
            Bundle savedFragmentBundle;
            if (!((String)bundleKey).startsWith(FRAGMENT_KEY_PREFIX) || (savedFragmentBundle = bundle.getBundle((String)bundleKey)) == null) continue;
            savedFragmentBundle.setClassLoader(this.mHost.getContext().getClassLoader());
            String fragmentKey = ((String)bundleKey).substring(FRAGMENT_KEY_PREFIX.length());
            allStateBundles.put(fragmentKey, savedFragmentBundle);
        }
        this.mFragmentStore.restoreSaveState(allStateBundles);
        FragmentManagerState fms = (FragmentManagerState)bundle.getParcelable(FRAGMENT_MANAGER_STATE_KEY);
        if (fms == null) {
            return;
        }
        this.mFragmentStore.resetActiveFragments();
        for (String who : fms.mActive) {
            FragmentStateManager fragmentStateManager;
            Bundle stateBundle = this.mFragmentStore.setSavedState(who, null);
            if (stateBundle == null) continue;
            FragmentState fs = (FragmentState)stateBundle.getParcelable(FRAGMENT_MANAGER_STATE_KEY);
            Fragment retainedFragment = this.mNonConfig.findRetainedFragmentByWho(fs.mWho);
            if (retainedFragment != null) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)TAG, (String)("restoreSaveState: re-attaching retained " + retainedFragment));
                }
                fragmentStateManager = new FragmentStateManager(this.mLifecycleCallbacksDispatcher, this.mFragmentStore, retainedFragment, stateBundle);
            } else {
                fragmentStateManager = new FragmentStateManager(this.mLifecycleCallbacksDispatcher, this.mFragmentStore, this.mHost.getContext().getClassLoader(), this.getFragmentFactory(), stateBundle);
            }
            Fragment f = fragmentStateManager.getFragment();
            f.mSavedFragmentState = stateBundle;
            f.mFragmentManager = this;
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)TAG, (String)("restoreSaveState: active (" + f.mWho + "): " + f));
            }
            fragmentStateManager.restoreState(this.mHost.getContext().getClassLoader());
            this.mFragmentStore.makeActive(fragmentStateManager);
            fragmentStateManager.setFragmentManagerState(this.mCurState);
        }
        for (Fragment f : this.mNonConfig.getRetainedFragments()) {
            if (this.mFragmentStore.containsActiveFragment(f.mWho)) continue;
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)TAG, (String)("Discarding retained Fragment " + f + " that was not found in the set of active Fragments " + fms.mActive));
            }
            this.mNonConfig.removeRetainedFragment(f);
            f.mFragmentManager = this;
            FragmentStateManager fragmentStateManager = new FragmentStateManager(this.mLifecycleCallbacksDispatcher, this.mFragmentStore, f);
            fragmentStateManager.setFragmentManagerState(1);
            fragmentStateManager.moveToExpectedState();
            f.mRemoving = true;
            fragmentStateManager.moveToExpectedState();
        }
        this.mFragmentStore.restoreAddedFragments(fms.mAdded);
        if (fms.mBackStack != null) {
            this.mBackStack = new ArrayList(fms.mBackStack.length);
            for (int i = 0; i < fms.mBackStack.length; ++i) {
                BackStackRecord bse = fms.mBackStack[i].instantiate(this);
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)TAG, (String)("restoreAllState: back stack #" + i + " (index " + bse.mIndex + "): " + bse));
                    LogWriter logw = new LogWriter(TAG);
                    PrintWriter pw = new PrintWriter(logw);
                    bse.dump("  ", pw, false);
                    pw.close();
                }
                this.mBackStack.add(bse);
            }
        } else {
            this.mBackStack = new ArrayList();
        }
        this.mBackStackIndex.set(fms.mBackStackIndex);
        if (fms.mPrimaryNavActiveWho != null) {
            this.mPrimaryNav = this.findActiveFragment(fms.mPrimaryNavActiveWho);
            this.dispatchParentPrimaryNavigationFragmentChanged(this.mPrimaryNav);
        }
        if ((savedBackStackStateKeys = fms.mBackStackStateKeys) != null) {
            for (int i = 0; i < savedBackStackStateKeys.size(); ++i) {
                this.mBackStackStates.put(savedBackStackStateKeys.get(i), fms.mBackStackStates.get(i));
            }
        }
        this.mLaunchedFragments = new ArrayDeque<LaunchedFragmentInfo>(fms.mLaunchedFragments);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public FragmentHostCallback<?> getHost() {
        return this.mHost;
    }

    @Nullable
    Fragment getParent() {
        return this.mParent;
    }

    @NonNull
    FragmentContainer getContainer() {
        return this.mContainer;
    }

    @NonNull
    FragmentStore getFragmentStore() {
        return this.mFragmentStore;
    }

    void attachController(@NonNull FragmentHostCallback<?> host, @NonNull FragmentContainer container, final @Nullable Fragment parent) {
        Object registry;
        if (this.mHost != null) {
            throw new IllegalStateException("Already attached");
        }
        this.mHost = host;
        this.mContainer = container;
        this.mParent = parent;
        if (this.mParent != null) {
            this.addFragmentOnAttachListener(new FragmentOnAttachListener(){

                @Override
                public void onAttachFragment(@NonNull FragmentManager fragmentManager, @NonNull Fragment fragment) {
                    parent.onAttachFragment(fragment);
                }
            });
        } else if (host instanceof FragmentOnAttachListener) {
            this.addFragmentOnAttachListener((FragmentOnAttachListener)((Object)host));
        }
        if (this.mParent != null) {
            this.updateOnBackPressedCallbackEnabled();
        }
        if (host instanceof OnBackPressedDispatcherOwner) {
            OnBackPressedDispatcherOwner dispatcherOwner = (OnBackPressedDispatcherOwner)((Object)host);
            this.mOnBackPressedDispatcher = dispatcherOwner.getOnBackPressedDispatcher();
            LifecycleOwner owner2 = parent != null ? parent : dispatcherOwner;
            this.mOnBackPressedDispatcher.addCallback(owner2, this.mOnBackPressedCallback);
        }
        if (parent != null) {
            this.mNonConfig = parent.mFragmentManager.getChildNonConfig(parent);
        } else if (host instanceof ViewModelStoreOwner) {
            ViewModelStore viewModelStore = ((ViewModelStoreOwner)((Object)host)).getViewModelStore();
            this.mNonConfig = FragmentManagerViewModel.getInstance(viewModelStore);
        } else {
            this.mNonConfig = new FragmentManagerViewModel(false);
        }
        this.mNonConfig.setIsStateSaved(this.isStateSaved());
        this.mFragmentStore.setNonConfig(this.mNonConfig);
        if (this.mHost instanceof SavedStateRegistryOwner && parent == null) {
            registry = ((SavedStateRegistryOwner)((Object)this.mHost)).getSavedStateRegistry();
            ((SavedStateRegistry)registry).registerSavedStateProvider(SAVED_STATE_KEY, () -> this.saveAllStateInternal());
            Bundle savedInstanceState = ((SavedStateRegistry)registry).consumeRestoredStateForKey(SAVED_STATE_KEY);
            if (savedInstanceState != null) {
                this.restoreSaveStateInternal((Parcelable)savedInstanceState);
            }
        }
        if (this.mHost instanceof ActivityResultRegistryOwner) {
            registry = ((ActivityResultRegistryOwner)((Object)this.mHost)).getActivityResultRegistry();
            String parentId = parent != null ? parent.mWho + ":" : "";
            String keyPrefix = "FragmentManager:" + parentId;
            this.mStartActivityForResult = ((ActivityResultRegistry)registry).register(keyPrefix + "StartActivityForResult", new ActivityResultContracts.StartActivityForResult(), new ActivityResultCallback<ActivityResult>(){

                @Override
                public void onActivityResult(ActivityResult result2) {
                    LaunchedFragmentInfo requestInfo = FragmentManager.this.mLaunchedFragments.pollLast();
                    if (requestInfo == null) {
                        Log.w((String)FragmentManager.TAG, (String)("No Activities were started for result for " + this));
                        return;
                    }
                    String fragmentWho = requestInfo.mWho;
                    int requestCode = requestInfo.mRequestCode;
                    Fragment fragment = FragmentManager.this.mFragmentStore.findFragmentByWho(fragmentWho);
                    if (fragment == null) {
                        Log.w((String)FragmentManager.TAG, (String)("Activity result delivered for unknown Fragment " + fragmentWho));
                        return;
                    }
                    fragment.onActivityResult(requestCode, result2.getResultCode(), result2.getData());
                }
            });
            this.mStartIntentSenderForResult = ((ActivityResultRegistry)registry).register(keyPrefix + "StartIntentSenderForResult", new FragmentIntentSenderContract(), new ActivityResultCallback<ActivityResult>(){

                @Override
                public void onActivityResult(ActivityResult result2) {
                    LaunchedFragmentInfo requestInfo = FragmentManager.this.mLaunchedFragments.pollFirst();
                    if (requestInfo == null) {
                        Log.w((String)FragmentManager.TAG, (String)("No IntentSenders were started for " + this));
                        return;
                    }
                    String fragmentWho = requestInfo.mWho;
                    int requestCode = requestInfo.mRequestCode;
                    Fragment fragment = FragmentManager.this.mFragmentStore.findFragmentByWho(fragmentWho);
                    if (fragment == null) {
                        Log.w((String)FragmentManager.TAG, (String)("Intent Sender result delivered for unknown Fragment " + fragmentWho));
                        return;
                    }
                    fragment.onActivityResult(requestCode, result2.getResultCode(), result2.getData());
                }
            });
            this.mRequestPermissions = ((ActivityResultRegistry)registry).register(keyPrefix + "RequestPermissions", new ActivityResultContracts.RequestMultiplePermissions(), new ActivityResultCallback<Map<String, Boolean>>(){

                @Override
                public void onActivityResult(Map<String, Boolean> result2) {
                    String[] permissions = result2.keySet().toArray(new String[0]);
                    ArrayList<Boolean> resultValues = new ArrayList<Boolean>(result2.values());
                    int[] grantResults = new int[resultValues.size()];
                    for (int i = 0; i < resultValues.size(); ++i) {
                        grantResults[i] = resultValues.get(i) != false ? 0 : -1;
                    }
                    LaunchedFragmentInfo requestInfo = FragmentManager.this.mLaunchedFragments.pollFirst();
                    if (requestInfo == null) {
                        Log.w((String)FragmentManager.TAG, (String)("No permissions were requested for " + this));
                        return;
                    }
                    String fragmentWho = requestInfo.mWho;
                    int requestCode = requestInfo.mRequestCode;
                    Fragment fragment = FragmentManager.this.mFragmentStore.findFragmentByWho(fragmentWho);
                    if (fragment == null) {
                        Log.w((String)FragmentManager.TAG, (String)("Permission request result delivered for unknown Fragment " + fragmentWho));
                        return;
                    }
                    fragment.onRequestPermissionsResult(requestCode, permissions, grantResults);
                }
            });
        }
        if (this.mHost instanceof OnConfigurationChangedProvider) {
            OnConfigurationChangedProvider onConfigurationChangedProvider = (OnConfigurationChangedProvider)((Object)this.mHost);
            onConfigurationChangedProvider.addOnConfigurationChangedListener(this.mOnConfigurationChangedListener);
        }
        if (this.mHost instanceof OnTrimMemoryProvider) {
            OnTrimMemoryProvider onTrimMemoryProvider = (OnTrimMemoryProvider)((Object)this.mHost);
            onTrimMemoryProvider.addOnTrimMemoryListener(this.mOnTrimMemoryListener);
        }
        if (this.mHost instanceof OnMultiWindowModeChangedProvider) {
            OnMultiWindowModeChangedProvider onMultiWindowModeChangedProvider = (OnMultiWindowModeChangedProvider)((Object)this.mHost);
            onMultiWindowModeChangedProvider.addOnMultiWindowModeChangedListener(this.mOnMultiWindowModeChangedListener);
        }
        if (this.mHost instanceof OnPictureInPictureModeChangedProvider) {
            OnPictureInPictureModeChangedProvider onPictureInPictureModeChangedProvider = (OnPictureInPictureModeChangedProvider)((Object)this.mHost);
            onPictureInPictureModeChangedProvider.addOnPictureInPictureModeChangedListener(this.mOnPictureInPictureModeChangedListener);
        }
        if (this.mHost instanceof MenuHost && parent == null) {
            ((MenuHost)((Object)this.mHost)).addMenuProvider(this.mMenuProvider);
        }
    }

    void noteStateNotSaved() {
        if (this.mHost == null) {
            return;
        }
        this.mStateSaved = false;
        this.mStopped = false;
        this.mNonConfig.setIsStateSaved(false);
        for (Fragment fragment : this.mFragmentStore.getFragments()) {
            if (fragment == null) continue;
            fragment.noteStateNotSaved();
        }
    }

    void launchStartActivityForResult(@NonNull Fragment f, @NonNull Intent intent, int requestCode, @Nullable Bundle options) {
        if (this.mStartActivityForResult != null) {
            LaunchedFragmentInfo info = new LaunchedFragmentInfo(f.mWho, requestCode);
            this.mLaunchedFragments.addLast(info);
            if (options != null) {
                intent.putExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE", options);
            }
            this.mStartActivityForResult.launch(intent);
        } else {
            this.mHost.onStartActivityFromFragment(f, intent, requestCode, options);
        }
    }

    void launchStartIntentSenderForResult(@NonNull Fragment f, @NonNull IntentSender intent, int requestCode, @Nullable Intent fillInIntent, int flagsMask, int flagsValues, int extraFlags, @Nullable Bundle options) throws IntentSender.SendIntentException {
        if (this.mStartIntentSenderForResult != null) {
            if (options != null) {
                if (fillInIntent == null) {
                    fillInIntent = new Intent();
                    fillInIntent.putExtra(EXTRA_CREATED_FILLIN_INTENT, true);
                }
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)TAG, (String)("ActivityOptions " + options + " were added to fillInIntent " + fillInIntent + " for fragment " + f));
                }
                fillInIntent.putExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE", options);
            }
            IntentSenderRequest request = new IntentSenderRequest.Builder(intent).setFillInIntent(fillInIntent).setFlags(flagsValues, flagsMask).build();
            LaunchedFragmentInfo info = new LaunchedFragmentInfo(f.mWho, requestCode);
            this.mLaunchedFragments.addLast(info);
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)TAG, (String)("Fragment " + f + "is launching an IntentSender for result "));
            }
            this.mStartIntentSenderForResult.launch(request);
        } else {
            this.mHost.onStartIntentSenderFromFragment(f, intent, requestCode, fillInIntent, flagsMask, flagsValues, extraFlags, options);
        }
    }

    void launchRequestPermissions(@NonNull Fragment f, @NonNull String[] permissions, int requestCode) {
        if (this.mRequestPermissions != null) {
            LaunchedFragmentInfo info = new LaunchedFragmentInfo(f.mWho, requestCode);
            this.mLaunchedFragments.addLast(info);
            this.mRequestPermissions.launch(permissions);
        } else {
            this.mHost.onRequestPermissionsFromFragment(f, permissions, requestCode);
        }
    }

    void dispatchAttach() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.mNonConfig.setIsStateSaved(false);
        this.dispatchStateChange(0);
    }

    void dispatchCreate() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.mNonConfig.setIsStateSaved(false);
        this.dispatchStateChange(1);
    }

    void dispatchViewCreated() {
        this.dispatchStateChange(2);
    }

    void dispatchActivityCreated() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.mNonConfig.setIsStateSaved(false);
        this.dispatchStateChange(4);
    }

    void dispatchStart() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.mNonConfig.setIsStateSaved(false);
        this.dispatchStateChange(5);
    }

    void dispatchResume() {
        this.mStateSaved = false;
        this.mStopped = false;
        this.mNonConfig.setIsStateSaved(false);
        this.dispatchStateChange(7);
    }

    void dispatchPause() {
        this.dispatchStateChange(5);
    }

    void dispatchStop() {
        this.mStopped = true;
        this.mNonConfig.setIsStateSaved(true);
        this.dispatchStateChange(4);
    }

    void dispatchDestroyView() {
        this.dispatchStateChange(1);
    }

    void dispatchDestroy() {
        this.mDestroyed = true;
        this.execPendingActions(true);
        this.endAnimatingAwayFragments();
        this.clearBackStackStateViewModels();
        this.dispatchStateChange(-1);
        if (this.mHost instanceof OnTrimMemoryProvider) {
            OnTrimMemoryProvider onTrimMemoryProvider = (OnTrimMemoryProvider)((Object)this.mHost);
            onTrimMemoryProvider.removeOnTrimMemoryListener(this.mOnTrimMemoryListener);
        }
        if (this.mHost instanceof OnConfigurationChangedProvider) {
            OnConfigurationChangedProvider onConfigurationChangedProvider = (OnConfigurationChangedProvider)((Object)this.mHost);
            onConfigurationChangedProvider.removeOnConfigurationChangedListener(this.mOnConfigurationChangedListener);
        }
        if (this.mHost instanceof OnMultiWindowModeChangedProvider) {
            OnMultiWindowModeChangedProvider onMultiWindowModeChangedProvider = (OnMultiWindowModeChangedProvider)((Object)this.mHost);
            onMultiWindowModeChangedProvider.removeOnMultiWindowModeChangedListener(this.mOnMultiWindowModeChangedListener);
        }
        if (this.mHost instanceof OnPictureInPictureModeChangedProvider) {
            OnPictureInPictureModeChangedProvider onPictureInPictureModeChangedProvider = (OnPictureInPictureModeChangedProvider)((Object)this.mHost);
            onPictureInPictureModeChangedProvider.removeOnPictureInPictureModeChangedListener(this.mOnPictureInPictureModeChangedListener);
        }
        if (this.mHost instanceof MenuHost && this.mParent == null) {
            ((MenuHost)((Object)this.mHost)).removeMenuProvider(this.mMenuProvider);
        }
        this.mHost = null;
        this.mContainer = null;
        this.mParent = null;
        if (this.mOnBackPressedDispatcher != null) {
            this.mOnBackPressedCallback.remove();
            this.mOnBackPressedDispatcher = null;
        }
        if (this.mStartActivityForResult != null) {
            this.mStartActivityForResult.unregister();
            this.mStartIntentSenderForResult.unregister();
            this.mRequestPermissions.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatchStateChange(int nextState) {
        try {
            this.mExecutingActions = true;
            this.mFragmentStore.dispatchStateChange(nextState);
            this.moveToState(nextState, false);
            Set<SpecialEffectsController> controllers = this.collectAllSpecialEffectsController();
            for (SpecialEffectsController controller : controllers) {
                controller.forceCompleteAllOperations();
            }
        }
        finally {
            this.mExecutingActions = false;
        }
        this.execPendingActions(true);
    }

    void dispatchMultiWindowModeChanged(boolean isInMultiWindowMode, boolean recursive) {
        if (recursive && this.mHost instanceof OnMultiWindowModeChangedProvider) {
            this.throwException(new IllegalStateException("Do not call dispatchMultiWindowModeChanged() on host. Host implements OnMultiWindowModeChangedProvider and automatically dispatches multi-window mode changes to fragments."));
        }
        for (Fragment f : this.mFragmentStore.getFragments()) {
            if (f == null) continue;
            f.performMultiWindowModeChanged(isInMultiWindowMode);
            if (!recursive) continue;
            f.mChildFragmentManager.dispatchMultiWindowModeChanged(isInMultiWindowMode, true);
        }
    }

    void dispatchPictureInPictureModeChanged(boolean isInPictureInPictureMode, boolean recursive) {
        if (recursive && this.mHost instanceof OnPictureInPictureModeChangedProvider) {
            this.throwException(new IllegalStateException("Do not call dispatchPictureInPictureModeChanged() on host. Host implements OnPictureInPictureModeChangedProvider and automatically dispatches picture-in-picture mode changes to fragments."));
        }
        for (Fragment f : this.mFragmentStore.getFragments()) {
            if (f == null) continue;
            f.performPictureInPictureModeChanged(isInPictureInPictureMode);
            if (!recursive) continue;
            f.mChildFragmentManager.dispatchPictureInPictureModeChanged(isInPictureInPictureMode, true);
        }
    }

    void dispatchConfigurationChanged(@NonNull Configuration newConfig, boolean recursive) {
        if (recursive && this.mHost instanceof OnConfigurationChangedProvider) {
            this.throwException(new IllegalStateException("Do not call dispatchConfigurationChanged() on host. Host implements OnConfigurationChangedProvider and automatically dispatches configuration changes to fragments."));
        }
        for (Fragment f : this.mFragmentStore.getFragments()) {
            if (f == null) continue;
            f.performConfigurationChanged(newConfig);
            if (!recursive) continue;
            f.mChildFragmentManager.dispatchConfigurationChanged(newConfig, true);
        }
    }

    void dispatchLowMemory(boolean recursive) {
        if (recursive && this.mHost instanceof OnTrimMemoryProvider) {
            this.throwException(new IllegalStateException("Do not call dispatchLowMemory() on host. Host implements OnTrimMemoryProvider and automatically dispatches low memory callbacks to fragments."));
        }
        for (Fragment f : this.mFragmentStore.getFragments()) {
            if (f == null) continue;
            f.performLowMemory();
            if (!recursive) continue;
            f.mChildFragmentManager.dispatchLowMemory(true);
        }
    }

    boolean dispatchCreateOptionsMenu(@NonNull Menu menu2, @NonNull MenuInflater inflater) {
        if (this.mCurState < 1) {
            return false;
        }
        boolean show = false;
        ArrayList<Fragment> newMenus = null;
        for (Fragment f : this.mFragmentStore.getFragments()) {
            if (f == null || !this.isParentMenuVisible(f) || !f.performCreateOptionsMenu(menu2, inflater)) continue;
            show = true;
            if (newMenus == null) {
                newMenus = new ArrayList<Fragment>();
            }
            newMenus.add(f);
        }
        if (this.mCreatedMenus != null) {
            for (int i = 0; i < this.mCreatedMenus.size(); ++i) {
                Fragment f;
                f = this.mCreatedMenus.get(i);
                if (newMenus != null && newMenus.contains(f)) continue;
                f.onDestroyOptionsMenu();
            }
        }
        this.mCreatedMenus = newMenus;
        return show;
    }

    boolean dispatchPrepareOptionsMenu(@NonNull Menu menu2) {
        if (this.mCurState < 1) {
            return false;
        }
        boolean show = false;
        for (Fragment f : this.mFragmentStore.getFragments()) {
            if (f == null || !this.isParentMenuVisible(f) || !f.performPrepareOptionsMenu(menu2)) continue;
            show = true;
        }
        return show;
    }

    boolean dispatchOptionsItemSelected(@NonNull MenuItem item) {
        if (this.mCurState < 1) {
            return false;
        }
        for (Fragment f : this.mFragmentStore.getFragments()) {
            if (f == null || !f.performOptionsItemSelected(item)) continue;
            return true;
        }
        return false;
    }

    boolean dispatchContextItemSelected(@NonNull MenuItem item) {
        if (this.mCurState < 1) {
            return false;
        }
        for (Fragment f : this.mFragmentStore.getFragments()) {
            if (f == null || !f.performContextItemSelected(item)) continue;
            return true;
        }
        return false;
    }

    void dispatchOptionsMenuClosed(@NonNull Menu menu2) {
        if (this.mCurState < 1) {
            return;
        }
        for (Fragment f : this.mFragmentStore.getFragments()) {
            if (f == null) continue;
            f.performOptionsMenuClosed(menu2);
        }
    }

    void setPrimaryNavigationFragment(@Nullable Fragment f) {
        if (f != null && (!f.equals(this.findActiveFragment(f.mWho)) || f.mHost != null && f.mFragmentManager != this)) {
            throw new IllegalArgumentException("Fragment " + f + " is not an active fragment of FragmentManager " + this);
        }
        Fragment previousPrimaryNav = this.mPrimaryNav;
        this.mPrimaryNav = f;
        this.dispatchParentPrimaryNavigationFragmentChanged(previousPrimaryNav);
        this.dispatchParentPrimaryNavigationFragmentChanged(this.mPrimaryNav);
    }

    private void dispatchParentPrimaryNavigationFragmentChanged(@Nullable Fragment f) {
        if (f != null && f.equals(this.findActiveFragment(f.mWho))) {
            f.performPrimaryNavigationFragmentChanged();
        }
    }

    void dispatchPrimaryNavigationFragmentChanged() {
        this.updateOnBackPressedCallbackEnabled();
        this.dispatchParentPrimaryNavigationFragmentChanged(this.mPrimaryNav);
    }

    @Nullable
    public Fragment getPrimaryNavigationFragment() {
        return this.mPrimaryNav;
    }

    void setMaxLifecycle(@NonNull Fragment f, @NonNull Lifecycle.State state) {
        if (!f.equals(this.findActiveFragment(f.mWho)) || f.mHost != null && f.mFragmentManager != this) {
            throw new IllegalArgumentException("Fragment " + f + " is not an active fragment of FragmentManager " + this);
        }
        f.mMaxState = state;
    }

    public void setFragmentFactory(@NonNull FragmentFactory fragmentFactory) {
        this.mFragmentFactory = fragmentFactory;
    }

    @NonNull
    public FragmentFactory getFragmentFactory() {
        if (this.mFragmentFactory != null) {
            return this.mFragmentFactory;
        }
        if (this.mParent != null) {
            return this.mParent.mFragmentManager.getFragmentFactory();
        }
        return this.mHostFragmentFactory;
    }

    void setSpecialEffectsControllerFactory(@NonNull SpecialEffectsControllerFactory specialEffectsControllerFactory) {
        this.mSpecialEffectsControllerFactory = specialEffectsControllerFactory;
    }

    @NonNull
    SpecialEffectsControllerFactory getSpecialEffectsControllerFactory() {
        if (this.mSpecialEffectsControllerFactory != null) {
            return this.mSpecialEffectsControllerFactory;
        }
        if (this.mParent != null) {
            return this.mParent.mFragmentManager.getSpecialEffectsControllerFactory();
        }
        return this.mDefaultSpecialEffectsControllerFactory;
    }

    @NonNull
    FragmentLifecycleCallbacksDispatcher getLifecycleCallbacksDispatcher() {
        return this.mLifecycleCallbacksDispatcher;
    }

    public void registerFragmentLifecycleCallbacks(@NonNull FragmentLifecycleCallbacks cb, boolean recursive) {
        this.mLifecycleCallbacksDispatcher.registerFragmentLifecycleCallbacks(cb, recursive);
    }

    public void unregisterFragmentLifecycleCallbacks(@NonNull FragmentLifecycleCallbacks cb) {
        this.mLifecycleCallbacksDispatcher.unregisterFragmentLifecycleCallbacks(cb);
    }

    public void addFragmentOnAttachListener(@NonNull FragmentOnAttachListener listener2) {
        this.mOnAttachListeners.add(listener2);
    }

    void dispatchOnAttachFragment(@NonNull Fragment fragment) {
        for (FragmentOnAttachListener listener2 : this.mOnAttachListeners) {
            listener2.onAttachFragment(this, fragment);
        }
    }

    public void removeFragmentOnAttachListener(@NonNull FragmentOnAttachListener listener2) {
        this.mOnAttachListeners.remove(listener2);
    }

    void dispatchOnHiddenChanged() {
        for (Fragment fragment : this.mFragmentStore.getActiveFragments()) {
            if (fragment == null) continue;
            fragment.onHiddenChanged(fragment.isHidden());
            fragment.mChildFragmentManager.dispatchOnHiddenChanged();
        }
    }

    boolean checkForMenus() {
        boolean hasMenu = false;
        for (Fragment fragment : this.mFragmentStore.getActiveFragments()) {
            if (fragment != null) {
                hasMenu = this.isMenuAvailable(fragment);
            }
            if (!hasMenu) continue;
            return true;
        }
        return false;
    }

    private boolean isMenuAvailable(@NonNull Fragment f) {
        return f.mHasMenu && f.mMenuVisible || f.mChildFragmentManager.checkForMenus();
    }

    void invalidateMenuForFragment(@NonNull Fragment f) {
        if (f.mAdded && this.isMenuAvailable(f)) {
            this.mNeedMenuInvalidate = true;
        }
    }

    private boolean isParentAdded() {
        if (this.mParent == null) {
            return true;
        }
        return this.mParent.isAdded() && this.mParent.getParentFragmentManager().isParentAdded();
    }

    static int reverseTransit(int transit) {
        int rev = 0;
        switch (transit) {
            case 4097: {
                rev = 8194;
                break;
            }
            case 8194: {
                rev = 4097;
                break;
            }
            case 4099: {
                rev = 4099;
                break;
            }
            case 4100: {
                rev = 8197;
                break;
            }
            case 8197: {
                rev = 4100;
            }
        }
        return rev;
    }

    @NonNull
    LayoutInflater.Factory2 getLayoutInflaterFactory() {
        return this.mLayoutInflaterFactory;
    }

    @Nullable
    public FragmentStrictMode.Policy getStrictModePolicy() {
        return this.mStrictModePolicy;
    }

    public void setStrictModePolicy(@Nullable FragmentStrictMode.Policy policy) {
        this.mStrictModePolicy = policy;
    }

    public static interface OnBackStackChangedListener {
        @MainThread
        public void onBackStackChanged();

        @MainThread
        default public void onBackStackChangeStarted(@NonNull Fragment fragment, boolean pop) {
        }

        @MainThread
        default public void onBackStackChangeProgressed(@NonNull BackEventCompat backEventCompat) {
        }

        @MainThread
        default public void onBackStackChangeCommitted(@NonNull Fragment fragment, boolean pop) {
        }

        @MainThread
        default public void onBackStackChangeCancelled() {
        }
    }

    private class RestoreBackStackState
    implements OpGenerator {
        private final String mName;

        RestoreBackStackState(String name) {
            this.mName = name;
        }

        @Override
        public boolean generateOps(@NonNull ArrayList<BackStackRecord> records, @NonNull ArrayList<Boolean> isRecordPop) {
            return FragmentManager.this.restoreBackStackState(records, isRecordPop, this.mName);
        }
    }

    static interface OpGenerator {
        public boolean generateOps(@NonNull ArrayList<BackStackRecord> var1, @NonNull ArrayList<Boolean> var2);
    }

    private class SaveBackStackState
    implements OpGenerator {
        private final String mName;

        SaveBackStackState(String name) {
            this.mName = name;
        }

        @Override
        public boolean generateOps(@NonNull ArrayList<BackStackRecord> records, @NonNull ArrayList<Boolean> isRecordPop) {
            return FragmentManager.this.saveBackStackState(records, isRecordPop, this.mName);
        }
    }

    private class ClearBackStackState
    implements OpGenerator {
        private final String mName;

        ClearBackStackState(String name) {
            this.mName = name;
        }

        @Override
        public boolean generateOps(@NonNull ArrayList<BackStackRecord> records, @NonNull ArrayList<Boolean> isRecordPop) {
            return FragmentManager.this.clearBackStackState(records, isRecordPop, this.mName);
        }
    }

    private class PopBackStackState
    implements OpGenerator {
        final String mName;
        final int mId;
        final int mFlags;

        PopBackStackState(String name, int id2, int flags) {
            this.mName = name;
            this.mId = id2;
            this.mFlags = flags;
        }

        @Override
        public boolean generateOps(@NonNull ArrayList<BackStackRecord> records, @NonNull ArrayList<Boolean> isRecordPop) {
            FragmentManager childManager;
            if (FragmentManager.this.mPrimaryNav != null && this.mId < 0 && this.mName == null && (childManager = FragmentManager.this.mPrimaryNav.getChildFragmentManager()).popBackStackImmediate()) {
                return false;
            }
            return FragmentManager.this.popBackStackState(records, isRecordPop, this.mName, this.mId, this.mFlags);
        }
    }

    class PrepareBackStackTransitionState
    implements OpGenerator {
        PrepareBackStackTransitionState() {
        }

        @Override
        public boolean generateOps(@NonNull ArrayList<BackStackRecord> records, @NonNull ArrayList<Boolean> isRecordPop) {
            boolean result2 = FragmentManager.this.prepareBackStackState(records, isRecordPop);
            FragmentManager.this.mBackStarted = true;
            if (!FragmentManager.this.mBackStackChangeListeners.isEmpty() && records.size() > 0) {
                boolean isPop = isRecordPop.get(records.size() - 1);
                LinkedHashSet<Fragment> fragments = new LinkedHashSet<Fragment>();
                for (BackStackRecord record : records) {
                    fragments.addAll(FragmentManager.this.fragmentsFromRecord(record));
                }
                for (OnBackStackChangedListener listener2 : FragmentManager.this.mBackStackChangeListeners) {
                    for (Fragment fragment : fragments) {
                        listener2.onBackStackChangeStarted(fragment, isPop);
                    }
                }
            }
            return result2;
        }
    }

    public static interface BackStackEntry {
        public int getId();

        @Nullable
        public String getName();

        @Deprecated
        @StringRes
        public int getBreadCrumbTitleRes();

        @Deprecated
        @StringRes
        public int getBreadCrumbShortTitleRes();

        @Deprecated
        @Nullable
        public CharSequence getBreadCrumbTitle();

        @Deprecated
        @Nullable
        public CharSequence getBreadCrumbShortTitle();
    }

    private static class LifecycleAwareResultListener
    implements FragmentResultListener {
        private final Lifecycle mLifecycle;
        private final FragmentResultListener mListener;
        private final LifecycleEventObserver mObserver;

        LifecycleAwareResultListener(@NonNull Lifecycle lifecycle, @NonNull FragmentResultListener listener2, @NonNull LifecycleEventObserver observer2) {
            this.mLifecycle = lifecycle;
            this.mListener = listener2;
            this.mObserver = observer2;
        }

        public boolean isAtLeast(Lifecycle.State state) {
            return this.mLifecycle.getCurrentState().isAtLeast(state);
        }

        @Override
        public void onFragmentResult(@NonNull String requestKey, @NonNull Bundle result2) {
            this.mListener.onFragmentResult(requestKey, result2);
        }

        public void removeObserver() {
            this.mLifecycle.removeObserver(this.mObserver);
        }
    }

    static class FragmentIntentSenderContract
    extends ActivityResultContract<IntentSenderRequest, ActivityResult> {
        FragmentIntentSenderContract() {
        }

        @Override
        @NonNull
        public Intent createIntent(@NonNull Context context, IntentSenderRequest input) {
            Bundle activityOptions;
            Intent result2 = new Intent("androidx.activity.result.contract.action.INTENT_SENDER_REQUEST");
            Intent fillInIntent = input.getFillInIntent();
            if (fillInIntent != null && (activityOptions = fillInIntent.getBundleExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE")) != null) {
                result2.putExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE", activityOptions);
                fillInIntent.removeExtra("androidx.activity.result.contract.extra.ACTIVITY_OPTIONS_BUNDLE");
                if (fillInIntent.getBooleanExtra(FragmentManager.EXTRA_CREATED_FILLIN_INTENT, false)) {
                    input = new IntentSenderRequest.Builder(input.getIntentSender()).setFillInIntent(null).setFlags(input.getFlagsValues(), input.getFlagsMask()).build();
                }
            }
            result2.putExtra("androidx.activity.result.contract.extra.INTENT_SENDER_REQUEST", (Parcelable)input);
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)FragmentManager.TAG, (String)("CreateIntent created the following intent: " + result2));
            }
            return result2;
        }

        @Override
        @NonNull
        public ActivityResult parseResult(int resultCode, @Nullable Intent intent) {
            return new ActivityResult(resultCode, intent);
        }
    }

    @SuppressLint(value={"BanParcelableUsage"})
    static class LaunchedFragmentInfo
    implements Parcelable {
        String mWho;
        int mRequestCode;
        public static final Parcelable.Creator<LaunchedFragmentInfo> CREATOR = new Parcelable.Creator<LaunchedFragmentInfo>(){

            public LaunchedFragmentInfo createFromParcel(Parcel in) {
                return new LaunchedFragmentInfo(in);
            }

            public LaunchedFragmentInfo[] newArray(int size) {
                return new LaunchedFragmentInfo[size];
            }
        };

        LaunchedFragmentInfo(@NonNull String who, int requestCode) {
            this.mWho = who;
            this.mRequestCode = requestCode;
        }

        LaunchedFragmentInfo(@NonNull Parcel in) {
            this.mWho = in.readString();
            this.mRequestCode = in.readInt();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mWho);
            dest.writeInt(this.mRequestCode);
        }
    }

    public static abstract class FragmentLifecycleCallbacks {
        public void onFragmentPreAttached(@NonNull FragmentManager fm, @NonNull Fragment f, @NonNull Context context) {
        }

        public void onFragmentAttached(@NonNull FragmentManager fm, @NonNull Fragment f, @NonNull Context context) {
        }

        public void onFragmentPreCreated(@NonNull FragmentManager fm, @NonNull Fragment f, @Nullable Bundle savedInstanceState) {
        }

        public void onFragmentCreated(@NonNull FragmentManager fm, @NonNull Fragment f, @Nullable Bundle savedInstanceState) {
        }

        @Deprecated
        public void onFragmentActivityCreated(@NonNull FragmentManager fm, @NonNull Fragment f, @Nullable Bundle savedInstanceState) {
        }

        public void onFragmentViewCreated(@NonNull FragmentManager fm, @NonNull Fragment f, @NonNull View v, @Nullable Bundle savedInstanceState) {
        }

        public void onFragmentStarted(@NonNull FragmentManager fm, @NonNull Fragment f) {
        }

        public void onFragmentResumed(@NonNull FragmentManager fm, @NonNull Fragment f) {
        }

        public void onFragmentPaused(@NonNull FragmentManager fm, @NonNull Fragment f) {
        }

        public void onFragmentStopped(@NonNull FragmentManager fm, @NonNull Fragment f) {
        }

        public void onFragmentSaveInstanceState(@NonNull FragmentManager fm, @NonNull Fragment f, @NonNull Bundle outState) {
        }

        public void onFragmentViewDestroyed(@NonNull FragmentManager fm, @NonNull Fragment f) {
        }

        public void onFragmentDestroyed(@NonNull FragmentManager fm, @NonNull Fragment f) {
        }

        public void onFragmentDetached(@NonNull FragmentManager fm, @NonNull Fragment f) {
        }
    }
}

