/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.activity.BackEventCompat;
import androidx.annotation.CallSuper;
import androidx.fragment.R;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentStateManager;
import androidx.fragment.app.SpecialEffectsControllerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\b \u0018\u0000 52\u00020\u0001:\u00045678B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0015\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b\u0011J#\u0010\u0012\u001a\u00020\u000f2\u0011\u0010\u0013\u001a\r\u0012\t\u0012\u00070\f\u00a2\u0006\u0002\b\u00150\u00142\u0006\u0010\u0016\u001a\u00020\bH&J \u0010\u0017\u001a\u00020\u000f2\u0011\u0010\u0013\u001a\r\u0012\t\u0012\u00070\f\u00a2\u0006\u0002\b\u00150\u0014H\u0010\u00a2\u0006\u0002\b\u0018J\u0006\u0010\u0019\u001a\u00020\u000fJ \u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010!\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010\"\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010#\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010$\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010%\u001a\u00020\u000fJ\u0012\u0010&\u001a\u0004\u0018\u00010\f2\u0006\u0010'\u001a\u00020(H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\f2\u0006\u0010'\u001a\u00020(H\u0002J\u0006\u0010*\u001a\u00020\u000fJ\u0006\u0010+\u001a\u00020\u000fJ\u0010\u0010,\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010-\u001a\u00020\bJ\u0006\u0010.\u001a\u00020\u000fJ\u000e\u0010/\u001a\u00020\u000f2\u0006\u00100\u001a\u000201J\u001b\u00102\u001a\u00020\u000f2\u0011\u0010\u0013\u001a\r\u0012\t\u0012\u00070\f\u00a2\u0006\u0002\b\u00150\u0014H\u0002J\b\u00103\u001a\u00020\u000fH\u0002J\u000e\u00104\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Landroidx/fragment/app/SpecialEffectsController;", "", "container", "Landroid/view/ViewGroup;", "(Landroid/view/ViewGroup;)V", "getContainer", "()Landroid/view/ViewGroup;", "isContainerPostponed", "", "operationDirectionIsPop", "pendingOperations", "", "Landroidx/fragment/app/SpecialEffectsController$Operation;", "runningOperations", "applyContainerChangesToOperation", "", "operation", "applyContainerChangesToOperation$fragment_release", "collectEffects", "operations", "", "Lkotlin/jvm/JvmSuppressWildcards;", "isPop", "commitEffects", "commitEffects$fragment_release", "completeBack", "enqueue", "finalState", "Landroidx/fragment/app/SpecialEffectsController$Operation$State;", "lifecycleImpact", "Landroidx/fragment/app/SpecialEffectsController$Operation$LifecycleImpact;", "fragmentStateManager", "Landroidx/fragment/app/FragmentStateManager;", "enqueueAdd", "enqueueHide", "enqueueRemove", "enqueueShow", "executePendingOperations", "findPendingOperation", "fragment", "Landroidx/fragment/app/Fragment;", "findRunningOperation", "forceCompleteAllOperations", "forcePostponedExecutePendingOperations", "getAwaitingCompletionLifecycleImpact", "isPendingExecute", "markPostponedState", "processProgress", "backEvent", "Landroidx/activity/BackEventCompat;", "processStart", "updateFinalState", "updateOperationDirection", "Companion", "Effect", "FragmentStateManagerOperation", "Operation", "fragment_release"})
@SourceDebugExtension(value={"SMAP\nSpecialEffectsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecialEffectsController.kt\nandroidx/fragment/app/SpecialEffectsController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,882:1\n288#2,2:883\n288#2,2:885\n533#2,6:887\n1855#2:893\n1726#2,3:894\n1856#2:897\n1360#2:898\n1446#2,5:899\n1360#2:904\n1446#2,5:905\n1360#2:910\n1446#2,5:911\n1360#2:916\n1446#2,5:917\n*S KotlinDebug\n*F\n+ 1 SpecialEffectsController.kt\nandroidx/fragment/app/SpecialEffectsController\n*L\n66#1:883,2\n72#1:885,2\n169#1:887,6\n269#1:893\n271#1:894,3\n269#1:897\n278#1:898\n278#1:899,5\n395#1:904\n395#1:905,5\n423#1:910\n423#1:911,5\n439#1:916\n439#1:917,5\n*E\n"})
public abstract class SpecialEffectsController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ViewGroup container;
    @NotNull
    private final List<Operation> pendingOperations;
    @NotNull
    private final List<Operation> runningOperations;
    private boolean operationDirectionIsPop;
    private boolean isContainerPostponed;

    public SpecialEffectsController(@NotNull ViewGroup container) {
        Intrinsics.checkNotNullParameter(container, "container");
        this.container = container;
        this.pendingOperations = new ArrayList();
        this.runningOperations = new ArrayList();
    }

    @NotNull
    public final ViewGroup getContainer() {
        return this.container;
    }

    @Nullable
    public final Operation.LifecycleImpact getAwaitingCompletionLifecycleImpact(@NotNull FragmentStateManager fragmentStateManager) {
        Operation.LifecycleImpact lifecycleImpact;
        Intrinsics.checkNotNullParameter(fragmentStateManager, "fragmentStateManager");
        Fragment fragment = fragmentStateManager.getFragment();
        Intrinsics.checkNotNullExpressionValue(fragment, "fragmentStateManager.fragment");
        Fragment fragment2 = fragment;
        Operation operation = this.findPendingOperation(fragment2);
        Operation.LifecycleImpact pendingLifecycleImpact = operation != null ? operation.getLifecycleImpact() : null;
        Operation operation2 = this.findRunningOperation(fragment2);
        Operation.LifecycleImpact runningLifecycleImpact = operation2 != null ? operation2.getLifecycleImpact() : null;
        Operation.LifecycleImpact lifecycleImpact2 = pendingLifecycleImpact;
        switch (lifecycleImpact2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[lifecycleImpact2.ordinal()]) {
            case -1: {
                lifecycleImpact = runningLifecycleImpact;
                break;
            }
            case 1: {
                lifecycleImpact = runningLifecycleImpact;
                break;
            }
            default: {
                lifecycleImpact = pendingLifecycleImpact;
            }
        }
        return lifecycleImpact;
    }

    private final Operation findPendingOperation(Fragment fragment) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.pendingOperations;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Operation operation = (Operation)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual(operation.getFragment(), fragment) && !operation.isCanceled())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final Operation findRunningOperation(Fragment fragment) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.runningOperations;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Operation operation = (Operation)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual(operation.getFragment(), fragment) && !operation.isCanceled())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final void enqueueAdd(@NotNull Operation.State finalState, @NotNull FragmentStateManager fragmentStateManager) {
        Intrinsics.checkNotNullParameter((Object)finalState, "finalState");
        Intrinsics.checkNotNullParameter(fragmentStateManager, "fragmentStateManager");
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Enqueuing add operation for fragment " + fragmentStateManager.getFragment()));
        }
        this.enqueue(finalState, Operation.LifecycleImpact.ADDING, fragmentStateManager);
    }

    public final void enqueueShow(@NotNull FragmentStateManager fragmentStateManager) {
        Intrinsics.checkNotNullParameter(fragmentStateManager, "fragmentStateManager");
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Enqueuing show operation for fragment " + fragmentStateManager.getFragment()));
        }
        this.enqueue(Operation.State.VISIBLE, Operation.LifecycleImpact.NONE, fragmentStateManager);
    }

    public final void enqueueHide(@NotNull FragmentStateManager fragmentStateManager) {
        Intrinsics.checkNotNullParameter(fragmentStateManager, "fragmentStateManager");
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Enqueuing hide operation for fragment " + fragmentStateManager.getFragment()));
        }
        this.enqueue(Operation.State.GONE, Operation.LifecycleImpact.NONE, fragmentStateManager);
    }

    public final void enqueueRemove(@NotNull FragmentStateManager fragmentStateManager) {
        Intrinsics.checkNotNullParameter(fragmentStateManager, "fragmentStateManager");
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Enqueuing remove operation for fragment " + fragmentStateManager.getFragment()));
        }
        this.enqueue(Operation.State.REMOVED, Operation.LifecycleImpact.REMOVING, fragmentStateManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void enqueue(Operation.State finalState, Operation.LifecycleImpact lifecycleImpact, FragmentStateManager fragmentStateManager) {
        List<Operation> list = this.pendingOperations;
        synchronized (list) {
            Operation existingOperation;
            boolean bl = false;
            Fragment fragment = fragmentStateManager.getFragment();
            Intrinsics.checkNotNullExpressionValue(fragment, "fragmentStateManager.fragment");
            Operation operation = this.findPendingOperation(fragment);
            if (operation == null) {
                if (fragmentStateManager.getFragment().mTransitioning) {
                    Fragment fragment2 = fragmentStateManager.getFragment();
                    Intrinsics.checkNotNullExpressionValue(fragment2, "fragmentStateManager.fragment");
                    operation = this.findRunningOperation(fragment2);
                } else {
                    operation = null;
                }
            }
            if ((existingOperation = operation) != null) {
                existingOperation.mergeWith(finalState, lifecycleImpact);
                return;
            }
            FragmentStateManagerOperation operation2 = new FragmentStateManagerOperation(finalState, lifecycleImpact, fragmentStateManager);
            this.pendingOperations.add(operation2);
            operation2.addCompletionListener(() -> SpecialEffectsController.enqueue$lambda$4$lambda$2(this, operation2));
            operation2.addCompletionListener(() -> SpecialEffectsController.enqueue$lambda$4$lambda$3(this, operation2));
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void updateOperationDirection(boolean isPop) {
        this.operationDirectionIsPop = isPop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void markPostponedState() {
        List<Operation> list = this.pendingOperations;
        synchronized (list) {
            Fragment lastEnteringFragment;
            Operation operation;
            block4: {
                boolean bl = false;
                this.updateFinalState();
                List<Operation> $this$lastOrNull$iv = this.pendingOperations;
                boolean $i$f$lastOrNull = false;
                ListIterator<Operation> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Operation element$iv;
                    Operation operation2 = element$iv = iterator$iv.previous();
                    boolean bl2 = false;
                    View view = operation2.getFragment().mView;
                    Intrinsics.checkNotNullExpressionValue(view, "operation.fragment.mView");
                    Operation.State currentState = Operation.State.Companion.asOperationState(view);
                    boolean bl3 = operation2.getFinalState() == Operation.State.VISIBLE && currentState != Operation.State.VISIBLE;
                    if (!bl3) continue;
                    operation = element$iv;
                    break block4;
                }
                operation = null;
            }
            Operation operation3 = operation;
            Fragment fragment = lastEnteringFragment = operation3 != null ? operation3.getFragment() : null;
            this.isContainerPostponed = fragment != null ? fragment.isPostponed() : false;
            Unit unit = Unit.INSTANCE;
        }
    }

    public final boolean isPendingExecute() {
        return !((Collection)this.pendingOperations).isEmpty();
    }

    public final void forcePostponedExecutePendingOperations() {
        if (this.isContainerPostponed) {
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)"FragmentManager", (String)"SpecialEffectsController: Forcing postponed operations");
            }
            this.isContainerPostponed = false;
            this.executePendingOperations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Iterators could be improved
     * Unable to fully structure code
     */
    public final void executePendingOperations() {
        if (this.isContainerPostponed) {
            return;
        }
        if (!this.container.isAttachedToWindow()) {
            this.forceCompleteAllOperations();
            this.operationDirectionIsPop = false;
            return;
        }
        var1_1 = this.pendingOperations;
        synchronized (var1_1) {
            block27: {
                block26: {
                    $i$a$-synchronized-SpecialEffectsController$executePendingOperations$1 = false;
                    if (!this.pendingOperations.isEmpty()) break block26;
                    currentlyRunningOperations = CollectionsKt.toMutableList((Collection)this.runningOperations);
                    this.runningOperations.clear();
                    for (Operation operation : currentlyRunningOperations) {
                        if (FragmentManager.isLoggingEnabled(2)) {
                            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Cancelling operation " + operation + " with no incoming pendingOperations"));
                        }
                        operation.cancel(this.container, false);
                        if (operation.isComplete()) continue;
                        this.runningOperations.add(operation);
                    }
                    break block27;
                }
                currentlyRunningOperations = CollectionsKt.toMutableList((Collection)this.runningOperations);
                this.runningOperations.clear();
                for (Operation operation : currentlyRunningOperations) {
                    if (FragmentManager.isLoggingEnabled(2)) {
                        Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Cancelling operation " + operation));
                    }
                    operation.cancel(this.container, operation.getFragment().mTransitioning);
                    if (operation.isComplete()) continue;
                    this.runningOperations.add(operation);
                }
                this.updateFinalState();
                newPendingOperations = CollectionsKt.toMutableList((Collection)this.pendingOperations);
                if (newPendingOperations.isEmpty()) {
                    return;
                }
                this.pendingOperations.clear();
                this.runningOperations.addAll((Collection<Operation>)newPendingOperations);
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)"SpecialEffectsController: Executing pending operations");
                }
                this.collectEffects(newPendingOperations, this.operationDirectionIsPop);
                seekable = new Ref.BooleanRef();
                seekable.element = true;
                transitioning = false;
                transitioning = true;
                $this$forEach$iv = newPendingOperations;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    block25: {
                        operation = (Operation)element$iv;
                        $i$a$-forEach-SpecialEffectsController$executePendingOperations$1$1 = false;
                        v0 = seekable;
                        if (!(((Collection)operation.getEffects$fragment_release()).isEmpty() == false)) ** GOTO lbl-1000
                        var13_21 = operation.getEffects$fragment_release();
                        var14_22 = v0;
                        $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            v1 = true;
                        } else {
                            for (T element$iv : $this$all$iv) {
                                effect = (Effect)element$iv;
                                $i$a$-all-SpecialEffectsController$executePendingOperations$1$1$1 = false;
                                if (effect.isSeekingSupported()) continue;
                                v1 = false;
                                break block25;
                            }
                            v1 = true;
                        }
                    }
                    var20_28 = v1;
                    v0 = var14_22;
                    if (var20_28) {
                        v2 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v2 = v0.element = false;
                    }
                    if (operation.getFragment().mTransitioning) continue;
                    transitioning = false;
                }
                v3 = seekable;
                if (!seekable.element) ** GOTO lbl-1000
                $this$forEach$iv = newPendingOperations;
                var21_29 = v3;
                $i$f$flatMap = false;
                var9_15 = $this$flatMap$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$flatMapTo = false;
                for (T element$iv$iv : $this$flatMapTo$iv$iv) {
                    it = (Operation)element$iv$iv;
                    $i$a$-flatMap-SpecialEffectsController$executePendingOperations$1$2 = false;
                    list$iv$iv = it.getEffects$fragment_release();
                    CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
                }
                v3 = var21_29;
                if (((Collection)((List)destination$iv$iv)).isEmpty() == false) {
                    v4 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v4 = v3.element = false;
                }
                if (!transitioning) {
                    this.processStart(newPendingOperations);
                    this.commitEffects$fragment_release(newPendingOperations);
                } else if (seekable.element) {
                    this.processStart(newPendingOperations);
                    var8_14 = newPendingOperations.size();
                    for (i = 0; i < var8_14; ++i) {
                        operation = newPendingOperations.get(i);
                        this.applyContainerChangesToOperation$fragment_release(operation);
                    }
                }
                this.operationDirectionIsPop = false;
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)"SpecialEffectsController: Finished executing pending operations");
                }
            }
            var2_3 = Unit.INSTANCE;
        }
    }

    public final void applyContainerChangesToOperation$fragment_release(@NotNull Operation operation) {
        Intrinsics.checkNotNullParameter(operation, "operation");
        if (operation.isAwaitingContainerChanges()) {
            Operation.State state = operation.getFinalState();
            View view = operation.getFragment().requireView();
            Intrinsics.checkNotNullExpressionValue(view, "operation.fragment.requireView()");
            state.applyState(view, this.container);
            operation.setAwaitingContainerChanges(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forceCompleteAllOperations() {
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)"FragmentManager", (String)"SpecialEffectsController: Forcing all operations to complete");
        }
        boolean attachedToWindow = this.container.isAttachedToWindow();
        List<Operation> list = this.pendingOperations;
        synchronized (list) {
            boolean bl = false;
            this.updateFinalState();
            this.processStart(this.pendingOperations);
            List<Operation> runningOperations = CollectionsKt.toMutableList((Collection)this.runningOperations);
            for (Operation operation : runningOperations) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    String notAttachedMessage = attachedToWindow ? "" : "Container " + this.container + " is not attached to window. ";
                    Log.v((String)"FragmentManager", (String)("SpecialEffectsController: " + notAttachedMessage + "Cancelling running operation " + operation));
                }
                operation.cancel(this.container);
            }
            List<Operation> pendingOperations = CollectionsKt.toMutableList((Collection)this.pendingOperations);
            for (Operation operation : pendingOperations) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    String notAttachedMessage = attachedToWindow ? "" : "Container " + this.container + " is not attached to window. ";
                    Log.v((String)"FragmentManager", (String)("SpecialEffectsController: " + notAttachedMessage + "Cancelling pending operation " + operation));
                }
                operation.cancel(this.container);
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void updateFinalState() {
        for (Operation operation : this.pendingOperations) {
            View view;
            if (operation.getLifecycleImpact() != Operation.LifecycleImpact.ADDING) continue;
            Fragment fragment = operation.getFragment();
            Intrinsics.checkNotNullExpressionValue(fragment.requireView(), "fragment.requireView()");
            Operation.State finalState = Operation.State.Companion.from(view.getVisibility());
            operation.mergeWith(finalState, Operation.LifecycleImpact.NONE);
        }
    }

    public abstract void collectEffects(@NotNull List<Operation> var1, boolean var2);

    /*
     * WARNING - void declaration
     */
    public void commitEffects$fragment_release(@NotNull List<Operation> operations) {
        int i;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(operations, "operations");
        Iterable $this$flatMap$iv = operations;
        int $i$f$flatMap = 0;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Operation it = (Operation)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getEffects$fragment_release();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List set = CollectionsKt.toList(CollectionsKt.toSet((List)destination$iv$iv));
        $i$f$flatMap = set.size();
        for (i = 0; i < $i$f$flatMap; ++i) {
            Effect effect = (Effect)set.get(i);
            effect.onCommit(this.container);
        }
        $i$f$flatMap = operations.size();
        for (i = 0; i < $i$f$flatMap; ++i) {
            Operation operation = operations.get(i);
            this.applyContainerChangesToOperation$fragment_release(operation);
        }
        List operationsCopy = CollectionsKt.toList((Iterable)operations);
        int n = operationsCopy.size();
        for (int i2 = 0; i2 < n; ++i2) {
            Operation operation = (Operation)operationsCopy.get(i2);
            if (!operation.getEffects$fragment_release().isEmpty()) continue;
            operation.complete$fragment_release();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void processStart(List<Operation> operations) {
        void $this$flatMapTo$iv$iv;
        int n = operations.size();
        for (int i = 0; i < n; ++i) {
            Operation operation = operations.get(i);
            operation.onStart();
        }
        Iterable $this$flatMap$iv = operations;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Operation it = (Operation)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getEffects$fragment_release();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List set = CollectionsKt.toList(CollectionsKt.toSet((List)destination$iv$iv));
        int n2 = set.size();
        for (int j = 0; j < n2; ++j) {
            Effect effect = (Effect)set.get(j);
            effect.performStart(this.container);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void processProgress(@NotNull BackEventCompat backEvent) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter(backEvent, "backEvent");
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Processing Progress " + backEvent.getProgress()));
        }
        Iterable $this$flatMap$iv = this.runningOperations;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Operation it = (Operation)element$iv$iv;
            boolean bl = false;
            Iterable list$iv$iv = it.getEffects$fragment_release();
            CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
        }
        List set = CollectionsKt.toList(CollectionsKt.toSet((List)destination$iv$iv));
        int n = set.size();
        for (int j = 0; j < n; ++j) {
            Effect effect = (Effect)set.get(j);
            effect.onProgress(backEvent, this.container);
        }
    }

    public final void completeBack() {
        if (FragmentManager.isLoggingEnabled(3)) {
            Log.d((String)"FragmentManager", (String)"SpecialEffectsController: Completing Back ");
        }
        this.processStart(this.runningOperations);
        this.commitEffects$fragment_release(this.runningOperations);
    }

    private static final void enqueue$lambda$4$lambda$2(SpecialEffectsController this$0, FragmentStateManagerOperation $operation) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($operation, "$operation");
        if (this$0.pendingOperations.contains($operation)) {
            Operation.State state = $operation.getFinalState();
            View view = $operation.getFragment().mView;
            Intrinsics.checkNotNullExpressionValue(view, "operation.fragment.mView");
            state.applyState(view, this$0.container);
        }
    }

    private static final void enqueue$lambda$4$lambda$3(SpecialEffectsController this$0, FragmentStateManagerOperation $operation) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($operation, "$operation");
        this$0.pendingOperations.remove($operation);
        this$0.runningOperations.remove($operation);
    }

    @JvmStatic
    @NotNull
    public static final SpecialEffectsController getOrCreateController(@NotNull ViewGroup container, @NotNull FragmentManager fragmentManager) {
        return Companion.getOrCreateController(container, fragmentManager);
    }

    @JvmStatic
    @NotNull
    public static final SpecialEffectsController getOrCreateController(@NotNull ViewGroup container, @NotNull SpecialEffectsControllerFactory factory) {
        return Companion.getOrCreateController(container, factory);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Landroidx/fragment/app/SpecialEffectsController$Companion;", "", "()V", "getOrCreateController", "Landroidx/fragment/app/SpecialEffectsController;", "container", "Landroid/view/ViewGroup;", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "factory", "Landroidx/fragment/app/SpecialEffectsControllerFactory;", "fragment_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SpecialEffectsController getOrCreateController(@NotNull ViewGroup container, @NotNull FragmentManager fragmentManager) {
            Intrinsics.checkNotNullParameter(container, "container");
            Intrinsics.checkNotNullParameter(fragmentManager, "fragmentManager");
            SpecialEffectsControllerFactory specialEffectsControllerFactory = fragmentManager.getSpecialEffectsControllerFactory();
            Intrinsics.checkNotNullExpressionValue(specialEffectsControllerFactory, "fragmentManager.specialEffectsControllerFactory");
            SpecialEffectsControllerFactory factory = specialEffectsControllerFactory;
            return this.getOrCreateController(container, factory);
        }

        @JvmStatic
        @NotNull
        public final SpecialEffectsController getOrCreateController(@NotNull ViewGroup container, @NotNull SpecialEffectsControllerFactory factory) {
            Intrinsics.checkNotNullParameter(container, "container");
            Intrinsics.checkNotNullParameter(factory, "factory");
            Object controller = container.getTag(R.id.special_effects_controller_view_tag);
            if (controller instanceof SpecialEffectsController) {
                return (SpecialEffectsController)controller;
            }
            SpecialEffectsController specialEffectsController = factory.createController(container);
            Intrinsics.checkNotNullExpressionValue(specialEffectsController, "factory.createController(container)");
            SpecialEffectsController newController = specialEffectsController;
            container.setTag(R.id.special_effects_controller_view_tag, (Object)newController);
            return newController;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0010\u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u000e\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0004X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Landroidx/fragment/app/SpecialEffectsController$Effect;", "", "()V", "isCancelled", "", "isSeekingSupported", "()Z", "isStarted", "cancel", "", "container", "Landroid/view/ViewGroup;", "onCancel", "onCommit", "onProgress", "backEvent", "Landroidx/activity/BackEventCompat;", "onStart", "performStart", "fragment_release"})
    public static class Effect {
        private final boolean isSeekingSupported;
        private boolean isStarted;
        private boolean isCancelled;

        public boolean isSeekingSupported() {
            return this.isSeekingSupported;
        }

        public final void performStart(@NotNull ViewGroup container) {
            Intrinsics.checkNotNullParameter(container, "container");
            if (!this.isStarted) {
                this.onStart(container);
            }
            this.isStarted = true;
        }

        public void onStart(@NotNull ViewGroup container) {
            Intrinsics.checkNotNullParameter(container, "container");
        }

        public void onProgress(@NotNull BackEventCompat backEvent, @NotNull ViewGroup container) {
            Intrinsics.checkNotNullParameter(backEvent, "backEvent");
            Intrinsics.checkNotNullParameter(container, "container");
        }

        public void onCommit(@NotNull ViewGroup container) {
            Intrinsics.checkNotNullParameter(container, "container");
        }

        public final void cancel(@NotNull ViewGroup container) {
            Intrinsics.checkNotNullParameter(container, "container");
            if (!this.isCancelled) {
                this.onCancel(container);
            }
            this.isCancelled = true;
        }

        public void onCancel(@NotNull ViewGroup container) {
            Intrinsics.checkNotNullParameter(container, "container");
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\r\u0010\t\u001a\u00020\nH\u0010\u00a2\u0006\u0002\b\u000bJ\b\u0010\f\u001a\u00020\nH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Landroidx/fragment/app/SpecialEffectsController$FragmentStateManagerOperation;", "Landroidx/fragment/app/SpecialEffectsController$Operation;", "finalState", "Landroidx/fragment/app/SpecialEffectsController$Operation$State;", "lifecycleImpact", "Landroidx/fragment/app/SpecialEffectsController$Operation$LifecycleImpact;", "fragmentStateManager", "Landroidx/fragment/app/FragmentStateManager;", "(Landroidx/fragment/app/SpecialEffectsController$Operation$State;Landroidx/fragment/app/SpecialEffectsController$Operation$LifecycleImpact;Landroidx/fragment/app/FragmentStateManager;)V", "complete", "", "complete$fragment_release", "onStart", "fragment_release"})
    private static final class FragmentStateManagerOperation
    extends Operation {
        @NotNull
        private final FragmentStateManager fragmentStateManager;

        public FragmentStateManagerOperation(@NotNull Operation.State finalState, @NotNull Operation.LifecycleImpact lifecycleImpact, @NotNull FragmentStateManager fragmentStateManager) {
            Intrinsics.checkNotNullParameter((Object)finalState, "finalState");
            Intrinsics.checkNotNullParameter((Object)lifecycleImpact, "lifecycleImpact");
            Intrinsics.checkNotNullParameter(fragmentStateManager, "fragmentStateManager");
            Fragment fragment = fragmentStateManager.getFragment();
            Intrinsics.checkNotNullExpressionValue(fragment, "fragmentStateManager.fragment");
            super(finalState, lifecycleImpact, fragment);
            this.fragmentStateManager = fragmentStateManager;
        }

        @Override
        public void onStart() {
            if (this.isStarted()) {
                return;
            }
            super.onStart();
            if (this.getLifecycleImpact() == Operation.LifecycleImpact.ADDING) {
                Fragment fragment = this.fragmentStateManager.getFragment();
                Intrinsics.checkNotNullExpressionValue(fragment, "fragmentStateManager.fragment");
                Fragment fragment2 = fragment;
                View focusedView = fragment2.mView.findFocus();
                if (focusedView != null) {
                    fragment2.setFocusedView(focusedView);
                    if (FragmentManager.isLoggingEnabled(2)) {
                        Log.v((String)"FragmentManager", (String)("requestFocus: Saved focused view " + focusedView + " for Fragment " + fragment2));
                    }
                }
                View view = this.getFragment().requireView();
                Intrinsics.checkNotNullExpressionValue(view, "this.fragment.requireView()");
                View view2 = view;
                if (view2.getParent() == null) {
                    this.fragmentStateManager.addViewToContainer();
                    view2.setAlpha(0.0f);
                }
                if (view2.getAlpha() == 0.0f && view2.getVisibility() == 0) {
                    view2.setVisibility(4);
                }
                view2.setAlpha(fragment2.getPostOnViewCreatedAlpha());
            } else if (this.getLifecycleImpact() == Operation.LifecycleImpact.REMOVING) {
                Fragment fragment = this.fragmentStateManager.getFragment();
                Intrinsics.checkNotNullExpressionValue(fragment, "fragmentStateManager.fragment");
                Fragment fragment3 = fragment;
                View view = fragment3.requireView();
                Intrinsics.checkNotNullExpressionValue(view, "fragment.requireView()");
                View view3 = view;
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)("Clearing focus " + view3.findFocus() + " on view " + view3 + " for Fragment " + fragment3));
                }
                view3.clearFocus();
            }
        }

        @Override
        public void complete$fragment_release() {
            super.complete$fragment_release();
            this.getFragment().mTransitioning = false;
            this.fragmentStateManager.moveToExpectedState();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001:\u000267B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000e\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\rJ\u000e\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020\u000bJ\u000e\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020-J\u0016\u0010+\u001a\u00020'2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u0019J\r\u0010/\u001a\u00020'H\u0011\u00a2\u0006\u0002\b0J\u000e\u00101\u001a\u00020'2\u0006\u0010*\u001a\u00020\u000bJ\u0016\u00102\u001a\u00020'2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005J\b\u00103\u001a\u00020'H\u0017J\b\u00104\u001a\u000205H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001e\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001aR\u001e\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001aR\u001e\u0010 \u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001aR\u001e\u0010!\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0019@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001aR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u00068"}, d2={"Landroidx/fragment/app/SpecialEffectsController$Operation;", "", "finalState", "Landroidx/fragment/app/SpecialEffectsController$Operation$State;", "lifecycleImpact", "Landroidx/fragment/app/SpecialEffectsController$Operation$LifecycleImpact;", "fragment", "Landroidx/fragment/app/Fragment;", "(Landroidx/fragment/app/SpecialEffectsController$Operation$State;Landroidx/fragment/app/SpecialEffectsController$Operation$LifecycleImpact;Landroidx/fragment/app/Fragment;)V", "_effects", "", "Landroidx/fragment/app/SpecialEffectsController$Effect;", "completionListeners", "Ljava/lang/Runnable;", "effects", "", "getEffects$fragment_release", "()Ljava/util/List;", "getFinalState", "()Landroidx/fragment/app/SpecialEffectsController$Operation$State;", "setFinalState", "(Landroidx/fragment/app/SpecialEffectsController$Operation$State;)V", "getFragment", "()Landroidx/fragment/app/Fragment;", "isAwaitingContainerChanges", "", "()Z", "setAwaitingContainerChanges", "(Z)V", "<set-?>", "isCanceled", "isComplete", "isSeeking", "isStarted", "getLifecycleImpact", "()Landroidx/fragment/app/SpecialEffectsController$Operation$LifecycleImpact;", "setLifecycleImpact", "(Landroidx/fragment/app/SpecialEffectsController$Operation$LifecycleImpact;)V", "addCompletionListener", "", "listener", "addEffect", "effect", "cancel", "container", "Landroid/view/ViewGroup;", "withSeeking", "complete", "complete$fragment_release", "completeEffect", "mergeWith", "onStart", "toString", "", "LifecycleImpact", "State", "fragment_release"})
    @SourceDebugExtension(value={"SMAP\nSpecialEffectsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecialEffectsController.kt\nandroidx/fragment/app/SpecialEffectsController$Operation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,882:1\n1855#2,2:883\n1855#2,2:885\n*S KotlinDebug\n*F\n+ 1 SpecialEffectsController.kt\nandroidx/fragment/app/SpecialEffectsController$Operation\n*L\n643#1:883,2\n743#1:885,2\n*E\n"})
    public static class Operation {
        @NotNull
        private State finalState;
        @NotNull
        private LifecycleImpact lifecycleImpact;
        @NotNull
        private final Fragment fragment;
        @NotNull
        private final List<Runnable> completionListeners;
        private boolean isCanceled;
        private boolean isComplete;
        private boolean isSeeking;
        private boolean isStarted;
        private boolean isAwaitingContainerChanges;
        @NotNull
        private final List<Effect> _effects;
        @NotNull
        private final List<Effect> effects;

        public Operation(@NotNull State finalState, @NotNull LifecycleImpact lifecycleImpact, @NotNull Fragment fragment) {
            Intrinsics.checkNotNullParameter((Object)finalState, "finalState");
            Intrinsics.checkNotNullParameter((Object)lifecycleImpact, "lifecycleImpact");
            Intrinsics.checkNotNullParameter(fragment, "fragment");
            this.finalState = finalState;
            this.lifecycleImpact = lifecycleImpact;
            this.fragment = fragment;
            this.completionListeners = new ArrayList();
            this.isAwaitingContainerChanges = true;
            this._effects = new ArrayList();
            this.effects = this._effects;
        }

        @NotNull
        public final State getFinalState() {
            return this.finalState;
        }

        public final void setFinalState(@NotNull State state) {
            Intrinsics.checkNotNullParameter((Object)state, "<set-?>");
            this.finalState = state;
        }

        @NotNull
        public final LifecycleImpact getLifecycleImpact() {
            return this.lifecycleImpact;
        }

        public final void setLifecycleImpact(@NotNull LifecycleImpact lifecycleImpact) {
            Intrinsics.checkNotNullParameter((Object)lifecycleImpact, "<set-?>");
            this.lifecycleImpact = lifecycleImpact;
        }

        @NotNull
        public final Fragment getFragment() {
            return this.fragment;
        }

        public final boolean isCanceled() {
            return this.isCanceled;
        }

        public final boolean isComplete() {
            return this.isComplete;
        }

        public final boolean isSeeking() {
            return this.isSeeking;
        }

        public final boolean isStarted() {
            return this.isStarted;
        }

        public final boolean isAwaitingContainerChanges() {
            return this.isAwaitingContainerChanges;
        }

        public final void setAwaitingContainerChanges(boolean bl) {
            this.isAwaitingContainerChanges = bl;
        }

        @NotNull
        public final List<Effect> getEffects$fragment_release() {
            return this.effects;
        }

        @NotNull
        public String toString() {
            String identityHash = Integer.toHexString(System.identityHashCode(this));
            return "Operation {" + identityHash + "} {finalState = " + (Object)((Object)this.finalState) + " lifecycleImpact = " + (Object)((Object)this.lifecycleImpact) + " fragment = " + this.fragment + '}';
        }

        public final void cancel(@NotNull ViewGroup container) {
            Intrinsics.checkNotNullParameter(container, "container");
            this.isStarted = false;
            if (this.isCanceled) {
                return;
            }
            this.isCanceled = true;
            if (this._effects.isEmpty()) {
                this.complete$fragment_release();
            } else {
                Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.effects);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Effect it = (Effect)element$iv;
                    boolean bl = false;
                    it.cancel(container);
                }
            }
        }

        public final void cancel(@NotNull ViewGroup container, boolean withSeeking) {
            Intrinsics.checkNotNullParameter(container, "container");
            if (this.isCanceled) {
                return;
            }
            if (withSeeking) {
                this.isSeeking = true;
            }
            this.cancel(container);
        }

        public final void mergeWith(@NotNull State finalState, @NotNull LifecycleImpact lifecycleImpact) {
            Intrinsics.checkNotNullParameter((Object)finalState, "finalState");
            Intrinsics.checkNotNullParameter((Object)lifecycleImpact, "lifecycleImpact");
            switch (WhenMappings.$EnumSwitchMapping$0[lifecycleImpact.ordinal()]) {
                case 1: {
                    if (this.finalState != State.REMOVED) break;
                    if (FragmentManager.isLoggingEnabled(2)) {
                        Log.v((String)"FragmentManager", (String)("SpecialEffectsController: For fragment " + this.fragment + " mFinalState = REMOVED -> VISIBLE. mLifecycleImpact = " + (Object)((Object)this.lifecycleImpact) + " to ADDING."));
                    }
                    this.finalState = State.VISIBLE;
                    this.lifecycleImpact = LifecycleImpact.ADDING;
                    this.isAwaitingContainerChanges = true;
                    break;
                }
                case 2: {
                    if (FragmentManager.isLoggingEnabled(2)) {
                        Log.v((String)"FragmentManager", (String)("SpecialEffectsController: For fragment " + this.fragment + " mFinalState = " + (Object)((Object)this.finalState) + " -> REMOVED. mLifecycleImpact  = " + (Object)((Object)this.lifecycleImpact) + " to REMOVING."));
                    }
                    this.finalState = State.REMOVED;
                    this.lifecycleImpact = LifecycleImpact.REMOVING;
                    this.isAwaitingContainerChanges = true;
                    break;
                }
                case 3: {
                    if (this.finalState == State.REMOVED) break;
                    if (FragmentManager.isLoggingEnabled(2)) {
                        Log.v((String)"FragmentManager", (String)("SpecialEffectsController: For fragment " + this.fragment + " mFinalState = " + (Object)((Object)this.finalState) + " -> " + (Object)((Object)finalState) + '.'));
                    }
                    this.finalState = finalState;
                }
            }
        }

        public final void addCompletionListener(@NotNull Runnable listener2) {
            Intrinsics.checkNotNullParameter(listener2, "listener");
            this.completionListeners.add(listener2);
        }

        public final void addEffect(@NotNull Effect effect) {
            Intrinsics.checkNotNullParameter(effect, "effect");
            this._effects.add(effect);
        }

        public final void completeEffect(@NotNull Effect effect) {
            Intrinsics.checkNotNullParameter(effect, "effect");
            if (this._effects.remove(effect) && this._effects.isEmpty()) {
                this.complete$fragment_release();
            }
        }

        @CallSuper
        public void onStart() {
            this.isStarted = true;
        }

        @CallSuper
        public void complete$fragment_release() {
            this.isStarted = false;
            if (this.isComplete) {
                return;
            }
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)"FragmentManager", (String)("SpecialEffectsController: " + this + " has called complete."));
            }
            this.isComplete = true;
            Iterable $this$forEach$iv = this.completionListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Runnable listener2 = (Runnable)element$iv;
                boolean bl = false;
                listener2.run();
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Landroidx/fragment/app/SpecialEffectsController$Operation$LifecycleImpact;", "", "(Ljava/lang/String;I)V", "NONE", "ADDING", "REMOVING", "fragment_release"})
        public static final class LifecycleImpact
        extends Enum<LifecycleImpact> {
            public static final /* enum */ LifecycleImpact NONE = new LifecycleImpact();
            public static final /* enum */ LifecycleImpact ADDING = new LifecycleImpact();
            public static final /* enum */ LifecycleImpact REMOVING = new LifecycleImpact();
            private static final /* synthetic */ LifecycleImpact[] $VALUES;

            public static LifecycleImpact[] values() {
                return (LifecycleImpact[])$VALUES.clone();
            }

            public static LifecycleImpact valueOf(String value) {
                return Enum.valueOf(LifecycleImpact.class, value);
            }

            static {
                $VALUES = lifecycleImpactArray = new LifecycleImpact[]{LifecycleImpact.NONE, LifecycleImpact.ADDING, LifecycleImpact.REMOVING};
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0080\u0001\u0018\u0000 \r2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\u000e"}, d2={"Landroidx/fragment/app/SpecialEffectsController$Operation$State;", "", "(Ljava/lang/String;I)V", "applyState", "", "view", "Landroid/view/View;", "container", "Landroid/view/ViewGroup;", "REMOVED", "VISIBLE", "GONE", "INVISIBLE", "Companion", "fragment_release"})
        public static final class State
        extends Enum<State> {
            @NotNull
            public static final Companion Companion;
            public static final /* enum */ State REMOVED;
            public static final /* enum */ State VISIBLE;
            public static final /* enum */ State GONE;
            public static final /* enum */ State INVISIBLE;
            private static final /* synthetic */ State[] $VALUES;

            public final void applyState(@NotNull View view, @NotNull ViewGroup container) {
                Intrinsics.checkNotNullParameter(view, "view");
                Intrinsics.checkNotNullParameter(container, "container");
                switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                    case 1: {
                        ViewGroup parent;
                        ViewParent viewParent = view.getParent();
                        ViewGroup viewGroup = parent = viewParent instanceof ViewGroup ? (ViewGroup)viewParent : null;
                        if (parent == null) break;
                        if (FragmentManager.isLoggingEnabled(2)) {
                            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Removing view " + view + " from container " + parent));
                        }
                        parent.removeView(view);
                        break;
                    }
                    case 2: {
                        ViewParent viewParent;
                        ViewGroup parent;
                        if (FragmentManager.isLoggingEnabled(2)) {
                            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Setting view " + view + " to VISIBLE"));
                        }
                        ViewGroup viewGroup = parent = (viewParent = view.getParent()) instanceof ViewGroup ? (ViewGroup)viewParent : null;
                        if (parent == null) {
                            if (FragmentManager.isLoggingEnabled(2)) {
                                Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Adding view " + view + " to Container " + container));
                            }
                            container.addView(view);
                        }
                        view.setVisibility(0);
                        break;
                    }
                    case 3: {
                        if (FragmentManager.isLoggingEnabled(2)) {
                            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Setting view " + view + " to GONE"));
                        }
                        view.setVisibility(8);
                        break;
                    }
                    case 4: {
                        if (FragmentManager.isLoggingEnabled(2)) {
                            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Setting view " + view + " to INVISIBLE"));
                        }
                        view.setVisibility(4);
                    }
                }
            }

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            @JvmStatic
            @NotNull
            public static final State from(int visibility) {
                return Companion.from(visibility);
            }

            static {
                REMOVED = new State();
                VISIBLE = new State();
                GONE = new State();
                INVISIBLE = new State();
                $VALUES = stateArray = new State[]{State.REMOVED, State.VISIBLE, State.GONE, State.INVISIBLE};
                Companion = new Companion(null);
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\n\u0010\u0007\u001a\u00020\u0004*\u00020\b\u00a8\u0006\t"}, d2={"Landroidx/fragment/app/SpecialEffectsController$Operation$State$Companion;", "", "()V", "from", "Landroidx/fragment/app/SpecialEffectsController$Operation$State;", "visibility", "", "asOperationState", "Landroid/view/View;", "fragment_release"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final State asOperationState(@NotNull View $this$asOperationState) {
                    Intrinsics.checkNotNullParameter($this$asOperationState, "<this>");
                    return $this$asOperationState.getAlpha() == 0.0f && $this$asOperationState.getVisibility() == 0 ? INVISIBLE : this.from($this$asOperationState.getVisibility());
                }

                @JvmStatic
                @NotNull
                public final State from(int visibility) {
                    State state;
                    switch (visibility) {
                        case 0: {
                            state = VISIBLE;
                            break;
                        }
                        case 4: {
                            state = INVISIBLE;
                            break;
                        }
                        case 8: {
                            state = GONE;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown visibility " + visibility);
                        }
                    }
                    return state;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }

            @Metadata(mv={1, 8, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[State.values().length];
                    try {
                        nArray[State.REMOVED.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[State.VISIBLE.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[State.GONE.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[State.INVISIBLE.ordinal()] = 4;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LifecycleImpact.values().length];
                try {
                    nArray[LifecycleImpact.ADDING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LifecycleImpact.REMOVING.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LifecycleImpact.NONE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Operation.LifecycleImpact.values().length];
            try {
                nArray[Operation.LifecycleImpact.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

