/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.executor.ArchTaskExecutor;
import androidx.arch.core.internal.SafeIterableMap;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.Observer;
import java.util.Map;

public abstract class LiveData<T> {
    final Object mDataLock = new Object();
    static final int START_VERSION = -1;
    static final Object NOT_SET = new Object();
    private SafeIterableMap<Observer<? super T>, ObserverWrapper> mObservers = new SafeIterableMap();
    int mActiveCount = 0;
    private boolean mChangingActiveState;
    private volatile Object mData;
    volatile Object mPendingData = NOT_SET;
    private int mVersion;
    private boolean mDispatchingValue;
    private boolean mDispatchInvalidated;
    private final Runnable mPostValueRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object newValue;
            Object object = LiveData.this.mDataLock;
            synchronized (object) {
                newValue = LiveData.this.mPendingData;
                LiveData.this.mPendingData = NOT_SET;
            }
            LiveData.this.setValue(newValue);
        }
    };

    public LiveData(T value) {
        this.mData = value;
        this.mVersion = 0;
    }

    public LiveData() {
        this.mData = NOT_SET;
        this.mVersion = -1;
    }

    private void considerNotify(ObserverWrapper observer2) {
        if (!observer2.mActive) {
            return;
        }
        if (!observer2.shouldBeActive()) {
            observer2.activeStateChanged(false);
            return;
        }
        if (observer2.mLastVersion >= this.mVersion) {
            return;
        }
        observer2.mLastVersion = this.mVersion;
        observer2.mObserver.onChanged(this.mData);
    }

    void dispatchingValue(@Nullable ObserverWrapper initiator) {
        if (this.mDispatchingValue) {
            this.mDispatchInvalidated = true;
            return;
        }
        this.mDispatchingValue = true;
        do {
            this.mDispatchInvalidated = false;
            if (initiator != null) {
                this.considerNotify(initiator);
                initiator = null;
                continue;
            }
            SafeIterableMap.IteratorWithAdditions iterator2 = this.mObservers.iteratorWithAdditions();
            while (iterator2.hasNext()) {
                this.considerNotify((ObserverWrapper)((Map.Entry)iterator2.next()).getValue());
                if (!this.mDispatchInvalidated) continue;
            }
        } while (this.mDispatchInvalidated);
        this.mDispatchingValue = false;
    }

    @MainThread
    public void observe(@NonNull LifecycleOwner owner2, @NonNull Observer<? super T> observer2) {
        LiveData.assertMainThread("observe");
        if (owner2.getLifecycle().getCurrentState() == Lifecycle.State.DESTROYED) {
            return;
        }
        LifecycleBoundObserver wrapper = new LifecycleBoundObserver(owner2, observer2);
        ObserverWrapper existing = this.mObservers.putIfAbsent(observer2, wrapper);
        if (existing != null && !existing.isAttachedTo(owner2)) {
            throw new IllegalArgumentException("Cannot add the same observer with different lifecycles");
        }
        if (existing != null) {
            return;
        }
        owner2.getLifecycle().addObserver(wrapper);
    }

    @MainThread
    public void observeForever(@NonNull Observer<? super T> observer2) {
        LiveData.assertMainThread("observeForever");
        AlwaysActiveObserver wrapper = new AlwaysActiveObserver(observer2);
        ObserverWrapper existing = this.mObservers.putIfAbsent(observer2, wrapper);
        if (existing instanceof LifecycleBoundObserver) {
            throw new IllegalArgumentException("Cannot add the same observer with different lifecycles");
        }
        if (existing != null) {
            return;
        }
        wrapper.activeStateChanged(true);
    }

    @MainThread
    public void removeObserver(@NonNull Observer<? super T> observer2) {
        LiveData.assertMainThread("removeObserver");
        ObserverWrapper removed = this.mObservers.remove(observer2);
        if (removed == null) {
            return;
        }
        removed.detachObserver();
        removed.activeStateChanged(false);
    }

    @MainThread
    public void removeObservers(@NonNull LifecycleOwner owner2) {
        LiveData.assertMainThread("removeObservers");
        for (Map.Entry<Observer<T>, ObserverWrapper> entry : this.mObservers) {
            if (!entry.getValue().isAttachedTo(owner2)) continue;
            this.removeObserver(entry.getKey());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void postValue(T value) {
        boolean postTask;
        Object object = this.mDataLock;
        synchronized (object) {
            postTask = this.mPendingData == NOT_SET;
            this.mPendingData = value;
        }
        if (!postTask) {
            return;
        }
        ArchTaskExecutor.getInstance().postToMainThread(this.mPostValueRunnable);
    }

    @MainThread
    protected void setValue(T value) {
        LiveData.assertMainThread("setValue");
        ++this.mVersion;
        this.mData = value;
        this.dispatchingValue(null);
    }

    @Nullable
    public T getValue() {
        Object data = this.mData;
        if (data != NOT_SET) {
            return (T)data;
        }
        return null;
    }

    public boolean isInitialized() {
        return this.mData != NOT_SET;
    }

    int getVersion() {
        return this.mVersion;
    }

    protected void onActive() {
    }

    protected void onInactive() {
    }

    public boolean hasObservers() {
        return this.mObservers.size() > 0;
    }

    public boolean hasActiveObservers() {
        return this.mActiveCount > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    void changeActiveCounter(int change) {
        int previousActiveCount = this.mActiveCount;
        this.mActiveCount += change;
        if (this.mChangingActiveState) {
            return;
        }
        this.mChangingActiveState = true;
        try {
            while (previousActiveCount != this.mActiveCount) {
                boolean needToCallActive = previousActiveCount == 0 && this.mActiveCount > 0;
                boolean needToCallInactive = previousActiveCount > 0 && this.mActiveCount == 0;
                previousActiveCount = this.mActiveCount;
                if (needToCallActive) {
                    this.onActive();
                    continue;
                }
                if (!needToCallInactive) continue;
                this.onInactive();
            }
        }
        finally {
            this.mChangingActiveState = false;
        }
    }

    static void assertMainThread(String methodName) {
        if (!ArchTaskExecutor.getInstance().isMainThread()) {
            throw new IllegalStateException("Cannot invoke " + methodName + " on a background thread");
        }
    }

    private abstract class ObserverWrapper {
        final Observer<? super T> mObserver;
        boolean mActive;
        int mLastVersion = -1;

        ObserverWrapper(Observer<? super T> observer2) {
            this.mObserver = observer2;
        }

        abstract boolean shouldBeActive();

        boolean isAttachedTo(LifecycleOwner owner2) {
            return false;
        }

        void detachObserver() {
        }

        void activeStateChanged(boolean newActive) {
            if (newActive == this.mActive) {
                return;
            }
            this.mActive = newActive;
            LiveData.this.changeActiveCounter(this.mActive ? 1 : -1);
            if (this.mActive) {
                LiveData.this.dispatchingValue(this);
            }
        }
    }

    class LifecycleBoundObserver
    extends ObserverWrapper
    implements LifecycleEventObserver {
        @NonNull
        final LifecycleOwner mOwner;

        LifecycleBoundObserver(LifecycleOwner owner2, Observer<? super T> observer2) {
            super(observer2);
            this.mOwner = owner2;
        }

        @Override
        boolean shouldBeActive() {
            return this.mOwner.getLifecycle().getCurrentState().isAtLeast(Lifecycle.State.STARTED);
        }

        @Override
        public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
            Lifecycle.State currentState = this.mOwner.getLifecycle().getCurrentState();
            if (currentState == Lifecycle.State.DESTROYED) {
                LiveData.this.removeObserver(this.mObserver);
                return;
            }
            Lifecycle.State prevState = null;
            while (prevState != currentState) {
                prevState = currentState;
                this.activeStateChanged(this.shouldBeActive());
                currentState = this.mOwner.getLifecycle().getCurrentState();
            }
        }

        @Override
        boolean isAttachedTo(LifecycleOwner owner2) {
            return this.mOwner == owner2;
        }

        @Override
        void detachObserver() {
            this.mOwner.getLifecycle().removeObserver(this);
        }
    }

    private class AlwaysActiveObserver
    extends ObserverWrapper {
        AlwaysActiveObserver(Observer<? super T> observer2) {
            super(observer2);
        }

        @Override
        boolean shouldBeActive() {
            return true;
        }
    }
}

