/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.annotation.CallSuper;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.internal.SafeIterableMap;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import java.util.Map;

public class MediatorLiveData<T>
extends MutableLiveData<T> {
    private SafeIterableMap<LiveData<?>, Source<?>> mSources = new SafeIterableMap();

    public MediatorLiveData() {
    }

    public MediatorLiveData(T value) {
        super(value);
    }

    @MainThread
    public <S> void addSource(@NonNull LiveData<S> source, @NonNull Observer<? super S> onChanged2) {
        if (source == null) {
            throw new NullPointerException("source cannot be null");
        }
        Source<S> e = new Source<S>(source, onChanged2);
        Source<? super S> existing = this.mSources.putIfAbsent(source, e);
        if (existing != null && existing.mObserver != onChanged2) {
            throw new IllegalArgumentException("This source was already added with the different observer");
        }
        if (existing != null) {
            return;
        }
        if (this.hasActiveObservers()) {
            e.plug();
        }
    }

    @MainThread
    public <S> void removeSource(@NonNull LiveData<S> toRemote) {
        Source<?> source = this.mSources.remove(toRemote);
        if (source != null) {
            source.unplug();
        }
    }

    @Override
    @CallSuper
    protected void onActive() {
        for (Map.Entry<LiveData<?>, Source<?>> entry : this.mSources) {
            entry.getValue().plug();
        }
    }

    @Override
    @CallSuper
    protected void onInactive() {
        for (Map.Entry<LiveData<?>, Source<?>> entry : this.mSources) {
            entry.getValue().unplug();
        }
    }

    private static class Source<V>
    implements Observer<V> {
        final LiveData<V> mLiveData;
        final Observer<? super V> mObserver;
        int mVersion = -1;

        Source(LiveData<V> liveData, Observer<? super V> observer2) {
            this.mLiveData = liveData;
            this.mObserver = observer2;
        }

        void plug() {
            this.mLiveData.observeForever(this);
        }

        void unplug() {
            this.mLiveData.removeObserver(this);
        }

        @Override
        public void onChanged(@Nullable V v) {
            if (this.mVersion != this.mLiveData.getVersion()) {
                this.mVersion = this.mLiveData.getVersion();
                this.mObserver.onChanged(v);
            }
        }
    }
}

