/*
 * Decompiled with CFR 0.152.
 */
package androidx.loader.app;

import android.os.Bundle;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.SparseArrayCompat;
import androidx.core.util.DebugUtils;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStore;
import androidx.loader.app.LoaderManager;
import androidx.loader.content.Loader;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.reflect.Modifier;

class LoaderManagerImpl
extends LoaderManager {
    static final String TAG = "LoaderManager";
    static boolean DEBUG = false;
    @NonNull
    private final LifecycleOwner mLifecycleOwner;
    @NonNull
    private final LoaderViewModel mLoaderViewModel;

    LoaderManagerImpl(@NonNull LifecycleOwner lifecycleOwner, @NonNull ViewModelStore viewModelStore) {
        this.mLifecycleOwner = lifecycleOwner;
        this.mLoaderViewModel = LoaderViewModel.getInstance(viewModelStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @MainThread
    @NonNull
    private <D> Loader<D> createAndInstallLoader(int id2, @Nullable Bundle args2, @NonNull LoaderManager.LoaderCallbacks<D> callback2, @Nullable Loader<D> priorLoader) {
        LoaderInfo<D> info;
        try {
            this.mLoaderViewModel.startCreatingLoader();
            Loader<D> loader = callback2.onCreateLoader(id2, args2);
            if (loader == null) {
                throw new IllegalArgumentException("Object returned from onCreateLoader must not be null");
            }
            if (loader.getClass().isMemberClass() && !Modifier.isStatic(loader.getClass().getModifiers())) {
                throw new IllegalArgumentException("Object returned from onCreateLoader must not be a non-static inner member class: " + loader);
            }
            info = new LoaderInfo<D>(id2, args2, loader, priorLoader);
            if (DEBUG) {
                Log.v((String)TAG, (String)("  Created new loader " + info));
            }
            this.mLoaderViewModel.putLoader(id2, info);
        }
        finally {
            this.mLoaderViewModel.finishCreatingLoader();
        }
        return info.setCallback(this.mLifecycleOwner, callback2);
    }

    @Override
    @MainThread
    @NonNull
    public <D> Loader<D> initLoader(int id2, @Nullable Bundle args2, @NonNull LoaderManager.LoaderCallbacks<D> callback2) {
        if (this.mLoaderViewModel.isCreatingLoader()) {
            throw new IllegalStateException("Called while creating a loader");
        }
        if (Looper.getMainLooper() != Looper.myLooper()) {
            throw new IllegalStateException("initLoader must be called on the main thread");
        }
        LoaderInfo<D> info = this.mLoaderViewModel.getLoader(id2);
        if (DEBUG) {
            Log.v((String)TAG, (String)("initLoader in " + this + ": args=" + args2));
        }
        if (info == null) {
            return this.createAndInstallLoader(id2, args2, callback2, null);
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("  Re-using existing loader " + info));
        }
        return info.setCallback(this.mLifecycleOwner, callback2);
    }

    @Override
    @MainThread
    @NonNull
    public <D> Loader<D> restartLoader(int id2, @Nullable Bundle args2, @NonNull LoaderManager.LoaderCallbacks<D> callback2) {
        if (this.mLoaderViewModel.isCreatingLoader()) {
            throw new IllegalStateException("Called while creating a loader");
        }
        if (Looper.getMainLooper() != Looper.myLooper()) {
            throw new IllegalStateException("restartLoader must be called on the main thread");
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("restartLoader in " + this + ": args=" + args2));
        }
        LoaderInfo info = this.mLoaderViewModel.getLoader(id2);
        Loader priorLoader = null;
        if (info != null) {
            priorLoader = info.destroy(false);
        }
        return this.createAndInstallLoader(id2, args2, callback2, priorLoader);
    }

    @Override
    @MainThread
    public void destroyLoader(int id2) {
        LoaderInfo info;
        if (this.mLoaderViewModel.isCreatingLoader()) {
            throw new IllegalStateException("Called while creating a loader");
        }
        if (Looper.getMainLooper() != Looper.myLooper()) {
            throw new IllegalStateException("destroyLoader must be called on the main thread");
        }
        if (DEBUG) {
            Log.v((String)TAG, (String)("destroyLoader in " + this + " of " + id2));
        }
        if ((info = this.mLoaderViewModel.getLoader(id2)) != null) {
            info.destroy(true);
            this.mLoaderViewModel.removeLoader(id2);
        }
    }

    @Override
    @Nullable
    public <D> Loader<D> getLoader(int id2) {
        if (this.mLoaderViewModel.isCreatingLoader()) {
            throw new IllegalStateException("Called while creating a loader");
        }
        LoaderInfo info = this.mLoaderViewModel.getLoader(id2);
        return info != null ? info.getLoader() : null;
    }

    @Override
    public void markForRedelivery() {
        this.mLoaderViewModel.markForRedelivery();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        sb.append("LoaderManager{");
        sb.append(Integer.toHexString(System.identityHashCode(this)));
        sb.append(" in ");
        DebugUtils.buildShortClassTag(this.mLifecycleOwner, sb);
        sb.append("}}");
        return sb.toString();
    }

    @Override
    @Deprecated
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args2) {
        this.mLoaderViewModel.dump(prefix, fd, writer, args2);
    }

    @Override
    public boolean hasRunningLoaders() {
        return this.mLoaderViewModel.hasRunningLoaders();
    }

    static class LoaderViewModel
    extends ViewModel {
        private static final ViewModelProvider.Factory FACTORY = new ViewModelProvider.Factory(){

            @Override
            @NonNull
            public <T extends ViewModel> T create(@NonNull Class<T> modelClass) {
                return (T)new LoaderViewModel();
            }
        };
        private SparseArrayCompat<LoaderInfo> mLoaders = new SparseArrayCompat();
        private boolean mCreatingLoader = false;

        LoaderViewModel() {
        }

        @NonNull
        static LoaderViewModel getInstance(ViewModelStore viewModelStore) {
            return new ViewModelProvider(viewModelStore, FACTORY).get(LoaderViewModel.class);
        }

        void startCreatingLoader() {
            this.mCreatingLoader = true;
        }

        boolean isCreatingLoader() {
            return this.mCreatingLoader;
        }

        void finishCreatingLoader() {
            this.mCreatingLoader = false;
        }

        void putLoader(int id2, @NonNull LoaderInfo info) {
            this.mLoaders.put(id2, info);
        }

        <D> LoaderInfo<D> getLoader(int id2) {
            return this.mLoaders.get(id2);
        }

        void removeLoader(int id2) {
            this.mLoaders.remove(id2);
        }

        boolean hasRunningLoaders() {
            int size = this.mLoaders.size();
            for (int index = 0; index < size; ++index) {
                LoaderInfo info = this.mLoaders.valueAt(index);
                if (!info.isCallbackWaitingForData()) continue;
                return true;
            }
            return false;
        }

        void markForRedelivery() {
            int size = this.mLoaders.size();
            for (int index = 0; index < size; ++index) {
                LoaderInfo info = this.mLoaders.valueAt(index);
                info.markForRedelivery();
            }
        }

        @Override
        protected void onCleared() {
            super.onCleared();
            int size = this.mLoaders.size();
            for (int index = 0; index < size; ++index) {
                LoaderInfo info = this.mLoaders.valueAt(index);
                info.destroy(true);
            }
            this.mLoaders.clear();
        }

        public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args2) {
            if (this.mLoaders.size() > 0) {
                writer.print(prefix);
                writer.println("Loaders:");
                String innerPrefix = prefix + "    ";
                for (int i = 0; i < this.mLoaders.size(); ++i) {
                    LoaderInfo info = this.mLoaders.valueAt(i);
                    writer.print(prefix);
                    writer.print("  #");
                    writer.print(this.mLoaders.keyAt(i));
                    writer.print(": ");
                    writer.println(info.toString());
                    info.dump(innerPrefix, fd, writer, args2);
                }
            }
        }
    }

    static class LoaderObserver<D>
    implements Observer<D> {
        @NonNull
        private final Loader<D> mLoader;
        @NonNull
        private final LoaderManager.LoaderCallbacks<D> mCallback;
        private boolean mDeliveredData = false;

        LoaderObserver(@NonNull Loader<D> loader, @NonNull LoaderManager.LoaderCallbacks<D> callback2) {
            this.mLoader = loader;
            this.mCallback = callback2;
        }

        @Override
        public void onChanged(@Nullable D data) {
            if (DEBUG) {
                Log.v((String)LoaderManagerImpl.TAG, (String)("  onLoadFinished in " + this.mLoader + ": " + this.mLoader.dataToString(data)));
            }
            this.mCallback.onLoadFinished(this.mLoader, data);
            this.mDeliveredData = true;
        }

        boolean hasDeliveredData() {
            return this.mDeliveredData;
        }

        @MainThread
        void reset() {
            if (this.mDeliveredData) {
                if (DEBUG) {
                    Log.v((String)LoaderManagerImpl.TAG, (String)("  Resetting: " + this.mLoader));
                }
                this.mCallback.onLoaderReset(this.mLoader);
            }
        }

        public String toString() {
            return this.mCallback.toString();
        }

        public void dump(String prefix, PrintWriter writer) {
            writer.print(prefix);
            writer.print("mDeliveredData=");
            writer.println(this.mDeliveredData);
        }
    }

    public static class LoaderInfo<D>
    extends MutableLiveData<D>
    implements Loader.OnLoadCompleteListener<D> {
        private final int mId;
        @Nullable
        private final Bundle mArgs;
        @NonNull
        private final Loader<D> mLoader;
        private LifecycleOwner mLifecycleOwner;
        private LoaderObserver<D> mObserver;
        private Loader<D> mPriorLoader;

        LoaderInfo(int id2, @Nullable Bundle args2, @NonNull Loader<D> loader, @Nullable Loader<D> priorLoader) {
            this.mId = id2;
            this.mArgs = args2;
            this.mLoader = loader;
            this.mPriorLoader = priorLoader;
            this.mLoader.registerListener(id2, this);
        }

        @NonNull
        Loader<D> getLoader() {
            return this.mLoader;
        }

        @Override
        protected void onActive() {
            if (DEBUG) {
                Log.v((String)LoaderManagerImpl.TAG, (String)("  Starting: " + this));
            }
            this.mLoader.startLoading();
        }

        @Override
        protected void onInactive() {
            if (DEBUG) {
                Log.v((String)LoaderManagerImpl.TAG, (String)("  Stopping: " + this));
            }
            this.mLoader.stopLoading();
        }

        @MainThread
        @NonNull
        Loader<D> setCallback(@NonNull LifecycleOwner owner2, @NonNull LoaderManager.LoaderCallbacks<D> callback2) {
            LoaderObserver<D> observer2 = new LoaderObserver<D>(this.mLoader, callback2);
            this.observe(owner2, observer2);
            if (this.mObserver != null) {
                this.removeObserver((Observer<? super D>)this.mObserver);
            }
            this.mLifecycleOwner = owner2;
            this.mObserver = observer2;
            return this.mLoader;
        }

        void markForRedelivery() {
            LifecycleOwner lifecycleOwner = this.mLifecycleOwner;
            LoaderObserver<D> observer2 = this.mObserver;
            if (lifecycleOwner != null && observer2 != null) {
                super.removeObserver(observer2);
                this.observe(lifecycleOwner, observer2);
            }
        }

        boolean isCallbackWaitingForData() {
            if (!this.hasActiveObservers()) {
                return false;
            }
            return this.mObserver != null && !this.mObserver.hasDeliveredData();
        }

        @Override
        public void removeObserver(@NonNull Observer<? super D> observer2) {
            super.removeObserver(observer2);
            this.mLifecycleOwner = null;
            this.mObserver = null;
        }

        @MainThread
        Loader<D> destroy(boolean reset) {
            if (DEBUG) {
                Log.v((String)LoaderManagerImpl.TAG, (String)("  Destroying: " + this));
            }
            this.mLoader.cancelLoad();
            this.mLoader.abandon();
            LoaderObserver<D> observer2 = this.mObserver;
            if (observer2 != null) {
                this.removeObserver((Observer<? super D>)observer2);
                if (reset) {
                    observer2.reset();
                }
            }
            this.mLoader.unregisterListener(this);
            if (observer2 != null && !observer2.hasDeliveredData() || reset) {
                this.mLoader.reset();
                return this.mPriorLoader;
            }
            return this.mLoader;
        }

        @Override
        public void onLoadComplete(@NonNull Loader<D> loader, @Nullable D data) {
            if (DEBUG) {
                Log.v((String)LoaderManagerImpl.TAG, (String)("onLoadComplete: " + this));
            }
            if (Looper.myLooper() == Looper.getMainLooper()) {
                this.setValue(data);
            } else {
                if (DEBUG) {
                    Log.w((String)LoaderManagerImpl.TAG, (String)"onLoadComplete was incorrectly called on a background thread");
                }
                this.postValue(data);
            }
        }

        @Override
        public void setValue(D value) {
            super.setValue(value);
            if (this.mPriorLoader != null) {
                this.mPriorLoader.reset();
                this.mPriorLoader = null;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(64);
            sb.append("LoaderInfo{");
            sb.append(Integer.toHexString(System.identityHashCode(this)));
            sb.append(" #");
            sb.append(this.mId);
            sb.append(" : ");
            DebugUtils.buildShortClassTag(this.mLoader, sb);
            sb.append("}}");
            return sb.toString();
        }

        public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args2) {
            writer.print(prefix);
            writer.print("mId=");
            writer.print(this.mId);
            writer.print(" mArgs=");
            writer.println(this.mArgs);
            writer.print(prefix);
            writer.print("mLoader=");
            writer.println(this.mLoader);
            this.mLoader.dump(prefix + "  ", fd, writer, args2);
            if (this.mObserver != null) {
                writer.print(prefix);
                writer.print("mCallbacks=");
                writer.println(this.mObserver);
                this.mObserver.dump(prefix + "  ", writer);
            }
            writer.print(prefix);
            writer.print("mData=");
            writer.println(this.getLoader().dataToString(this.getValue()));
            writer.print(prefix);
            writer.print("mStarted=");
            writer.println(this.hasActiveObservers());
        }
    }
}

