/*
 * Decompiled with CFR 0.152.
 */
package androidx.loader.content;

import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.util.Log;
import androidx.annotation.RestrictTo;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

abstract class ModernAsyncTask<Params, Progress, Result> {
    private static final String LOG_TAG = "AsyncTask";
    private static final int CORE_POOL_SIZE = 5;
    private static final int MAXIMUM_POOL_SIZE = 128;
    private static final int KEEP_ALIVE = 1;
    private static final ThreadFactory sThreadFactory = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "ModernAsyncTask #" + this.mCount.getAndIncrement());
        }
    };
    private static final BlockingQueue<Runnable> sPoolWorkQueue = new LinkedBlockingQueue<Runnable>(10);
    public static final Executor THREAD_POOL_EXECUTOR;
    private static final int MESSAGE_POST_RESULT = 1;
    private static final int MESSAGE_POST_PROGRESS = 2;
    private static InternalHandler sHandler;
    private static volatile Executor sDefaultExecutor;
    private final WorkerRunnable<Params, Result> mWorker;
    private final FutureTask<Result> mFuture;
    private volatile Status mStatus = Status.PENDING;
    final AtomicBoolean mCancelled = new AtomicBoolean();
    final AtomicBoolean mTaskInvoked = new AtomicBoolean();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Handler getHandler() {
        Class<ModernAsyncTask> clazz = ModernAsyncTask.class;
        synchronized (ModernAsyncTask.class) {
            if (sHandler == null) {
                sHandler = new InternalHandler();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return sHandler;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static void setDefaultExecutor(Executor exec) {
        sDefaultExecutor = exec;
    }

    ModernAsyncTask() {
        this.mWorker = new WorkerRunnable<Params, Result>(){

            @Override
            public Result call() throws Exception {
                ModernAsyncTask.this.mTaskInvoked.set(true);
                Object result2 = null;
                try {
                    Process.setThreadPriority((int)10);
                    result2 = ModernAsyncTask.this.doInBackground(this.mParams);
                    Binder.flushPendingCommands();
                }
                catch (Throwable tr) {
                    ModernAsyncTask.this.mCancelled.set(true);
                    throw tr;
                }
                finally {
                    ModernAsyncTask.this.postResult(result2);
                }
                return result2;
            }
        };
        this.mFuture = new FutureTask<Result>(this.mWorker){

            @Override
            protected void done() {
                try {
                    Object result2 = this.get();
                    ModernAsyncTask.this.postResultIfNotInvoked(result2);
                }
                catch (InterruptedException e) {
                    Log.w((String)ModernAsyncTask.LOG_TAG, (Throwable)e);
                }
                catch (ExecutionException e) {
                    throw new RuntimeException("An error occurred while executing doInBackground()", e.getCause());
                }
                catch (CancellationException e) {
                    ModernAsyncTask.this.postResultIfNotInvoked(null);
                }
                catch (Throwable t) {
                    throw new RuntimeException("An error occurred while executing doInBackground()", t);
                }
            }
        };
    }

    void postResultIfNotInvoked(Result result2) {
        boolean wasTaskInvoked = this.mTaskInvoked.get();
        if (!wasTaskInvoked) {
            this.postResult(result2);
        }
    }

    Result postResult(Result result2) {
        Message message = ModernAsyncTask.getHandler().obtainMessage(1, new AsyncTaskResult<Object>(this, result2));
        message.sendToTarget();
        return result2;
    }

    public final Status getStatus() {
        return this.mStatus;
    }

    protected abstract Result doInBackground(Params ... var1);

    protected void onPreExecute() {
    }

    protected void onPostExecute(Result result2) {
    }

    protected void onProgressUpdate(Progress ... values2) {
    }

    protected void onCancelled(Result result2) {
        this.onCancelled();
    }

    protected void onCancelled() {
    }

    public final boolean isCancelled() {
        return this.mCancelled.get();
    }

    public final boolean cancel(boolean mayInterruptIfRunning) {
        this.mCancelled.set(true);
        return this.mFuture.cancel(mayInterruptIfRunning);
    }

    public final Result get() throws InterruptedException, ExecutionException {
        return this.mFuture.get();
    }

    public final Result get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.mFuture.get(timeout, unit);
    }

    public final ModernAsyncTask<Params, Progress, Result> execute(Params ... params) {
        return this.executeOnExecutor(sDefaultExecutor, params);
    }

    public final ModernAsyncTask<Params, Progress, Result> executeOnExecutor(Executor exec, Params ... params) {
        if (this.mStatus != Status.PENDING) {
            switch (this.mStatus) {
                case RUNNING: {
                    throw new IllegalStateException("Cannot execute task: the task is already running.");
                }
                case FINISHED: {
                    throw new IllegalStateException("Cannot execute task: the task has already been executed (a task can be executed only once)");
                }
            }
            throw new IllegalStateException("We should never reach this state");
        }
        this.mStatus = Status.RUNNING;
        this.onPreExecute();
        this.mWorker.mParams = params;
        exec.execute(this.mFuture);
        return this;
    }

    public static void execute(Runnable runnable2) {
        sDefaultExecutor.execute(runnable2);
    }

    protected final void publishProgress(Progress ... values2) {
        if (!this.isCancelled()) {
            ModernAsyncTask.getHandler().obtainMessage(2, new AsyncTaskResult<Progress>(this, values2)).sendToTarget();
        }
    }

    void finish(Result result2) {
        if (this.isCancelled()) {
            this.onCancelled(result2);
        } else {
            this.onPostExecute(result2);
        }
        this.mStatus = Status.FINISHED;
    }

    static {
        sDefaultExecutor = THREAD_POOL_EXECUTOR = new ThreadPoolExecutor(5, 128, 1L, TimeUnit.SECONDS, sPoolWorkQueue, sThreadFactory);
    }

    private static class AsyncTaskResult<Data> {
        final ModernAsyncTask mTask;
        final Data[] mData;

        AsyncTaskResult(ModernAsyncTask task, Data ... data) {
            this.mTask = task;
            this.mData = data;
        }
    }

    private static abstract class WorkerRunnable<Params, Result>
    implements Callable<Result> {
        Params[] mParams;

        WorkerRunnable() {
        }
    }

    private static class InternalHandler
    extends Handler {
        InternalHandler() {
            super(Looper.getMainLooper());
        }

        public void handleMessage(Message msg) {
            AsyncTaskResult result2 = (AsyncTaskResult)msg.obj;
            switch (msg.what) {
                case 1: {
                    result2.mTask.finish(result2.mData[0]);
                    break;
                }
                case 2: {
                    result2.mTask.onProgressUpdate(result2.mData);
                }
            }
        }
    }

    public static enum Status {
        PENDING,
        RUNNING,
        FINISHED;

    }
}

