/*
 * Decompiled with CFR 0.152.
 */
package androidx.profileinstaller;

import android.content.Context;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.profileinstaller.ProfileInstallReceiver;
import java.io.File;

class BenchmarkOperation {
    private BenchmarkOperation() {
    }

    static void dropShaderCache(@NonNull Context context, @NonNull ProfileInstallReceiver.ResultDiagnostics callback2) {
        File shaderDirectory = Build.VERSION.SDK_INT >= 24 ? Api24ContextHelper.getDeviceProtectedCodeCacheDir(context) : (Build.VERSION.SDK_INT >= 23 ? Api21ContextHelper.getCodeCacheDir(context) : context.getCacheDir());
        if (BenchmarkOperation.deleteFilesRecursively(shaderDirectory)) {
            callback2.onResultReceived(14, null);
        } else {
            callback2.onResultReceived(15, null);
        }
    }

    static boolean deleteFilesRecursively(File file) {
        if (file.isDirectory()) {
            File[] children2 = file.listFiles();
            if (children2 == null) {
                return false;
            }
            boolean success = true;
            for (File child : children2) {
                success = BenchmarkOperation.deleteFilesRecursively(child) && success;
            }
            return success;
        }
        file.delete();
        return true;
    }

    @RequiresApi(api=24)
    private static class Api24ContextHelper {
        private Api24ContextHelper() {
        }

        static File getDeviceProtectedCodeCacheDir(Context context) {
            return context.createDeviceProtectedStorageContext().getCodeCacheDir();
        }
    }

    @RequiresApi(api=21)
    private static class Api21ContextHelper {
        private Api21ContextHelper() {
        }

        static File getCodeCacheDir(Context context) {
            return context.getCodeCacheDir();
        }
    }
}

