/*
 * Decompiled with CFR 0.152.
 */
package androidx.profileinstaller;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.os.Build;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import androidx.profileinstaller.DeviceProfileWriter;
import androidx.profileinstaller.ProfileVerifier;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.concurrent.Executor;

public class ProfileInstaller {
    private static final String TAG = "ProfileInstaller";
    private static final String PROFILE_BASE_DIR = "/data/misc/profiles/cur/0";
    private static final String PROFILE_FILE = "primary.prof";
    private static final String PROFILE_SOURCE_LOCATION = "dexopt/baseline.prof";
    private static final String PROFILE_META_LOCATION = "dexopt/baseline.profm";
    private static final String PROFILE_INSTALLER_SKIP_FILE_NAME = "profileinstaller_profileWrittenFor_lastUpdateTime.dat";
    private static final DiagnosticsCallback EMPTY_DIAGNOSTICS = new DiagnosticsCallback(){

        @Override
        public void onDiagnosticReceived(int code, @Nullable Object data) {
        }

        @Override
        public void onResultReceived(int code, @Nullable Object data) {
        }
    };
    @NonNull
    static final DiagnosticsCallback LOG_DIAGNOSTICS = new DiagnosticsCallback(){
        static final String TAG = "ProfileInstaller";

        @Override
        public void onDiagnosticReceived(int code, @Nullable Object data) {
            String msg = "";
            switch (code) {
                case 1: {
                    msg = "DIAGNOSTIC_CURRENT_PROFILE_EXISTS";
                    break;
                }
                case 2: {
                    msg = "DIAGNOSTIC_CURRENT_PROFILE_DOES_NOT_EXIST";
                    break;
                }
                case 3: {
                    msg = "DIAGNOSTIC_REF_PROFILE_EXISTS";
                    break;
                }
                case 4: {
                    msg = "DIAGNOSTIC_REF_PROFILE_DOES_NOT_EXIST";
                    break;
                }
                case 5: {
                    msg = "DIAGNOSTIC_PROFILE_IS_COMPRESSED";
                }
            }
            Log.d((String)"ProfileInstaller", (String)msg);
        }

        @Override
        public void onResultReceived(int code, @Nullable Object data) {
            String msg = "";
            switch (code) {
                case 1: {
                    msg = "RESULT_INSTALL_SUCCESS";
                    break;
                }
                case 2: {
                    msg = "RESULT_ALREADY_INSTALLED";
                    break;
                }
                case 3: {
                    msg = "RESULT_UNSUPPORTED_ART_VERSION";
                    break;
                }
                case 4: {
                    msg = "RESULT_NOT_WRITABLE";
                    break;
                }
                case 5: {
                    msg = "RESULT_DESIRED_FORMAT_UNSUPPORTED";
                    break;
                }
                case 6: {
                    msg = "RESULT_BASELINE_PROFILE_NOT_FOUND";
                    break;
                }
                case 7: {
                    msg = "RESULT_IO_EXCEPTION";
                    break;
                }
                case 8: {
                    msg = "RESULT_PARSE_EXCEPTION";
                    break;
                }
                case 10: {
                    msg = "RESULT_INSTALL_SKIP_FILE_SUCCESS";
                    break;
                }
                case 11: {
                    msg = "RESULT_DELETE_SKIP_FILE_SUCCESS";
                }
            }
            switch (code) {
                case 6: 
                case 7: 
                case 8: {
                    Log.e((String)"ProfileInstaller", (String)msg, (Throwable)((Throwable)data));
                    break;
                }
                default: {
                    Log.d((String)"ProfileInstaller", (String)msg);
                }
            }
        }
    };
    public static final int DIAGNOSTIC_CURRENT_PROFILE_EXISTS = 1;
    public static final int DIAGNOSTIC_CURRENT_PROFILE_DOES_NOT_EXIST = 2;
    public static final int DIAGNOSTIC_REF_PROFILE_EXISTS = 3;
    public static final int DIAGNOSTIC_REF_PROFILE_DOES_NOT_EXIST = 4;
    public static final int DIAGNOSTIC_PROFILE_IS_COMPRESSED = 5;
    public static final int RESULT_INSTALL_SUCCESS = 1;
    public static final int RESULT_ALREADY_INSTALLED = 2;
    public static final int RESULT_UNSUPPORTED_ART_VERSION = 3;
    public static final int RESULT_NOT_WRITABLE = 4;
    public static final int RESULT_DESIRED_FORMAT_UNSUPPORTED = 5;
    public static final int RESULT_BASELINE_PROFILE_NOT_FOUND = 6;
    public static final int RESULT_IO_EXCEPTION = 7;
    public static final int RESULT_PARSE_EXCEPTION = 8;
    public static final int RESULT_META_FILE_REQUIRED_BUT_NOT_FOUND = 9;
    public static final int RESULT_INSTALL_SKIP_FILE_SUCCESS = 10;
    public static final int RESULT_DELETE_SKIP_FILE_SUCCESS = 11;
    public static final int RESULT_SAVE_PROFILE_SIGNALLED = 12;
    public static final int RESULT_SAVE_PROFILE_SKIPPED = 13;
    public static final int RESULT_BENCHMARK_OPERATION_SUCCESS = 14;
    public static final int RESULT_BENCHMARK_OPERATION_FAILURE = 15;
    public static final int RESULT_BENCHMARK_OPERATION_UNKNOWN = 16;

    private ProfileInstaller() {
    }

    static void result(@NonNull Executor executor, @NonNull DiagnosticsCallback diagnostics, int code, @Nullable Object data) {
        executor.execute(() -> diagnostics.onResultReceived(code, data));
    }

    static void diagnostic(@NonNull Executor executor, @NonNull DiagnosticsCallback diagnostics, int code, @Nullable Object data) {
        executor.execute(() -> diagnostics.onDiagnosticReceived(code, data));
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @WorkerThread
    static boolean hasAlreadyWrittenProfileForThisInstall(PackageInfo packageInfo, File appFilesDir, DiagnosticsCallback diagnostics) {
        boolean result2;
        long lastProfileWritePackageUpdateTime;
        File skipFile = new File(appFilesDir, PROFILE_INSTALLER_SKIP_FILE_NAME);
        if (!skipFile.exists()) {
            return false;
        }
        try (DataInputStream dataInputStream = new DataInputStream(new FileInputStream(skipFile));){
            lastProfileWritePackageUpdateTime = dataInputStream.readLong();
        }
        catch (IOException e) {
            return false;
        }
        boolean bl = result2 = lastProfileWritePackageUpdateTime == packageInfo.lastUpdateTime;
        if (result2) {
            diagnostics.onResultReceived(2, null);
        }
        return result2;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    static void noteProfileWrittenFor(@NonNull PackageInfo packageInfo, @NonNull File appFilesDir) {
        File skipFile = new File(appFilesDir, PROFILE_INSTALLER_SKIP_FILE_NAME);
        try (DataOutputStream os = new DataOutputStream(new FileOutputStream(skipFile));){
            os.writeLong(packageInfo.lastUpdateTime);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    static boolean deleteProfileWrittenFor(@NonNull File appFilesDir) {
        File skipFile = new File(appFilesDir, PROFILE_INSTALLER_SKIP_FILE_NAME);
        return skipFile.delete();
    }

    private static boolean transcodeAndWrite(@NonNull AssetManager assets, @NonNull String packageName, @NonNull PackageInfo packageInfo, @NonNull File filesDir, @NonNull String apkName, @NonNull Executor executor, @NonNull DiagnosticsCallback diagnostics) {
        if (Build.VERSION.SDK_INT < 19) {
            ProfileInstaller.result(executor, diagnostics, 3, null);
            return false;
        }
        File curProfile = new File(new File(PROFILE_BASE_DIR, packageName), PROFILE_FILE);
        DeviceProfileWriter deviceProfileWriter = new DeviceProfileWriter(assets, executor, diagnostics, apkName, PROFILE_SOURCE_LOCATION, PROFILE_META_LOCATION, curProfile);
        if (!deviceProfileWriter.deviceAllowsProfileInstallerAotWrites()) {
            return false;
        }
        boolean success = deviceProfileWriter.read().transcodeIfNeeded().write();
        if (success) {
            ProfileInstaller.noteProfileWrittenFor(packageInfo, filesDir);
        }
        return success;
    }

    @WorkerThread
    public static void writeProfile(@NonNull Context context) {
        ProfileInstaller.writeProfile(context, Runnable::run, EMPTY_DIAGNOSTICS);
    }

    @WorkerThread
    public static void writeProfile(@NonNull Context context, @NonNull Executor executor, @NonNull DiagnosticsCallback diagnostics) {
        ProfileInstaller.writeProfile(context, executor, diagnostics, false);
    }

    @WorkerThread
    static void writeProfile(@NonNull Context context, @NonNull Executor executor, @NonNull DiagnosticsCallback diagnostics, boolean forceWriteProfile) {
        PackageInfo packageInfo;
        Context appContext = context.getApplicationContext();
        String packageName = appContext.getPackageName();
        ApplicationInfo appInfo = appContext.getApplicationInfo();
        AssetManager assetManager = appContext.getAssets();
        String apkName = new File(appInfo.sourceDir).getName();
        PackageManager packageManager = context.getPackageManager();
        try {
            packageInfo = packageManager.getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            diagnostics.onResultReceived(7, (Object)e);
            ProfileVerifier.writeProfileVerification(context, false);
            return;
        }
        File filesDir = context.getFilesDir();
        if (forceWriteProfile || !ProfileInstaller.hasAlreadyWrittenProfileForThisInstall(packageInfo, filesDir, diagnostics)) {
            Log.d((String)TAG, (String)("Installing profile for " + context.getPackageName()));
            boolean profileWritten = ProfileInstaller.transcodeAndWrite(assetManager, packageName, packageInfo, filesDir, apkName, executor, diagnostics);
            ProfileVerifier.writeProfileVerification(context, profileWritten && forceWriteProfile);
        } else {
            Log.d((String)TAG, (String)("Skipping profile installation for " + context.getPackageName()));
            ProfileVerifier.writeProfileVerification(context, false);
        }
    }

    @WorkerThread
    static void writeSkipFile(@NonNull Context context, @NonNull Executor executor, @NonNull DiagnosticsCallback diagnostics) {
        PackageInfo packageInfo;
        Context appContext = context.getApplicationContext();
        String packageName = appContext.getPackageName();
        PackageManager packageManager = context.getPackageManager();
        try {
            packageInfo = packageManager.getPackageInfo(packageName, 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            ProfileInstaller.result(executor, diagnostics, 7, (Object)e);
            return;
        }
        File filesDir = context.getFilesDir();
        ProfileInstaller.noteProfileWrittenFor(packageInfo, filesDir);
        ProfileInstaller.result(executor, diagnostics, 10, null);
    }

    @WorkerThread
    static void deleteSkipFile(@NonNull Context context, @NonNull Executor executor, @NonNull DiagnosticsCallback diagnostics) {
        File filesDir = context.getFilesDir();
        ProfileInstaller.deleteProfileWrittenFor(filesDir);
        ProfileInstaller.result(executor, diagnostics, 11, null);
    }

    public static interface DiagnosticsCallback {
        public void onDiagnosticReceived(int var1, @Nullable Object var2);

        public void onResultReceived(int var1, @Nullable Object var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface ResultCode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static @interface DiagnosticCode {
    }
}

