/*
 * Decompiled with CFR 0.152.
 */
package androidx.profileinstaller;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.profileinstaller.DexProfileData;
import androidx.profileinstaller.Encoding;
import androidx.profileinstaller.FileSectionType;
import androidx.profileinstaller.ProfileVersion;
import androidx.profileinstaller.WritableFileSection;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;

@RequiresApi(value=19)
class ProfileTranscoder {
    private static final int HOT = 1;
    private static final int STARTUP = 2;
    private static final int POST_STARTUP = 4;
    private static final int INLINE_CACHE_MISSING_TYPES_ENCODING = 6;
    private static final int INLINE_CACHE_MEGAMORPHIC_ENCODING = 7;
    static final byte[] MAGIC_PROF = new byte[]{112, 114, 111, 0};
    static final byte[] MAGIC_PROFM = new byte[]{112, 114, 109, 0};

    private ProfileTranscoder() {
    }

    static byte[] readHeader(@NonNull InputStream is, @NonNull byte[] magic) throws IOException {
        byte[] fileMagic = Encoding.read(is, magic.length);
        if (!Arrays.equals(magic, fileMagic)) {
            throw Encoding.error("Invalid magic");
        }
        return Encoding.read(is, ProfileVersion.V010_P.length);
    }

    static void writeHeader(@NonNull OutputStream os, byte[] version2) throws IOException {
        os.write(MAGIC_PROF);
        os.write(version2);
    }

    static boolean transcodeAndWriteBody(@NonNull OutputStream os, @NonNull byte[] desiredVersion, @NonNull DexProfileData[] data) throws IOException {
        if (Arrays.equals(desiredVersion, ProfileVersion.V015_S)) {
            ProfileTranscoder.writeProfileForS(os, data);
            return true;
        }
        if (Arrays.equals(desiredVersion, ProfileVersion.V010_P)) {
            ProfileTranscoder.writeProfileForP(os, data);
            return true;
        }
        if (Arrays.equals(desiredVersion, ProfileVersion.V005_O)) {
            ProfileTranscoder.writeProfileForO(os, data);
            return true;
        }
        if (Arrays.equals(desiredVersion, ProfileVersion.V009_O_MR1)) {
            ProfileTranscoder.writeProfileForO_MR1(os, data);
            return true;
        }
        if (Arrays.equals(desiredVersion, ProfileVersion.V001_N)) {
            ProfileTranscoder.writeProfileForN(os, data);
            return true;
        }
        return false;
    }

    private static void writeProfileForN(@NonNull OutputStream os, @NonNull DexProfileData[] lines) throws IOException {
        Encoding.writeUInt16(os, lines.length);
        for (DexProfileData data : lines) {
            String profileKey = ProfileTranscoder.generateDexKey(data.apkName, data.dexName, ProfileVersion.V001_N);
            Encoding.writeUInt16(os, Encoding.utf8Length(profileKey));
            Encoding.writeUInt16(os, data.methods.size());
            Encoding.writeUInt16(os, data.classes.length);
            Encoding.writeUInt32(os, data.dexChecksum);
            Encoding.writeString(os, profileKey);
            Iterator<Integer> iterator2 = data.methods.keySet().iterator();
            while (iterator2.hasNext()) {
                int id2 = iterator2.next();
                Encoding.writeUInt16(os, id2);
            }
            for (Object id3 : (Iterator<Integer>)data.classes) {
                Encoding.writeUInt16(os, (int)id3);
            }
        }
    }

    private static void writeProfileForS(@NonNull OutputStream os, @NonNull DexProfileData[] profileData) throws IOException {
        ProfileTranscoder.writeProfileSections(os, profileData);
    }

    private static void writeProfileSections(@NonNull OutputStream os, @NonNull DexProfileData[] profileData) throws IOException {
        int i;
        ArrayList<WritableFileSection> sections = new ArrayList<WritableFileSection>(3);
        ArrayList<byte[]> sectionContents = new ArrayList<byte[]>(3);
        sections.add(ProfileTranscoder.writeDexFileSection(profileData));
        sections.add(ProfileTranscoder.createCompressibleClassSection(profileData));
        sections.add(ProfileTranscoder.createCompressibleMethodsSection(profileData));
        long offset = (long)ProfileVersion.V015_S.length + (long)MAGIC_PROF.length;
        offset += 4L;
        offset += (long)(16 * sections.size());
        Encoding.writeUInt32(os, sections.size());
        for (i = 0; i < sections.size(); ++i) {
            WritableFileSection section = (WritableFileSection)sections.get(i);
            Encoding.writeUInt32(os, section.mType.getValue());
            Encoding.writeUInt32(os, offset);
            if (section.mNeedsCompression) {
                long inflatedSize = section.mContents.length;
                byte[] compressed = Encoding.compress(section.mContents);
                sectionContents.add(compressed);
                Encoding.writeUInt32(os, compressed.length);
                Encoding.writeUInt32(os, inflatedSize);
                offset += (long)compressed.length;
                continue;
            }
            sectionContents.add(section.mContents);
            Encoding.writeUInt32(os, section.mContents.length);
            Encoding.writeUInt32(os, 0L);
            offset += (long)section.mContents.length;
        }
        for (i = 0; i < sectionContents.size(); ++i) {
            os.write((byte[])sectionContents.get(i));
        }
    }

    private static WritableFileSection writeDexFileSection(@NonNull DexProfileData[] profileData) throws IOException {
        int expectedSize = 0;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            expectedSize += 2;
            Encoding.writeUInt16(out, profileData.length);
            for (int i = 0; i < profileData.length; ++i) {
                DexProfileData profile = profileData[i];
                expectedSize += 4;
                Encoding.writeUInt32(out, profile.dexChecksum);
                expectedSize += 4;
                Encoding.writeUInt32(out, profile.mTypeIdCount);
                expectedSize += 4;
                Encoding.writeUInt32(out, profile.numMethodIds);
                String profileKey = ProfileTranscoder.generateDexKey(profile.apkName, profile.dexName, ProfileVersion.V015_S);
                expectedSize += 2;
                int keyLength = Encoding.utf8Length(profileKey);
                Encoding.writeUInt16(out, keyLength);
                expectedSize += keyLength * 1;
                Encoding.writeString(out, profileKey);
            }
            byte[] contents = out.toByteArray();
            if (expectedSize != contents.length) {
                throw Encoding.error("Expected size " + expectedSize + ", does not match actual size " + contents.length);
            }
            WritableFileSection writableFileSection = new WritableFileSection(FileSectionType.DEX_FILES, expectedSize, contents, false);
            return writableFileSection;
        }
    }

    private static WritableFileSection createCompressibleClassSection(@NonNull DexProfileData[] profileData) throws IOException {
        int expectedSize = 0;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            for (int i = 0; i < profileData.length; ++i) {
                DexProfileData profile = profileData[i];
                expectedSize += 2;
                Encoding.writeUInt16(out, i);
                expectedSize += 2;
                Encoding.writeUInt16(out, profile.classSetSize);
                expectedSize += 2 * profile.classSetSize;
                ProfileTranscoder.writeClasses(out, profile);
            }
            byte[] contents = out.toByteArray();
            if (expectedSize != contents.length) {
                throw Encoding.error("Expected size " + expectedSize + ", does not match actual size " + contents.length);
            }
            WritableFileSection writableFileSection = new WritableFileSection(FileSectionType.CLASSES, expectedSize, contents, true);
            return writableFileSection;
        }
    }

    private static WritableFileSection createCompressibleMethodsSection(@NonNull DexProfileData[] profileData) throws IOException {
        int expectedSize = 0;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            for (int i = 0; i < profileData.length; ++i) {
                DexProfileData profile = profileData[i];
                int methodFlags = ProfileTranscoder.computeMethodFlags(profile);
                byte[] bitmapContents = ProfileTranscoder.createMethodBitmapRegion(profile);
                byte[] methodRegionContents = ProfileTranscoder.createMethodsWithInlineCaches(profile);
                expectedSize += 2;
                Encoding.writeUInt16(out, i);
                int followingDataSize = 2 + bitmapContents.length + methodRegionContents.length;
                expectedSize += 4;
                Encoding.writeUInt32(out, followingDataSize);
                Encoding.writeUInt16(out, methodFlags);
                out.write(bitmapContents);
                out.write(methodRegionContents);
                expectedSize += followingDataSize;
            }
            byte[] contents = out.toByteArray();
            if (expectedSize != contents.length) {
                throw Encoding.error("Expected size " + expectedSize + ", does not match actual size " + contents.length);
            }
            WritableFileSection writableFileSection = new WritableFileSection(FileSectionType.METHODS, expectedSize, contents, true);
            return writableFileSection;
        }
    }

    private static byte[] createMethodBitmapRegion(@NonNull DexProfileData profile) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            ProfileTranscoder.writeMethodBitmap(out, profile);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    private static byte[] createMethodsWithInlineCaches(@NonNull DexProfileData profile) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            ProfileTranscoder.writeMethodsWithInlineCaches(out, profile);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    private static int computeMethodFlags(@NonNull DexProfileData profileData) {
        int methodFlags = 0;
        for (Map.Entry<Integer, Integer> entry : profileData.methods.entrySet()) {
            int flagValue = entry.getValue();
            methodFlags |= flagValue;
        }
        return methodFlags;
    }

    private static void writeProfileForP(@NonNull OutputStream os, @NonNull DexProfileData[] lines) throws IOException {
        byte[] profileBytes = ProfileTranscoder.createCompressibleBody(lines, ProfileVersion.V010_P);
        Encoding.writeUInt8(os, lines.length);
        Encoding.writeCompressed(os, profileBytes);
    }

    private static void writeProfileForO_MR1(@NonNull OutputStream os, @NonNull DexProfileData[] lines) throws IOException {
        byte[] profileBytes = ProfileTranscoder.createCompressibleBody(lines, ProfileVersion.V009_O_MR1);
        Encoding.writeUInt8(os, lines.length);
        Encoding.writeCompressed(os, profileBytes);
    }

    private static void writeProfileForO(@NonNull OutputStream os, @NonNull DexProfileData[] lines) throws IOException {
        Encoding.writeUInt8(os, lines.length);
        for (DexProfileData data : lines) {
            int hotMethodRegionSize = data.methods.size() * 4;
            String dexKey = ProfileTranscoder.generateDexKey(data.apkName, data.dexName, ProfileVersion.V005_O);
            Encoding.writeUInt16(os, Encoding.utf8Length(dexKey));
            Encoding.writeUInt16(os, data.classes.length);
            Encoding.writeUInt32(os, hotMethodRegionSize);
            Encoding.writeUInt32(os, data.dexChecksum);
            Encoding.writeString(os, dexKey);
            Iterator<Integer> iterator2 = data.methods.keySet().iterator();
            while (iterator2.hasNext()) {
                int id2 = iterator2.next();
                Encoding.writeUInt16(os, id2);
                Encoding.writeUInt16(os, 0);
            }
            for (Object id3 : (Iterator<Integer>)data.classes) {
                Encoding.writeUInt16(os, (int)id3);
            }
        }
    }

    @NonNull
    private static byte[] createCompressibleBody(@NonNull DexProfileData[] lines, @NonNull byte[] version2) throws IOException {
        String dexKey;
        int requiredCapacity = 0;
        for (DexProfileData data : lines) {
            int lineHeaderSize = 16;
            dexKey = ProfileTranscoder.generateDexKey(data.apkName, data.dexName, version2);
            requiredCapacity += lineHeaderSize + Encoding.utf8Length(dexKey) + data.classSetSize * 2 + data.hotMethodRegionSize + ProfileTranscoder.getMethodBitmapStorageSize(data.numMethodIds);
        }
        ByteArrayOutputStream dataBos = new ByteArrayOutputStream(requiredCapacity);
        if (Arrays.equals(version2, ProfileVersion.V009_O_MR1)) {
            for (DexProfileData data : lines) {
                dexKey = ProfileTranscoder.generateDexKey(data.apkName, data.dexName, version2);
                ProfileTranscoder.writeLineHeader(dataBos, data, dexKey);
                ProfileTranscoder.writeLineData(dataBos, data);
            }
        } else {
            for (DexProfileData data : lines) {
                dexKey = ProfileTranscoder.generateDexKey(data.apkName, data.dexName, version2);
                ProfileTranscoder.writeLineHeader(dataBos, data, dexKey);
            }
            for (DexProfileData data : lines) {
                ProfileTranscoder.writeLineData(dataBos, data);
            }
        }
        if (dataBos.size() != requiredCapacity) {
            throw Encoding.error("The bytes saved do not match expectation. actual=" + dataBos.size() + " expected=" + requiredCapacity);
        }
        return dataBos.toByteArray();
    }

    private static int getMethodBitmapStorageSize(int numMethodIds) {
        int methodBitmapBits = numMethodIds * 2;
        return ProfileTranscoder.roundUpToByte(methodBitmapBits) / 8;
    }

    private static int roundUpToByte(int bits) {
        return bits + 8 - 1 & 0xFFFFFFF8;
    }

    private static void setMethodBitmapBit(@NonNull byte[] bitmap, int flag, int methodIndex, @NonNull DexProfileData dexData) {
        byte value;
        int bitIndex = ProfileTranscoder.methodFlagBitmapIndex(flag, methodIndex, dexData.numMethodIds);
        int bitmapIndex = bitIndex / 8;
        bitmap[bitmapIndex] = value = (byte)(bitmap[bitmapIndex] | 1 << bitIndex % 8);
    }

    private static void writeLineHeader(@NonNull OutputStream os, @NonNull DexProfileData dexData, @NonNull String dexKey) throws IOException {
        Encoding.writeUInt16(os, Encoding.utf8Length(dexKey));
        Encoding.writeUInt16(os, dexData.classSetSize);
        Encoding.writeUInt32(os, dexData.hotMethodRegionSize);
        Encoding.writeUInt32(os, dexData.dexChecksum);
        Encoding.writeUInt32(os, dexData.numMethodIds);
        Encoding.writeString(os, dexKey);
    }

    private static void writeLineData(@NonNull OutputStream os, @NonNull DexProfileData dexData) throws IOException {
        ProfileTranscoder.writeMethodsWithInlineCaches(os, dexData);
        ProfileTranscoder.writeClasses(os, dexData);
        ProfileTranscoder.writeMethodBitmap(os, dexData);
    }

    private static void writeMethodsWithInlineCaches(@NonNull OutputStream os, @NonNull DexProfileData dexData) throws IOException {
        int lastMethodIndex = 0;
        for (Map.Entry<Integer, Integer> entry : dexData.methods.entrySet()) {
            int methodId = entry.getKey();
            int flags = entry.getValue();
            if ((flags & 1) == 0) continue;
            int diffWithTheLastMethodIndex = methodId - lastMethodIndex;
            Encoding.writeUInt16(os, diffWithTheLastMethodIndex);
            Encoding.writeUInt16(os, 0);
            lastMethodIndex = methodId;
        }
    }

    private static void writeClasses(@NonNull OutputStream os, @NonNull DexProfileData dexData) throws IOException {
        int lastClassIndex = 0;
        int[] nArray = dexData.classes;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            Integer classIndex = nArray[i];
            int diffWithTheLastClassIndex = classIndex - lastClassIndex;
            Encoding.writeUInt16(os, diffWithTheLastClassIndex);
            lastClassIndex = classIndex;
        }
    }

    private static void writeMethodBitmap(@NonNull OutputStream os, @NonNull DexProfileData dexData) throws IOException {
        byte[] bitmap = new byte[ProfileTranscoder.getMethodBitmapStorageSize(dexData.numMethodIds)];
        for (Map.Entry<Integer, Integer> entry : dexData.methods.entrySet()) {
            int methodIndex = entry.getKey();
            int flagValue = entry.getValue();
            if ((flagValue & 2) != 0) {
                ProfileTranscoder.setMethodBitmapBit(bitmap, 2, methodIndex, dexData);
            }
            if ((flagValue & 4) == 0) continue;
            ProfileTranscoder.setMethodBitmapBit(bitmap, 4, methodIndex, dexData);
        }
        os.write(bitmap);
    }

    @NonNull
    static DexProfileData[] readProfile(@NonNull InputStream is, @NonNull byte[] version2, @NonNull String apkName) throws IOException {
        if (!Arrays.equals(version2, ProfileVersion.V010_P)) {
            throw Encoding.error("Unsupported version");
        }
        int numberOfDexFiles = Encoding.readUInt8(is);
        long uncompressedDataSize = Encoding.readUInt32(is);
        long compressedDataSize = Encoding.readUInt32(is);
        byte[] uncompressedData = Encoding.readCompressed(is, (int)compressedDataSize, (int)uncompressedDataSize);
        if (is.read() > 0) {
            throw Encoding.error("Content found after the end of file");
        }
        try (ByteArrayInputStream dataStream = new ByteArrayInputStream(uncompressedData);){
            DexProfileData[] dexProfileDataArray = ProfileTranscoder.readUncompressedBody(dataStream, apkName, numberOfDexFiles);
            return dexProfileDataArray;
        }
    }

    @NonNull
    static DexProfileData[] readMeta(@NonNull InputStream is, @NonNull byte[] metadataVersion, @NonNull byte[] desiredProfileVersion, DexProfileData[] profile) throws IOException {
        if (Arrays.equals(metadataVersion, ProfileVersion.METADATA_V001_N)) {
            boolean requiresProfileV015 = Arrays.equals(ProfileVersion.V015_S, desiredProfileVersion);
            if (requiresProfileV015) {
                throw Encoding.error("Requires new Baseline Profile Metadata. Please rebuild the APK with Android Gradle Plugin 7.2 Canary 7 or higher");
            }
            return ProfileTranscoder.readMetadata001(is, metadataVersion, profile);
        }
        if (Arrays.equals(metadataVersion, ProfileVersion.METADATA_V002)) {
            return ProfileTranscoder.readMetadataV002(is, desiredProfileVersion, profile);
        }
        throw Encoding.error("Unsupported meta version");
    }

    @NonNull
    static DexProfileData[] readMetadata001(@NonNull InputStream is, @NonNull byte[] metadataVersion, DexProfileData[] profile) throws IOException {
        if (!Arrays.equals(metadataVersion, ProfileVersion.METADATA_V001_N)) {
            throw Encoding.error("Unsupported meta version");
        }
        int numberOfDexFiles = Encoding.readUInt8(is);
        long uncompressedDataSize = Encoding.readUInt32(is);
        long compressedDataSize = Encoding.readUInt32(is);
        byte[] uncompressedData = Encoding.readCompressed(is, (int)compressedDataSize, (int)uncompressedDataSize);
        if (is.read() > 0) {
            throw Encoding.error("Content found after the end of file");
        }
        try (ByteArrayInputStream dataStream = new ByteArrayInputStream(uncompressedData);){
            DexProfileData[] dexProfileDataArray = ProfileTranscoder.readMetadataForNBody(dataStream, numberOfDexFiles, profile);
            return dexProfileDataArray;
        }
    }

    @NonNull
    static DexProfileData[] readMetadataV002(@NonNull InputStream is, @NonNull byte[] desiredProfileVersion, DexProfileData[] profile) throws IOException {
        int dexFileCount = Encoding.readUInt16(is);
        long uncompressed = Encoding.readUInt32(is);
        long compressed = Encoding.readUInt32(is);
        byte[] contents = Encoding.readCompressed(is, (int)compressed, (int)uncompressed);
        if (is.read() > 0) {
            throw Encoding.error("Content found after the end of file");
        }
        try (ByteArrayInputStream dataStream = new ByteArrayInputStream(contents);){
            DexProfileData[] dexProfileDataArray = ProfileTranscoder.readMetadataV002Body(dataStream, desiredProfileVersion, dexFileCount, profile);
            return dexProfileDataArray;
        }
    }

    @NonNull
    private static DexProfileData[] readMetadataV002Body(@NonNull InputStream is, @NonNull byte[] desiredProfileVersion, int dexFileCount, DexProfileData[] profile) throws IOException {
        if (is.available() == 0) {
            return new DexProfileData[0];
        }
        if (dexFileCount != profile.length) {
            throw Encoding.error("Mismatched number of dex files found in metadata");
        }
        for (int i = 0; i < dexFileCount; ++i) {
            Encoding.readUInt16(is);
            int profileKeySize = Encoding.readUInt16(is);
            String profileKey = Encoding.readString(is, profileKeySize);
            long typeIdCount = Encoding.readUInt32(is);
            int classIdSetSize = Encoding.readUInt16(is);
            DexProfileData data = ProfileTranscoder.findByDexName(profile, profileKey);
            if (data == null) {
                throw Encoding.error("Missing profile key: " + profileKey);
            }
            data.mTypeIdCount = typeIdCount;
            int[] classes = ProfileTranscoder.readClasses(is, classIdSetSize);
            if (!Arrays.equals(desiredProfileVersion, ProfileVersion.V001_N)) continue;
            data.classSetSize = classIdSetSize;
            data.classes = classes;
        }
        return profile;
    }

    @Nullable
    private static DexProfileData findByDexName(@NonNull DexProfileData[] profile, @NonNull String profileKey) {
        if (profile.length <= 0) {
            return null;
        }
        String dexName = ProfileTranscoder.extractKey(profileKey);
        for (int i = 0; i < profile.length; ++i) {
            if (!profile[i].dexName.equals(dexName)) continue;
            return profile[i];
        }
        return null;
    }

    @NonNull
    private static DexProfileData[] readMetadataForNBody(@NonNull InputStream is, int numberOfDexFiles, DexProfileData[] profile) throws IOException {
        int i;
        if (is.available() == 0) {
            return new DexProfileData[0];
        }
        if (numberOfDexFiles != profile.length) {
            throw Encoding.error("Mismatched number of dex files found in metadata");
        }
        String[] names = new String[numberOfDexFiles];
        int[] sizes = new int[numberOfDexFiles];
        for (i = 0; i < numberOfDexFiles; ++i) {
            int dexNameSize = Encoding.readUInt16(is);
            sizes[i] = Encoding.readUInt16(is);
            names[i] = Encoding.readString(is, dexNameSize);
        }
        for (i = 0; i < numberOfDexFiles; ++i) {
            DexProfileData data = profile[i];
            if (!data.dexName.equals(names[i])) {
                throw Encoding.error("Order of dexfiles in metadata did not match baseline");
            }
            data.classSetSize = sizes[i];
            data.classes = ProfileTranscoder.readClasses(is, data.classSetSize);
        }
        return profile;
    }

    @NonNull
    private static String generateDexKey(@NonNull String apkName, @NonNull String dexName, @NonNull byte[] version2) {
        String separator = ProfileVersion.dexKeySeparator(version2);
        if (apkName.length() <= 0) {
            return ProfileTranscoder.enforceSeparator(dexName, separator);
        }
        if (dexName.equals("classes.dex")) {
            return apkName;
        }
        if (dexName.contains("!") || dexName.contains(":")) {
            return ProfileTranscoder.enforceSeparator(dexName, separator);
        }
        if (dexName.endsWith(".apk")) {
            return dexName;
        }
        return apkName + ProfileVersion.dexKeySeparator(version2) + dexName;
    }

    @NonNull
    private static String enforceSeparator(@NonNull String value, @NonNull String separator) {
        if ("!".equals(separator)) {
            return value.replace(":", "!");
        }
        if (":".equals(separator)) {
            return value.replace("!", ":");
        }
        return value;
    }

    @NonNull
    private static String extractKey(@NonNull String profileKey) {
        int index = profileKey.indexOf("!");
        if (index < 0) {
            index = profileKey.indexOf(":");
        }
        if (index > 0) {
            return profileKey.substring(index + 1);
        }
        return profileKey;
    }

    @NonNull
    private static DexProfileData[] readUncompressedBody(@NonNull InputStream is, @NonNull String apkName, int numberOfDexFiles) throws IOException {
        if (is.available() == 0) {
            return new DexProfileData[0];
        }
        DexProfileData[] lines = new DexProfileData[numberOfDexFiles];
        for (int i = 0; i < numberOfDexFiles; ++i) {
            int dexNameSize = Encoding.readUInt16(is);
            int classSetSize = Encoding.readUInt16(is);
            long hotMethodRegionSize = Encoding.readUInt32(is);
            long dexChecksum = Encoding.readUInt32(is);
            long numMethodIds = Encoding.readUInt32(is);
            lines[i] = new DexProfileData(apkName, Encoding.readString(is, dexNameSize), dexChecksum, 0L, classSetSize, (int)hotMethodRegionSize, (int)numMethodIds, new int[classSetSize], new TreeMap<Integer, Integer>());
        }
        for (DexProfileData data : lines) {
            ProfileTranscoder.readHotMethodRegion(is, data);
            data.classes = ProfileTranscoder.readClasses(is, data.classSetSize);
            ProfileTranscoder.readMethodBitmap(is, data);
        }
        return lines;
    }

    private static void readHotMethodRegion(@NonNull InputStream is, @NonNull DexProfileData data) throws IOException {
        int expectedBytesAvailableAfterRead = is.available() - data.hotMethodRegionSize;
        int lastMethodIndex = 0;
        while (is.available() > expectedBytesAvailableAfterRead) {
            int diffWithLastMethodDexIndex = Encoding.readUInt16(is);
            int methodDexIndex = lastMethodIndex + diffWithLastMethodDexIndex;
            data.methods.put(methodDexIndex, 1);
            for (int inlineCacheSize = Encoding.readUInt16(is); inlineCacheSize > 0; --inlineCacheSize) {
                ProfileTranscoder.skipInlineCache(is);
            }
            lastMethodIndex = methodDexIndex;
        }
        if (is.available() != expectedBytesAvailableAfterRead) {
            throw Encoding.error("Read too much data during profile line parse");
        }
    }

    private static void skipInlineCache(@NonNull InputStream is) throws IOException {
        int dexPcMapSize;
        Encoding.readUInt16(is);
        if (dexPcMapSize == 6) {
            return;
        }
        if (dexPcMapSize == 7) {
            return;
        }
        for (dexPcMapSize = Encoding.readUInt8(is); dexPcMapSize > 0; --dexPcMapSize) {
            Encoding.readUInt8(is);
            for (int numClasses = Encoding.readUInt8(is); numClasses > 0; --numClasses) {
                Encoding.readUInt16(is);
            }
        }
    }

    private static int[] readClasses(@NonNull InputStream is, int classSetSize) throws IOException {
        int[] classes = new int[classSetSize];
        int lastClassIndex = 0;
        for (int k = 0; k < classSetSize; ++k) {
            int classDexIndex;
            int diffWithTheLastClassIndex = Encoding.readUInt16(is);
            classes[k] = classDexIndex = lastClassIndex + diffWithTheLastClassIndex;
            lastClassIndex = classDexIndex;
        }
        return classes;
    }

    private static void readMethodBitmap(@NonNull InputStream is, @NonNull DexProfileData data) throws IOException {
        int methodBitmapStorageSize = Encoding.bitsToBytes(data.numMethodIds * 2);
        byte[] methodBitmap = Encoding.read(is, methodBitmapStorageSize);
        BitSet bs = BitSet.valueOf(methodBitmap);
        for (int methodIndex = 0; methodIndex < data.numMethodIds; ++methodIndex) {
            int newFlags = ProfileTranscoder.readFlagsFromBitmap(bs, methodIndex, data.numMethodIds);
            if (newFlags == 0) continue;
            Integer current = data.methods.get(methodIndex);
            if (current == null) {
                current = 0;
            }
            data.methods.put(methodIndex, current | newFlags);
        }
    }

    private static int readFlagsFromBitmap(@NonNull BitSet bs, int methodIndex, int numMethodIds) {
        int result2 = 0;
        if (bs.get(ProfileTranscoder.methodFlagBitmapIndex(2, methodIndex, numMethodIds))) {
            result2 |= 2;
        }
        if (bs.get(ProfileTranscoder.methodFlagBitmapIndex(4, methodIndex, numMethodIds))) {
            result2 |= 4;
        }
        return result2;
    }

    private static int methodFlagBitmapIndex(int flag, int methodIndex, int numMethodIds) {
        switch (flag) {
            case 1: {
                throw Encoding.error("HOT methods are not stored in the bitmap");
            }
            case 2: {
                return methodIndex;
            }
            case 4: {
                return methodIndex + numMethodIds;
            }
        }
        throw Encoding.error("Unexpected flag: " + flag);
    }
}

