/*
 * Decompiled with CFR 0.152.
 */
package androidx.profileinstaller;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.WorkerThread;
import androidx.concurrent.futures.ResolvableFuture;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Objects;

public final class ProfileVerifier {
    private static final String REF_PROFILES_BASE_DIR = "/data/misc/profiles/ref/";
    private static final String CUR_PROFILES_BASE_DIR = "/data/misc/profiles/cur/0/";
    private static final String PROFILE_FILE_NAME = "primary.prof";
    private static final String PROFILE_INSTALLED_CACHE_FILE_NAME = "profileInstalled";
    private static final ResolvableFuture<CompilationStatus> sFuture = ResolvableFuture.create();
    private static final Object SYNC_OBJ = new Object();
    private static final String TAG = "ProfileVerifier";
    @Nullable
    private static CompilationStatus sCompilationStatus = null;

    private ProfileVerifier() {
    }

    @WorkerThread
    @NonNull
    public static CompilationStatus writeProfileVerification(@NonNull Context context) {
        return ProfileVerifier.writeProfileVerification(context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @WorkerThread
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    static CompilationStatus writeProfileVerification(@NonNull Context context, boolean forceVerifyCurrentProfile) {
        if (!forceVerifyCurrentProfile && sCompilationStatus != null) {
            return sCompilationStatus;
        }
        Object object = SYNC_OBJ;
        synchronized (object) {
            long packageLastUpdateTime;
            if (!forceVerifyCurrentProfile && sCompilationStatus != null) {
                return sCompilationStatus;
            }
            if (Build.VERSION.SDK_INT < 28 || Build.VERSION.SDK_INT == 30) {
                return ProfileVerifier.setCompilationStatus(262144, false, false);
            }
            File referenceProfileFile = new File(new File(REF_PROFILES_BASE_DIR, context.getPackageName()), PROFILE_FILE_NAME);
            long referenceProfileSize = referenceProfileFile.length();
            boolean hasReferenceProfile = referenceProfileFile.exists() && referenceProfileSize > 0L;
            File currentProfileFile = new File(new File(CUR_PROFILES_BASE_DIR, context.getPackageName()), PROFILE_FILE_NAME);
            long currentProfileSize = currentProfileFile.length();
            boolean hasCurrentProfile = currentProfileFile.exists() && currentProfileSize > 0L;
            try {
                packageLastUpdateTime = ProfileVerifier.getPackageLastUpdateTime(context);
            }
            catch (PackageManager.NameNotFoundException e) {
                return ProfileVerifier.setCompilationStatus(65536, hasReferenceProfile, hasCurrentProfile);
            }
            File cacheFile = new File(context.getFilesDir(), PROFILE_INSTALLED_CACHE_FILE_NAME);
            Cache currentCache = null;
            if (cacheFile.exists()) {
                try {
                    currentCache = Cache.readFromFile(cacheFile);
                }
                catch (IOException e) {
                    return ProfileVerifier.setCompilationStatus(131072, hasReferenceProfile, hasCurrentProfile);
                }
            }
            int resultCode = currentCache == null || currentCache.mPackageLastUpdateTime != packageLastUpdateTime || currentCache.mResultCode == 2 ? (hasReferenceProfile ? 1 : (hasCurrentProfile ? 2 : 0)) : currentCache.mResultCode;
            if (forceVerifyCurrentProfile && hasCurrentProfile && resultCode != 1) {
                resultCode = 2;
            }
            if (currentCache != null && currentCache.mResultCode == 2 && resultCode == 1 && referenceProfileSize < currentCache.mInstalledCurrentProfileSize) {
                resultCode = 3;
            }
            Cache newCache = new Cache(1, resultCode, packageLastUpdateTime, currentProfileSize);
            if (currentCache == null || !currentCache.equals(newCache)) {
                try {
                    newCache.writeOnFile(cacheFile);
                }
                catch (IOException e) {
                    resultCode = 196608;
                }
            }
            return ProfileVerifier.setCompilationStatus(resultCode, hasReferenceProfile, hasCurrentProfile);
        }
    }

    private static CompilationStatus setCompilationStatus(int resultCode, boolean hasReferenceProfile, boolean hasCurrentProfile) {
        sCompilationStatus = new CompilationStatus(resultCode, hasReferenceProfile, hasCurrentProfile);
        sFuture.set(sCompilationStatus);
        return sCompilationStatus;
    }

    private static long getPackageLastUpdateTime(Context context) throws PackageManager.NameNotFoundException {
        PackageManager packageManager = context.getApplicationContext().getPackageManager();
        if (Build.VERSION.SDK_INT >= 33) {
            return Api33Impl.getPackageInfo((PackageManager)packageManager, (Context)context).lastUpdateTime;
        }
        return packageManager.getPackageInfo((String)context.getPackageName(), (int)0).lastUpdateTime;
    }

    @NonNull
    public static ListenableFuture<CompilationStatus> getCompilationStatusAsync() {
        return sFuture;
    }

    public static class CompilationStatus {
        private static final int RESULT_CODE_ERROR_CODE_BIT_SHIFT = 16;
        public static final int RESULT_CODE_NO_PROFILE = 0;
        public static final int RESULT_CODE_COMPILED_WITH_PROFILE = 1;
        public static final int RESULT_CODE_PROFILE_ENQUEUED_FOR_COMPILATION = 2;
        public static final int RESULT_CODE_COMPILED_WITH_PROFILE_NON_MATCHING = 3;
        public static final int RESULT_CODE_ERROR_PACKAGE_NAME_DOES_NOT_EXIST = 65536;
        public static final int RESULT_CODE_ERROR_CACHE_FILE_EXISTS_BUT_CANNOT_BE_READ = 131072;
        public static final int RESULT_CODE_ERROR_CANT_WRITE_PROFILE_VERIFICATION_RESULT_CACHE_FILE = 196608;
        public static final int RESULT_CODE_ERROR_UNSUPPORTED_API_VERSION = 262144;
        final int mResultCode;
        private final boolean mHasReferenceProfile;
        private final boolean mHasCurrentProfile;

        CompilationStatus(int resultCode, boolean hasReferenceProfile, boolean hasCurrentProfile) {
            this.mResultCode = resultCode;
            this.mHasCurrentProfile = hasCurrentProfile;
            this.mHasReferenceProfile = hasReferenceProfile;
        }

        public int getProfileInstallResultCode() {
            return this.mResultCode;
        }

        public boolean isCompiledWithProfile() {
            return this.mHasReferenceProfile;
        }

        public boolean hasProfileEnqueuedForCompilation() {
            return this.mHasCurrentProfile;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public static @interface ResultCode {
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    static class Cache {
        private static final int SCHEMA = 1;
        final int mSchema;
        final int mResultCode;
        final long mPackageLastUpdateTime;
        final long mInstalledCurrentProfileSize;

        Cache(int schema, int resultCode, long packageLastUpdateTime, long installedCurrentProfileSize) {
            this.mSchema = schema;
            this.mResultCode = resultCode;
            this.mPackageLastUpdateTime = packageLastUpdateTime;
            this.mInstalledCurrentProfileSize = installedCurrentProfileSize;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Cache)) {
                return false;
            }
            Cache cacheFile = (Cache)o;
            return this.mResultCode == cacheFile.mResultCode && this.mPackageLastUpdateTime == cacheFile.mPackageLastUpdateTime && this.mSchema == cacheFile.mSchema && this.mInstalledCurrentProfileSize == cacheFile.mInstalledCurrentProfileSize;
        }

        public int hashCode() {
            return Objects.hash(this.mResultCode, this.mPackageLastUpdateTime, this.mSchema, this.mInstalledCurrentProfileSize);
        }

        void writeOnFile(@NonNull File file) throws IOException {
            file.delete();
            try (DataOutputStream dos = new DataOutputStream(new FileOutputStream(file));){
                dos.writeInt(this.mSchema);
                dos.writeInt(this.mResultCode);
                dos.writeLong(this.mPackageLastUpdateTime);
                dos.writeLong(this.mInstalledCurrentProfileSize);
            }
        }

        static Cache readFromFile(@NonNull File file) throws IOException {
            try (DataInputStream dis = new DataInputStream(new FileInputStream(file));){
                Cache cache2 = new Cache(dis.readInt(), dis.readInt(), dis.readLong(), dis.readLong());
                return cache2;
            }
        }
    }

    @RequiresApi(value=33)
    private static class Api33Impl {
        private Api33Impl() {
        }

        @DoNotInline
        static PackageInfo getPackageInfo(PackageManager packageManager, Context context) throws PackageManager.NameNotFoundException {
            return packageManager.getPackageInfo(context.getPackageName(), PackageManager.PackageInfoFlags.of((long)0L));
        }
    }
}

