/*
 * Decompiled with CFR 0.152.
 */
package androidx.room;

import android.app.Service;
import android.content.Intent;
import android.os.IBinder;
import android.os.IInterface;
import android.os.RemoteCallbackList;
import android.os.RemoteException;
import android.util.Log;
import androidx.room.ExperimentalRoomApi;
import androidx.room.IMultiInstanceInvalidationCallback;
import androidx.room.IMultiInstanceInvalidationService;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR \u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\fX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Landroidx/room/MultiInstanceInvalidationService;", "Landroid/app/Service;", "()V", "binder", "Landroidx/room/IMultiInstanceInvalidationService$Stub;", "callbackList", "Landroid/os/RemoteCallbackList;", "Landroidx/room/IMultiInstanceInvalidationCallback;", "getCallbackList$room_runtime_release", "()Landroid/os/RemoteCallbackList;", "clientNames", "", "", "", "getClientNames$room_runtime_release", "()Ljava/util/Map;", "maxClientId", "getMaxClientId$room_runtime_release", "()I", "setMaxClientId$room_runtime_release", "(I)V", "onBind", "Landroid/os/IBinder;", "intent", "Landroid/content/Intent;", "room-runtime_release"})
@ExperimentalRoomApi
public final class MultiInstanceInvalidationService
extends Service {
    private int maxClientId;
    @NotNull
    private final Map<Integer, String> clientNames = new LinkedHashMap();
    @NotNull
    private final RemoteCallbackList<IMultiInstanceInvalidationCallback> callbackList = (RemoteCallbackList)new RemoteCallbackList<IMultiInstanceInvalidationCallback>(this){
        final /* synthetic */ MultiInstanceInvalidationService this$0;
        {
            this.this$0 = $receiver;
        }

        public void onCallbackDied(@NotNull IMultiInstanceInvalidationCallback callback2, @NotNull Object cookie) {
            Intrinsics.checkNotNullParameter(callback2, "callback");
            Intrinsics.checkNotNullParameter(cookie, "cookie");
            this.this$0.getClientNames$room_runtime_release().remove((Integer)cookie);
        }
    };
    @NotNull
    private final IMultiInstanceInvalidationService.Stub binder = new IMultiInstanceInvalidationService.Stub(this){
        final /* synthetic */ MultiInstanceInvalidationService this$0;
        {
            this.this$0 = $receiver;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int registerCallback(@NotNull IMultiInstanceInvalidationCallback callback2, @Nullable String name) {
            Intrinsics.checkNotNullParameter(callback2, "callback");
            if (name == null) {
                return 0;
            }
            RemoteCallbackList<IMultiInstanceInvalidationCallback> remoteCallbackList = this.this$0.getCallbackList$room_runtime_release();
            MultiInstanceInvalidationService multiInstanceInvalidationService = this.this$0;
            RemoteCallbackList<IMultiInstanceInvalidationCallback> remoteCallbackList2 = remoteCallbackList;
            synchronized (remoteCallbackList2) {
                int n;
                boolean bl = false;
                multiInstanceInvalidationService.setMaxClientId$room_runtime_release(multiInstanceInvalidationService.getMaxClientId$room_runtime_release() + 1);
                int clientId = multiInstanceInvalidationService.getMaxClientId$room_runtime_release();
                if (multiInstanceInvalidationService.getCallbackList$room_runtime_release().register((IInterface)callback2, (Object)clientId)) {
                    Integer n2 = clientId;
                    multiInstanceInvalidationService.getClientNames$room_runtime_release().put(n2, name);
                    n = clientId;
                } else {
                    multiInstanceInvalidationService.setMaxClientId$room_runtime_release(multiInstanceInvalidationService.getMaxClientId$room_runtime_release() + -1);
                    multiInstanceInvalidationService.getMaxClientId$room_runtime_release();
                    n = 0;
                }
                int n3 = n;
                return n3;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void unregisterCallback(@NotNull IMultiInstanceInvalidationCallback callback2, int clientId) {
            Intrinsics.checkNotNullParameter(callback2, "callback");
            RemoteCallbackList<IMultiInstanceInvalidationCallback> remoteCallbackList = this.this$0.getCallbackList$room_runtime_release();
            MultiInstanceInvalidationService multiInstanceInvalidationService = this.this$0;
            RemoteCallbackList<IMultiInstanceInvalidationCallback> remoteCallbackList2 = remoteCallbackList;
            synchronized (remoteCallbackList2) {
                boolean bl = false;
                multiInstanceInvalidationService.getCallbackList$room_runtime_release().unregister((IInterface)callback2);
                String string2 = multiInstanceInvalidationService.getClientNames$room_runtime_release().remove(clientId);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void broadcastInvalidation(int clientId, @NotNull String[] tables) {
            Intrinsics.checkNotNullParameter(tables, "tables");
            RemoteCallbackList<IMultiInstanceInvalidationCallback> remoteCallbackList = this.this$0.getCallbackList$room_runtime_release();
            MultiInstanceInvalidationService multiInstanceInvalidationService = this.this$0;
            RemoteCallbackList<IMultiInstanceInvalidationCallback> remoteCallbackList2 = remoteCallbackList;
            synchronized (remoteCallbackList2) {
                boolean bl = false;
                String name = multiInstanceInvalidationService.getClientNames$room_runtime_release().get(clientId);
                if (name == null) {
                    Log.w((String)"ROOM", (String)"Remote invalidation client ID not registered");
                    return;
                }
                int count2 = multiInstanceInvalidationService.getCallbackList$room_runtime_release().beginBroadcast();
                try {
                    for (int i = 0; i < count2; ++i) {
                        Object object = multiInstanceInvalidationService.getCallbackList$room_runtime_release().getBroadcastCookie(i);
                        Intrinsics.checkNotNull(object, "null cannot be cast to non-null type kotlin.Int");
                        int targetClientId = (Integer)object;
                        String targetName = multiInstanceInvalidationService.getClientNames$room_runtime_release().get(targetClientId);
                        if (clientId == targetClientId || !Intrinsics.areEqual(name, targetName)) continue;
                        try {
                            ((IMultiInstanceInvalidationCallback)multiInstanceInvalidationService.getCallbackList$room_runtime_release().getBroadcastItem(i)).onInvalidation(tables);
                            continue;
                        }
                        catch (RemoteException e) {
                            Log.w((String)"ROOM", (String)"Error invoking a remote callback", (Throwable)e);
                        }
                    }
                }
                finally {
                    multiInstanceInvalidationService.getCallbackList$room_runtime_release().finishBroadcast();
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    };

    public final int getMaxClientId$room_runtime_release() {
        return this.maxClientId;
    }

    public final void setMaxClientId$room_runtime_release(int n) {
        this.maxClientId = n;
    }

    @NotNull
    public final Map<Integer, String> getClientNames$room_runtime_release() {
        return this.clientNames;
    }

    @NotNull
    public final RemoteCallbackList<IMultiInstanceInvalidationCallback> getCallbackList$room_runtime_release() {
        return this.callbackList;
    }

    @NotNull
    public IBinder onBind(@NotNull Intent intent) {
        Intrinsics.checkNotNullParameter(intent, "intent");
        return (IBinder)this.binder;
    }
}

