/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.paging;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import androidx.paging.PositionalDataSource;
import androidx.room.InvalidationTracker;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteQuery;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public abstract class LimitOffsetDataSource<T>
extends PositionalDataSource<T> {
    private final RoomSQLiteQuery mSourceQuery;
    private final String mCountQuery;
    private final String mLimitOffsetQuery;
    private final RoomDatabase mDb;
    private final InvalidationTracker.Observer mObserver;
    private final boolean mInTransaction;
    private final AtomicBoolean mRegisteredObserver = new AtomicBoolean(false);

    protected LimitOffsetDataSource(@NonNull RoomDatabase db, @NonNull SupportSQLiteQuery query2, boolean inTransaction2, String ... tables) {
        this(db, RoomSQLiteQuery.copyFrom(query2), inTransaction2, tables);
    }

    protected LimitOffsetDataSource(@NonNull RoomDatabase db, @NonNull SupportSQLiteQuery query2, boolean inTransaction2, boolean registerObserverImmediately, String ... tables) {
        this(db, RoomSQLiteQuery.copyFrom(query2), inTransaction2, registerObserverImmediately, tables);
    }

    protected LimitOffsetDataSource(@NonNull RoomDatabase db, @NonNull RoomSQLiteQuery query2, boolean inTransaction2, String ... tables) {
        this(db, query2, inTransaction2, true, tables);
    }

    protected LimitOffsetDataSource(@NonNull RoomDatabase db, @NonNull RoomSQLiteQuery query2, boolean inTransaction2, boolean registerObserverImmediately, String ... tables) {
        this.mDb = db;
        this.mSourceQuery = query2;
        this.mInTransaction = inTransaction2;
        this.mCountQuery = "SELECT COUNT(*) FROM ( " + this.mSourceQuery.getSql() + " )";
        this.mLimitOffsetQuery = "SELECT * FROM ( " + this.mSourceQuery.getSql() + " ) LIMIT ? OFFSET ?";
        this.mObserver = new InvalidationTracker.Observer(tables){

            @Override
            public void onInvalidated(@NonNull Set<String> tables) {
                LimitOffsetDataSource.this.invalidate();
            }
        };
        if (registerObserverImmediately) {
            this.registerObserverIfNecessary();
        }
    }

    private void registerObserverIfNecessary() {
        if (this.mRegisteredObserver.compareAndSet(false, true)) {
            this.mDb.getInvalidationTracker().addWeakObserver(this.mObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public int countItems() {
        this.registerObserverIfNecessary();
        RoomSQLiteQuery sqLiteQuery = RoomSQLiteQuery.acquire(this.mCountQuery, this.mSourceQuery.getArgCount());
        sqLiteQuery.copyArgumentsFrom(this.mSourceQuery);
        Cursor cursor = this.mDb.query(sqLiteQuery);
        try {
            if (cursor.moveToFirst()) {
                int n = cursor.getInt(0);
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            cursor.close();
            sqLiteQuery.release();
        }
    }

    public boolean isInvalid() {
        this.registerObserverIfNecessary();
        this.mDb.getInvalidationTracker().refreshVersionsSync();
        return super.isInvalid();
    }

    @NonNull
    protected abstract List<T> convertRows(@NonNull Cursor var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadInitial(@NonNull PositionalDataSource.LoadInitialParams params, @NonNull PositionalDataSource.LoadInitialCallback<T> callback2) {
        int totalCount;
        this.registerObserverIfNecessary();
        List list = Collections.emptyList();
        int firstLoadPosition = 0;
        RoomSQLiteQuery sqLiteQuery = null;
        Cursor cursor = null;
        this.mDb.beginTransaction();
        try {
            totalCount = this.countItems();
            if (totalCount != 0) {
                firstLoadPosition = LimitOffsetDataSource.computeInitialLoadPosition((PositionalDataSource.LoadInitialParams)params, (int)totalCount);
                int firstLoadSize = LimitOffsetDataSource.computeInitialLoadSize((PositionalDataSource.LoadInitialParams)params, (int)firstLoadPosition, (int)totalCount);
                sqLiteQuery = this.getSQLiteQuery(firstLoadPosition, firstLoadSize);
                cursor = this.mDb.query(sqLiteQuery);
                List<T> rows = this.convertRows(cursor);
                this.mDb.setTransactionSuccessful();
                list = rows;
            }
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
            this.mDb.endTransaction();
            if (sqLiteQuery != null) {
                sqLiteQuery.release();
            }
        }
        callback2.onResult(list, firstLoadPosition, totalCount);
    }

    public void loadRange(@NonNull PositionalDataSource.LoadRangeParams params, @NonNull PositionalDataSource.LoadRangeCallback<T> callback2) {
        callback2.onResult(this.loadRange(params.startPosition, params.loadSize));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    @NonNull
    public List<T> loadRange(int startPosition, int loadCount) {
        RoomSQLiteQuery sqLiteQuery = this.getSQLiteQuery(startPosition, loadCount);
        if (this.mInTransaction) {
            this.mDb.beginTransaction();
            Cursor cursor = null;
            try {
                cursor = this.mDb.query(sqLiteQuery);
                List<T> rows = this.convertRows(cursor);
                this.mDb.setTransactionSuccessful();
                List<T> list = rows;
                return list;
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
                this.mDb.endTransaction();
                sqLiteQuery.release();
            }
        }
        Cursor cursor = this.mDb.query(sqLiteQuery);
        try {
            List<T> list = this.convertRows(cursor);
            return list;
        }
        finally {
            cursor.close();
            sqLiteQuery.release();
        }
    }

    private RoomSQLiteQuery getSQLiteQuery(int startPosition, int loadCount) {
        RoomSQLiteQuery sqLiteQuery = RoomSQLiteQuery.acquire(this.mLimitOffsetQuery, this.mSourceQuery.getArgCount() + 2);
        sqLiteQuery.copyArgumentsFrom(this.mSourceQuery);
        sqLiteQuery.bindLong(sqLiteQuery.getArgCount() - 1, loadCount);
        sqLiteQuery.bindLong(sqLiteQuery.getArgCount(), startPosition);
        return sqLiteQuery;
    }
}

