/*
 * Decompiled with CFR 0.152.
 */
package androidx.room.util;

import androidx.annotation.RestrictTo;
import androidx.collection.ArrayMap;
import androidx.collection.LongSparseArray;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001aR\u0010\u0000\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\u0004\b\u0001\u0010\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u00062\u0006\u0010\u0007\u001a\u00020\b2\u001e\u0010\t\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\u0006\u0012\u0004\u0012\u00020\u00010\n\u001ar\u0010\u000b\u001a\u00020\u0001\"\b\b\u0000\u0010\u0002*\u00020\u0003\"\u0004\b\u0001\u0010\u00042\"\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\fj\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0004`\r2\u0006\u0010\u0007\u001a\u00020\b2.\u0010\t\u001a*\u0012 \u0012\u001e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00040\fj\u000e\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u0004`\r\u0012\u0004\u0012\u00020\u00010\n\u001a<\u0010\u000e\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u0002H\u00040\u000f2\u0006\u0010\u0007\u001a\u00020\b2\u0018\u0010\t\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00040\u000f\u0012\u0004\u0012\u00020\u00010\n\u00a8\u0006\u0010"}, d2={"recursiveFetchArrayMap", "", "K", "", "V", "map", "Landroidx/collection/ArrayMap;", "isRelationCollection", "", "fetchBlock", "Lkotlin/Function1;", "recursiveFetchHashMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "recursiveFetchLongSparseArray", "Landroidx/collection/LongSparseArray;", "room-runtime_release"})
@JvmName(name="RelationUtil")
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public final class RelationUtil {
    public static final <K, V> void recursiveFetchHashMap(@NotNull HashMap<K, V> map2, boolean isRelationCollection, @NotNull Function1<? super HashMap<K, V>, Unit> fetchBlock) {
        Intrinsics.checkNotNullParameter(map2, "map");
        Intrinsics.checkNotNullParameter(fetchBlock, "fetchBlock");
        HashMap tmpMap = new HashMap(999);
        int count2 = 0;
        for (K key : map2.keySet()) {
            if (isRelationCollection) {
                Map map3 = tmpMap;
                Intrinsics.checkNotNullExpressionValue(key, "key");
                map3.put(key, map2.get(key));
            } else {
                Map map4 = tmpMap;
                Intrinsics.checkNotNullExpressionValue(key, "key");
                map4.put(key, null);
            }
            if (++count2 != 999) continue;
            fetchBlock.invoke(tmpMap);
            if (!isRelationCollection) {
                map2.putAll(tmpMap);
            }
            tmpMap.clear();
            count2 = 0;
        }
        if (count2 > 0) {
            fetchBlock.invoke(tmpMap);
            if (!isRelationCollection) {
                map2.putAll(tmpMap);
            }
        }
    }

    public static final <V> void recursiveFetchLongSparseArray(@NotNull LongSparseArray<V> map2, boolean isRelationCollection, @NotNull Function1<? super LongSparseArray<V>, Unit> fetchBlock) {
        Intrinsics.checkNotNullParameter(map2, "map");
        Intrinsics.checkNotNullParameter(fetchBlock, "fetchBlock");
        LongSparseArray<V> tmpMap = new LongSparseArray<V>(999);
        int count2 = 0;
        int mapIndex = 0;
        int limit = map2.size();
        while (mapIndex < limit) {
            if (isRelationCollection) {
                tmpMap.put(map2.keyAt(mapIndex), map2.valueAt(mapIndex));
            } else {
                tmpMap.put(map2.keyAt(mapIndex), null);
            }
            ++mapIndex;
            if (++count2 != 999) continue;
            fetchBlock.invoke(tmpMap);
            if (!isRelationCollection) {
                map2.putAll(tmpMap);
            }
            tmpMap.clear();
            count2 = 0;
        }
        if (count2 > 0) {
            fetchBlock.invoke(tmpMap);
            if (!isRelationCollection) {
                map2.putAll(tmpMap);
            }
        }
    }

    public static final <K, V> void recursiveFetchArrayMap(@NotNull ArrayMap<K, V> map2, boolean isRelationCollection, @NotNull Function1<? super ArrayMap<K, V>, Unit> fetchBlock) {
        Intrinsics.checkNotNullParameter(map2, "map");
        Intrinsics.checkNotNullParameter(fetchBlock, "fetchBlock");
        ArrayMap tmpMap = new ArrayMap(999);
        int count2 = 0;
        int mapIndex = 0;
        int limit = map2.size();
        while (mapIndex < limit) {
            if (isRelationCollection) {
                ((Map)tmpMap).put(map2.keyAt(mapIndex), map2.valueAt(mapIndex));
            } else {
                ((Map)tmpMap).put(map2.keyAt(mapIndex), null);
            }
            ++mapIndex;
            if (++count2 != 999) continue;
            fetchBlock.invoke(tmpMap);
            if (!isRelationCollection) {
                map2.putAll(tmpMap);
            }
            tmpMap.clear();
            count2 = 0;
        }
        if (count2 > 0) {
            fetchBlock.invoke(tmpMap);
            if (!isRelationCollection) {
                map2.putAll(tmpMap);
            }
        }
    }
}

