/*
 * Decompiled with CFR 0.152.
 */
package androidx.sqlite.db;

import android.content.Context;
import android.database.sqlite.SQLiteException;
import android.os.Build;
import android.util.Log;
import android.util.Pair;
import androidx.annotation.RequiresApi;
import androidx.sqlite.db.SupportSQLiteCompat;
import androidx.sqlite.db.SupportSQLiteDatabase;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001:\u0003\u0011\u0012\u0013J\b\u0010\f\u001a\u00020\rH&J\u0010\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H'R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\t\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0014\u00c0\u0006\u0001"}, d2={"Landroidx/sqlite/db/SupportSQLiteOpenHelper;", "Ljava/io/Closeable;", "databaseName", "", "getDatabaseName", "()Ljava/lang/String;", "readableDatabase", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "getReadableDatabase", "()Landroidx/sqlite/db/SupportSQLiteDatabase;", "writableDatabase", "getWritableDatabase", "close", "", "setWriteAheadLoggingEnabled", "enabled", "", "Callback", "Configuration", "Factory", "sqlite_release"})
public interface SupportSQLiteOpenHelper
extends Closeable {
    @Nullable
    public String getDatabaseName();

    @RequiresApi(api=16)
    public void setWriteAheadLoggingEnabled(boolean var1);

    @NotNull
    public SupportSQLiteDatabase getWritableDatabase();

    @NotNull
    public SupportSQLiteDatabase getReadableDatabase();

    @Override
    public void close();

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b&\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH&J \u0010\u000e\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0016J\u0010\u0010\u0011\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016J \u0010\u0012\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H&R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Landroidx/sqlite/db/SupportSQLiteOpenHelper$Callback;", "", "version", "", "(I)V", "deleteDatabaseFile", "", "fileName", "", "onConfigure", "db", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "onCorruption", "onCreate", "onDowngrade", "oldVersion", "newVersion", "onOpen", "onUpgrade", "Companion", "sqlite_release"})
    @SourceDebugExtension(value={"SMAP\nSupportSQLiteOpenHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SupportSQLiteOpenHelper.kt\nandroidx/sqlite/db/SupportSQLiteOpenHelper$Callback\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,426:1\n1#2:427\n1855#3,2:428\n107#4:430\n79#4,22:431\n*S KotlinDebug\n*F\n+ 1 SupportSQLiteOpenHelper.kt\nandroidx/sqlite/db/SupportSQLiteOpenHelper$Callback\n*L\n243#1:428,2\n251#1:430\n251#1:431,22\n*E\n"})
    public static abstract class Callback {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        public final int version;
        @NotNull
        private static final String TAG = "SupportSQLite";

        public Callback(int version2) {
            this.version = version2;
        }

        public void onConfigure(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter(db, "db");
        }

        public abstract void onCreate(@NotNull SupportSQLiteDatabase var1);

        public abstract void onUpgrade(@NotNull SupportSQLiteDatabase var1, int var2, int var3);

        public void onDowngrade(@NotNull SupportSQLiteDatabase db, int oldVersion, int newVersion) {
            Intrinsics.checkNotNullParameter(db, "db");
            throw new SQLiteException("Can't downgrade database from version " + oldVersion + " to " + newVersion);
        }

        public void onOpen(@NotNull SupportSQLiteDatabase db) {
            Intrinsics.checkNotNullParameter(db, "db");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCorruption(@NotNull SupportSQLiteDatabase db) {
            List<Pair<String, String>> list;
            Intrinsics.checkNotNullParameter(db, "db");
            Log.e((String)TAG, (String)("Corruption reported by sqlite on database: " + db + ".path"));
            if (!db.isOpen()) {
                String string2 = db.getPath();
                if (string2 != null) {
                    String it = string2;
                    boolean bl = false;
                    this.deleteDatabaseFile(it);
                }
                return;
            }
            List<Pair<String, String>> attachedDbs2 = null;
            try {
                try {
                    attachedDbs2 = db.getAttachedDbs();
                }
                catch (SQLiteException sQLiteException) {
                    // empty catch block
                }
                try {
                    db.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                list = attachedDbs2;
            }
            catch (Throwable throwable) {
                List<Pair<String, String>> list2 = attachedDbs2;
                if (list2 != null) {
                    Iterable $this$forEach$iv = list2;
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        Pair p = (Pair)element$iv;
                        boolean bl = false;
                        Object object = p.second;
                        Intrinsics.checkNotNullExpressionValue(object, "p.second");
                        this.deleteDatabaseFile((String)object);
                    }
                } else {
                    String string3 = db.getPath();
                    if (string3 != null) {
                        String it = string3;
                        boolean bl = false;
                        this.deleteDatabaseFile(it);
                    }
                }
                throw throwable;
            }
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Pair p = (Pair)element$iv;
                    boolean bl = false;
                    Object object = p.second;
                    Intrinsics.checkNotNullExpressionValue(object, "p.second");
                    this.deleteDatabaseFile((String)object);
                }
            } else {
                String string4 = db.getPath();
                if (string4 != null) {
                    String it = string4;
                    boolean bl = false;
                    this.deleteDatabaseFile(it);
                }
            }
        }

        private final void deleteDatabaseFile(String fileName) {
            block14: {
                block16: {
                    block15: {
                        if (StringsKt.equals(fileName, ":memory:", true)) break block15;
                        String $this$trim$iv = fileName;
                        boolean $i$f$trim = false;
                        CharSequence $this$trim$iv$iv = $this$trim$iv;
                        boolean $i$f$trim2 = false;
                        int startIndex$iv$iv = 0;
                        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                        boolean startFound$iv$iv = false;
                        while (startIndex$iv$iv <= endIndex$iv$iv) {
                            boolean match$iv$iv;
                            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                            char it = $this$trim$iv$iv.charAt(index$iv$iv);
                            boolean bl = false;
                            boolean bl2 = match$iv$iv = Intrinsics.compare(it, 32) <= 0;
                            if (!startFound$iv$iv) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv = true;
                                    continue;
                                }
                                ++startIndex$iv$iv;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv;
                        }
                        if (!(((CharSequence)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString()).length() == 0)) break block16;
                    }
                    return;
                }
                Log.w((String)TAG, (String)("deleting the database file: " + fileName));
                try {
                    if (Build.VERSION.SDK_INT >= 16) {
                        SupportSQLiteCompat.Api16Impl.deleteDatabase(new File(fileName));
                        break block14;
                    }
                    try {
                        boolean deleted = new File(fileName).delete();
                        if (!deleted) {
                            Log.e((String)TAG, (String)("Could not delete the database file " + fileName));
                        }
                    }
                    catch (Exception error) {
                        Log.e((String)TAG, (String)"error while deleting corrupted database file", (Throwable)error);
                    }
                }
                catch (Exception e) {
                    Log.w((String)TAG, (String)"delete failed: ", (Throwable)e);
                }
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/sqlite/db/SupportSQLiteOpenHelper$Callback$Companion;", "", "()V", "TAG", "", "sqlite_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \r2\u00020\u0001:\u0002\f\rB3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bR\u0010\u0010\n\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/sqlite/db/SupportSQLiteOpenHelper$Configuration;", "", "context", "Landroid/content/Context;", "name", "", "callback", "Landroidx/sqlite/db/SupportSQLiteOpenHelper$Callback;", "useNoBackupDirectory", "", "allowDataLossOnRecovery", "(Landroid/content/Context;Ljava/lang/String;Landroidx/sqlite/db/SupportSQLiteOpenHelper$Callback;ZZ)V", "Builder", "Companion", "sqlite_release"})
    public static final class Configuration {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @JvmField
        @NotNull
        public final Context context;
        @JvmField
        @Nullable
        public final String name;
        @JvmField
        @NotNull
        public final Callback callback;
        @JvmField
        public final boolean useNoBackupDirectory;
        @JvmField
        public final boolean allowDataLossOnRecovery;

        public Configuration(@NotNull Context context, @Nullable String name, @NotNull Callback callback2, boolean useNoBackupDirectory, boolean allowDataLossOnRecovery) {
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(callback2, "callback");
            this.context = context;
            this.name = name;
            this.callback = callback2;
            this.useNoBackupDirectory = useNoBackupDirectory;
            this.allowDataLossOnRecovery = allowDataLossOnRecovery;
        }

        public /* synthetic */ Configuration(Context context, String string2, Callback callback2, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                bl = false;
            }
            if ((n & 0x10) != 0) {
                bl2 = false;
            }
            this(context, string2, callback2, bl, bl2);
        }

        @JvmStatic
        @NotNull
        public static final Builder builder(@NotNull Context context) {
            return Companion.builder(context);
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u000f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0007\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\t\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\u0006H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/sqlite/db/SupportSQLiteOpenHelper$Configuration$Builder;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "allowDataLossOnRecovery", "", "callback", "Landroidx/sqlite/db/SupportSQLiteOpenHelper$Callback;", "name", "", "useNoBackupDirectory", "build", "Landroidx/sqlite/db/SupportSQLiteOpenHelper$Configuration;", "noBackupDirectory", "sqlite_release"})
        public static class Builder {
            @NotNull
            private final Context context;
            @Nullable
            private String name;
            @Nullable
            private Callback callback;
            private boolean useNoBackupDirectory;
            private boolean allowDataLossOnRecovery;

            public Builder(@NotNull Context context) {
                Intrinsics.checkNotNullParameter(context, "context");
                this.context = context;
            }

            @NotNull
            public Configuration build() {
                CharSequence charSequence;
                Callback callback2 = this.callback;
                if (callback2 == null) {
                    boolean bl = false;
                    String string2 = "Must set a callback to create the configuration.";
                    throw new IllegalArgumentException(string2.toString());
                }
                if (!(!this.useNoBackupDirectory || !((charSequence = (CharSequence)this.name) == null || charSequence.length() == 0))) {
                    boolean bl = false;
                    String string3 = "Must set a non-null database name to a configuration that uses the no backup directory.";
                    throw new IllegalArgumentException(string3.toString());
                }
                return new Configuration(this.context, this.name, callback2, this.useNoBackupDirectory, this.allowDataLossOnRecovery);
            }

            @NotNull
            public Builder name(@Nullable String name) {
                Builder builder;
                Builder $this$name_u24lambda_u242 = builder = this;
                boolean bl = false;
                $this$name_u24lambda_u242.name = name;
                return builder;
            }

            @NotNull
            public Builder callback(@NotNull Callback callback2) {
                Builder builder;
                Intrinsics.checkNotNullParameter(callback2, "callback");
                Builder $this$callback_u24lambda_u243 = builder = this;
                boolean bl = false;
                $this$callback_u24lambda_u243.callback = callback2;
                return builder;
            }

            @NotNull
            public Builder noBackupDirectory(boolean useNoBackupDirectory) {
                Builder builder;
                Builder $this$noBackupDirectory_u24lambda_u244 = builder = this;
                boolean bl = false;
                $this$noBackupDirectory_u24lambda_u244.useNoBackupDirectory = useNoBackupDirectory;
                return builder;
            }

            @NotNull
            public Builder allowDataLossOnRecovery(boolean allowDataLossOnRecovery) {
                Builder builder;
                Builder $this$allowDataLossOnRecovery_u24lambda_u245 = builder = this;
                boolean bl = false;
                $this$allowDataLossOnRecovery_u24lambda_u245.allowDataLossOnRecovery = allowDataLossOnRecovery;
                return builder;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Landroidx/sqlite/db/SupportSQLiteOpenHelper$Configuration$Companion;", "", "()V", "builder", "Landroidx/sqlite/db/SupportSQLiteOpenHelper$Configuration$Builder;", "context", "Landroid/content/Context;", "sqlite_release"})
        public static final class Companion {
            private Companion() {
            }

            @JvmStatic
            @NotNull
            public final Builder builder(@NotNull Context context) {
                Intrinsics.checkNotNullParameter(context, "context");
                return new Builder(context);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Landroidx/sqlite/db/SupportSQLiteOpenHelper$Factory;", "", "create", "Landroidx/sqlite/db/SupportSQLiteOpenHelper;", "configuration", "Landroidx/sqlite/db/SupportSQLiteOpenHelper$Configuration;", "sqlite_release"})
    public static interface Factory {
        @NotNull
        public SupportSQLiteOpenHelper create(@NotNull Configuration var1);
    }
}

