/*
 * Decompiled with CFR 0.152.
 */
package androidx.sqlite.db.framework;

import android.content.Context;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteOpenHelper;
import android.os.Build;
import android.util.Log;
import androidx.annotation.RequiresApi;
import androidx.sqlite.db.SupportSQLiteCompat;
import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import androidx.sqlite.db.framework.FrameworkSQLiteDatabase;
import androidx.sqlite.util.ProcessLock;
import java.io.File;
import java.io.Serializable;
import java.util.UUID;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0003\"#$B5\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\tH\u0017R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\u0004\u0018\u00010\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001b\u0010\u000f\u001a\u00020\u00108BX\u0082\u0084\u0002\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014*\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u000e\u0010\u001d\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Landroidx/sqlite/db/framework/FrameworkSQLiteOpenHelper;", "Landroidx/sqlite/db/SupportSQLiteOpenHelper;", "context", "Landroid/content/Context;", "name", "", "callback", "Landroidx/sqlite/db/SupportSQLiteOpenHelper$Callback;", "useNoBackupDirectory", "", "allowDataLossOnRecovery", "(Landroid/content/Context;Ljava/lang/String;Landroidx/sqlite/db/SupportSQLiteOpenHelper$Callback;ZZ)V", "databaseName", "getDatabaseName", "()Ljava/lang/String;", "delegate", "Landroidx/sqlite/db/framework/FrameworkSQLiteOpenHelper$OpenHelper;", "getDelegate$delegate", "(Landroidx/sqlite/db/framework/FrameworkSQLiteOpenHelper;)Ljava/lang/Object;", "getDelegate", "()Landroidx/sqlite/db/framework/FrameworkSQLiteOpenHelper$OpenHelper;", "lazyDelegate", "Lkotlin/Lazy;", "readableDatabase", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "getReadableDatabase", "()Landroidx/sqlite/db/SupportSQLiteDatabase;", "writableDatabase", "getWritableDatabase", "writeAheadLoggingEnabled", "close", "", "setWriteAheadLoggingEnabled", "enabled", "Companion", "DBRefHolder", "OpenHelper", "sqlite-framework_release"})
public final class FrameworkSQLiteOpenHelper
implements SupportSQLiteOpenHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @Nullable
    private final String name;
    @NotNull
    private final SupportSQLiteOpenHelper.Callback callback;
    private final boolean useNoBackupDirectory;
    private final boolean allowDataLossOnRecovery;
    @NotNull
    private final Lazy<OpenHelper> lazyDelegate;
    private boolean writeAheadLoggingEnabled;
    @NotNull
    private static final String TAG = "SupportSQLite";

    @JvmOverloads
    public FrameworkSQLiteOpenHelper(@NotNull Context context, @Nullable String name, @NotNull SupportSQLiteOpenHelper.Callback callback2, boolean useNoBackupDirectory, boolean allowDataLossOnRecovery) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(callback2, "callback");
        this.context = context;
        this.name = name;
        this.callback = callback2;
        this.useNoBackupDirectory = useNoBackupDirectory;
        this.allowDataLossOnRecovery = allowDataLossOnRecovery;
        this.lazyDelegate = LazyKt.lazy((Function0)new Function0<OpenHelper>(this){
            final /* synthetic */ FrameworkSQLiteOpenHelper this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final OpenHelper invoke() {
                OpenHelper openHelper = null;
                if (Build.VERSION.SDK_INT >= 23 && FrameworkSQLiteOpenHelper.access$getName$p(this.this$0) != null && FrameworkSQLiteOpenHelper.access$getUseNoBackupDirectory$p(this.this$0)) {
                    File file = new File(SupportSQLiteCompat.Api21Impl.getNoBackupFilesDir(FrameworkSQLiteOpenHelper.access$getContext$p(this.this$0)), FrameworkSQLiteOpenHelper.access$getName$p(this.this$0));
                    openHelper = new OpenHelper(FrameworkSQLiteOpenHelper.access$getContext$p(this.this$0), file.getAbsolutePath(), new DBRefHolder(null), FrameworkSQLiteOpenHelper.access$getCallback$p(this.this$0), FrameworkSQLiteOpenHelper.access$getAllowDataLossOnRecovery$p(this.this$0));
                } else {
                    openHelper = new OpenHelper(FrameworkSQLiteOpenHelper.access$getContext$p(this.this$0), FrameworkSQLiteOpenHelper.access$getName$p(this.this$0), new DBRefHolder(null), FrameworkSQLiteOpenHelper.access$getCallback$p(this.this$0), FrameworkSQLiteOpenHelper.access$getAllowDataLossOnRecovery$p(this.this$0));
                }
                if (Build.VERSION.SDK_INT >= 16) {
                    SupportSQLiteCompat.Api16Impl.setWriteAheadLoggingEnabled(openHelper, FrameworkSQLiteOpenHelper.access$getWriteAheadLoggingEnabled$p(this.this$0));
                }
                return openHelper;
            }
        });
    }

    public /* synthetic */ FrameworkSQLiteOpenHelper(Context context, String string2, SupportSQLiteOpenHelper.Callback callback2, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            bl = false;
        }
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        this(context, string2, callback2, bl, bl2);
    }

    private final OpenHelper getDelegate() {
        Lazy<OpenHelper> lazy = this.lazyDelegate;
        return lazy.getValue();
    }

    private static Object getDelegate$delegate(FrameworkSQLiteOpenHelper frameworkSQLiteOpenHelper) {
        return frameworkSQLiteOpenHelper.lazyDelegate;
    }

    @Override
    @Nullable
    public String getDatabaseName() {
        return this.name;
    }

    @Override
    @RequiresApi(api=16)
    public void setWriteAheadLoggingEnabled(boolean enabled) {
        if (this.lazyDelegate.isInitialized()) {
            SupportSQLiteCompat.Api16Impl.setWriteAheadLoggingEnabled(this.getDelegate(), enabled);
        }
        this.writeAheadLoggingEnabled = enabled;
    }

    @Override
    @NotNull
    public SupportSQLiteDatabase getWritableDatabase() {
        return this.getDelegate().getSupportDatabase(true);
    }

    @Override
    @NotNull
    public SupportSQLiteDatabase getReadableDatabase() {
        return this.getDelegate().getSupportDatabase(false);
    }

    @Override
    public void close() {
        if (this.lazyDelegate.isInitialized()) {
            this.getDelegate().close();
        }
    }

    @JvmOverloads
    public FrameworkSQLiteOpenHelper(@NotNull Context context, @Nullable String name, @NotNull SupportSQLiteOpenHelper.Callback callback2, boolean useNoBackupDirectory) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(callback2, "callback");
        this(context, name, callback2, useNoBackupDirectory, false, 16, null);
    }

    @JvmOverloads
    public FrameworkSQLiteOpenHelper(@NotNull Context context, @Nullable String name, @NotNull SupportSQLiteOpenHelper.Callback callback2) {
        Intrinsics.checkNotNullParameter(context, "context");
        Intrinsics.checkNotNullParameter(callback2, "callback");
        this(context, name, callback2, false, false, 24, null);
    }

    public static final /* synthetic */ String access$getName$p(FrameworkSQLiteOpenHelper $this) {
        return $this.name;
    }

    public static final /* synthetic */ boolean access$getUseNoBackupDirectory$p(FrameworkSQLiteOpenHelper $this) {
        return $this.useNoBackupDirectory;
    }

    public static final /* synthetic */ Context access$getContext$p(FrameworkSQLiteOpenHelper $this) {
        return $this.context;
    }

    public static final /* synthetic */ SupportSQLiteOpenHelper.Callback access$getCallback$p(FrameworkSQLiteOpenHelper $this) {
        return $this.callback;
    }

    public static final /* synthetic */ boolean access$getAllowDataLossOnRecovery$p(FrameworkSQLiteOpenHelper $this) {
        return $this.allowDataLossOnRecovery;
    }

    public static final /* synthetic */ boolean access$getWriteAheadLoggingEnabled$p(FrameworkSQLiteOpenHelper $this) {
        return $this.writeAheadLoggingEnabled;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/sqlite/db/framework/FrameworkSQLiteOpenHelper$Companion;", "", "()V", "TAG", "", "sqlite-framework_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\b"}, d2={"Landroidx/sqlite/db/framework/FrameworkSQLiteOpenHelper$DBRefHolder;", "", "db", "Landroidx/sqlite/db/framework/FrameworkSQLiteDatabase;", "(Landroidx/sqlite/db/framework/FrameworkSQLiteDatabase;)V", "getDb", "()Landroidx/sqlite/db/framework/FrameworkSQLiteDatabase;", "setDb", "sqlite-framework_release"})
    private static final class DBRefHolder {
        @Nullable
        private FrameworkSQLiteDatabase db;

        public DBRefHolder(@Nullable FrameworkSQLiteDatabase db) {
            this.db = db;
        }

        @Nullable
        public final FrameworkSQLiteDatabase getDb() {
            return this.db;
        }

        public final void setDb(@Nullable FrameworkSQLiteDatabase frameworkSQLiteDatabase) {
            this.db = frameworkSQLiteDatabase;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u0000 /2\u00020\u0001:\u0003-./B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u000bJ\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u0010\u0010#\u001a\u00020!2\u0006\u0010\u001d\u001a\u00020\u000bH\u0002J\u0010\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020!H\u0016J\u0010\u0010&\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0016J \u0010'\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020!2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0016J\u0010\u0010+\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020!H\u0016J \u0010,\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020!2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)H\u0016R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Landroidx/sqlite/db/framework/FrameworkSQLiteOpenHelper$OpenHelper;", "Landroid/database/sqlite/SQLiteOpenHelper;", "context", "Landroid/content/Context;", "name", "", "dbRef", "Landroidx/sqlite/db/framework/FrameworkSQLiteOpenHelper$DBRefHolder;", "callback", "Landroidx/sqlite/db/SupportSQLiteOpenHelper$Callback;", "allowDataLossOnRecovery", "", "(Landroid/content/Context;Ljava/lang/String;Landroidx/sqlite/db/framework/FrameworkSQLiteOpenHelper$DBRefHolder;Landroidx/sqlite/db/SupportSQLiteOpenHelper$Callback;Z)V", "getAllowDataLossOnRecovery", "()Z", "getCallback", "()Landroidx/sqlite/db/SupportSQLiteOpenHelper$Callback;", "getContext", "()Landroid/content/Context;", "getDbRef", "()Landroidx/sqlite/db/framework/FrameworkSQLiteOpenHelper$DBRefHolder;", "lock", "Landroidx/sqlite/util/ProcessLock;", "migrated", "opened", "close", "", "getSupportDatabase", "Landroidx/sqlite/db/SupportSQLiteDatabase;", "writable", "getWrappedDb", "Landroidx/sqlite/db/framework/FrameworkSQLiteDatabase;", "sqLiteDatabase", "Landroid/database/sqlite/SQLiteDatabase;", "getWritableOrReadableDatabase", "innerGetDatabase", "onConfigure", "db", "onCreate", "onDowngrade", "oldVersion", "", "newVersion", "onOpen", "onUpgrade", "CallbackException", "CallbackName", "Companion", "sqlite-framework_release"})
    private static final class OpenHelper
    extends SQLiteOpenHelper {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final Context context;
        @NotNull
        private final DBRefHolder dbRef;
        @NotNull
        private final SupportSQLiteOpenHelper.Callback callback;
        private final boolean allowDataLossOnRecovery;
        private boolean migrated;
        @NotNull
        private final ProcessLock lock;
        private boolean opened;

        public OpenHelper(@NotNull Context context, @Nullable String name, @NotNull DBRefHolder dbRef, @NotNull SupportSQLiteOpenHelper.Callback callback2, boolean allowDataLossOnRecovery) {
            Intrinsics.checkNotNullParameter(context, "context");
            Intrinsics.checkNotNullParameter(dbRef, "dbRef");
            Intrinsics.checkNotNullParameter(callback2, "callback");
            super(context, name, null, callback2.version, arg_0 -> OpenHelper._init_$lambda$0(callback2, dbRef, arg_0));
            this.context = context;
            this.dbRef = dbRef;
            this.callback = callback2;
            this.allowDataLossOnRecovery = allowDataLossOnRecovery;
            String string2 = name;
            if (string2 == null) {
                String string3 = UUID.randomUUID().toString();
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue(string3, "randomUUID().toString()");
            }
            this.lock = new ProcessLock(string2, this.context.getCacheDir(), false);
        }

        @NotNull
        public final Context getContext() {
            return this.context;
        }

        @NotNull
        public final DBRefHolder getDbRef() {
            return this.dbRef;
        }

        @NotNull
        public final SupportSQLiteOpenHelper.Callback getCallback() {
            return this.callback;
        }

        public final boolean getAllowDataLossOnRecovery() {
            return this.allowDataLossOnRecovery;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final SupportSQLiteDatabase getSupportDatabase(boolean writable) {
            SupportSQLiteDatabase supportSQLiteDatabase;
            try {
                this.lock.lock(!this.opened && this.getDatabaseName() != null);
                this.migrated = false;
                SQLiteDatabase db = this.innerGetDatabase(writable);
                if (this.migrated) {
                    this.close();
                    SupportSQLiteDatabase supportSQLiteDatabase2 = this.getSupportDatabase(writable);
                    return supportSQLiteDatabase2;
                }
                supportSQLiteDatabase = this.getWrappedDb(db);
            }
            finally {
                this.lock.unlock();
            }
            return supportSQLiteDatabase;
        }

        private final SQLiteDatabase innerGetDatabase(boolean writable) {
            File databaseFile;
            Serializable parentFile;
            String name = this.getDatabaseName();
            boolean isOpen = this.opened;
            if (name != null && !isOpen && (parentFile = (databaseFile = this.context.getDatabasePath(name)).getParentFile()) != null) {
                ((File)parentFile).mkdirs();
                if (!((File)parentFile).isDirectory()) {
                    Log.w((String)FrameworkSQLiteOpenHelper.TAG, (String)("Invalid database parent file, not a directory: " + parentFile));
                }
            }
            try {
                return this.getWritableOrReadableDatabase(writable);
            }
            catch (Throwable t2) {
                super.close();
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException t2) {
                    // empty catch block
                }
                try {
                    return this.getWritableOrReadableDatabase(writable);
                }
                catch (Throwable t3) {
                    super.close();
                    Serializable openRetryError = parentFile = t3;
                    if (openRetryError instanceof CallbackException) {
                        Throwable cause = ((CallbackException)openRetryError).getCause();
                        switch (WhenMappings.$EnumSwitchMapping$0[((CallbackException)openRetryError).getCallbackName().ordinal()]) {
                            case 1: 
                            case 2: 
                            case 3: 
                            case 4: {
                                throw cause;
                            }
                        }
                        if (!(cause instanceof SQLiteException)) {
                            throw cause;
                        }
                    } else if (openRetryError instanceof SQLiteException) {
                        if (name == null || !this.allowDataLossOnRecovery) {
                            throw openRetryError;
                        }
                    } else {
                        throw openRetryError;
                    }
                    this.context.deleteDatabase(name);
                    try {
                        return this.getWritableOrReadableDatabase(writable);
                    }
                    catch (CallbackException ex) {
                        throw ex.getCause();
                    }
                }
            }
        }

        private final SQLiteDatabase getWritableOrReadableDatabase(boolean writable) {
            SQLiteDatabase sQLiteDatabase;
            if (writable) {
                SQLiteDatabase sQLiteDatabase2 = super.getWritableDatabase();
                sQLiteDatabase = sQLiteDatabase2;
                Intrinsics.checkNotNullExpressionValue(sQLiteDatabase2, "{\n                super.\u2026eDatabase()\n            }");
            } else {
                SQLiteDatabase sQLiteDatabase3 = super.getReadableDatabase();
                sQLiteDatabase = sQLiteDatabase3;
                Intrinsics.checkNotNullExpressionValue(sQLiteDatabase3, "{\n                super.\u2026eDatabase()\n            }");
            }
            return sQLiteDatabase;
        }

        @NotNull
        public final FrameworkSQLiteDatabase getWrappedDb(@NotNull SQLiteDatabase sqLiteDatabase) {
            Intrinsics.checkNotNullParameter(sqLiteDatabase, "sqLiteDatabase");
            return Companion.getWrappedDb(this.dbRef, sqLiteDatabase);
        }

        public void onCreate(@NotNull SQLiteDatabase sqLiteDatabase) {
            Intrinsics.checkNotNullParameter(sqLiteDatabase, "sqLiteDatabase");
            try {
                this.callback.onCreate(this.getWrappedDb(sqLiteDatabase));
            }
            catch (Throwable t) {
                throw new CallbackException(CallbackName.ON_CREATE, t);
            }
        }

        public void onUpgrade(@NotNull SQLiteDatabase sqLiteDatabase, int oldVersion, int newVersion) {
            Intrinsics.checkNotNullParameter(sqLiteDatabase, "sqLiteDatabase");
            this.migrated = true;
            try {
                this.callback.onUpgrade(this.getWrappedDb(sqLiteDatabase), oldVersion, newVersion);
            }
            catch (Throwable t) {
                throw new CallbackException(CallbackName.ON_UPGRADE, t);
            }
        }

        public void onConfigure(@NotNull SQLiteDatabase db) {
            Intrinsics.checkNotNullParameter(db, "db");
            if (!this.migrated && this.callback.version != db.getVersion()) {
                db.setMaxSqlCacheSize(1);
            }
            try {
                this.callback.onConfigure(this.getWrappedDb(db));
            }
            catch (Throwable t) {
                throw new CallbackException(CallbackName.ON_CONFIGURE, t);
            }
        }

        public void onDowngrade(@NotNull SQLiteDatabase db, int oldVersion, int newVersion) {
            Intrinsics.checkNotNullParameter(db, "db");
            this.migrated = true;
            try {
                this.callback.onDowngrade(this.getWrappedDb(db), oldVersion, newVersion);
            }
            catch (Throwable t) {
                throw new CallbackException(CallbackName.ON_DOWNGRADE, t);
            }
        }

        public void onOpen(@NotNull SQLiteDatabase db) {
            Intrinsics.checkNotNullParameter(db, "db");
            if (!this.migrated) {
                try {
                    this.callback.onOpen(this.getWrappedDb(db));
                }
                catch (Throwable t) {
                    throw new CallbackException(CallbackName.ON_OPEN, t);
                }
            }
            this.opened = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                ProcessLock.lock$default(this.lock, false, 1, null);
                super.close();
                this.dbRef.setDb(null);
                this.opened = false;
            }
            finally {
                this.lock.unlock();
            }
        }

        private static final void _init_$lambda$0(SupportSQLiteOpenHelper.Callback $callback, DBRefHolder $dbRef, SQLiteDatabase dbObj) {
            Intrinsics.checkNotNullParameter($callback, "$callback");
            Intrinsics.checkNotNullParameter($dbRef, "$dbRef");
            Intrinsics.checkNotNullExpressionValue(dbObj, "dbObj");
            $callback.onCorruption(Companion.getWrappedDb($dbRef, dbObj));
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0006\b\u0002\u0018\u00002\u00060\u0001j\u0002`\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Landroidx/sqlite/db/framework/FrameworkSQLiteOpenHelper$OpenHelper$CallbackException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "callbackName", "Landroidx/sqlite/db/framework/FrameworkSQLiteOpenHelper$OpenHelper$CallbackName;", "cause", "", "(Landroidx/sqlite/db/framework/FrameworkSQLiteOpenHelper$OpenHelper$CallbackName;Ljava/lang/Throwable;)V", "getCallbackName", "()Landroidx/sqlite/db/framework/FrameworkSQLiteOpenHelper$OpenHelper$CallbackName;", "getCause", "()Ljava/lang/Throwable;", "sqlite-framework_release"})
        private static final class CallbackException
        extends RuntimeException {
            @NotNull
            private final CallbackName callbackName;
            @NotNull
            private final Throwable cause;

            public CallbackException(@NotNull CallbackName callbackName, @NotNull Throwable cause) {
                Intrinsics.checkNotNullParameter((Object)callbackName, "callbackName");
                Intrinsics.checkNotNullParameter(cause, "cause");
                super(cause);
                this.callbackName = callbackName;
                this.cause = cause;
            }

            @NotNull
            public final CallbackName getCallbackName() {
                return this.callbackName;
            }

            @Override
            @NotNull
            public Throwable getCause() {
                return this.cause;
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0007\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Landroidx/sqlite/db/framework/FrameworkSQLiteOpenHelper$OpenHelper$CallbackName;", "", "(Ljava/lang/String;I)V", "ON_CONFIGURE", "ON_CREATE", "ON_UPGRADE", "ON_DOWNGRADE", "ON_OPEN", "sqlite-framework_release"})
        public static final class CallbackName
        extends Enum<CallbackName> {
            public static final /* enum */ CallbackName ON_CONFIGURE = new CallbackName();
            public static final /* enum */ CallbackName ON_CREATE = new CallbackName();
            public static final /* enum */ CallbackName ON_UPGRADE = new CallbackName();
            public static final /* enum */ CallbackName ON_DOWNGRADE = new CallbackName();
            public static final /* enum */ CallbackName ON_OPEN = new CallbackName();
            private static final /* synthetic */ CallbackName[] $VALUES;

            public static CallbackName[] values() {
                return (CallbackName[])$VALUES.clone();
            }

            public static CallbackName valueOf(String value) {
                return Enum.valueOf(CallbackName.class, value);
            }

            static {
                $VALUES = callbackNameArray = new CallbackName[]{CallbackName.ON_CONFIGURE, CallbackName.ON_CREATE, CallbackName.ON_UPGRADE, CallbackName.ON_DOWNGRADE, CallbackName.ON_OPEN};
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Landroidx/sqlite/db/framework/FrameworkSQLiteOpenHelper$OpenHelper$Companion;", "", "()V", "getWrappedDb", "Landroidx/sqlite/db/framework/FrameworkSQLiteDatabase;", "refHolder", "Landroidx/sqlite/db/framework/FrameworkSQLiteOpenHelper$DBRefHolder;", "sqLiteDatabase", "Landroid/database/sqlite/SQLiteDatabase;", "sqlite-framework_release"})
        @SourceDebugExtension(value={"SMAP\nFrameworkSQLiteOpenHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrameworkSQLiteOpenHelper.kt\nandroidx/sqlite/db/framework/FrameworkSQLiteOpenHelper$OpenHelper$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,342:1\n1#2:343\n*E\n"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final FrameworkSQLiteDatabase getWrappedDb(@NotNull DBRefHolder refHolder, @NotNull SQLiteDatabase sqLiteDatabase) {
                FrameworkSQLiteDatabase frameworkSQLiteDatabase;
                Intrinsics.checkNotNullParameter(refHolder, "refHolder");
                Intrinsics.checkNotNullParameter(sqLiteDatabase, "sqLiteDatabase");
                FrameworkSQLiteDatabase dbRef = refHolder.getDb();
                if (dbRef == null || !dbRef.isDelegate(sqLiteDatabase)) {
                    FrameworkSQLiteDatabase frameworkSQLiteDatabase2;
                    FrameworkSQLiteDatabase it = frameworkSQLiteDatabase2 = new FrameworkSQLiteDatabase(sqLiteDatabase);
                    boolean bl = false;
                    refHolder.setDb(it);
                    frameworkSQLiteDatabase = frameworkSQLiteDatabase2;
                } else {
                    frameworkSQLiteDatabase = dbRef;
                }
                return frameworkSQLiteDatabase;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[CallbackName.values().length];
                try {
                    nArray[CallbackName.ON_CONFIGURE.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CallbackName.ON_CREATE.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CallbackName.ON_UPGRADE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CallbackName.ON_DOWNGRADE.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[CallbackName.ON_OPEN.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

