/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TypeEvaluator;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.transition.ImageViewUtils;
import androidx.transition.MatrixUtils;
import androidx.transition.R;
import androidx.transition.Transition;
import androidx.transition.TransitionUtils;
import androidx.transition.TransitionValues;
import java.util.Map;

public class ChangeImageTransform
extends Transition {
    private static final String PROPNAME_MATRIX = "android:changeImageTransform:matrix";
    private static final String PROPNAME_BOUNDS = "android:changeImageTransform:bounds";
    private static final String[] sTransitionProperties = new String[]{"android:changeImageTransform:matrix", "android:changeImageTransform:bounds"};
    private static final TypeEvaluator<Matrix> NULL_MATRIX_EVALUATOR = new TypeEvaluator<Matrix>(){

        public Matrix evaluate(float fraction, Matrix startValue, Matrix endValue) {
            return null;
        }
    };
    private static final Property<ImageView, Matrix> ANIMATED_TRANSFORM_PROPERTY = new Property<ImageView, Matrix>(Matrix.class, "animatedTransform"){

        public void set(ImageView view, Matrix matrix) {
            ImageViewUtils.animateTransform(view, matrix);
        }

        public Matrix get(ImageView object) {
            return null;
        }
    };

    public ChangeImageTransform() {
    }

    public ChangeImageTransform(@NonNull Context context, @NonNull AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public boolean isSeekingSupported() {
        return true;
    }

    private void captureValues(TransitionValues transitionValues, boolean useIntermediate) {
        View view = transitionValues.view;
        if (!(view instanceof ImageView) || view.getVisibility() != 0) {
            return;
        }
        ImageView imageView = (ImageView)view;
        Drawable drawable2 = imageView.getDrawable();
        if (drawable2 == null) {
            return;
        }
        Map<String, Object> values2 = transitionValues.values;
        int left = view.getLeft();
        int top = view.getTop();
        int right = view.getRight();
        int bottom = view.getBottom();
        Rect bounds = new Rect(left, top, right, bottom);
        values2.put(PROPNAME_BOUNDS, bounds);
        Matrix matrix = null;
        if (useIntermediate) {
            matrix = (Matrix)imageView.getTag(R.id.transition_image_transform);
        }
        if (matrix == null) {
            matrix = ChangeImageTransform.copyImageMatrix(imageView);
        }
        values2.put(PROPNAME_MATRIX, matrix);
    }

    @Override
    public void captureStartValues(@NonNull TransitionValues transitionValues) {
        this.captureValues(transitionValues, true);
    }

    @Override
    public void captureEndValues(@NonNull TransitionValues transitionValues) {
        this.captureValues(transitionValues, false);
    }

    @Override
    @NonNull
    public String[] getTransitionProperties() {
        return sTransitionProperties;
    }

    @Override
    @Nullable
    public Animator createAnimator(@NonNull ViewGroup sceneRoot, @Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        ObjectAnimator animator2;
        boolean matricesEqual;
        if (startValues == null || endValues == null) {
            return null;
        }
        Rect startBounds = (Rect)startValues.values.get(PROPNAME_BOUNDS);
        Rect endBounds = (Rect)endValues.values.get(PROPNAME_BOUNDS);
        if (startBounds == null || endBounds == null) {
            return null;
        }
        Matrix startMatrix = (Matrix)startValues.values.get(PROPNAME_MATRIX);
        Matrix endMatrix = (Matrix)endValues.values.get(PROPNAME_MATRIX);
        boolean bl = matricesEqual = startMatrix == null && endMatrix == null || startMatrix != null && startMatrix.equals((Object)endMatrix);
        if (startBounds.equals((Object)endBounds) && matricesEqual) {
            return null;
        }
        ImageView imageView = (ImageView)endValues.view;
        Drawable drawable2 = imageView.getDrawable();
        int drawableWidth = drawable2.getIntrinsicWidth();
        int drawableHeight = drawable2.getIntrinsicHeight();
        if (drawableWidth <= 0 || drawableHeight <= 0) {
            animator2 = this.createNullAnimator(imageView);
        } else {
            if (startMatrix == null) {
                startMatrix = MatrixUtils.IDENTITY_MATRIX;
            }
            if (endMatrix == null) {
                endMatrix = MatrixUtils.IDENTITY_MATRIX;
            }
            ANIMATED_TRANSFORM_PROPERTY.set((Object)imageView, (Object)startMatrix);
            animator2 = this.createMatrixAnimator(imageView, startMatrix, endMatrix);
            Listener listener2 = new Listener(imageView, startMatrix, endMatrix);
            animator2.addListener((Animator.AnimatorListener)listener2);
            animator2.addPauseListener((Animator.AnimatorPauseListener)listener2);
            this.addListener(listener2);
        }
        return animator2;
    }

    @NonNull
    private ObjectAnimator createNullAnimator(@NonNull ImageView imageView) {
        return ObjectAnimator.ofObject((Object)imageView, ANIMATED_TRANSFORM_PROPERTY, NULL_MATRIX_EVALUATOR, (Object[])new Matrix[]{MatrixUtils.IDENTITY_MATRIX, MatrixUtils.IDENTITY_MATRIX});
    }

    private ObjectAnimator createMatrixAnimator(ImageView imageView, Matrix startMatrix, Matrix endMatrix) {
        return ObjectAnimator.ofObject((Object)imageView, ANIMATED_TRANSFORM_PROPERTY, (TypeEvaluator)new TransitionUtils.MatrixEvaluator(), (Object[])new Matrix[]{startMatrix, endMatrix});
    }

    @NonNull
    private static Matrix copyImageMatrix(@NonNull ImageView view) {
        Drawable image = view.getDrawable();
        if (image.getIntrinsicWidth() > 0 && image.getIntrinsicHeight() > 0) {
            switch (view.getScaleType()) {
                case FIT_XY: {
                    return ChangeImageTransform.fitXYMatrix(view);
                }
                case CENTER_CROP: {
                    return ChangeImageTransform.centerCropMatrix(view);
                }
            }
            return new Matrix(view.getImageMatrix());
        }
        return new Matrix(view.getImageMatrix());
    }

    private static Matrix fitXYMatrix(ImageView view) {
        Drawable image = view.getDrawable();
        Matrix matrix = new Matrix();
        matrix.postScale((float)view.getWidth() / (float)image.getIntrinsicWidth(), (float)view.getHeight() / (float)image.getIntrinsicHeight());
        return matrix;
    }

    private static Matrix centerCropMatrix(ImageView view) {
        Drawable image = view.getDrawable();
        int imageWidth = image.getIntrinsicWidth();
        int imageViewWidth = view.getWidth();
        float scaleX = (float)imageViewWidth / (float)imageWidth;
        int imageHeight = image.getIntrinsicHeight();
        int imageViewHeight = view.getHeight();
        float scaleY = (float)imageViewHeight / (float)imageHeight;
        float maxScale = Math.max(scaleX, scaleY);
        float width = (float)imageWidth * maxScale;
        float height = (float)imageHeight * maxScale;
        int tx = Math.round(((float)imageViewWidth - width) / 2.0f);
        int ty = Math.round(((float)imageViewHeight - height) / 2.0f);
        Matrix matrix = new Matrix();
        matrix.postScale(maxScale, maxScale);
        matrix.postTranslate((float)tx, (float)ty);
        return matrix;
    }

    private static class Listener
    extends AnimatorListenerAdapter
    implements Transition.TransitionListener {
        private final ImageView mImageView;
        private final Matrix mStartMatrix;
        private final Matrix mEndMatrix;
        private boolean mIsBeforeAnimator = true;

        Listener(ImageView imageView, Matrix startMatrix, Matrix endMatrix) {
            this.mImageView = imageView;
            this.mStartMatrix = startMatrix;
            this.mEndMatrix = endMatrix;
        }

        @Override
        public void onTransitionStart(@NonNull Transition transition) {
        }

        @Override
        public void onTransitionEnd(@NonNull Transition transition) {
        }

        @Override
        public void onTransitionCancel(@NonNull Transition transition) {
        }

        @Override
        public void onTransitionPause(@NonNull Transition transition) {
            if (this.mIsBeforeAnimator) {
                this.saveMatrix(this.mStartMatrix);
            }
        }

        @Override
        public void onTransitionResume(@NonNull Transition transition) {
            this.restoreMatrix();
        }

        public void onAnimationStart(@NonNull Animator animation, boolean isReverse) {
            this.mIsBeforeAnimator = false;
        }

        public void onAnimationStart(Animator animation) {
            this.mIsBeforeAnimator = false;
        }

        public void onAnimationEnd(@NonNull Animator animation, boolean isReverse) {
            this.mIsBeforeAnimator = isReverse;
        }

        public void onAnimationEnd(Animator animation) {
            this.mIsBeforeAnimator = false;
        }

        public void onAnimationPause(Animator animation) {
            Matrix pauseMatrix = (Matrix)((ObjectAnimator)animation).getAnimatedValue();
            this.saveMatrix(pauseMatrix);
        }

        public void onAnimationResume(Animator animation) {
            this.restoreMatrix();
        }

        private void restoreMatrix() {
            Matrix pauseMatrix = (Matrix)this.mImageView.getTag(R.id.transition_image_transform);
            if (pauseMatrix != null) {
                ImageViewUtils.animateTransform(this.mImageView, pauseMatrix);
                this.mImageView.setTag(R.id.transition_image_transform, null);
            }
        }

        private void saveMatrix(Matrix pauseMatrix) {
            this.mImageView.setTag(R.id.transition_image_transform, (Object)pauseMatrix);
            ImageViewUtils.animateTransform(this.mImageView, this.mEndMatrix);
        }
    }
}

