/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.annotation.SuppressLint;
import android.graphics.Rect;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.os.CancellationSignal;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransitionImpl;
import androidx.transition.Transition;
import androidx.transition.TransitionListenerAdapter;
import androidx.transition.TransitionManager;
import androidx.transition.TransitionSeekController;
import androidx.transition.TransitionSet;
import java.util.ArrayList;
import java.util.List;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class FragmentTransitionSupport
extends FragmentTransitionImpl {
    @Override
    public boolean canHandle(@NonNull Object transition) {
        return transition instanceof Transition;
    }

    @Override
    @Nullable
    public Object cloneTransition(@Nullable Object transition) {
        Transition copy = null;
        if (transition != null) {
            copy = ((Transition)transition).clone();
        }
        return copy;
    }

    @Override
    @Nullable
    public Object wrapTransitionInSet(@Nullable Object transition) {
        if (transition == null) {
            return null;
        }
        TransitionSet transitionSet = new TransitionSet();
        transitionSet.addTransition((Transition)transition);
        return transitionSet;
    }

    @Override
    public void setSharedElementTargets(@NonNull Object transitionObj, @NonNull View nonExistentView, @NonNull ArrayList<View> sharedViews) {
        TransitionSet transition = (TransitionSet)transitionObj;
        List<View> views = transition.getTargets();
        views.clear();
        int count2 = sharedViews.size();
        for (int i = 0; i < count2; ++i) {
            View view = sharedViews.get(i);
            FragmentTransitionSupport.bfsAddViewChildren(views, view);
        }
        views.add(nonExistentView);
        sharedViews.add(nonExistentView);
        this.addTargets(transition, sharedViews);
    }

    @Override
    public void setEpicenter(@NonNull Object transitionObj, @Nullable View view) {
        if (view != null) {
            Transition transition = (Transition)transitionObj;
            final Rect epicenter = new Rect();
            this.getBoundsOnScreen(view, epicenter);
            transition.setEpicenterCallback(new Transition.EpicenterCallback(){

                @Override
                public Rect onGetEpicenter(@NonNull Transition transition) {
                    return epicenter;
                }
            });
        }
    }

    @Override
    public void addTargets(@NonNull Object transitionObj, @NonNull ArrayList<View> views) {
        block4: {
            List<View> targets;
            Transition transition;
            block3: {
                transition = (Transition)transitionObj;
                if (transition == null) {
                    return;
                }
                if (!(transition instanceof TransitionSet)) break block3;
                TransitionSet set = (TransitionSet)transition;
                int numTransitions = set.getTransitionCount();
                for (int i = 0; i < numTransitions; ++i) {
                    Transition child = set.getTransitionAt(i);
                    this.addTargets(child, views);
                }
                break block4;
            }
            if (FragmentTransitionSupport.hasSimpleTarget(transition) || !FragmentTransitionSupport.isNullOrEmpty(targets = transition.getTargets())) break block4;
            int numViews = views.size();
            for (int i = 0; i < numViews; ++i) {
                transition.addTarget(views.get(i));
            }
        }
    }

    private static boolean hasSimpleTarget(Transition transition) {
        return !FragmentTransitionSupport.isNullOrEmpty(transition.getTargetIds()) || !FragmentTransitionSupport.isNullOrEmpty(transition.getTargetNames()) || !FragmentTransitionSupport.isNullOrEmpty(transition.getTargetTypes());
    }

    @Override
    @NonNull
    public Object mergeTransitionsTogether(@Nullable Object transition1, @Nullable Object transition2, @Nullable Object transition3) {
        TransitionSet transitionSet = new TransitionSet();
        if (transition1 != null) {
            transitionSet.addTransition((Transition)transition1);
        }
        if (transition2 != null) {
            transitionSet.addTransition((Transition)transition2);
        }
        if (transition3 != null) {
            transitionSet.addTransition((Transition)transition3);
        }
        return transitionSet;
    }

    @Override
    public void scheduleHideFragmentView(@NonNull Object exitTransitionObj, final @NonNull View fragmentView, final @NonNull ArrayList<View> exitingViews) {
        Transition exitTransition = (Transition)exitTransitionObj;
        exitTransition.addListener(new Transition.TransitionListener(){

            @Override
            public void onTransitionStart(@NonNull Transition transition) {
                transition.removeListener(this);
                transition.addListener(this);
            }

            @Override
            public void onTransitionEnd(@NonNull Transition transition) {
                transition.removeListener(this);
                fragmentView.setVisibility(8);
                int numViews = exitingViews.size();
                for (int i = 0; i < numViews; ++i) {
                    ((View)exitingViews.get(i)).setVisibility(0);
                }
            }

            @Override
            public void onTransitionCancel(@NonNull Transition transition) {
            }

            @Override
            public void onTransitionPause(@NonNull Transition transition) {
            }

            @Override
            public void onTransitionResume(@NonNull Transition transition) {
            }
        });
    }

    @Override
    @Nullable
    public Object mergeTransitionsInSequence(@Nullable Object exitTransitionObj, @Nullable Object enterTransitionObj, @Nullable Object sharedElementTransitionObj) {
        Transition staggered = null;
        Transition exitTransition = (Transition)exitTransitionObj;
        Transition enterTransition = (Transition)enterTransitionObj;
        Transition sharedElementTransition = (Transition)sharedElementTransitionObj;
        if (exitTransition != null && enterTransition != null) {
            staggered = new TransitionSet().addTransition(exitTransition).addTransition(enterTransition).setOrdering(1);
        } else if (exitTransition != null) {
            staggered = exitTransition;
        } else if (enterTransition != null) {
            staggered = enterTransition;
        }
        if (sharedElementTransition != null) {
            TransitionSet together = new TransitionSet();
            if (staggered != null) {
                together.addTransition(staggered);
            }
            together.addTransition(sharedElementTransition);
            return together;
        }
        return staggered;
    }

    @Override
    public void beginDelayedTransition(@NonNull ViewGroup sceneRoot, @Nullable Object transition) {
        TransitionManager.beginDelayedTransition(sceneRoot, (Transition)transition);
    }

    @Override
    public boolean isSeekingSupported() {
        return true;
    }

    @Override
    public boolean isSeekingSupported(@NonNull Object transition) {
        boolean supported = ((Transition)transition).isSeekingSupported();
        if (!supported) {
            Log.v((String)"FragmentManager", (String)("Predictive back not available for AndroidX Transition " + transition + ". Please enable seeking support for the designated transition by overriding isSeekingSupported()."));
        }
        return supported;
    }

    @Override
    @Nullable
    public Object controlDelayedTransition(@NonNull ViewGroup sceneRoot, @NonNull Object transition) {
        return TransitionManager.controlDelayedTransition(sceneRoot, (Transition)transition);
    }

    @Override
    public void setCurrentPlayTime(@NonNull Object transitionController, float progress) {
        TransitionSeekController controller = (TransitionSeekController)transitionController;
        if (controller.isReady()) {
            long time = (long)(progress * (float)controller.getDurationMillis());
            if (time == 0L) {
                time = 1L;
            }
            if (time == controller.getDurationMillis()) {
                time = controller.getDurationMillis() - 1L;
            }
            controller.setCurrentPlayTimeMillis(time);
        }
    }

    @Override
    public void animateToEnd(@NonNull Object transitionController) {
        TransitionSeekController controller = (TransitionSeekController)transitionController;
        controller.animateToEnd();
    }

    @Override
    public void animateToStart(@NonNull Object transitionController, @NonNull Runnable completeRunnable) {
        TransitionSeekController controller = (TransitionSeekController)transitionController;
        controller.animateToStart(completeRunnable);
    }

    @Override
    public void scheduleRemoveTargets(@NonNull Object overallTransitionObj, final @Nullable Object enterTransition, final @Nullable ArrayList<View> enteringViews, final @Nullable Object exitTransition, final @Nullable ArrayList<View> exitingViews, final @Nullable Object sharedElementTransition, final @Nullable ArrayList<View> sharedElementsIn) {
        Transition overallTransition = (Transition)overallTransitionObj;
        overallTransition.addListener(new TransitionListenerAdapter(){

            @Override
            public void onTransitionStart(@NonNull Transition transition) {
                if (enterTransition != null) {
                    FragmentTransitionSupport.this.replaceTargets(enterTransition, enteringViews, null);
                }
                if (exitTransition != null) {
                    FragmentTransitionSupport.this.replaceTargets(exitTransition, exitingViews, null);
                }
                if (sharedElementTransition != null) {
                    FragmentTransitionSupport.this.replaceTargets(sharedElementTransition, sharedElementsIn, null);
                }
            }

            @Override
            public void onTransitionEnd(@NonNull Transition transition) {
                transition.removeListener(this);
            }
        });
    }

    @Override
    public void setListenerForTransitionEnd(@NonNull Fragment outFragment, @NonNull Object transition, @NonNull CancellationSignal signal, @NonNull Runnable transitionCompleteRunnable) {
        this.setListenerForTransitionEnd(outFragment, transition, signal, null, transitionCompleteRunnable);
    }

    @Override
    public void setListenerForTransitionEnd(@NonNull Fragment outFragment, @NonNull Object transition, @NonNull CancellationSignal signal, @Nullable Runnable cancelRunnable, final @NonNull Runnable transitionCompleteRunnable) {
        Transition realTransition = (Transition)transition;
        signal.setOnCancelListener(() -> {
            if (cancelRunnable == null) {
                realTransition.cancel();
                transitionCompleteRunnable.run();
            } else {
                cancelRunnable.run();
            }
        });
        realTransition.addListener(new Transition.TransitionListener(){

            @Override
            public void onTransitionStart(@NonNull Transition transition) {
            }

            @Override
            public void onTransitionEnd(@NonNull Transition transition) {
                transitionCompleteRunnable.run();
            }

            @Override
            public void onTransitionCancel(@NonNull Transition transition) {
            }

            @Override
            public void onTransitionPause(@NonNull Transition transition) {
            }

            @Override
            public void onTransitionResume(@NonNull Transition transition) {
            }
        });
    }

    @Override
    public void swapSharedElementTargets(@Nullable Object sharedElementTransitionObj, @Nullable ArrayList<View> sharedElementsOut, @Nullable ArrayList<View> sharedElementsIn) {
        TransitionSet sharedElementTransition = (TransitionSet)sharedElementTransitionObj;
        if (sharedElementTransition != null) {
            sharedElementTransition.getTargets().clear();
            sharedElementTransition.getTargets().addAll(sharedElementsIn);
            this.replaceTargets(sharedElementTransition, sharedElementsOut, sharedElementsIn);
        }
    }

    @Override
    public void replaceTargets(@NonNull Object transitionObj, @SuppressLint(value={"UnknownNullness"}) ArrayList<View> oldTargets, @SuppressLint(value={"UnknownNullness"}) ArrayList<View> newTargets) {
        block4: {
            int i;
            List<View> targets;
            Transition transition;
            block3: {
                transition = (Transition)transitionObj;
                if (!(transition instanceof TransitionSet)) break block3;
                TransitionSet set = (TransitionSet)transition;
                int numTransitions = set.getTransitionCount();
                for (int i2 = 0; i2 < numTransitions; ++i2) {
                    Transition child = set.getTransitionAt(i2);
                    this.replaceTargets(child, oldTargets, newTargets);
                }
                break block4;
            }
            if (FragmentTransitionSupport.hasSimpleTarget(transition) || (targets = transition.getTargets()).size() != oldTargets.size() || !targets.containsAll(oldTargets)) break block4;
            int targetCount = newTargets == null ? 0 : newTargets.size();
            for (i = 0; i < targetCount; ++i) {
                transition.addTarget(newTargets.get(i));
            }
            for (i = oldTargets.size() - 1; i >= 0; --i) {
                transition.removeTarget(oldTargets.get(i));
            }
        }
    }

    @Override
    public void addTarget(@NonNull Object transitionObj, @NonNull View view) {
        if (transitionObj != null) {
            Transition transition = (Transition)transitionObj;
            transition.addTarget(view);
        }
    }

    @Override
    public void removeTarget(@NonNull Object transitionObj, @NonNull View view) {
        if (transitionObj != null) {
            Transition transition = (Transition)transitionObj;
            transition.removeTarget(view);
        }
    }

    @Override
    public void setEpicenter(@NonNull Object transitionObj, final @NonNull Rect epicenter) {
        if (transitionObj != null) {
            Transition transition = (Transition)transitionObj;
            transition.setEpicenterCallback(new Transition.EpicenterCallback(){

                @Override
                public Rect onGetEpicenter(@NonNull Transition transition) {
                    if (epicenter == null || epicenter.isEmpty()) {
                        return null;
                    }
                    return epicenter;
                }
            });
        }
    }
}

