/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.animation.ObjectAnimator;
import android.graphics.Path;
import android.graphics.PointF;
import android.os.Build;
import android.util.Property;
import androidx.annotation.DoNotInline;
import androidx.annotation.RequiresApi;
import androidx.transition.PathProperty;

class ObjectAnimatorUtils {
    static <T> ObjectAnimator ofPointF(T target, Property<T, PointF> property, Path path2) {
        if (Build.VERSION.SDK_INT >= 21) {
            return Api21Impl.ofObject(target, property, path2);
        }
        return ObjectAnimator.ofFloat(target, new PathProperty<T>(property, path2), (float[])new float[]{0.0f, 1.0f});
    }

    private ObjectAnimatorUtils() {
    }

    @RequiresApi(value=21)
    static class Api21Impl {
        private Api21Impl() {
        }

        @DoNotInline
        static <T, V> ObjectAnimator ofObject(T target, Property<T, V> property, Path path2) {
            return ObjectAnimator.ofObject(target, property, null, (Path)path2);
        }
    }
}

