/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.animation.PropertyValuesHolder;
import android.graphics.Path;
import android.graphics.PointF;
import android.os.Build;
import android.util.Property;
import androidx.annotation.DoNotInline;
import androidx.annotation.RequiresApi;
import androidx.transition.PathProperty;

class PropertyValuesHolderUtils {
    static PropertyValuesHolder ofPointF(Property<?, PointF> property, Path path2) {
        if (Build.VERSION.SDK_INT >= 21) {
            return Api21Impl.ofObject(property, path2);
        }
        return PropertyValuesHolder.ofFloat(new PathProperty(property, path2), (float[])new float[]{0.0f, 1.0f});
    }

    private PropertyValuesHolderUtils() {
    }

    @RequiresApi(value=21)
    static class Api21Impl {
        private Api21Impl() {
        }

        @DoNotInline
        static <V> PropertyValuesHolder ofObject(Property<?, V> property, Path path2) {
            return PropertyValuesHolder.ofObject(property, null, (Path)path2);
        }
    }
}

