/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.Path;
import android.graphics.Rect;
import android.os.Build;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.InflateException;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowId;
import android.view.animation.AnimationUtils;
import android.widget.ListView;
import androidx.annotation.DoNotInline;
import androidx.annotation.IdRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.collection.ArrayMap;
import androidx.collection.LongSparseArray;
import androidx.collection.SimpleArrayMap;
import androidx.core.content.res.TypedArrayUtils;
import androidx.core.util.Consumer;
import androidx.core.view.ViewCompat;
import androidx.dynamicanimation.animation.DynamicAnimation;
import androidx.dynamicanimation.animation.FloatValueHolder;
import androidx.dynamicanimation.animation.SpringAnimation;
import androidx.dynamicanimation.animation.SpringForce;
import androidx.transition.PathMotion;
import androidx.transition.Styleable;
import androidx.transition.TransitionListenerAdapter;
import androidx.transition.TransitionPropagation;
import androidx.transition.TransitionSeekController;
import androidx.transition.TransitionSet;
import androidx.transition.TransitionValues;
import androidx.transition.TransitionValuesMaps;
import androidx.transition.VelocityTracker1D;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.xmlpull.v1.XmlPullParser;

public abstract class Transition
implements Cloneable {
    private static final String LOG_TAG = "Transition";
    private static final Animator[] EMPTY_ANIMATOR_ARRAY = new Animator[0];
    static final boolean DBG = false;
    public static final int MATCH_INSTANCE = 1;
    private static final int MATCH_FIRST = 1;
    public static final int MATCH_NAME = 2;
    public static final int MATCH_ID = 3;
    public static final int MATCH_ITEM_ID = 4;
    private static final int MATCH_LAST = 4;
    private static final String MATCH_INSTANCE_STR = "instance";
    private static final String MATCH_NAME_STR = "name";
    private static final String MATCH_ID_STR = "id";
    private static final String MATCH_ITEM_ID_STR = "itemId";
    private static final int[] DEFAULT_MATCH_ORDER = new int[]{2, 1, 3, 4};
    private static final PathMotion STRAIGHT_PATH_MOTION = new PathMotion(){

        @Override
        @NonNull
        public Path getPath(float startX, float startY, float endX, float endY) {
            Path path2 = new Path();
            path2.moveTo(startX, startY);
            path2.lineTo(endX, endY);
            return path2;
        }
    };
    private String mName = this.getClass().getName();
    private long mStartDelay = -1L;
    long mDuration = -1L;
    private TimeInterpolator mInterpolator = null;
    ArrayList<Integer> mTargetIds = new ArrayList();
    ArrayList<View> mTargets = new ArrayList();
    private ArrayList<String> mTargetNames = null;
    private ArrayList<Class<?>> mTargetTypes = null;
    private ArrayList<Integer> mTargetIdExcludes = null;
    private ArrayList<View> mTargetExcludes = null;
    private ArrayList<Class<?>> mTargetTypeExcludes = null;
    private ArrayList<String> mTargetNameExcludes = null;
    private ArrayList<Integer> mTargetIdChildExcludes = null;
    private ArrayList<View> mTargetChildExcludes = null;
    private ArrayList<Class<?>> mTargetTypeChildExcludes = null;
    private TransitionValuesMaps mStartValues = new TransitionValuesMaps();
    private TransitionValuesMaps mEndValues = new TransitionValuesMaps();
    TransitionSet mParent = null;
    private int[] mMatchOrder = DEFAULT_MATCH_ORDER;
    private ArrayList<TransitionValues> mStartValuesList;
    private ArrayList<TransitionValues> mEndValuesList;
    private TransitionListener[] mListenersCache;
    private static ThreadLocal<ArrayMap<Animator, AnimationInfo>> sRunningAnimators = new ThreadLocal();
    boolean mCanRemoveViews = false;
    ArrayList<Animator> mCurrentAnimators = new ArrayList();
    private Animator[] mAnimatorCache = EMPTY_ANIMATOR_ARRAY;
    int mNumInstances = 0;
    private boolean mPaused = false;
    boolean mEnded = false;
    private Transition mCloneParent = null;
    private ArrayList<TransitionListener> mListeners = null;
    ArrayList<Animator> mAnimators = new ArrayList();
    TransitionPropagation mPropagation;
    private EpicenterCallback mEpicenterCallback;
    private ArrayMap<String, String> mNameOverrides;
    private PathMotion mPathMotion = STRAIGHT_PATH_MOTION;
    long mTotalDuration;
    SeekController mSeekController;
    long mSeekOffsetInParent;

    public Transition() {
    }

    public Transition(@NonNull Context context, @NonNull AttributeSet attrs) {
        String matchOrder;
        int resId;
        long startDelay;
        TypedArray a = context.obtainStyledAttributes(attrs, Styleable.TRANSITION);
        XmlResourceParser parser = (XmlResourceParser)attrs;
        long duration = TypedArrayUtils.getNamedInt(a, (XmlPullParser)parser, "duration", 1, -1);
        if (duration >= 0L) {
            this.setDuration(duration);
        }
        if ((startDelay = (long)TypedArrayUtils.getNamedInt(a, (XmlPullParser)parser, "startDelay", 2, -1)) > 0L) {
            this.setStartDelay(startDelay);
        }
        if ((resId = TypedArrayUtils.getNamedResourceId(a, (XmlPullParser)parser, "interpolator", 0, 0)) > 0) {
            this.setInterpolator((TimeInterpolator)AnimationUtils.loadInterpolator((Context)context, (int)resId));
        }
        if ((matchOrder = TypedArrayUtils.getNamedString(a, (XmlPullParser)parser, "matchOrder", 3)) != null) {
            this.setMatchOrder(Transition.parseMatchOrder(matchOrder));
        }
        a.recycle();
    }

    private static int[] parseMatchOrder(String matchOrderString) {
        StringTokenizer st = new StringTokenizer(matchOrderString, ",");
        int[] matches = new int[st.countTokens()];
        int index = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken().trim();
            if (MATCH_ID_STR.equalsIgnoreCase(token)) {
                matches[index] = 3;
            } else if (MATCH_INSTANCE_STR.equalsIgnoreCase(token)) {
                matches[index] = 1;
            } else if (MATCH_NAME_STR.equalsIgnoreCase(token)) {
                matches[index] = 2;
            } else if (MATCH_ITEM_ID_STR.equalsIgnoreCase(token)) {
                matches[index] = 4;
            } else if (token.isEmpty()) {
                int[] smallerMatches = new int[matches.length - 1];
                System.arraycopy(matches, 0, smallerMatches, 0, index);
                matches = smallerMatches;
                --index;
            } else {
                throw new InflateException("Unknown match type in matchOrder: '" + token + "'");
            }
            ++index;
        }
        return matches;
    }

    @NonNull
    public final Transition getRootTransition() {
        if (this.mParent != null) {
            return this.mParent.getRootTransition();
        }
        return this;
    }

    @NonNull
    public Transition setDuration(long duration) {
        this.mDuration = duration;
        return this;
    }

    public long getDuration() {
        return this.mDuration;
    }

    @NonNull
    public Transition setStartDelay(long startDelay) {
        this.mStartDelay = startDelay;
        return this;
    }

    public long getStartDelay() {
        return this.mStartDelay;
    }

    @NonNull
    public Transition setInterpolator(@Nullable TimeInterpolator interpolator2) {
        this.mInterpolator = interpolator2;
        return this;
    }

    @Nullable
    public TimeInterpolator getInterpolator() {
        return this.mInterpolator;
    }

    @Nullable
    public String[] getTransitionProperties() {
        return null;
    }

    @Nullable
    public Animator createAnimator(@NonNull ViewGroup sceneRoot, @Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        return null;
    }

    @RequiresApi(value=34)
    @NonNull
    TransitionSeekController createSeekController() {
        this.mSeekController = new SeekController();
        this.addListener(this.mSeekController);
        return this.mSeekController;
    }

    public void setMatchOrder(int ... matches) {
        if (matches == null || matches.length == 0) {
            this.mMatchOrder = DEFAULT_MATCH_ORDER;
        } else {
            for (int i = 0; i < matches.length; ++i) {
                int match = matches[i];
                if (!Transition.isValidMatch(match)) {
                    throw new IllegalArgumentException("matches contains invalid value");
                }
                if (!Transition.alreadyContains(matches, i)) continue;
                throw new IllegalArgumentException("matches contains a duplicate value");
            }
            this.mMatchOrder = (int[])matches.clone();
        }
    }

    private static boolean isValidMatch(int match) {
        return match >= 1 && match <= 4;
    }

    private static boolean alreadyContains(int[] array, int searchIndex) {
        int value = array[searchIndex];
        for (int i = 0; i < searchIndex; ++i) {
            if (array[i] != value) continue;
            return true;
        }
        return false;
    }

    private void matchInstances(ArrayMap<View, TransitionValues> unmatchedStart, ArrayMap<View, TransitionValues> unmatchedEnd) {
        for (int i = unmatchedStart.size() - 1; i >= 0; --i) {
            TransitionValues end;
            View view = (View)unmatchedStart.keyAt(i);
            if (view == null || !this.isValidTarget(view) || (end = (TransitionValues)unmatchedEnd.remove(view)) == null || !this.isValidTarget(end.view)) continue;
            TransitionValues start = (TransitionValues)unmatchedStart.removeAt(i);
            this.mStartValuesList.add(start);
            this.mEndValuesList.add(end);
        }
    }

    private void matchItemIds(ArrayMap<View, TransitionValues> unmatchedStart, ArrayMap<View, TransitionValues> unmatchedEnd, LongSparseArray<View> startItemIds, LongSparseArray<View> endItemIds) {
        int numStartIds = startItemIds.size();
        for (int i = 0; i < numStartIds; ++i) {
            View endView;
            View startView = startItemIds.valueAt(i);
            if (startView == null || !this.isValidTarget(startView) || (endView = endItemIds.get(startItemIds.keyAt(i))) == null || !this.isValidTarget(endView)) continue;
            TransitionValues startValues = (TransitionValues)unmatchedStart.get(startView);
            TransitionValues endValues = (TransitionValues)unmatchedEnd.get(endView);
            if (startValues == null || endValues == null) continue;
            this.mStartValuesList.add(startValues);
            this.mEndValuesList.add(endValues);
            unmatchedStart.remove(startView);
            unmatchedEnd.remove(endView);
        }
    }

    private void matchIds(ArrayMap<View, TransitionValues> unmatchedStart, ArrayMap<View, TransitionValues> unmatchedEnd, SparseArray<View> startIds, SparseArray<View> endIds) {
        int numStartIds = startIds.size();
        for (int i = 0; i < numStartIds; ++i) {
            View endView;
            View startView = (View)startIds.valueAt(i);
            if (startView == null || !this.isValidTarget(startView) || (endView = (View)endIds.get(startIds.keyAt(i))) == null || !this.isValidTarget(endView)) continue;
            TransitionValues startValues = (TransitionValues)unmatchedStart.get(startView);
            TransitionValues endValues = (TransitionValues)unmatchedEnd.get(endView);
            if (startValues == null || endValues == null) continue;
            this.mStartValuesList.add(startValues);
            this.mEndValuesList.add(endValues);
            unmatchedStart.remove(startView);
            unmatchedEnd.remove(endView);
        }
    }

    private void matchNames(ArrayMap<View, TransitionValues> unmatchedStart, ArrayMap<View, TransitionValues> unmatchedEnd, ArrayMap<String, View> startNames, ArrayMap<String, View> endNames) {
        int numStartNames = startNames.size();
        for (int i = 0; i < numStartNames; ++i) {
            View endView;
            View startView = (View)startNames.valueAt(i);
            if (startView == null || !this.isValidTarget(startView) || (endView = (View)endNames.get(startNames.keyAt(i))) == null || !this.isValidTarget(endView)) continue;
            TransitionValues startValues = (TransitionValues)unmatchedStart.get(startView);
            TransitionValues endValues = (TransitionValues)unmatchedEnd.get(endView);
            if (startValues == null || endValues == null) continue;
            this.mStartValuesList.add(startValues);
            this.mEndValuesList.add(endValues);
            unmatchedStart.remove(startView);
            unmatchedEnd.remove(endView);
        }
    }

    private void addUnmatched(ArrayMap<View, TransitionValues> unmatchedStart, ArrayMap<View, TransitionValues> unmatchedEnd) {
        int i;
        for (i = 0; i < unmatchedStart.size(); ++i) {
            TransitionValues start = (TransitionValues)unmatchedStart.valueAt(i);
            if (!this.isValidTarget(start.view)) continue;
            this.mStartValuesList.add(start);
            this.mEndValuesList.add(null);
        }
        for (i = 0; i < unmatchedEnd.size(); ++i) {
            TransitionValues end = (TransitionValues)unmatchedEnd.valueAt(i);
            if (!this.isValidTarget(end.view)) continue;
            this.mEndValuesList.add(end);
            this.mStartValuesList.add(null);
        }
    }

    private void matchStartAndEnd(TransitionValuesMaps startValues, TransitionValuesMaps endValues) {
        ArrayMap<View, TransitionValues> unmatchedStart = new ArrayMap<View, TransitionValues>(startValues.mViewValues);
        ArrayMap<View, TransitionValues> unmatchedEnd = new ArrayMap<View, TransitionValues>(endValues.mViewValues);
        block6: for (int i = 0; i < this.mMatchOrder.length; ++i) {
            switch (this.mMatchOrder[i]) {
                case 1: {
                    this.matchInstances(unmatchedStart, unmatchedEnd);
                    continue block6;
                }
                case 2: {
                    this.matchNames(unmatchedStart, unmatchedEnd, startValues.mNameValues, endValues.mNameValues);
                    continue block6;
                }
                case 3: {
                    this.matchIds(unmatchedStart, unmatchedEnd, startValues.mIdValues, endValues.mIdValues);
                    continue block6;
                }
                case 4: {
                    this.matchItemIds(unmatchedStart, unmatchedEnd, startValues.mItemIdValues, endValues.mItemIdValues);
                }
            }
        }
        this.addUnmatched(unmatchedStart, unmatchedEnd);
    }

    void createAnimators(@NonNull ViewGroup sceneRoot, @NonNull TransitionValuesMaps startValues, @NonNull TransitionValuesMaps endValues, @NonNull ArrayList<TransitionValues> startValuesList, @NonNull ArrayList<TransitionValues> endValuesList) {
        int i;
        ArrayMap<Animator, AnimationInfo> runningAnimators = Transition.getRunningAnimators();
        long minStartDelay = Long.MAX_VALUE;
        SparseIntArray startDelays = new SparseIntArray();
        int startValuesListCount = startValuesList.size();
        boolean hasSeekController = this.getRootTransition().mSeekController != null;
        for (i = 0; i < startValuesListCount; ++i) {
            View view;
            Animator animator2;
            boolean isChanged;
            TransitionValues start = startValuesList.get(i);
            TransitionValues end = endValuesList.get(i);
            if (start != null && !start.mTargetedTransitions.contains(this)) {
                start = null;
            }
            if (end != null && !end.mTargetedTransitions.contains(this)) {
                end = null;
            }
            if (start == null && end == null) continue;
            boolean bl = isChanged = start == null || end == null || this.isTransitionRequired(start, end);
            if (!isChanged || (animator2 = this.createAnimator(sceneRoot, start, end)) == null) continue;
            TransitionValues infoValues = null;
            if (end != null) {
                view = end.view;
                String[] properties = this.getTransitionProperties();
                if (properties != null && properties.length > 0) {
                    infoValues = new TransitionValues(view);
                    TransitionValues newValues = (TransitionValues)endValues.mViewValues.get(view);
                    if (newValues != null) {
                        for (int j = 0; j < properties.length; ++j) {
                            infoValues.values.put(properties[j], newValues.values.get(properties[j]));
                        }
                    }
                    int numExistingAnims = runningAnimators.size();
                    for (int j = 0; j < numExistingAnims; ++j) {
                        Animator anim2 = (Animator)runningAnimators.keyAt(j);
                        AnimationInfo info = (AnimationInfo)runningAnimators.get(anim2);
                        if (info.mValues == null || info.mView != view || !info.mName.equals(this.getName()) || !info.mValues.equals(infoValues)) continue;
                        animator2 = null;
                        break;
                    }
                }
            } else {
                view = start.view;
            }
            if (animator2 == null) continue;
            if (this.mPropagation != null) {
                long delay = this.mPropagation.getStartDelay(sceneRoot, this, start, end);
                startDelays.put(this.mAnimators.size(), (int)delay);
                minStartDelay = Math.min(delay, minStartDelay);
            }
            AnimationInfo info = new AnimationInfo(view, this.getName(), this, sceneRoot.getWindowId(), infoValues, animator2);
            if (hasSeekController) {
                AnimatorSet set = new AnimatorSet();
                set.play(animator2);
                animator2 = set;
            }
            runningAnimators.put(animator2, info);
            this.mAnimators.add(animator2);
        }
        if (startDelays.size() != 0) {
            for (i = 0; i < startDelays.size(); ++i) {
                int index = startDelays.keyAt(i);
                Animator animator3 = this.mAnimators.get(index);
                AnimationInfo info = (AnimationInfo)runningAnimators.get(animator3);
                long delay = (long)startDelays.valueAt(i) - minStartDelay + info.mAnimator.getStartDelay();
                info.mAnimator.setStartDelay(delay);
            }
        }
    }

    boolean isValidTarget(View target) {
        int targetId = target.getId();
        if (this.mTargetIdExcludes != null && this.mTargetIdExcludes.contains(targetId)) {
            return false;
        }
        if (this.mTargetExcludes != null && this.mTargetExcludes.contains(target)) {
            return false;
        }
        if (this.mTargetTypeExcludes != null) {
            int numTypes = this.mTargetTypeExcludes.size();
            for (int i = 0; i < numTypes; ++i) {
                Class<?> type = this.mTargetTypeExcludes.get(i);
                if (!type.isInstance(target)) continue;
                return false;
            }
        }
        if (this.mTargetNameExcludes != null && ViewCompat.getTransitionName(target) != null && this.mTargetNameExcludes.contains(ViewCompat.getTransitionName(target))) {
            return false;
        }
        if (this.mTargetIds.size() == 0 && this.mTargets.size() == 0 && (this.mTargetTypes == null || this.mTargetTypes.isEmpty()) && (this.mTargetNames == null || this.mTargetNames.isEmpty())) {
            return true;
        }
        if (this.mTargetIds.contains(targetId) || this.mTargets.contains(target)) {
            return true;
        }
        if (this.mTargetNames != null && this.mTargetNames.contains(ViewCompat.getTransitionName(target))) {
            return true;
        }
        if (this.mTargetTypes != null) {
            for (int i = 0; i < this.mTargetTypes.size(); ++i) {
                if (!this.mTargetTypes.get(i).isInstance(target)) continue;
                return true;
            }
        }
        return false;
    }

    private static ArrayMap<Animator, AnimationInfo> getRunningAnimators() {
        ArrayMap<Object, AnimationInfo> runningAnimators = sRunningAnimators.get();
        if (runningAnimators == null) {
            runningAnimators = new ArrayMap();
            sRunningAnimators.set(runningAnimators);
        }
        return runningAnimators;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    protected void runAnimators() {
        this.start();
        ArrayMap<Animator, AnimationInfo> runningAnimators = Transition.getRunningAnimators();
        for (Animator anim2 : this.mAnimators) {
            if (!runningAnimators.containsKey(anim2)) continue;
            this.start();
            this.runAnimator(anim2, runningAnimators);
        }
        this.mAnimators.clear();
        this.end();
    }

    private void runAnimator(Animator animator2, final ArrayMap<Animator, AnimationInfo> runningAnimators) {
        if (animator2 != null) {
            animator2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationStart(Animator animation) {
                    Transition.this.mCurrentAnimators.add(animation);
                }

                public void onAnimationEnd(Animator animation) {
                    runningAnimators.remove(animation);
                    Transition.this.mCurrentAnimators.remove(animation);
                }
            });
            this.animate(animator2);
        }
    }

    @RequiresApi(value=34)
    void prepareAnimatorsForSeeking() {
        ArrayMap<Animator, AnimationInfo> runningAnimators = Transition.getRunningAnimators();
        this.mTotalDuration = 0L;
        for (int i = 0; i < this.mAnimators.size(); ++i) {
            Animator anim2 = this.mAnimators.get(i);
            AnimationInfo info = (AnimationInfo)runningAnimators.get(anim2);
            if (anim2 == null || info == null) continue;
            if (this.getDuration() >= 0L) {
                info.mAnimator.setDuration(this.getDuration());
            }
            if (this.getStartDelay() >= 0L) {
                info.mAnimator.setStartDelay(this.getStartDelay() + info.mAnimator.getStartDelay());
            }
            if (this.getInterpolator() != null) {
                info.mAnimator.setInterpolator(this.getInterpolator());
            }
            this.mCurrentAnimators.add(anim2);
            this.mTotalDuration = Math.max(this.mTotalDuration, Impl26.getTotalDuration(anim2));
        }
        this.mAnimators.clear();
    }

    public abstract void captureStartValues(@NonNull TransitionValues var1);

    public abstract void captureEndValues(@NonNull TransitionValues var1);

    @NonNull
    public Transition addTarget(@NonNull View target) {
        this.mTargets.add(target);
        return this;
    }

    @NonNull
    public Transition addTarget(@IdRes int targetId) {
        if (targetId != 0) {
            this.mTargetIds.add(targetId);
        }
        return this;
    }

    @NonNull
    public Transition addTarget(@NonNull String targetName) {
        if (this.mTargetNames == null) {
            this.mTargetNames = new ArrayList();
        }
        this.mTargetNames.add(targetName);
        return this;
    }

    @NonNull
    public Transition addTarget(@NonNull Class<?> targetType) {
        if (this.mTargetTypes == null) {
            this.mTargetTypes = new ArrayList();
        }
        this.mTargetTypes.add(targetType);
        return this;
    }

    @NonNull
    public Transition removeTarget(@NonNull View target) {
        this.mTargets.remove(target);
        return this;
    }

    @NonNull
    public Transition removeTarget(@IdRes int targetId) {
        if (targetId != 0) {
            this.mTargetIds.remove((Object)targetId);
        }
        return this;
    }

    @NonNull
    public Transition removeTarget(@NonNull String targetName) {
        if (this.mTargetNames != null) {
            this.mTargetNames.remove(targetName);
        }
        return this;
    }

    @NonNull
    public Transition removeTarget(@NonNull Class<?> target) {
        if (this.mTargetTypes != null) {
            this.mTargetTypes.remove(target);
        }
        return this;
    }

    private static <T> ArrayList<T> excludeObject(ArrayList<T> list, T target, boolean exclude) {
        if (target != null) {
            list = exclude ? ArrayListManager.add(list, target) : ArrayListManager.remove(list, target);
        }
        return list;
    }

    @NonNull
    public Transition excludeTarget(@NonNull View target, boolean exclude) {
        this.mTargetExcludes = this.excludeView(this.mTargetExcludes, target, exclude);
        return this;
    }

    @NonNull
    public Transition excludeTarget(@IdRes int targetId, boolean exclude) {
        this.mTargetIdExcludes = this.excludeId(this.mTargetIdExcludes, targetId, exclude);
        return this;
    }

    @NonNull
    public Transition excludeTarget(@NonNull String targetName, boolean exclude) {
        this.mTargetNameExcludes = Transition.excludeObject(this.mTargetNameExcludes, targetName, exclude);
        return this;
    }

    @NonNull
    public Transition excludeChildren(@NonNull View target, boolean exclude) {
        this.mTargetChildExcludes = this.excludeView(this.mTargetChildExcludes, target, exclude);
        return this;
    }

    @NonNull
    public Transition excludeChildren(@IdRes int targetId, boolean exclude) {
        this.mTargetIdChildExcludes = this.excludeId(this.mTargetIdChildExcludes, targetId, exclude);
        return this;
    }

    private ArrayList<Integer> excludeId(ArrayList<Integer> list, int targetId, boolean exclude) {
        if (targetId > 0) {
            list = exclude ? ArrayListManager.add(list, targetId) : ArrayListManager.remove(list, targetId);
        }
        return list;
    }

    private ArrayList<View> excludeView(ArrayList<View> list, View target, boolean exclude) {
        if (target != null) {
            list = exclude ? ArrayListManager.add(list, target) : ArrayListManager.remove(list, target);
        }
        return list;
    }

    @NonNull
    public Transition excludeTarget(@NonNull Class<?> type, boolean exclude) {
        this.mTargetTypeExcludes = this.excludeType(this.mTargetTypeExcludes, type, exclude);
        return this;
    }

    @NonNull
    public Transition excludeChildren(@NonNull Class<?> type, boolean exclude) {
        this.mTargetTypeChildExcludes = this.excludeType(this.mTargetTypeChildExcludes, type, exclude);
        return this;
    }

    private ArrayList<Class<?>> excludeType(ArrayList<Class<?>> list, Class<?> type, boolean exclude) {
        if (type != null) {
            list = exclude ? ArrayListManager.add(list, type) : ArrayListManager.remove(list, type);
        }
        return list;
    }

    @NonNull
    public List<Integer> getTargetIds() {
        return this.mTargetIds;
    }

    @NonNull
    public List<View> getTargets() {
        return this.mTargets;
    }

    @Nullable
    public List<String> getTargetNames() {
        return this.mTargetNames;
    }

    @Nullable
    public List<Class<?>> getTargetTypes() {
        return this.mTargetTypes;
    }

    public boolean isSeekingSupported() {
        return false;
    }

    void captureValues(@NonNull ViewGroup sceneRoot, boolean start) {
        this.clearValues(start);
        if (!(this.mTargetIds.size() <= 0 && this.mTargets.size() <= 0 || this.mTargetNames != null && !this.mTargetNames.isEmpty() || this.mTargetTypes != null && !this.mTargetTypes.isEmpty())) {
            int i;
            for (i = 0; i < this.mTargetIds.size(); ++i) {
                int id2 = this.mTargetIds.get(i);
                View view = sceneRoot.findViewById(id2);
                if (view == null) continue;
                TransitionValues values2 = new TransitionValues(view);
                if (start) {
                    this.captureStartValues(values2);
                } else {
                    this.captureEndValues(values2);
                }
                values2.mTargetedTransitions.add(this);
                this.capturePropagationValues(values2);
                if (start) {
                    Transition.addViewValues(this.mStartValues, view, values2);
                    continue;
                }
                Transition.addViewValues(this.mEndValues, view, values2);
            }
            for (i = 0; i < this.mTargets.size(); ++i) {
                View view = this.mTargets.get(i);
                TransitionValues values3 = new TransitionValues(view);
                if (start) {
                    this.captureStartValues(values3);
                } else {
                    this.captureEndValues(values3);
                }
                values3.mTargetedTransitions.add(this);
                this.capturePropagationValues(values3);
                if (start) {
                    Transition.addViewValues(this.mStartValues, view, values3);
                    continue;
                }
                Transition.addViewValues(this.mEndValues, view, values3);
            }
        } else {
            this.captureHierarchy((View)sceneRoot, start);
        }
        if (!start && this.mNameOverrides != null) {
            int i;
            int numOverrides = this.mNameOverrides.size();
            ArrayList<View> overriddenViews = new ArrayList<View>(numOverrides);
            for (i = 0; i < numOverrides; ++i) {
                String fromName = (String)this.mNameOverrides.keyAt(i);
                overriddenViews.add((View)this.mStartValues.mNameValues.remove(fromName));
            }
            for (i = 0; i < numOverrides; ++i) {
                View view = (View)overriddenViews.get(i);
                if (view == null) continue;
                String toName = (String)this.mNameOverrides.valueAt(i);
                this.mStartValues.mNameValues.put(toName, view);
            }
        }
    }

    private static void addViewValues(TransitionValuesMaps transitionValuesMaps, View view, TransitionValues transitionValues) {
        ListView listview;
        String name;
        transitionValuesMaps.mViewValues.put(view, transitionValues);
        int id2 = view.getId();
        if (id2 >= 0) {
            if (transitionValuesMaps.mIdValues.indexOfKey(id2) >= 0) {
                transitionValuesMaps.mIdValues.put(id2, null);
            } else {
                transitionValuesMaps.mIdValues.put(id2, (Object)view);
            }
        }
        if ((name = ViewCompat.getTransitionName(view)) != null) {
            if (transitionValuesMaps.mNameValues.containsKey(name)) {
                transitionValuesMaps.mNameValues.put(name, null);
            } else {
                transitionValuesMaps.mNameValues.put(name, view);
            }
        }
        if (view.getParent() instanceof ListView && (listview = (ListView)view.getParent()).getAdapter().hasStableIds()) {
            int position = listview.getPositionForView(view);
            long itemId = listview.getItemIdAtPosition(position);
            if (transitionValuesMaps.mItemIdValues.indexOfKey(itemId) >= 0) {
                View alreadyMatched = transitionValuesMaps.mItemIdValues.get(itemId);
                if (alreadyMatched != null) {
                    alreadyMatched.setHasTransientState(false);
                    transitionValuesMaps.mItemIdValues.put(itemId, null);
                }
            } else {
                view.setHasTransientState(true);
                transitionValuesMaps.mItemIdValues.put(itemId, view);
            }
        }
    }

    void clearValues(boolean start) {
        if (start) {
            this.mStartValues.mViewValues.clear();
            this.mStartValues.mIdValues.clear();
            this.mStartValues.mItemIdValues.clear();
        } else {
            this.mEndValues.mViewValues.clear();
            this.mEndValues.mIdValues.clear();
            this.mEndValues.mItemIdValues.clear();
        }
    }

    private void captureHierarchy(View view, boolean start) {
        int i;
        int numTypes;
        if (view == null) {
            return;
        }
        int id2 = view.getId();
        if (this.mTargetIdExcludes != null && this.mTargetIdExcludes.contains(id2)) {
            return;
        }
        if (this.mTargetExcludes != null && this.mTargetExcludes.contains(view)) {
            return;
        }
        if (this.mTargetTypeExcludes != null) {
            numTypes = this.mTargetTypeExcludes.size();
            for (i = 0; i < numTypes; ++i) {
                if (!this.mTargetTypeExcludes.get(i).isInstance(view)) continue;
                return;
            }
        }
        if (view.getParent() instanceof ViewGroup) {
            TransitionValues values2 = new TransitionValues(view);
            if (start) {
                this.captureStartValues(values2);
            } else {
                this.captureEndValues(values2);
            }
            values2.mTargetedTransitions.add(this);
            this.capturePropagationValues(values2);
            if (start) {
                Transition.addViewValues(this.mStartValues, view, values2);
            } else {
                Transition.addViewValues(this.mEndValues, view, values2);
            }
        }
        if (view instanceof ViewGroup) {
            if (this.mTargetIdChildExcludes != null && this.mTargetIdChildExcludes.contains(id2)) {
                return;
            }
            if (this.mTargetChildExcludes != null && this.mTargetChildExcludes.contains(view)) {
                return;
            }
            if (this.mTargetTypeChildExcludes != null) {
                numTypes = this.mTargetTypeChildExcludes.size();
                for (i = 0; i < numTypes; ++i) {
                    if (!this.mTargetTypeChildExcludes.get(i).isInstance(view)) continue;
                    return;
                }
            }
            ViewGroup parent = (ViewGroup)view;
            for (i = 0; i < parent.getChildCount(); ++i) {
                this.captureHierarchy(parent.getChildAt(i), start);
            }
        }
    }

    @Nullable
    public TransitionValues getTransitionValues(@NonNull View view, boolean start) {
        if (this.mParent != null) {
            return this.mParent.getTransitionValues(view, start);
        }
        TransitionValuesMaps valuesMaps = start ? this.mStartValues : this.mEndValues;
        return (TransitionValues)valuesMaps.mViewValues.get(view);
    }

    TransitionValues getMatchedTransitionValues(View view, boolean viewInStart) {
        ArrayList<TransitionValues> lookIn;
        if (this.mParent != null) {
            return this.mParent.getMatchedTransitionValues(view, viewInStart);
        }
        ArrayList<TransitionValues> arrayList = lookIn = viewInStart ? this.mStartValuesList : this.mEndValuesList;
        if (lookIn == null) {
            return null;
        }
        int count2 = lookIn.size();
        int index = -1;
        for (int i = 0; i < count2; ++i) {
            TransitionValues values2 = lookIn.get(i);
            if (values2 == null) {
                return null;
            }
            if (values2.view != view) continue;
            index = i;
            break;
        }
        TransitionValues values3 = null;
        if (index >= 0) {
            ArrayList<TransitionValues> matchIn = viewInStart ? this.mEndValuesList : this.mStartValuesList;
            values3 = matchIn.get(index);
        }
        return values3;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public void pause(@Nullable View sceneRoot) {
        if (!this.mEnded) {
            int numAnimators = this.mCurrentAnimators.size();
            Animator[] cache2 = this.mCurrentAnimators.toArray(this.mAnimatorCache);
            this.mAnimatorCache = EMPTY_ANIMATOR_ARRAY;
            for (int i = numAnimators - 1; i >= 0; --i) {
                Animator animator2 = cache2[i];
                cache2[i] = null;
                animator2.pause();
            }
            this.mAnimatorCache = cache2;
            this.notifyListeners(TransitionNotification.ON_PAUSE, false);
            this.mPaused = true;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public void resume(@Nullable View sceneRoot) {
        if (this.mPaused) {
            if (!this.mEnded) {
                int numAnimators = this.mCurrentAnimators.size();
                Animator[] cache2 = this.mCurrentAnimators.toArray(this.mAnimatorCache);
                this.mAnimatorCache = EMPTY_ANIMATOR_ARRAY;
                for (int i = numAnimators - 1; i >= 0; --i) {
                    Animator animator2 = cache2[i];
                    cache2[i] = null;
                    animator2.resume();
                }
                this.mAnimatorCache = cache2;
                this.notifyListeners(TransitionNotification.ON_RESUME, false);
            }
            this.mPaused = false;
        }
    }

    boolean hasAnimators() {
        return !this.mCurrentAnimators.isEmpty();
    }

    void playTransition(@NonNull ViewGroup sceneRoot) {
        this.mStartValuesList = new ArrayList();
        this.mEndValuesList = new ArrayList();
        this.matchStartAndEnd(this.mStartValues, this.mEndValues);
        ArrayMap<Animator, AnimationInfo> runningAnimators = Transition.getRunningAnimators();
        int numOldAnims = runningAnimators.size();
        WindowId windowId = sceneRoot.getWindowId();
        for (int i = numOldAnims - 1; i >= 0; --i) {
            boolean cancel;
            AnimationInfo oldInfo;
            Animator anim2 = (Animator)runningAnimators.keyAt(i);
            if (anim2 == null || (oldInfo = (AnimationInfo)runningAnimators.get(anim2)) == null || oldInfo.mView == null || !windowId.equals((Object)oldInfo.mWindowId)) continue;
            TransitionValues oldValues = oldInfo.mValues;
            View oldView = oldInfo.mView;
            TransitionValues startValues = this.getTransitionValues(oldView, true);
            TransitionValues endValues = this.getMatchedTransitionValues(oldView, true);
            if (startValues == null && endValues == null) {
                endValues = (TransitionValues)this.mEndValues.mViewValues.get(oldView);
            }
            boolean bl = cancel = (startValues != null || endValues != null) && oldInfo.mTransition.isTransitionRequired(oldValues, endValues);
            if (!cancel) continue;
            Transition transition = oldInfo.mTransition;
            if (transition.getRootTransition().mSeekController != null) {
                anim2.cancel();
                transition.mCurrentAnimators.remove(anim2);
                runningAnimators.remove(anim2);
                if (transition.mCurrentAnimators.size() != 0) continue;
                transition.notifyListeners(TransitionNotification.ON_CANCEL, false);
                if (transition.mEnded) continue;
                transition.mEnded = true;
                transition.notifyListeners(TransitionNotification.ON_END, false);
                continue;
            }
            if (anim2.isRunning() || anim2.isStarted()) {
                anim2.cancel();
                continue;
            }
            runningAnimators.remove(anim2);
        }
        this.createAnimators(sceneRoot, this.mStartValues, this.mEndValues, this.mStartValuesList, this.mEndValuesList);
        if (this.mSeekController == null) {
            this.runAnimators();
        } else if (Build.VERSION.SDK_INT >= 34) {
            this.prepareAnimatorsForSeeking();
            this.mSeekController.initPlayTime();
            this.mSeekController.ready();
        }
    }

    public boolean isTransitionRequired(@Nullable TransitionValues startValues, @Nullable TransitionValues endValues) {
        boolean valuesChanged;
        block4: {
            valuesChanged = false;
            if (startValues == null || endValues == null) break block4;
            String[] properties = this.getTransitionProperties();
            if (properties != null) {
                for (String property : properties) {
                    if (!Transition.isValueChanged(startValues, endValues, property)) continue;
                    valuesChanged = true;
                    break;
                }
            } else {
                for (String key : startValues.values.keySet()) {
                    if (!Transition.isValueChanged(startValues, endValues, key)) continue;
                    valuesChanged = true;
                    break;
                }
            }
        }
        return valuesChanged;
    }

    private static boolean isValueChanged(TransitionValues oldValues, TransitionValues newValues, String key) {
        Object oldValue = oldValues.values.get(key);
        Object newValue = newValues.values.get(key);
        boolean changed = oldValue == null && newValue == null ? false : (oldValue == null || newValue == null ? true : !oldValue.equals(newValue));
        return changed;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    protected void animate(@Nullable Animator animator2) {
        if (animator2 == null) {
            this.end();
        } else {
            if (this.getDuration() >= 0L) {
                animator2.setDuration(this.getDuration());
            }
            if (this.getStartDelay() >= 0L) {
                animator2.setStartDelay(this.getStartDelay() + animator2.getStartDelay());
            }
            if (this.getInterpolator() != null) {
                animator2.setInterpolator(this.getInterpolator());
            }
            animator2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    Transition.this.end();
                    animation.removeListener((Animator.AnimatorListener)this);
                }
            });
            animator2.start();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    protected void start() {
        if (this.mNumInstances == 0) {
            this.notifyListeners(TransitionNotification.ON_START, false);
            this.mEnded = false;
        }
        ++this.mNumInstances;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    protected void end() {
        --this.mNumInstances;
        if (this.mNumInstances == 0) {
            View view;
            int i;
            this.notifyListeners(TransitionNotification.ON_END, false);
            for (i = 0; i < this.mStartValues.mItemIdValues.size(); ++i) {
                view = this.mStartValues.mItemIdValues.valueAt(i);
                if (view == null) continue;
                view.setHasTransientState(false);
            }
            for (i = 0; i < this.mEndValues.mItemIdValues.size(); ++i) {
                view = this.mEndValues.mItemIdValues.valueAt(i);
                if (view == null) continue;
                view.setHasTransientState(false);
            }
            this.mEnded = true;
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    void forceToEnd(@Nullable ViewGroup sceneRoot) {
        ArrayMap<Animator, AnimationInfo> runningAnimators = Transition.getRunningAnimators();
        int numOldAnims = runningAnimators.size();
        if (sceneRoot == null || numOldAnims == 0) {
            return;
        }
        WindowId windowId = sceneRoot.getWindowId();
        ArrayMap oldAnimators = new ArrayMap((SimpleArrayMap)runningAnimators);
        runningAnimators.clear();
        for (int i = numOldAnims - 1; i >= 0; --i) {
            AnimationInfo info = (AnimationInfo)oldAnimators.valueAt(i);
            if (info.mView == null || !windowId.equals((Object)info.mWindowId)) continue;
            Animator anim2 = (Animator)oldAnimators.keyAt(i);
            anim2.end();
        }
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    protected void cancel() {
        int numAnimators = this.mCurrentAnimators.size();
        Animator[] cache2 = this.mCurrentAnimators.toArray(this.mAnimatorCache);
        this.mAnimatorCache = EMPTY_ANIMATOR_ARRAY;
        for (int i = numAnimators - 1; i >= 0; --i) {
            Animator animator2 = cache2[i];
            cache2[i] = null;
            animator2.cancel();
        }
        this.mAnimatorCache = cache2;
        this.notifyListeners(TransitionNotification.ON_CANCEL, false);
    }

    @NonNull
    public Transition addListener(@NonNull TransitionListener listener2) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
        }
        this.mListeners.add(listener2);
        return this;
    }

    @NonNull
    public Transition removeListener(@NonNull TransitionListener listener2) {
        if (this.mListeners == null) {
            return this;
        }
        if (!this.mListeners.remove(listener2) && this.mCloneParent != null) {
            this.mCloneParent.removeListener(listener2);
        }
        if (this.mListeners.size() == 0) {
            this.mListeners = null;
        }
        return this;
    }

    public void setPathMotion(@Nullable PathMotion pathMotion) {
        this.mPathMotion = pathMotion == null ? STRAIGHT_PATH_MOTION : pathMotion;
    }

    @NonNull
    public PathMotion getPathMotion() {
        return this.mPathMotion;
    }

    public void setEpicenterCallback(@Nullable EpicenterCallback epicenterCallback) {
        this.mEpicenterCallback = epicenterCallback;
    }

    @Nullable
    public EpicenterCallback getEpicenterCallback() {
        return this.mEpicenterCallback;
    }

    @Nullable
    public Rect getEpicenter() {
        if (this.mEpicenterCallback == null) {
            return null;
        }
        return this.mEpicenterCallback.onGetEpicenter(this);
    }

    public void setPropagation(@Nullable TransitionPropagation transitionPropagation) {
        this.mPropagation = transitionPropagation;
    }

    @Nullable
    public TransitionPropagation getPropagation() {
        return this.mPropagation;
    }

    void capturePropagationValues(TransitionValues transitionValues) {
        if (this.mPropagation != null && !transitionValues.values.isEmpty()) {
            String[] propertyNames = this.mPropagation.getPropagationProperties();
            if (propertyNames == null) {
                return;
            }
            boolean containsAll = true;
            for (int i = 0; i < propertyNames.length; ++i) {
                if (transitionValues.values.containsKey(propertyNames[i])) continue;
                containsAll = false;
                break;
            }
            if (!containsAll) {
                this.mPropagation.captureValues(transitionValues);
            }
        }
    }

    void setCanRemoveViews(boolean canRemoveViews) {
        this.mCanRemoveViews = canRemoveViews;
    }

    @NonNull
    public String toString() {
        return this.toString("");
    }

    @NonNull
    public Transition clone() {
        try {
            Transition clone = (Transition)super.clone();
            clone.mAnimators = new ArrayList();
            clone.mStartValues = new TransitionValuesMaps();
            clone.mEndValues = new TransitionValuesMaps();
            clone.mStartValuesList = null;
            clone.mEndValuesList = null;
            clone.mSeekController = null;
            clone.mCloneParent = this;
            clone.mListeners = null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @NonNull
    public String getName() {
        return this.mName;
    }

    void notifyListeners(TransitionNotification notification, boolean isReversed) {
        this.notifyFromTransition(this, notification, isReversed);
    }

    private void notifyFromTransition(Transition transition, TransitionNotification notification, boolean isReversed) {
        if (this.mCloneParent != null) {
            this.mCloneParent.notifyFromTransition(transition, notification, isReversed);
        }
        if (this.mListeners != null && !this.mListeners.isEmpty()) {
            int size = this.mListeners.size();
            TransitionListener[] listeners = this.mListenersCache == null ? new TransitionListener[size] : this.mListenersCache;
            this.mListenersCache = null;
            listeners = this.mListeners.toArray(listeners);
            for (int i = 0; i < size; ++i) {
                notification.notifyListener(listeners[i], transition, isReversed);
                listeners[i] = null;
            }
            this.mListenersCache = listeners;
        }
    }

    final long getTotalDurationMillis() {
        return this.mTotalDuration;
    }

    @RequiresApi(value=34)
    void setCurrentPlayTimeMillis(long playTimeMillis, long lastPlayTimeMillis) {
        boolean isReversed;
        long duration = this.getTotalDurationMillis();
        boolean bl = isReversed = playTimeMillis < lastPlayTimeMillis;
        if (lastPlayTimeMillis < 0L && playTimeMillis >= 0L || lastPlayTimeMillis > duration && playTimeMillis <= duration) {
            this.mEnded = false;
            this.notifyListeners(TransitionNotification.ON_START, isReversed);
        }
        int numAnimators = this.mCurrentAnimators.size();
        Animator[] cache2 = this.mCurrentAnimators.toArray(this.mAnimatorCache);
        this.mAnimatorCache = EMPTY_ANIMATOR_ARRAY;
        for (int i = 0; i < numAnimators; ++i) {
            Animator animator2 = cache2[i];
            cache2[i] = null;
            long animDuration = Impl26.getTotalDuration(animator2);
            long playTime = Math.min(Math.max(0L, playTimeMillis), animDuration);
            Impl26.setCurrentPlayTime(animator2, playTime);
        }
        this.mAnimatorCache = cache2;
        if (playTimeMillis > duration && lastPlayTimeMillis <= duration || playTimeMillis < 0L && lastPlayTimeMillis >= 0L) {
            if (playTimeMillis > duration) {
                this.mEnded = true;
            }
            this.notifyListeners(TransitionNotification.ON_END, isReversed);
        }
    }

    String toString(String indent) {
        StringBuilder result2 = new StringBuilder(indent).append(this.getClass().getSimpleName()).append("@").append(Integer.toHexString(this.hashCode())).append(": ");
        if (this.mDuration != -1L) {
            result2.append("dur(").append(this.mDuration).append(") ");
        }
        if (this.mStartDelay != -1L) {
            result2.append("dly(").append(this.mStartDelay).append(") ");
        }
        if (this.mInterpolator != null) {
            result2.append("interp(").append(this.mInterpolator).append(") ");
        }
        if (this.mTargetIds.size() > 0 || this.mTargets.size() > 0) {
            int i;
            result2.append("tgts(");
            if (this.mTargetIds.size() > 0) {
                for (i = 0; i < this.mTargetIds.size(); ++i) {
                    if (i > 0) {
                        result2.append(", ");
                    }
                    result2.append(this.mTargetIds.get(i));
                }
            }
            if (this.mTargets.size() > 0) {
                for (i = 0; i < this.mTargets.size(); ++i) {
                    if (i > 0) {
                        result2.append(", ");
                    }
                    result2.append(this.mTargets.get(i));
                }
            }
            result2.append(")");
        }
        return result2.toString();
    }

    @RequiresApi(value=34)
    class SeekController
    extends TransitionListenerAdapter
    implements TransitionSeekController,
    DynamicAnimation.OnAnimationUpdateListener {
        private long mCurrentPlayTime = -1L;
        private ArrayList<Consumer<TransitionSeekController>> mOnReadyListeners = null;
        private ArrayList<Consumer<TransitionSeekController>> mOnProgressListeners = null;
        private boolean mIsReady;
        private boolean mIsCanceled;
        private SpringAnimation mSpringAnimation;
        private Consumer<TransitionSeekController>[] mListenerCache = null;
        private final VelocityTracker1D mVelocityTracker = new VelocityTracker1D();
        private Runnable mResetToStartState;

        SeekController() {
        }

        @Override
        public long getDurationMillis() {
            return Transition.this.getTotalDurationMillis();
        }

        @Override
        public long getCurrentPlayTimeMillis() {
            return Math.min(this.getDurationMillis(), Math.max(0L, this.mCurrentPlayTime));
        }

        @Override
        public float getCurrentFraction() {
            return (float)this.getCurrentPlayTimeMillis() / (float)this.getDurationMillis();
        }

        @Override
        public boolean isReady() {
            return this.mIsReady;
        }

        public void ready() {
            this.mIsReady = true;
            if (this.mOnReadyListeners != null) {
                ArrayList<Consumer<TransitionSeekController>> onReadyListeners = this.mOnReadyListeners;
                this.mOnReadyListeners = null;
                for (int i = 0; i < onReadyListeners.size(); ++i) {
                    onReadyListeners.get(i).accept(this);
                }
            }
            this.callProgressListeners();
        }

        @Override
        public void setCurrentPlayTimeMillis(long playTimeMillis) {
            if (this.mSpringAnimation != null) {
                throw new IllegalStateException("setCurrentPlayTimeMillis() called after animation has been started");
            }
            if (playTimeMillis == this.mCurrentPlayTime || !this.isReady()) {
                return;
            }
            long targetPlayTime = playTimeMillis;
            if (!this.mIsCanceled) {
                if (targetPlayTime == 0L && this.mCurrentPlayTime > 0L) {
                    targetPlayTime = -1L;
                } else {
                    long duration = this.getDurationMillis();
                    if (targetPlayTime == duration && this.mCurrentPlayTime < duration) {
                        targetPlayTime = duration + 1L;
                    }
                }
                if (targetPlayTime != this.mCurrentPlayTime) {
                    Transition.this.setCurrentPlayTimeMillis(targetPlayTime, this.mCurrentPlayTime);
                    this.mCurrentPlayTime = targetPlayTime;
                }
            }
            this.callProgressListeners();
            this.mVelocityTracker.addDataPoint(AnimationUtils.currentAnimationTimeMillis(), targetPlayTime);
        }

        void initPlayTime() {
            long playTime = this.getDurationMillis() == 0L ? 1L : 0L;
            Transition.this.setCurrentPlayTimeMillis(playTime, this.mCurrentPlayTime);
            this.mCurrentPlayTime = playTime;
        }

        @Override
        public void setCurrentFraction(float fraction) {
            if (this.mSpringAnimation != null) {
                throw new IllegalStateException("setCurrentFraction() called after animation has been started");
            }
            this.setCurrentPlayTimeMillis((long)(fraction * (float)this.getDurationMillis()));
        }

        @Override
        public void addOnReadyListener(@NonNull Consumer<TransitionSeekController> onReadyListener) {
            if (this.isReady()) {
                onReadyListener.accept(this);
                return;
            }
            if (this.mOnReadyListeners == null) {
                this.mOnReadyListeners = new ArrayList();
            }
            this.mOnReadyListeners.add(onReadyListener);
        }

        @Override
        public void removeOnReadyListener(@NonNull Consumer<TransitionSeekController> onReadyListener) {
            if (this.mOnReadyListeners != null) {
                this.mOnReadyListeners.remove(onReadyListener);
                if (this.mOnReadyListeners.isEmpty()) {
                    this.mOnReadyListeners = null;
                }
            }
        }

        @Override
        public void onTransitionCancel(@NonNull Transition transition) {
            this.mIsCanceled = true;
        }

        @Override
        public void onAnimationUpdate(DynamicAnimation animation, float value, float velocity) {
            long time = Math.max(-1L, Math.min(this.getDurationMillis() + 1L, Math.round((double)value)));
            Transition.this.setCurrentPlayTimeMillis(time, this.mCurrentPlayTime);
            this.mCurrentPlayTime = time;
            this.callProgressListeners();
        }

        private void ensureAnimation() {
            if (this.mSpringAnimation != null) {
                return;
            }
            this.mVelocityTracker.addDataPoint(AnimationUtils.currentAnimationTimeMillis(), this.mCurrentPlayTime);
            this.mSpringAnimation = new SpringAnimation(new FloatValueHolder());
            SpringForce springForce = new SpringForce();
            springForce.setDampingRatio(1.0f);
            springForce.setStiffness(200.0f);
            this.mSpringAnimation.setSpring(springForce);
            this.mSpringAnimation.setStartValue(this.mCurrentPlayTime);
            this.mSpringAnimation.addUpdateListener(this);
            this.mSpringAnimation.setStartVelocity(this.mVelocityTracker.calculateVelocity());
            this.mSpringAnimation.setMaxValue(this.getDurationMillis() + 1L);
            this.mSpringAnimation.setMinValue(-1.0f);
            this.mSpringAnimation.setMinimumVisibleChange(4.0f);
            this.mSpringAnimation.addEndListener((anim2, canceled, value, velocity) -> {
                if (!canceled) {
                    boolean isReversed;
                    boolean bl = isReversed = value < 1.0f;
                    if (isReversed) {
                        long duration = this.getDurationMillis();
                        Transition child = ((TransitionSet)Transition.this).getTransitionAt(0);
                        Transition cloneParent = child.mCloneParent;
                        child.mCloneParent = null;
                        Transition.this.setCurrentPlayTimeMillis(-1L, this.mCurrentPlayTime);
                        Transition.this.setCurrentPlayTimeMillis(duration, -1L);
                        this.mCurrentPlayTime = duration;
                        if (this.mResetToStartState != null) {
                            this.mResetToStartState.run();
                        }
                        Transition.this.mAnimators.clear();
                        if (cloneParent != null) {
                            cloneParent.notifyListeners(TransitionNotification.ON_END, true);
                        }
                    } else {
                        Transition.this.notifyListeners(TransitionNotification.ON_END, false);
                    }
                }
            });
        }

        @Override
        public void animateToEnd() {
            this.ensureAnimation();
            this.mSpringAnimation.animateToFinalPosition(this.getDurationMillis() + 1L);
        }

        @Override
        public void animateToStart(@NonNull Runnable resetToStartState) {
            this.mResetToStartState = resetToStartState;
            this.ensureAnimation();
            this.mSpringAnimation.animateToFinalPosition(0.0f);
        }

        @Override
        public void addOnProgressChangedListener(@NonNull Consumer<TransitionSeekController> consumer) {
            if (this.mOnProgressListeners == null) {
                this.mOnProgressListeners = new ArrayList();
            }
            this.mOnProgressListeners.add(consumer);
        }

        @Override
        public void removeOnProgressChangedListener(@NonNull Consumer<TransitionSeekController> consumer) {
            if (this.mOnProgressListeners != null) {
                this.mOnProgressListeners.remove(consumer);
            }
        }

        private void callProgressListeners() {
            if (this.mOnProgressListeners == null || this.mOnProgressListeners.isEmpty()) {
                return;
            }
            int size = this.mOnProgressListeners.size();
            if (this.mListenerCache == null) {
                this.mListenerCache = new Consumer[size];
            }
            Consumer<TransitionSeekController>[] cache2 = this.mOnProgressListeners.toArray(this.mListenerCache);
            this.mListenerCache = null;
            for (int i = 0; i < size; ++i) {
                cache2[i].accept(this);
                cache2[i] = null;
            }
            this.mListenerCache = cache2;
        }
    }

    public static interface TransitionListener {
        public void onTransitionStart(@NonNull Transition var1);

        default public void onTransitionStart(@NonNull Transition transition, boolean isReverse) {
            this.onTransitionStart(transition);
        }

        public void onTransitionEnd(@NonNull Transition var1);

        default public void onTransitionEnd(@NonNull Transition transition, boolean isReverse) {
            this.onTransitionEnd(transition);
        }

        public void onTransitionCancel(@NonNull Transition var1);

        public void onTransitionPause(@NonNull Transition var1);

        public void onTransitionResume(@NonNull Transition var1);
    }

    private static class AnimationInfo {
        View mView;
        String mName;
        TransitionValues mValues;
        WindowId mWindowId;
        Transition mTransition;
        Animator mAnimator;

        AnimationInfo(View view, String name, Transition transition, WindowId windowId, TransitionValues values2, Animator animator2) {
            this.mView = view;
            this.mName = name;
            this.mValues = values2;
            this.mWindowId = windowId;
            this.mTransition = transition;
            this.mAnimator = animator2;
        }
    }

    @RequiresApi(value=26)
    private static class Impl26 {
        private Impl26() {
        }

        @DoNotInline
        static long getTotalDuration(Animator animator2) {
            return animator2.getTotalDuration();
        }

        @DoNotInline
        static void setCurrentPlayTime(Animator animator2, long playTimeMillis) {
            ((AnimatorSet)animator2).setCurrentPlayTime(playTimeMillis);
        }
    }

    private static class ArrayListManager {
        private ArrayListManager() {
        }

        static <T> ArrayList<T> add(ArrayList<T> list, T item) {
            if (list == null) {
                list = new ArrayList();
            }
            if (!list.contains(item)) {
                list.add(item);
            }
            return list;
        }

        static <T> ArrayList<T> remove(ArrayList<T> list, T item) {
            if (list != null) {
                list.remove(item);
                if (list.isEmpty()) {
                    list = null;
                }
            }
            return list;
        }
    }

    static interface TransitionNotification {
        public static final TransitionNotification ON_START = TransitionListener::onTransitionStart;
        public static final TransitionNotification ON_END = TransitionListener::onTransitionEnd;
        public static final TransitionNotification ON_CANCEL = (listener2, transition, isReversed) -> listener2.onTransitionCancel(transition);
        public static final TransitionNotification ON_PAUSE = (listener2, transition, isReversed) -> listener2.onTransitionPause(transition);
        public static final TransitionNotification ON_RESUME = (listener2, transition, isReversed) -> listener2.onTransitionResume(transition);

        public void notifyListener(@NonNull TransitionListener var1, @NonNull Transition var2, boolean var3);
    }

    public static abstract class EpicenterCallback {
        @Nullable
        public abstract Rect onGetEpicenter(@NonNull Transition var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static @interface MatchOrder {
    }
}

