/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import java.util.Arrays;

class VelocityTracker1D {
    private static final int HISTORY_SIZE = 20;
    private static final int ASSUME_POINTER_MOVE_STOPPED_MILLIS = 40;
    private static final int HORIZON_MILLIS = 100;
    private long[] mTimeSamples = new long[20];
    private float[] mDataSamples = new float[20];
    private int mIndex = 0;

    VelocityTracker1D() {
        Arrays.fill(this.mTimeSamples, Long.MIN_VALUE);
    }

    public void addDataPoint(long timeMillis, float data) {
        this.mIndex = (this.mIndex + 1) % 20;
        this.mTimeSamples[this.mIndex] = timeMillis;
        this.mDataSamples[this.mIndex] = data;
    }

    public void resetTracking() {
        this.mIndex = 0;
        Arrays.fill(this.mTimeSamples, Long.MIN_VALUE);
        Arrays.fill(this.mDataSamples, 0.0f);
    }

    float calculateVelocity() {
        long sampleTime;
        long newestTime;
        int sampleCount = 0;
        int index = this.mIndex;
        if (index == 0 && this.mTimeSamples[index] == Long.MIN_VALUE) {
            return 0.0f;
        }
        long previousTime = newestTime = this.mTimeSamples[index];
        while ((sampleTime = this.mTimeSamples[index]) != Long.MIN_VALUE) {
            float age = newestTime - sampleTime;
            float delta = Math.abs(sampleTime - previousTime);
            previousTime = sampleTime;
            if (age > 100.0f || delta > 40.0f) break;
            index = (index == 0 ? 20 : index) - 1;
            if (++sampleCount < 20) continue;
        }
        if (sampleCount < 2) {
            return 0.0f;
        }
        if (sampleCount == 2) {
            int prevIndex = this.mIndex == 0 ? 19 : this.mIndex - 1;
            float timeDiff = this.mTimeSamples[this.mIndex] - this.mTimeSamples[prevIndex];
            if (timeDiff == 0.0f) {
                return 0.0f;
            }
            float dataDiff = this.mDataSamples[this.mIndex] - this.mDataSamples[prevIndex];
            return dataDiff / timeDiff * 1000.0f;
        }
        float work = 0.0f;
        int startIndex = (this.mIndex - sampleCount + 20 + 1) % 20;
        int endIndex = (this.mIndex + 1 + 20) % 20;
        previousTime = this.mTimeSamples[startIndex];
        float previousData = this.mDataSamples[startIndex];
        int i = (startIndex + 1) % 20;
        while (i != endIndex) {
            long time = this.mTimeSamples[i];
            long timeDelta = time - previousTime;
            if ((float)timeDelta != 0.0f) {
                float data = this.mDataSamples[i];
                float vPrev = this.kineticEnergyToVelocity(work);
                float dataPointsDelta = data - previousData;
                float vCurr = dataPointsDelta / (float)timeDelta;
                work += (vCurr - vPrev) * Math.abs(vCurr);
                if (i == startIndex + 1) {
                    work *= 0.5f;
                }
                previousTime = time;
                previousData = data;
            }
            i = (i + 1) % 20;
        }
        return this.kineticEnergyToVelocity(work) * 1000.0f;
    }

    private float kineticEnergyToVelocity(float kineticEnergy) {
        return (float)((double)Math.signum(kineticEnergy) * Math.sqrt(2.0f * Math.abs(kineticEnergy)));
    }
}

