/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.annotation.SuppressLint;
import android.graphics.Matrix;
import android.util.Log;
import android.view.View;
import android.view.ViewParent;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class ViewUtilsApi19 {
    private static final String TAG = "ViewUtilsApi19";
    private static boolean sTryHiddenTransitionAlpha = true;
    private static Method sSetFrameMethod;
    private static boolean sSetFrameFetched;
    private static Field sViewFlagsField;
    private static boolean sViewFlagsFieldFetched;
    private static final int VISIBILITY_MASK = 12;
    private float[] mMatrixValues;

    ViewUtilsApi19() {
    }

    @SuppressLint(value={"NewApi"})
    public void setTransitionAlpha(@NonNull View view, float alpha) {
        if (sTryHiddenTransitionAlpha) {
            try {
                Api29Impl.setTransitionAlpha(view, alpha);
                return;
            }
            catch (NoSuchMethodError e) {
                sTryHiddenTransitionAlpha = false;
            }
        }
        view.setAlpha(alpha);
    }

    @SuppressLint(value={"NewApi"})
    public float getTransitionAlpha(@NonNull View view) {
        if (sTryHiddenTransitionAlpha) {
            try {
                return Api29Impl.getTransitionAlpha(view);
            }
            catch (NoSuchMethodError e) {
                sTryHiddenTransitionAlpha = false;
            }
        }
        return view.getAlpha();
    }

    public void saveNonTransitionAlpha(@NonNull View view) {
    }

    public void clearNonTransitionAlpha(@NonNull View view) {
    }

    public void transformMatrixToGlobal(@NonNull View view, @NonNull Matrix matrix) {
        ViewParent parent = view.getParent();
        if (parent instanceof View) {
            View vp = (View)parent;
            this.transformMatrixToGlobal(vp, matrix);
            matrix.preTranslate((float)(-vp.getScrollX()), (float)(-vp.getScrollY()));
        }
        matrix.preTranslate((float)view.getLeft(), (float)view.getTop());
        Matrix vm = view.getMatrix();
        if (!vm.isIdentity()) {
            matrix.preConcat(vm);
        }
    }

    public void transformMatrixToLocal(@NonNull View view, @NonNull Matrix matrix) {
        Matrix inverted;
        ViewParent parent = view.getParent();
        if (parent instanceof View) {
            View vp = (View)parent;
            this.transformMatrixToLocal(vp, matrix);
            matrix.postTranslate((float)vp.getScrollX(), (float)vp.getScrollY());
        }
        matrix.postTranslate((float)(-view.getLeft()), (float)(-view.getTop()));
        Matrix vm = view.getMatrix();
        if (!vm.isIdentity() && vm.invert(inverted = new Matrix())) {
            matrix.postConcat(inverted);
        }
    }

    public void setAnimationMatrix(@NonNull View view, @Nullable Matrix matrix) {
        if (matrix == null || matrix.isIdentity()) {
            view.setPivotX((float)(view.getWidth() / 2));
            view.setPivotY((float)(view.getHeight() / 2));
            view.setTranslationX(0.0f);
            view.setTranslationY(0.0f);
            view.setScaleX(1.0f);
            view.setScaleY(1.0f);
            view.setRotation(0.0f);
        } else {
            float[] values2 = this.mMatrixValues;
            if (values2 == null) {
                this.mMatrixValues = values2 = new float[9];
            }
            matrix.getValues(values2);
            float sin = values2[3];
            float cos = (float)Math.sqrt(1.0f - sin * sin) * (float)(values2[0] < 0.0f ? -1 : 1);
            float rotation = (float)Math.toDegrees(Math.atan2(sin, cos));
            float scaleX = values2[0] / cos;
            float scaleY = values2[4] / cos;
            float dx = values2[2];
            float dy = values2[5];
            view.setPivotX(0.0f);
            view.setPivotY(0.0f);
            view.setTranslationX(dx);
            view.setTranslationY(dy);
            view.setRotation(rotation);
            view.setScaleX(scaleX);
            view.setScaleY(scaleY);
        }
    }

    @SuppressLint(value={"BanUncheckedReflection"})
    public void setLeftTopRightBottom(@NonNull View v, int left, int top, int right, int bottom) {
        this.fetchSetFrame();
        if (sSetFrameMethod != null) {
            try {
                sSetFrameMethod.invoke((Object)v, left, top, right, bottom);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        }
    }

    @SuppressLint(value={"SoonBlockedPrivateApi"})
    public void setTransitionVisibility(@NonNull View view, int visibility) {
        if (!sViewFlagsFieldFetched) {
            try {
                sViewFlagsField = View.class.getDeclaredField("mViewFlags");
                sViewFlagsField.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                Log.i((String)TAG, (String)"fetchViewFlagsField: ");
            }
            sViewFlagsFieldFetched = true;
        }
        if (sViewFlagsField != null) {
            try {
                int viewFlags = sViewFlagsField.getInt(view);
                sViewFlagsField.setInt(view, viewFlags & 0xFFFFFFF3 | visibility);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
    }

    @SuppressLint(value={"PrivateApi", "SoonBlockedPrivateApi"})
    private void fetchSetFrame() {
        if (!sSetFrameFetched) {
            try {
                sSetFrameMethod = View.class.getDeclaredMethod("setFrame", Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                sSetFrameMethod.setAccessible(true);
            }
            catch (NoSuchMethodException e) {
                Log.i((String)TAG, (String)"Failed to retrieve setFrame method", (Throwable)e);
            }
            sSetFrameFetched = true;
        }
    }

    @RequiresApi(value=29)
    static class Api29Impl {
        private Api29Impl() {
        }

        @DoNotInline
        static void setTransitionAlpha(View view, float alpha) {
            view.setTransitionAlpha(alpha);
        }

        @DoNotInline
        static float getTransitionAlpha(View view) {
            return view.getTransitionAlpha();
        }
    }
}

