/*
 * Decompiled with CFR 0.152.
 */
package androidx.transition;

import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.transition.TransitionPropagation;
import androidx.transition.TransitionValues;

public abstract class VisibilityPropagation
extends TransitionPropagation {
    private static final String PROPNAME_VISIBILITY = "android:visibilityPropagation:visibility";
    private static final String PROPNAME_VIEW_CENTER = "android:visibilityPropagation:center";
    private static final String[] VISIBILITY_PROPAGATION_VALUES = new String[]{"android:visibilityPropagation:visibility", "android:visibilityPropagation:center"};

    @Override
    public void captureValues(@NonNull TransitionValues transitionValues) {
        View view = transitionValues.view;
        Integer visibility = (Integer)transitionValues.values.get("android:visibility:visibility");
        if (visibility == null) {
            visibility = view.getVisibility();
        }
        transitionValues.values.put(PROPNAME_VISIBILITY, visibility);
        int[] loc = new int[2];
        view.getLocationOnScreen(loc);
        loc[0] = loc[0] + Math.round(view.getTranslationX());
        loc[0] = loc[0] + view.getWidth() / 2;
        loc[1] = loc[1] + Math.round(view.getTranslationY());
        loc[1] = loc[1] + view.getHeight() / 2;
        transitionValues.values.put(PROPNAME_VIEW_CENTER, loc);
    }

    @Override
    @Nullable
    public String[] getPropagationProperties() {
        return VISIBILITY_PROPAGATION_VALUES;
    }

    public int getViewVisibility(@Nullable TransitionValues values2) {
        if (values2 == null) {
            return 8;
        }
        Integer visibility = (Integer)values2.values.get(PROPNAME_VISIBILITY);
        if (visibility == null) {
            return 8;
        }
        return visibility;
    }

    public int getViewX(@Nullable TransitionValues values2) {
        return VisibilityPropagation.getViewCoordinate(values2, 0);
    }

    public int getViewY(@Nullable TransitionValues values2) {
        return VisibilityPropagation.getViewCoordinate(values2, 1);
    }

    private static int getViewCoordinate(@Nullable TransitionValues values2, int coordinateIndex) {
        if (values2 == null) {
            return -1;
        }
        int[] coordinates = (int[])values2.values.get(PROPNAME_VIEW_CENTER);
        if (coordinates == null) {
            return -1;
        }
        return coordinates[coordinateIndex];
    }
}

