/*
 * Decompiled with CFR 0.152.
 */
package androidx.vectordrawable.graphics.drawable;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.animation.AccelerateDecelerateInterpolator;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AnimationUtils;
import android.view.animation.AnticipateInterpolator;
import android.view.animation.AnticipateOvershootInterpolator;
import android.view.animation.BounceInterpolator;
import android.view.animation.CycleInterpolator;
import android.view.animation.DecelerateInterpolator;
import android.view.animation.Interpolator;
import android.view.animation.LinearInterpolator;
import android.view.animation.OvershootInterpolator;
import androidx.annotation.RestrictTo;
import androidx.interpolator.view.animation.FastOutLinearInInterpolator;
import androidx.interpolator.view.animation.FastOutSlowInInterpolator;
import androidx.interpolator.view.animation.LinearOutSlowInInterpolator;
import androidx.vectordrawable.graphics.drawable.PathInterpolatorCompat;
import java.io.IOException;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
public class AnimationUtilsCompat {
    public static Interpolator loadInterpolator(Context context, int id2) throws Resources.NotFoundException {
        if (Build.VERSION.SDK_INT >= 21) {
            return AnimationUtils.loadInterpolator((Context)context, (int)id2);
        }
        try (XmlResourceParser parser = null;){
            if (id2 == 17563663) {
                FastOutLinearInInterpolator fastOutLinearInInterpolator = new FastOutLinearInInterpolator();
                return fastOutLinearInInterpolator;
            }
            if (id2 == 17563661) {
                FastOutSlowInInterpolator fastOutSlowInInterpolator = new FastOutSlowInInterpolator();
                return fastOutSlowInInterpolator;
            }
            if (id2 == 17563662) {
                LinearOutSlowInInterpolator linearOutSlowInInterpolator = new LinearOutSlowInInterpolator();
                return linearOutSlowInInterpolator;
            }
            parser = context.getResources().getAnimation(id2);
            Interpolator interpolator2 = AnimationUtilsCompat.createInterpolatorFromXml(context, context.getResources(), context.getTheme(), (XmlPullParser)parser);
            return interpolator2;
        }
    }

    private static Interpolator createInterpolatorFromXml(Context context, Resources res, Resources.Theme theme, XmlPullParser parser) throws XmlPullParserException, IOException {
        int type;
        Object interpolator2 = null;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            AttributeSet attrs = Xml.asAttributeSet((XmlPullParser)parser);
            String name = parser.getName();
            if (name.equals("linearInterpolator")) {
                interpolator2 = new LinearInterpolator();
                continue;
            }
            if (name.equals("accelerateInterpolator")) {
                interpolator2 = new AccelerateInterpolator(context, attrs);
                continue;
            }
            if (name.equals("decelerateInterpolator")) {
                interpolator2 = new DecelerateInterpolator(context, attrs);
                continue;
            }
            if (name.equals("accelerateDecelerateInterpolator")) {
                interpolator2 = new AccelerateDecelerateInterpolator();
                continue;
            }
            if (name.equals("cycleInterpolator")) {
                interpolator2 = new CycleInterpolator(context, attrs);
                continue;
            }
            if (name.equals("anticipateInterpolator")) {
                interpolator2 = new AnticipateInterpolator(context, attrs);
                continue;
            }
            if (name.equals("overshootInterpolator")) {
                interpolator2 = new OvershootInterpolator(context, attrs);
                continue;
            }
            if (name.equals("anticipateOvershootInterpolator")) {
                interpolator2 = new AnticipateOvershootInterpolator(context, attrs);
                continue;
            }
            if (name.equals("bounceInterpolator")) {
                interpolator2 = new BounceInterpolator();
                continue;
            }
            if (name.equals("pathInterpolator")) {
                interpolator2 = new PathInterpolatorCompat(context, attrs, parser);
                continue;
            }
            throw new RuntimeException("Unknown interpolator name: " + parser.getName());
        }
        return interpolator2;
    }

    private AnimationUtilsCompat() {
    }
}

