/*
 * Decompiled with CFR 0.152.
 */
package androidx.viewpager2.adapter;

import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcelable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.collection.ArraySet;
import androidx.collection.LongSparseArray;
import androidx.core.util.Preconditions;
import androidx.core.view.ViewCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.adapter.FragmentViewHolder;
import androidx.viewpager2.adapter.StatefulAdapter;
import androidx.viewpager2.widget.ViewPager2;

public abstract class FragmentStateAdapter
extends RecyclerView.Adapter<FragmentViewHolder>
implements StatefulAdapter {
    private static final String KEY_PREFIX_FRAGMENT = "f#";
    private static final String KEY_PREFIX_STATE = "s#";
    private static final long GRACE_WINDOW_TIME_MS = 10000L;
    final Lifecycle mLifecycle;
    final FragmentManager mFragmentManager;
    final LongSparseArray<Fragment> mFragments = new LongSparseArray();
    private final LongSparseArray<Fragment.SavedState> mSavedStates = new LongSparseArray();
    private final LongSparseArray<Integer> mItemIdToViewHolder = new LongSparseArray();
    private FragmentMaxLifecycleEnforcer mFragmentMaxLifecycleEnforcer;
    boolean mIsInGracePeriod = false;
    private boolean mHasStaleFragments = false;

    public FragmentStateAdapter(@NonNull FragmentActivity fragmentActivity) {
        this(fragmentActivity.getSupportFragmentManager(), fragmentActivity.getLifecycle());
    }

    public FragmentStateAdapter(@NonNull Fragment fragment) {
        this(fragment.getChildFragmentManager(), fragment.getLifecycle());
    }

    public FragmentStateAdapter(@NonNull FragmentManager fragmentManager, @NonNull Lifecycle lifecycle) {
        this.mFragmentManager = fragmentManager;
        this.mLifecycle = lifecycle;
        super.setHasStableIds(true);
    }

    @Override
    @CallSuper
    public void onAttachedToRecyclerView(@NonNull RecyclerView recyclerView) {
        Preconditions.checkArgument(this.mFragmentMaxLifecycleEnforcer == null);
        this.mFragmentMaxLifecycleEnforcer = new FragmentMaxLifecycleEnforcer();
        this.mFragmentMaxLifecycleEnforcer.register(recyclerView);
    }

    @Override
    @CallSuper
    public void onDetachedFromRecyclerView(@NonNull RecyclerView recyclerView) {
        this.mFragmentMaxLifecycleEnforcer.unregister(recyclerView);
        this.mFragmentMaxLifecycleEnforcer = null;
    }

    @NonNull
    public abstract Fragment createFragment(int var1);

    @Override
    @NonNull
    public final FragmentViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return FragmentViewHolder.create(parent);
    }

    @Override
    public final void onBindViewHolder(final @NonNull FragmentViewHolder holder, int position) {
        long itemId = holder.getItemId();
        int viewHolderId = holder.getContainer().getId();
        Long boundItemId = this.itemForViewHolder(viewHolderId);
        if (boundItemId != null && boundItemId != itemId) {
            this.removeFragment(boundItemId);
            this.mItemIdToViewHolder.remove(boundItemId);
        }
        this.mItemIdToViewHolder.put(itemId, viewHolderId);
        this.ensureFragment(position);
        final FrameLayout container = holder.getContainer();
        if (ViewCompat.isAttachedToWindow((View)container)) {
            if (container.getParent() != null) {
                throw new IllegalStateException("Design assumption violated.");
            }
            container.addOnLayoutChangeListener(new View.OnLayoutChangeListener(){

                public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                    if (container.getParent() != null) {
                        container.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                        FragmentStateAdapter.this.placeFragmentInViewHolder(holder);
                    }
                }
            });
        }
        this.gcFragments();
    }

    void gcFragments() {
        long itemId;
        int ix;
        if (!this.mHasStaleFragments || this.shouldDelayFragmentTransactions()) {
            return;
        }
        ArraySet<Long> toRemove = new ArraySet<Long>();
        for (ix = 0; ix < this.mFragments.size(); ++ix) {
            itemId = this.mFragments.keyAt(ix);
            if (this.containsItem(itemId)) continue;
            toRemove.add(itemId);
            this.mItemIdToViewHolder.remove(itemId);
        }
        if (!this.mIsInGracePeriod) {
            this.mHasStaleFragments = false;
            for (ix = 0; ix < this.mFragments.size(); ++ix) {
                itemId = this.mFragments.keyAt(ix);
                if (this.isFragmentViewBound(itemId)) continue;
                toRemove.add(itemId);
            }
        }
        for (Long itemId2 : toRemove) {
            this.removeFragment(itemId2);
        }
    }

    private boolean isFragmentViewBound(long itemId) {
        if (this.mItemIdToViewHolder.containsKey(itemId)) {
            return true;
        }
        Fragment fragment = this.mFragments.get(itemId);
        if (fragment == null) {
            return false;
        }
        View view = fragment.getView();
        if (view == null) {
            return false;
        }
        return view.getParent() != null;
    }

    private Long itemForViewHolder(int viewHolderId) {
        Long boundItemId = null;
        for (int ix = 0; ix < this.mItemIdToViewHolder.size(); ++ix) {
            if (this.mItemIdToViewHolder.valueAt(ix) != viewHolderId) continue;
            if (boundItemId != null) {
                throw new IllegalStateException("Design assumption violated: a ViewHolder can only be bound to one item at a time.");
            }
            boundItemId = this.mItemIdToViewHolder.keyAt(ix);
        }
        return boundItemId;
    }

    private void ensureFragment(int position) {
        long itemId = this.getItemId(position);
        if (!this.mFragments.containsKey(itemId)) {
            Fragment newFragment = this.createFragment(position);
            newFragment.setInitialSavedState(this.mSavedStates.get(itemId));
            this.mFragments.put(itemId, newFragment);
        }
    }

    @Override
    public final void onViewAttachedToWindow(@NonNull FragmentViewHolder holder) {
        this.placeFragmentInViewHolder(holder);
        this.gcFragments();
    }

    void placeFragmentInViewHolder(final @NonNull FragmentViewHolder holder) {
        Fragment fragment = this.mFragments.get(holder.getItemId());
        if (fragment == null) {
            throw new IllegalStateException("Design assumption violated.");
        }
        FrameLayout container = holder.getContainer();
        View view = fragment.getView();
        if (!fragment.isAdded() && view != null) {
            throw new IllegalStateException("Design assumption violated.");
        }
        if (fragment.isAdded() && view == null) {
            this.scheduleViewAttach(fragment, container);
            return;
        }
        if (fragment.isAdded() && view.getParent() != null) {
            if (view.getParent() != container) {
                this.addViewToContainer(view, container);
            }
            return;
        }
        if (fragment.isAdded()) {
            this.addViewToContainer(view, container);
            return;
        }
        if (!this.shouldDelayFragmentTransactions()) {
            this.scheduleViewAttach(fragment, container);
            this.mFragmentManager.beginTransaction().add(fragment, "f" + holder.getItemId()).setMaxLifecycle(fragment, Lifecycle.State.STARTED).commitNow();
            this.mFragmentMaxLifecycleEnforcer.updateFragmentMaxLifecycle(false);
        } else {
            if (this.mFragmentManager.isDestroyed()) {
                return;
            }
            this.mLifecycle.addObserver(new LifecycleEventObserver(){

                @Override
                public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
                    if (FragmentStateAdapter.this.shouldDelayFragmentTransactions()) {
                        return;
                    }
                    source.getLifecycle().removeObserver(this);
                    if (ViewCompat.isAttachedToWindow((View)holder.getContainer())) {
                        FragmentStateAdapter.this.placeFragmentInViewHolder(holder);
                    }
                }
            });
        }
    }

    private void scheduleViewAttach(final Fragment fragment, final @NonNull FrameLayout container) {
        this.mFragmentManager.registerFragmentLifecycleCallbacks(new FragmentManager.FragmentLifecycleCallbacks(){

            @Override
            public void onFragmentViewCreated(@NonNull FragmentManager fm, @NonNull Fragment f, @NonNull View v, @Nullable Bundle savedInstanceState) {
                if (f == fragment) {
                    fm.unregisterFragmentLifecycleCallbacks(this);
                    FragmentStateAdapter.this.addViewToContainer(v, container);
                }
            }
        }, false);
    }

    void addViewToContainer(@NonNull View v, @NonNull FrameLayout container) {
        if (container.getChildCount() > 1) {
            throw new IllegalStateException("Design assumption violated.");
        }
        if (v.getParent() == container) {
            return;
        }
        if (container.getChildCount() > 0) {
            container.removeAllViews();
        }
        if (v.getParent() != null) {
            ((ViewGroup)v.getParent()).removeView(v);
        }
        container.addView(v);
    }

    @Override
    public final void onViewRecycled(@NonNull FragmentViewHolder holder) {
        int viewHolderId = holder.getContainer().getId();
        Long boundItemId = this.itemForViewHolder(viewHolderId);
        if (boundItemId != null) {
            this.removeFragment(boundItemId);
            this.mItemIdToViewHolder.remove(boundItemId);
        }
    }

    @Override
    public final boolean onFailedToRecycleView(@NonNull FragmentViewHolder holder) {
        return true;
    }

    private void removeFragment(long itemId) {
        ViewParent viewParent;
        Fragment fragment = this.mFragments.get(itemId);
        if (fragment == null) {
            return;
        }
        if (fragment.getView() != null && (viewParent = fragment.getView().getParent()) != null) {
            ((FrameLayout)viewParent).removeAllViews();
        }
        if (!this.containsItem(itemId)) {
            this.mSavedStates.remove(itemId);
        }
        if (!fragment.isAdded()) {
            this.mFragments.remove(itemId);
            return;
        }
        if (this.shouldDelayFragmentTransactions()) {
            this.mHasStaleFragments = true;
            return;
        }
        if (fragment.isAdded() && this.containsItem(itemId)) {
            this.mSavedStates.put(itemId, this.mFragmentManager.saveFragmentInstanceState(fragment));
        }
        this.mFragmentManager.beginTransaction().remove(fragment).commitNow();
        this.mFragments.remove(itemId);
    }

    boolean shouldDelayFragmentTransactions() {
        return this.mFragmentManager.isStateSaved();
    }

    @Override
    public long getItemId(int position) {
        return position;
    }

    public boolean containsItem(long itemId) {
        return itemId >= 0L && itemId < (long)this.getItemCount();
    }

    @Override
    public final void setHasStableIds(boolean hasStableIds) {
        throw new UnsupportedOperationException("Stable Ids are required for the adapter to function properly, and the adapter takes care of setting the flag.");
    }

    @Override
    @NonNull
    public final Parcelable saveState() {
        long itemId;
        int ix;
        Bundle savedState = new Bundle(this.mFragments.size() + this.mSavedStates.size());
        for (ix = 0; ix < this.mFragments.size(); ++ix) {
            itemId = this.mFragments.keyAt(ix);
            Fragment fragment = this.mFragments.get(itemId);
            if (fragment == null || !fragment.isAdded()) continue;
            String key = FragmentStateAdapter.createKey(KEY_PREFIX_FRAGMENT, itemId);
            this.mFragmentManager.putFragment(savedState, key, fragment);
        }
        for (ix = 0; ix < this.mSavedStates.size(); ++ix) {
            itemId = this.mSavedStates.keyAt(ix);
            if (!this.containsItem(itemId)) continue;
            String key = FragmentStateAdapter.createKey(KEY_PREFIX_STATE, itemId);
            savedState.putParcelable(key, (Parcelable)this.mSavedStates.get(itemId));
        }
        return savedState;
    }

    @Override
    public final void restoreState(@NonNull Parcelable savedState) {
        if (!this.mSavedStates.isEmpty() || !this.mFragments.isEmpty()) {
            throw new IllegalStateException("Expected the adapter to be 'fresh' while restoring state.");
        }
        Bundle bundle = (Bundle)savedState;
        if (bundle.getClassLoader() == null) {
            bundle.setClassLoader(this.getClass().getClassLoader());
        }
        for (String key : bundle.keySet()) {
            long itemId;
            if (FragmentStateAdapter.isValidKey(key, KEY_PREFIX_FRAGMENT)) {
                itemId = FragmentStateAdapter.parseIdFromKey(key, KEY_PREFIX_FRAGMENT);
                Fragment fragment = this.mFragmentManager.getFragment(bundle, key);
                this.mFragments.put(itemId, fragment);
                continue;
            }
            if (FragmentStateAdapter.isValidKey(key, KEY_PREFIX_STATE)) {
                itemId = FragmentStateAdapter.parseIdFromKey(key, KEY_PREFIX_STATE);
                Fragment.SavedState state = (Fragment.SavedState)bundle.getParcelable(key);
                if (!this.containsItem(itemId)) continue;
                this.mSavedStates.put(itemId, state);
                continue;
            }
            throw new IllegalArgumentException("Unexpected key in savedState: " + key);
        }
        if (!this.mFragments.isEmpty()) {
            this.mHasStaleFragments = true;
            this.mIsInGracePeriod = true;
            this.gcFragments();
            this.scheduleGracePeriodEnd();
        }
    }

    private void scheduleGracePeriodEnd() {
        final Handler handler = new Handler(Looper.getMainLooper());
        final Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                FragmentStateAdapter.this.mIsInGracePeriod = false;
                FragmentStateAdapter.this.gcFragments();
            }
        };
        this.mLifecycle.addObserver(new LifecycleEventObserver(){

            @Override
            public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
                if (event == Lifecycle.Event.ON_DESTROY) {
                    handler.removeCallbacks(runnable2);
                    source.getLifecycle().removeObserver(this);
                }
            }
        });
        handler.postDelayed(runnable2, 10000L);
    }

    @NonNull
    private static String createKey(@NonNull String prefix, long id2) {
        return prefix + id2;
    }

    private static boolean isValidKey(@NonNull String key, @NonNull String prefix) {
        return key.startsWith(prefix) && key.length() > prefix.length();
    }

    private static long parseIdFromKey(@NonNull String key, @NonNull String prefix) {
        return Long.parseLong(key.substring(prefix.length()));
    }

    private static abstract class DataSetChangeObserver
    extends RecyclerView.AdapterDataObserver {
        private DataSetChangeObserver() {
        }

        @Override
        public abstract void onChanged();

        @Override
        public final void onItemRangeChanged(int positionStart, int itemCount) {
            this.onChanged();
        }

        @Override
        public final void onItemRangeChanged(int positionStart, int itemCount, @Nullable Object payload) {
            this.onChanged();
        }

        @Override
        public final void onItemRangeInserted(int positionStart, int itemCount) {
            this.onChanged();
        }

        @Override
        public final void onItemRangeRemoved(int positionStart, int itemCount) {
            this.onChanged();
        }

        @Override
        public final void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            this.onChanged();
        }
    }

    class FragmentMaxLifecycleEnforcer {
        private ViewPager2.OnPageChangeCallback mPageChangeCallback;
        private RecyclerView.AdapterDataObserver mDataObserver;
        private LifecycleEventObserver mLifecycleObserver;
        private ViewPager2 mViewPager;
        private long mPrimaryItemId = -1L;

        FragmentMaxLifecycleEnforcer() {
        }

        void register(@NonNull RecyclerView recyclerView) {
            this.mViewPager = this.inferViewPager(recyclerView);
            this.mPageChangeCallback = new ViewPager2.OnPageChangeCallback(){

                @Override
                public void onPageScrollStateChanged(int state) {
                    FragmentMaxLifecycleEnforcer.this.updateFragmentMaxLifecycle(false);
                }

                @Override
                public void onPageSelected(int position) {
                    FragmentMaxLifecycleEnforcer.this.updateFragmentMaxLifecycle(false);
                }
            };
            this.mViewPager.registerOnPageChangeCallback(this.mPageChangeCallback);
            this.mDataObserver = new DataSetChangeObserver(){

                @Override
                public void onChanged() {
                    FragmentMaxLifecycleEnforcer.this.updateFragmentMaxLifecycle(true);
                }
            };
            FragmentStateAdapter.this.registerAdapterDataObserver(this.mDataObserver);
            this.mLifecycleObserver = new LifecycleEventObserver(){

                @Override
                public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
                    FragmentMaxLifecycleEnforcer.this.updateFragmentMaxLifecycle(false);
                }
            };
            FragmentStateAdapter.this.mLifecycle.addObserver(this.mLifecycleObserver);
        }

        void unregister(@NonNull RecyclerView recyclerView) {
            ViewPager2 viewPager = this.inferViewPager(recyclerView);
            viewPager.unregisterOnPageChangeCallback(this.mPageChangeCallback);
            FragmentStateAdapter.this.unregisterAdapterDataObserver(this.mDataObserver);
            FragmentStateAdapter.this.mLifecycle.removeObserver(this.mLifecycleObserver);
            this.mViewPager = null;
        }

        void updateFragmentMaxLifecycle(boolean dataSetChanged) {
            if (FragmentStateAdapter.this.shouldDelayFragmentTransactions()) {
                return;
            }
            if (this.mViewPager.getScrollState() != 0) {
                return;
            }
            if (FragmentStateAdapter.this.mFragments.isEmpty() || FragmentStateAdapter.this.getItemCount() == 0) {
                return;
            }
            int currentItem = this.mViewPager.getCurrentItem();
            if (currentItem >= FragmentStateAdapter.this.getItemCount()) {
                return;
            }
            long currentItemId = FragmentStateAdapter.this.getItemId(currentItem);
            if (currentItemId == this.mPrimaryItemId && !dataSetChanged) {
                return;
            }
            Fragment currentItemFragment = FragmentStateAdapter.this.mFragments.get(currentItemId);
            if (currentItemFragment == null || !currentItemFragment.isAdded()) {
                return;
            }
            this.mPrimaryItemId = currentItemId;
            FragmentTransaction transaction = FragmentStateAdapter.this.mFragmentManager.beginTransaction();
            Fragment toResume = null;
            for (int ix = 0; ix < FragmentStateAdapter.this.mFragments.size(); ++ix) {
                long itemId = FragmentStateAdapter.this.mFragments.keyAt(ix);
                Fragment fragment = FragmentStateAdapter.this.mFragments.valueAt(ix);
                if (!fragment.isAdded()) continue;
                if (itemId != this.mPrimaryItemId) {
                    transaction.setMaxLifecycle(fragment, Lifecycle.State.STARTED);
                } else {
                    toResume = fragment;
                }
                fragment.setMenuVisibility(itemId == this.mPrimaryItemId);
            }
            if (toResume != null) {
                transaction.setMaxLifecycle(toResume, Lifecycle.State.RESUMED);
            }
            if (!transaction.isEmpty()) {
                transaction.commitNow();
            }
        }

        @NonNull
        private ViewPager2 inferViewPager(@NonNull RecyclerView recyclerView) {
            ViewParent parent = recyclerView.getParent();
            if (parent instanceof ViewPager2) {
                return (ViewPager2)parent;
            }
            throw new IllegalStateException("Expected ViewPager2 instance. Got: " + parent);
        }
    }
}

