/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.animation;

import android.util.Property;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import com.google.android.material.R;

public class ChildrenAlphaProperty
extends Property<ViewGroup, Float> {
    public static final Property<ViewGroup, Float> CHILDREN_ALPHA = new ChildrenAlphaProperty("childrenAlpha");

    private ChildrenAlphaProperty(String name) {
        super(Float.class, name);
    }

    @NonNull
    public Float get(@NonNull ViewGroup object) {
        Float alpha = (Float)object.getTag(R.id.mtrl_internal_children_alpha_tag);
        if (alpha != null) {
            return alpha;
        }
        return Float.valueOf(1.0f);
    }

    public void set(@NonNull ViewGroup object, @NonNull Float value) {
        float alpha = value.floatValue();
        object.setTag(R.id.mtrl_internal_children_alpha_tag, (Object)Float.valueOf(alpha));
        int count2 = object.getChildCount();
        for (int i = 0; i < count2; ++i) {
            View child = object.getChildAt(i);
            child.setAlpha(alpha);
        }
    }
}

