/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.animation;

import android.animation.Animator;
import android.animation.AnimatorInflater;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.Log;
import android.util.Property;
import androidx.annotation.AnimatorRes;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.StyleableRes;
import androidx.collection.SimpleArrayMap;
import com.google.android.material.animation.MotionTiming;
import java.util.ArrayList;
import java.util.List;

public class MotionSpec {
    private static final String TAG = "MotionSpec";
    private final SimpleArrayMap<String, MotionTiming> timings = new SimpleArrayMap();
    private final SimpleArrayMap<String, PropertyValuesHolder[]> propertyValues = new SimpleArrayMap();

    public boolean hasTiming(String name) {
        return this.timings.get(name) != null;
    }

    public MotionTiming getTiming(String name) {
        if (!this.hasTiming(name)) {
            throw new IllegalArgumentException();
        }
        return this.timings.get(name);
    }

    public void setTiming(String name, @Nullable MotionTiming timing) {
        this.timings.put(name, timing);
    }

    public boolean hasPropertyValues(String name) {
        return this.propertyValues.get(name) != null;
    }

    @NonNull
    public PropertyValuesHolder[] getPropertyValues(String name) {
        if (!this.hasPropertyValues(name)) {
            throw new IllegalArgumentException();
        }
        return this.clonePropertyValuesHolder(this.propertyValues.get(name));
    }

    public void setPropertyValues(String name, PropertyValuesHolder[] values2) {
        this.propertyValues.put(name, values2);
    }

    @NonNull
    private PropertyValuesHolder[] clonePropertyValuesHolder(@NonNull PropertyValuesHolder[] values2) {
        PropertyValuesHolder[] ret = new PropertyValuesHolder[values2.length];
        for (int i = 0; i < values2.length; ++i) {
            ret[i] = values2[i].clone();
        }
        return ret;
    }

    @NonNull
    public <T> ObjectAnimator getAnimator(@NonNull String name, @NonNull T target, @NonNull Property<T, ?> property) {
        ObjectAnimator animator2 = ObjectAnimator.ofPropertyValuesHolder(target, (PropertyValuesHolder[])this.getPropertyValues(name));
        animator2.setProperty(property);
        this.getTiming(name).apply((Animator)animator2);
        return animator2;
    }

    public long getTotalDuration() {
        long duration = 0L;
        int count2 = this.timings.size();
        for (int i = 0; i < count2; ++i) {
            MotionTiming timing = this.timings.valueAt(i);
            duration = Math.max(duration, timing.getDelay() + timing.getDuration());
        }
        return duration;
    }

    @Nullable
    public static MotionSpec createFromAttribute(@NonNull Context context, @NonNull TypedArray attributes, @StyleableRes int index) {
        int resourceId;
        if (attributes.hasValue(index) && (resourceId = attributes.getResourceId(index, 0)) != 0) {
            return MotionSpec.createFromResource(context, resourceId);
        }
        return null;
    }

    @Nullable
    public static MotionSpec createFromResource(@NonNull Context context, @AnimatorRes int id2) {
        try {
            Animator animator2 = AnimatorInflater.loadAnimator((Context)context, (int)id2);
            if (animator2 instanceof AnimatorSet) {
                AnimatorSet set = (AnimatorSet)animator2;
                return MotionSpec.createSpecFromAnimators(set.getChildAnimations());
            }
            if (animator2 != null) {
                ArrayList<Animator> animators = new ArrayList<Animator>();
                animators.add(animator2);
                return MotionSpec.createSpecFromAnimators(animators);
            }
            return null;
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("Can't load animation resource ID #0x" + Integer.toHexString(id2)), (Throwable)e);
            return null;
        }
    }

    @NonNull
    private static MotionSpec createSpecFromAnimators(@NonNull List<Animator> animators) {
        MotionSpec spec = new MotionSpec();
        int count2 = animators.size();
        for (int i = 0; i < count2; ++i) {
            MotionSpec.addInfoFromAnimator(spec, animators.get(i));
        }
        return spec;
    }

    private static void addInfoFromAnimator(@NonNull MotionSpec spec, Animator animator2) {
        if (!(animator2 instanceof ObjectAnimator)) {
            throw new IllegalArgumentException("Animator must be an ObjectAnimator: " + animator2);
        }
        ObjectAnimator anim2 = (ObjectAnimator)animator2;
        spec.setPropertyValues(anim2.getPropertyName(), anim2.getValues());
        spec.setTiming(anim2.getPropertyName(), MotionTiming.createFromAnimator((ValueAnimator)anim2));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MotionSpec)) {
            return false;
        }
        MotionSpec that = (MotionSpec)o;
        return this.timings.equals(that.timings);
    }

    public int hashCode() {
        return this.timings.hashCode();
    }

    @NonNull
    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append('\n');
        out.append(this.getClass().getName());
        out.append('{');
        out.append(Integer.toHexString(System.identityHashCode(this)));
        out.append(" timings: ");
        out.append(this.timings);
        out.append("}\n");
        return out.toString();
    }
}

