/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.appbar;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.DrawableRes;
import androidx.annotation.FloatRange;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;
import androidx.appcompat.R;
import androidx.appcompat.widget.Toolbar;
import androidx.core.content.ContextCompat;
import androidx.core.graphics.drawable.DrawableCompat;
import androidx.core.math.MathUtils;
import androidx.core.util.ObjectsCompat;
import androidx.core.view.OnApplyWindowInsetsListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.appbar.AppBarLayout;
import com.google.android.material.appbar.ViewOffsetHelper;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.elevation.ElevationOverlayProvider;
import com.google.android.material.internal.CollapsingTextHelper;
import com.google.android.material.internal.DescendantOffsetUtils;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.motion.MotionUtils;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.theme.overlay.MaterialThemeOverlay;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class CollapsingToolbarLayout
extends FrameLayout {
    private static final int DEF_STYLE_RES = R.style.Widget_Design_CollapsingToolbar;
    private static final int DEFAULT_SCRIM_ANIMATION_DURATION = 600;
    public static final int TITLE_COLLAPSE_MODE_SCALE = 0;
    public static final int TITLE_COLLAPSE_MODE_FADE = 1;
    private boolean refreshToolbar = true;
    private int toolbarId;
    @Nullable
    private ViewGroup toolbar;
    @Nullable
    private View toolbarDirectChild;
    private View dummyView;
    private int expandedMarginStart;
    private int expandedMarginTop;
    private int expandedMarginEnd;
    private int expandedMarginBottom;
    private final Rect tmpRect = new Rect();
    @NonNull
    final CollapsingTextHelper collapsingTextHelper;
    @NonNull
    final ElevationOverlayProvider elevationOverlayProvider;
    private boolean collapsingTitleEnabled;
    private boolean drawCollapsingTitle;
    @Nullable
    private Drawable contentScrim;
    @Nullable
    Drawable statusBarScrim;
    private int scrimAlpha;
    private boolean scrimsAreShown;
    private ValueAnimator scrimAnimator;
    private long scrimAnimationDuration;
    private final TimeInterpolator scrimAnimationFadeInInterpolator;
    private final TimeInterpolator scrimAnimationFadeOutInterpolator;
    private int scrimVisibleHeightTrigger = -1;
    private AppBarLayout.OnOffsetChangedListener onOffsetChangedListener;
    int currentOffset;
    private int titleCollapseMode;
    @Nullable
    WindowInsetsCompat lastInsets;
    private int topInsetApplied = 0;
    private boolean forceApplySystemWindowInsetTop;
    private int extraMultilineHeight = 0;
    private boolean extraMultilineHeightEnabled;

    public CollapsingToolbarLayout(@NonNull Context context) {
        this(context, null);
    }

    public CollapsingToolbarLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, R.attr.collapsingToolbarLayoutStyle);
    }

    public CollapsingToolbarLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(MaterialThemeOverlay.wrap(context, attrs, defStyleAttr, DEF_STYLE_RES), attrs, defStyleAttr);
        context = this.getContext();
        this.collapsingTextHelper = new CollapsingTextHelper((View)this);
        this.collapsingTextHelper.setTextSizeInterpolator(AnimationUtils.DECELERATE_INTERPOLATOR);
        this.collapsingTextHelper.setRtlTextDirectionHeuristicsEnabled(false);
        this.elevationOverlayProvider = new ElevationOverlayProvider(context);
        TypedArray a = ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.CollapsingToolbarLayout, defStyleAttr, DEF_STYLE_RES, new int[0]);
        this.collapsingTextHelper.setExpandedTextGravity(a.getInt(R.styleable.CollapsingToolbarLayout_expandedTitleGravity, 8388691));
        this.collapsingTextHelper.setCollapsedTextGravity(a.getInt(R.styleable.CollapsingToolbarLayout_collapsedTitleGravity, 8388627));
        this.expandedMarginEnd = this.expandedMarginBottom = a.getDimensionPixelSize(R.styleable.CollapsingToolbarLayout_expandedTitleMargin, 0);
        this.expandedMarginTop = this.expandedMarginBottom;
        this.expandedMarginStart = this.expandedMarginBottom;
        if (a.hasValue(R.styleable.CollapsingToolbarLayout_expandedTitleMarginStart)) {
            this.expandedMarginStart = a.getDimensionPixelSize(R.styleable.CollapsingToolbarLayout_expandedTitleMarginStart, 0);
        }
        if (a.hasValue(R.styleable.CollapsingToolbarLayout_expandedTitleMarginEnd)) {
            this.expandedMarginEnd = a.getDimensionPixelSize(R.styleable.CollapsingToolbarLayout_expandedTitleMarginEnd, 0);
        }
        if (a.hasValue(R.styleable.CollapsingToolbarLayout_expandedTitleMarginTop)) {
            this.expandedMarginTop = a.getDimensionPixelSize(R.styleable.CollapsingToolbarLayout_expandedTitleMarginTop, 0);
        }
        if (a.hasValue(R.styleable.CollapsingToolbarLayout_expandedTitleMarginBottom)) {
            this.expandedMarginBottom = a.getDimensionPixelSize(R.styleable.CollapsingToolbarLayout_expandedTitleMarginBottom, 0);
        }
        this.collapsingTitleEnabled = a.getBoolean(R.styleable.CollapsingToolbarLayout_titleEnabled, true);
        this.setTitle(a.getText(R.styleable.CollapsingToolbarLayout_title));
        this.collapsingTextHelper.setExpandedTextAppearance(R.style.TextAppearance_Design_CollapsingToolbar_Expanded);
        this.collapsingTextHelper.setCollapsedTextAppearance(R.style.TextAppearance_AppCompat_Widget_ActionBar_Title);
        if (a.hasValue(R.styleable.CollapsingToolbarLayout_expandedTitleTextAppearance)) {
            this.collapsingTextHelper.setExpandedTextAppearance(a.getResourceId(R.styleable.CollapsingToolbarLayout_expandedTitleTextAppearance, 0));
        }
        if (a.hasValue(R.styleable.CollapsingToolbarLayout_collapsedTitleTextAppearance)) {
            this.collapsingTextHelper.setCollapsedTextAppearance(a.getResourceId(R.styleable.CollapsingToolbarLayout_collapsedTitleTextAppearance, 0));
        }
        if (a.hasValue(R.styleable.CollapsingToolbarLayout_titleTextEllipsize)) {
            this.setTitleEllipsize(this.convertEllipsizeToTruncateAt(a.getInt(R.styleable.CollapsingToolbarLayout_titleTextEllipsize, -1)));
        }
        if (a.hasValue(R.styleable.CollapsingToolbarLayout_expandedTitleTextColor)) {
            this.collapsingTextHelper.setExpandedTextColor(MaterialResources.getColorStateList(context, a, R.styleable.CollapsingToolbarLayout_expandedTitleTextColor));
        }
        if (a.hasValue(R.styleable.CollapsingToolbarLayout_collapsedTitleTextColor)) {
            this.collapsingTextHelper.setCollapsedTextColor(MaterialResources.getColorStateList(context, a, R.styleable.CollapsingToolbarLayout_collapsedTitleTextColor));
        }
        this.scrimVisibleHeightTrigger = a.getDimensionPixelSize(R.styleable.CollapsingToolbarLayout_scrimVisibleHeightTrigger, -1);
        if (a.hasValue(R.styleable.CollapsingToolbarLayout_maxLines)) {
            this.collapsingTextHelper.setMaxLines(a.getInt(R.styleable.CollapsingToolbarLayout_maxLines, 1));
        }
        if (a.hasValue(R.styleable.CollapsingToolbarLayout_titlePositionInterpolator)) {
            this.collapsingTextHelper.setPositionInterpolator((TimeInterpolator)android.view.animation.AnimationUtils.loadInterpolator((Context)context, (int)a.getResourceId(R.styleable.CollapsingToolbarLayout_titlePositionInterpolator, 0)));
        }
        this.scrimAnimationDuration = a.getInt(R.styleable.CollapsingToolbarLayout_scrimAnimationDuration, 600);
        this.scrimAnimationFadeInInterpolator = MotionUtils.resolveThemeInterpolator(context, R.attr.motionEasingStandardInterpolator, AnimationUtils.FAST_OUT_LINEAR_IN_INTERPOLATOR);
        this.scrimAnimationFadeOutInterpolator = MotionUtils.resolveThemeInterpolator(context, R.attr.motionEasingStandardInterpolator, AnimationUtils.LINEAR_OUT_SLOW_IN_INTERPOLATOR);
        this.setContentScrim(a.getDrawable(R.styleable.CollapsingToolbarLayout_contentScrim));
        this.setStatusBarScrim(a.getDrawable(R.styleable.CollapsingToolbarLayout_statusBarScrim));
        this.setTitleCollapseMode(a.getInt(R.styleable.CollapsingToolbarLayout_titleCollapseMode, 0));
        this.toolbarId = a.getResourceId(R.styleable.CollapsingToolbarLayout_toolbarId, -1);
        this.forceApplySystemWindowInsetTop = a.getBoolean(R.styleable.CollapsingToolbarLayout_forceApplySystemWindowInsetTop, false);
        this.extraMultilineHeightEnabled = a.getBoolean(R.styleable.CollapsingToolbarLayout_extraMultilineHeightEnabled, false);
        a.recycle();
        this.setWillNotDraw(false);
        ViewCompat.setOnApplyWindowInsetsListener((View)this, new OnApplyWindowInsetsListener(){

            @Override
            public WindowInsetsCompat onApplyWindowInsets(View v, @NonNull WindowInsetsCompat insets) {
                return CollapsingToolbarLayout.this.onWindowInsetChanged(insets);
            }
        });
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        ViewParent parent = this.getParent();
        if (parent instanceof AppBarLayout) {
            AppBarLayout appBarLayout = (AppBarLayout)parent;
            this.disableLiftOnScrollIfNeeded(appBarLayout);
            ViewCompat.setFitsSystemWindows((View)this, ViewCompat.getFitsSystemWindows((View)appBarLayout));
            if (this.onOffsetChangedListener == null) {
                this.onOffsetChangedListener = new OffsetUpdateListener();
            }
            appBarLayout.addOnOffsetChangedListener(this.onOffsetChangedListener);
            ViewCompat.requestApplyInsets((View)this);
        }
    }

    protected void onDetachedFromWindow() {
        ViewParent parent = this.getParent();
        if (this.onOffsetChangedListener != null && parent instanceof AppBarLayout) {
            ((AppBarLayout)parent).removeOnOffsetChangedListener(this.onOffsetChangedListener);
        }
        super.onDetachedFromWindow();
    }

    WindowInsetsCompat onWindowInsetChanged(@NonNull WindowInsetsCompat insets) {
        WindowInsetsCompat newInsets = null;
        if (ViewCompat.getFitsSystemWindows((View)this)) {
            newInsets = insets;
        }
        if (!ObjectsCompat.equals(this.lastInsets, newInsets)) {
            this.lastInsets = newInsets;
            this.requestLayout();
        }
        return insets.consumeSystemWindowInsets();
    }

    public void draw(@NonNull Canvas canvas) {
        super.draw(canvas);
        this.ensureToolbar();
        if (this.toolbar == null && this.contentScrim != null && this.scrimAlpha > 0) {
            this.contentScrim.mutate().setAlpha(this.scrimAlpha);
            this.contentScrim.draw(canvas);
        }
        if (this.collapsingTitleEnabled && this.drawCollapsingTitle) {
            if (this.toolbar != null && this.contentScrim != null && this.scrimAlpha > 0 && this.isTitleCollapseFadeMode() && this.collapsingTextHelper.getExpansionFraction() < this.collapsingTextHelper.getFadeModeThresholdFraction()) {
                int save = canvas.save();
                canvas.clipRect(this.contentScrim.getBounds(), Region.Op.DIFFERENCE);
                this.collapsingTextHelper.draw(canvas);
                canvas.restoreToCount(save);
            } else {
                this.collapsingTextHelper.draw(canvas);
            }
        }
        if (this.statusBarScrim != null && this.scrimAlpha > 0) {
            int topInset;
            int n = topInset = this.lastInsets != null ? this.lastInsets.getSystemWindowInsetTop() : 0;
            if (topInset > 0) {
                this.statusBarScrim.setBounds(0, -this.currentOffset, this.getWidth(), topInset - this.currentOffset);
                this.statusBarScrim.mutate().setAlpha(this.scrimAlpha);
                this.statusBarScrim.draw(canvas);
            }
        }
    }

    protected void onConfigurationChanged(@NonNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.collapsingTextHelper.maybeUpdateFontWeightAdjustment(newConfig);
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        boolean invalidated = false;
        if (this.contentScrim != null && this.scrimAlpha > 0 && this.isToolbarChild(child)) {
            this.updateContentScrimBounds(this.contentScrim, child, this.getWidth(), this.getHeight());
            this.contentScrim.mutate().setAlpha(this.scrimAlpha);
            this.contentScrim.draw(canvas);
            invalidated = true;
        }
        return super.drawChild(canvas, child, drawingTime) || invalidated;
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.contentScrim != null) {
            this.updateContentScrimBounds(this.contentScrim, w, h);
        }
    }

    private boolean isTitleCollapseFadeMode() {
        return this.titleCollapseMode == 1;
    }

    private void disableLiftOnScrollIfNeeded(AppBarLayout appBarLayout) {
        if (this.isTitleCollapseFadeMode()) {
            appBarLayout.setLiftOnScroll(false);
        }
    }

    private void updateContentScrimBounds(@NonNull Drawable contentScrim, int width, int height) {
        this.updateContentScrimBounds(contentScrim, (View)this.toolbar, width, height);
    }

    private void updateContentScrimBounds(@NonNull Drawable contentScrim, @Nullable View toolbar, int width, int height) {
        int bottom = this.isTitleCollapseFadeMode() && toolbar != null && this.collapsingTitleEnabled ? toolbar.getBottom() : height;
        contentScrim.setBounds(0, 0, width, bottom);
    }

    private void ensureToolbar() {
        if (!this.refreshToolbar) {
            return;
        }
        this.toolbar = null;
        this.toolbarDirectChild = null;
        if (this.toolbarId != -1) {
            this.toolbar = (ViewGroup)this.findViewById(this.toolbarId);
            if (this.toolbar != null) {
                this.toolbarDirectChild = this.findDirectChild((View)this.toolbar);
            }
        }
        if (this.toolbar == null) {
            ViewGroup toolbar = null;
            int count2 = this.getChildCount();
            for (int i = 0; i < count2; ++i) {
                View child = this.getChildAt(i);
                if (!CollapsingToolbarLayout.isToolbar(child)) continue;
                toolbar = (ViewGroup)child;
                break;
            }
            this.toolbar = toolbar;
        }
        this.updateDummyView();
        this.refreshToolbar = false;
    }

    private static boolean isToolbar(View view) {
        return view instanceof Toolbar || Build.VERSION.SDK_INT >= 21 && view instanceof android.widget.Toolbar;
    }

    private boolean isToolbarChild(View child) {
        return this.toolbarDirectChild == null || this.toolbarDirectChild == this ? child == this.toolbar : child == this.toolbarDirectChild;
    }

    @NonNull
    private View findDirectChild(@NonNull View descendant) {
        View directChild = descendant;
        for (ViewParent p = descendant.getParent(); p != this && p != null; p = p.getParent()) {
            if (!(p instanceof View)) continue;
            directChild = (View)p;
        }
        return directChild;
    }

    private void updateDummyView() {
        ViewParent parent;
        if (!this.collapsingTitleEnabled && this.dummyView != null && (parent = this.dummyView.getParent()) instanceof ViewGroup) {
            ((ViewGroup)parent).removeView(this.dummyView);
        }
        if (this.collapsingTitleEnabled && this.toolbar != null) {
            if (this.dummyView == null) {
                this.dummyView = new View(this.getContext());
            }
            if (this.dummyView.getParent() == null) {
                this.toolbar.addView(this.dummyView, -1, -1);
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int topInset;
        this.ensureToolbar();
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int mode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int n = topInset = this.lastInsets != null ? this.lastInsets.getSystemWindowInsetTop() : 0;
        if ((mode == 0 || this.forceApplySystemWindowInsetTop) && topInset > 0) {
            this.topInsetApplied = topInset;
            int newHeight = this.getMeasuredHeight() + topInset;
            heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)newHeight, (int)0x40000000);
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        }
        if (this.extraMultilineHeightEnabled && this.collapsingTextHelper.getMaxLines() > 1) {
            this.updateTitleFromToolbarIfNeeded();
            this.updateTextBounds(0, 0, this.getMeasuredWidth(), this.getMeasuredHeight(), true);
            int lineCount = this.collapsingTextHelper.getExpandedLineCount();
            if (lineCount > 1) {
                int expandedTextHeight = Math.round(this.collapsingTextHelper.getExpandedTextFullHeight());
                this.extraMultilineHeight = expandedTextHeight * (lineCount - 1);
                int newHeight = this.getMeasuredHeight() + this.extraMultilineHeight;
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)newHeight, (int)0x40000000);
                super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            }
        }
        if (this.toolbar != null) {
            if (this.toolbarDirectChild == null || this.toolbarDirectChild == this) {
                this.setMinimumHeight(CollapsingToolbarLayout.getHeightWithMargins((View)this.toolbar));
            } else {
                this.setMinimumHeight(CollapsingToolbarLayout.getHeightWithMargins(this.toolbarDirectChild));
            }
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int i;
        super.onLayout(changed, left, top, right, bottom);
        if (this.lastInsets != null) {
            int insetTop = this.lastInsets.getSystemWindowInsetTop();
            int z = this.getChildCount();
            for (int i2 = 0; i2 < z; ++i2) {
                View child = this.getChildAt(i2);
                if (ViewCompat.getFitsSystemWindows(child) || child.getTop() >= insetTop) continue;
                ViewCompat.offsetTopAndBottom(child, insetTop);
            }
        }
        int z = this.getChildCount();
        for (i = 0; i < z; ++i) {
            CollapsingToolbarLayout.getViewOffsetHelper(this.getChildAt(i)).onViewLayout();
        }
        this.updateTextBounds(left, top, right, bottom, false);
        this.updateTitleFromToolbarIfNeeded();
        this.updateScrimVisibility();
        z = this.getChildCount();
        for (i = 0; i < z; ++i) {
            CollapsingToolbarLayout.getViewOffsetHelper(this.getChildAt(i)).applyOffsets();
        }
    }

    private void updateTextBounds(int left, int top, int right, int bottom, boolean forceRecalculate) {
        if (this.collapsingTitleEnabled && this.dummyView != null) {
            boolean bl = this.drawCollapsingTitle = ViewCompat.isAttachedToWindow(this.dummyView) && this.dummyView.getVisibility() == 0;
            if (this.drawCollapsingTitle || forceRecalculate) {
                boolean isRtl = ViewCompat.getLayoutDirection((View)this) == 1;
                this.updateCollapsedBounds(isRtl);
                this.collapsingTextHelper.setExpandedBounds(isRtl ? this.expandedMarginEnd : this.expandedMarginStart, this.tmpRect.top + this.expandedMarginTop, right - left - (isRtl ? this.expandedMarginStart : this.expandedMarginEnd), bottom - top - this.expandedMarginBottom);
                this.collapsingTextHelper.recalculate(forceRecalculate);
            }
        }
    }

    private void updateTitleFromToolbarIfNeeded() {
        if (this.toolbar != null && this.collapsingTitleEnabled && TextUtils.isEmpty((CharSequence)this.collapsingTextHelper.getText())) {
            this.setTitle(CollapsingToolbarLayout.getToolbarTitle((View)this.toolbar));
        }
    }

    private void updateCollapsedBounds(boolean isRtl) {
        int titleMarginBottom;
        int titleMarginTop;
        int titleMarginEnd;
        int titleMarginStart;
        int maxOffset = this.getMaxOffsetForPinChild((View)(this.toolbarDirectChild != null ? this.toolbarDirectChild : this.toolbar));
        DescendantOffsetUtils.getDescendantRect((ViewGroup)this, this.dummyView, this.tmpRect);
        if (this.toolbar instanceof Toolbar) {
            Toolbar compatToolbar = (Toolbar)this.toolbar;
            titleMarginStart = compatToolbar.getTitleMarginStart();
            titleMarginEnd = compatToolbar.getTitleMarginEnd();
            titleMarginTop = compatToolbar.getTitleMarginTop();
            titleMarginBottom = compatToolbar.getTitleMarginBottom();
        } else if (Build.VERSION.SDK_INT >= 24 && this.toolbar instanceof android.widget.Toolbar) {
            android.widget.Toolbar frameworkToolbar = (android.widget.Toolbar)this.toolbar;
            titleMarginStart = frameworkToolbar.getTitleMarginStart();
            titleMarginEnd = frameworkToolbar.getTitleMarginEnd();
            titleMarginTop = frameworkToolbar.getTitleMarginTop();
            titleMarginBottom = frameworkToolbar.getTitleMarginBottom();
        } else {
            titleMarginStart = 0;
            titleMarginEnd = 0;
            titleMarginTop = 0;
            titleMarginBottom = 0;
        }
        this.collapsingTextHelper.setCollapsedBounds(this.tmpRect.left + (isRtl ? titleMarginEnd : titleMarginStart), this.tmpRect.top + maxOffset + titleMarginTop, this.tmpRect.right - (isRtl ? titleMarginStart : titleMarginEnd), this.tmpRect.bottom + maxOffset - titleMarginBottom);
    }

    private static CharSequence getToolbarTitle(View view) {
        if (view instanceof Toolbar) {
            return ((Toolbar)view).getTitle();
        }
        if (Build.VERSION.SDK_INT >= 21 && view instanceof android.widget.Toolbar) {
            return ((android.widget.Toolbar)view).getTitle();
        }
        return null;
    }

    private static int getHeightWithMargins(@NonNull View view) {
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        if (lp instanceof ViewGroup.MarginLayoutParams) {
            ViewGroup.MarginLayoutParams mlp = (ViewGroup.MarginLayoutParams)lp;
            return view.getMeasuredHeight() + mlp.topMargin + mlp.bottomMargin;
        }
        return view.getMeasuredHeight();
    }

    @NonNull
    static ViewOffsetHelper getViewOffsetHelper(@NonNull View view) {
        ViewOffsetHelper offsetHelper = (ViewOffsetHelper)view.getTag(R.id.view_offset_helper);
        if (offsetHelper == null) {
            offsetHelper = new ViewOffsetHelper(view);
            view.setTag(R.id.view_offset_helper, (Object)offsetHelper);
        }
        return offsetHelper;
    }

    public void setTitle(@Nullable CharSequence title) {
        this.collapsingTextHelper.setText(title);
        this.updateContentDescriptionFromTitle();
    }

    @Nullable
    public CharSequence getTitle() {
        return this.collapsingTitleEnabled ? this.collapsingTextHelper.getText() : null;
    }

    public void setTitleCollapseMode(int titleCollapseMode) {
        this.titleCollapseMode = titleCollapseMode;
        boolean fadeModeEnabled = this.isTitleCollapseFadeMode();
        this.collapsingTextHelper.setFadeModeEnabled(fadeModeEnabled);
        ViewParent parent = this.getParent();
        if (parent instanceof AppBarLayout) {
            this.disableLiftOnScrollIfNeeded((AppBarLayout)parent);
        }
        if (fadeModeEnabled && this.contentScrim == null) {
            this.setContentScrimColor(this.getDefaultContentScrimColorForTitleCollapseFadeMode());
        }
    }

    @ColorInt
    private int getDefaultContentScrimColorForTitleCollapseFadeMode() {
        ColorStateList colorSurfaceContainer = MaterialColors.getColorStateListOrNull(this.getContext(), R.attr.colorSurfaceContainer);
        if (colorSurfaceContainer != null) {
            return colorSurfaceContainer.getDefaultColor();
        }
        float appBarElevation = this.getResources().getDimension(R.dimen.design_appbar_elevation);
        return this.elevationOverlayProvider.compositeOverlayWithThemeSurfaceColorIfNeeded(appBarElevation);
    }

    public int getTitleCollapseMode() {
        return this.titleCollapseMode;
    }

    public void setTitleEnabled(boolean enabled) {
        if (enabled != this.collapsingTitleEnabled) {
            this.collapsingTitleEnabled = enabled;
            this.updateContentDescriptionFromTitle();
            this.updateDummyView();
            this.requestLayout();
        }
    }

    public boolean isTitleEnabled() {
        return this.collapsingTitleEnabled;
    }

    public void setTitleEllipsize(@NonNull TextUtils.TruncateAt ellipsize) {
        this.collapsingTextHelper.setTitleTextEllipsize(ellipsize);
    }

    @NonNull
    public TextUtils.TruncateAt getTitleTextEllipsize() {
        return this.collapsingTextHelper.getTitleTextEllipsize();
    }

    private TextUtils.TruncateAt convertEllipsizeToTruncateAt(int ellipsize) {
        switch (ellipsize) {
            case 0: {
                return TextUtils.TruncateAt.START;
            }
            case 1: {
                return TextUtils.TruncateAt.MIDDLE;
            }
            case 3: {
                return TextUtils.TruncateAt.MARQUEE;
            }
        }
        return TextUtils.TruncateAt.END;
    }

    public void setScrimsShown(boolean shown) {
        this.setScrimsShown(shown, ViewCompat.isLaidOut((View)this) && !this.isInEditMode());
    }

    public void setScrimsShown(boolean shown, boolean animate) {
        if (this.scrimsAreShown != shown) {
            if (animate) {
                this.animateScrim(shown ? 255 : 0);
            } else {
                this.setScrimAlpha(shown ? 255 : 0);
            }
            this.scrimsAreShown = shown;
        }
    }

    private void animateScrim(int targetAlpha) {
        this.ensureToolbar();
        if (this.scrimAnimator == null) {
            this.scrimAnimator = new ValueAnimator();
            this.scrimAnimator.setInterpolator(targetAlpha > this.scrimAlpha ? this.scrimAnimationFadeInInterpolator : this.scrimAnimationFadeOutInterpolator);
            this.scrimAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

                public void onAnimationUpdate(@NonNull ValueAnimator animator2) {
                    CollapsingToolbarLayout.this.setScrimAlpha((Integer)animator2.getAnimatedValue());
                }
            });
        } else if (this.scrimAnimator.isRunning()) {
            this.scrimAnimator.cancel();
        }
        this.scrimAnimator.setDuration(this.scrimAnimationDuration);
        this.scrimAnimator.setIntValues(new int[]{this.scrimAlpha, targetAlpha});
        this.scrimAnimator.start();
    }

    void setScrimAlpha(int alpha) {
        if (alpha != this.scrimAlpha) {
            Drawable contentScrim = this.contentScrim;
            if (contentScrim != null && this.toolbar != null) {
                ViewCompat.postInvalidateOnAnimation((View)this.toolbar);
            }
            this.scrimAlpha = alpha;
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    int getScrimAlpha() {
        return this.scrimAlpha;
    }

    public void setContentScrim(@Nullable Drawable drawable2) {
        if (this.contentScrim != drawable2) {
            if (this.contentScrim != null) {
                this.contentScrim.setCallback(null);
            }
            Drawable drawable3 = this.contentScrim = drawable2 != null ? drawable2.mutate() : null;
            if (this.contentScrim != null) {
                this.updateContentScrimBounds(this.contentScrim, this.getWidth(), this.getHeight());
                this.contentScrim.setCallback((Drawable.Callback)this);
                this.contentScrim.setAlpha(this.scrimAlpha);
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void setContentScrimColor(@ColorInt int color2) {
        this.setContentScrim((Drawable)new ColorDrawable(color2));
    }

    public void setContentScrimResource(@DrawableRes int resId) {
        this.setContentScrim(ContextCompat.getDrawable(this.getContext(), resId));
    }

    @Nullable
    public Drawable getContentScrim() {
        return this.contentScrim;
    }

    public void setStatusBarScrim(@Nullable Drawable drawable2) {
        if (this.statusBarScrim != drawable2) {
            if (this.statusBarScrim != null) {
                this.statusBarScrim.setCallback(null);
            }
            Drawable drawable3 = this.statusBarScrim = drawable2 != null ? drawable2.mutate() : null;
            if (this.statusBarScrim != null) {
                if (this.statusBarScrim.isStateful()) {
                    this.statusBarScrim.setState(this.getDrawableState());
                }
                DrawableCompat.setLayoutDirection(this.statusBarScrim, ViewCompat.getLayoutDirection((View)this));
                this.statusBarScrim.setVisible(this.getVisibility() == 0, false);
                this.statusBarScrim.setCallback((Drawable.Callback)this);
                this.statusBarScrim.setAlpha(this.scrimAlpha);
            }
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        int[] state = this.getDrawableState();
        boolean changed = false;
        Drawable d = this.statusBarScrim;
        if (d != null && d.isStateful()) {
            changed |= d.setState(state);
        }
        if ((d = this.contentScrim) != null && d.isStateful()) {
            changed |= d.setState(state);
        }
        if (this.collapsingTextHelper != null) {
            changed |= this.collapsingTextHelper.setState(state);
        }
        if (changed) {
            this.invalidate();
        }
    }

    protected boolean verifyDrawable(@NonNull Drawable who) {
        return super.verifyDrawable(who) || who == this.contentScrim || who == this.statusBarScrim;
    }

    public void setVisibility(int visibility) {
        boolean visible;
        super.setVisibility(visibility);
        boolean bl = visible = visibility == 0;
        if (this.statusBarScrim != null && this.statusBarScrim.isVisible() != visible) {
            this.statusBarScrim.setVisible(visible, false);
        }
        if (this.contentScrim != null && this.contentScrim.isVisible() != visible) {
            this.contentScrim.setVisible(visible, false);
        }
    }

    public void setStatusBarScrimColor(@ColorInt int color2) {
        this.setStatusBarScrim((Drawable)new ColorDrawable(color2));
    }

    public void setStatusBarScrimResource(@DrawableRes int resId) {
        this.setStatusBarScrim(ContextCompat.getDrawable(this.getContext(), resId));
    }

    @Nullable
    public Drawable getStatusBarScrim() {
        return this.statusBarScrim;
    }

    public void setCollapsedTitleTextAppearance(@StyleRes int resId) {
        this.collapsingTextHelper.setCollapsedTextAppearance(resId);
    }

    public void setCollapsedTitleTextColor(@ColorInt int color2) {
        this.setCollapsedTitleTextColor(ColorStateList.valueOf((int)color2));
    }

    public void setCollapsedTitleTextColor(@NonNull ColorStateList colors) {
        this.collapsingTextHelper.setCollapsedTextColor(colors);
    }

    public void setCollapsedTitleGravity(int gravity) {
        this.collapsingTextHelper.setCollapsedTextGravity(gravity);
    }

    public int getCollapsedTitleGravity() {
        return this.collapsingTextHelper.getCollapsedTextGravity();
    }

    public void setExpandedTitleTextAppearance(@StyleRes int resId) {
        this.collapsingTextHelper.setExpandedTextAppearance(resId);
    }

    public void setExpandedTitleColor(@ColorInt int color2) {
        this.setExpandedTitleTextColor(ColorStateList.valueOf((int)color2));
    }

    public void setExpandedTitleTextColor(@NonNull ColorStateList colors) {
        this.collapsingTextHelper.setExpandedTextColor(colors);
    }

    public void setExpandedTitleGravity(int gravity) {
        this.collapsingTextHelper.setExpandedTextGravity(gravity);
    }

    public int getExpandedTitleGravity() {
        return this.collapsingTextHelper.getExpandedTextGravity();
    }

    public void setExpandedTitleTextSize(float textSize) {
        this.collapsingTextHelper.setExpandedTextSize(textSize);
    }

    public float getExpandedTitleTextSize() {
        return this.collapsingTextHelper.getExpandedTextSize();
    }

    public void setCollapsedTitleTextSize(float textSize) {
        this.collapsingTextHelper.setCollapsedTextSize(textSize);
    }

    public float getCollapsedTitleTextSize() {
        return this.collapsingTextHelper.getCollapsedTextSize();
    }

    public void setCollapsedTitleTypeface(@Nullable Typeface typeface) {
        this.collapsingTextHelper.setCollapsedTypeface(typeface);
    }

    @NonNull
    public Typeface getCollapsedTitleTypeface() {
        return this.collapsingTextHelper.getCollapsedTypeface();
    }

    public void setExpandedTitleTypeface(@Nullable Typeface typeface) {
        this.collapsingTextHelper.setExpandedTypeface(typeface);
    }

    @NonNull
    public Typeface getExpandedTitleTypeface() {
        return this.collapsingTextHelper.getExpandedTypeface();
    }

    public void setExpandedTitleMargin(int start, int top, int end, int bottom) {
        this.expandedMarginStart = start;
        this.expandedMarginTop = top;
        this.expandedMarginEnd = end;
        this.expandedMarginBottom = bottom;
        this.requestLayout();
    }

    public int getExpandedTitleMarginStart() {
        return this.expandedMarginStart;
    }

    public void setExpandedTitleMarginStart(int margin) {
        this.expandedMarginStart = margin;
        this.requestLayout();
    }

    public int getExpandedTitleMarginTop() {
        return this.expandedMarginTop;
    }

    public void setExpandedTitleMarginTop(int margin) {
        this.expandedMarginTop = margin;
        this.requestLayout();
    }

    public int getExpandedTitleMarginEnd() {
        return this.expandedMarginEnd;
    }

    public void setExpandedTitleMarginEnd(int margin) {
        this.expandedMarginEnd = margin;
        this.requestLayout();
    }

    public int getExpandedTitleMarginBottom() {
        return this.expandedMarginBottom;
    }

    public void setExpandedTitleMarginBottom(int margin) {
        this.expandedMarginBottom = margin;
        this.requestLayout();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setMaxLines(int maxLines) {
        this.collapsingTextHelper.setMaxLines(maxLines);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getMaxLines() {
        return this.collapsingTextHelper.getMaxLines();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getLineCount() {
        return this.collapsingTextHelper.getLineCount();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @RequiresApi(value=23)
    public void setLineSpacingAdd(float spacingAdd) {
        this.collapsingTextHelper.setLineSpacingAdd(spacingAdd);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @RequiresApi(value=23)
    public float getLineSpacingAdd() {
        return this.collapsingTextHelper.getLineSpacingAdd();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @RequiresApi(value=23)
    public void setLineSpacingMultiplier(@FloatRange(from=0.0) float spacingMultiplier) {
        this.collapsingTextHelper.setLineSpacingMultiplier(spacingMultiplier);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @RequiresApi(value=23)
    public float getLineSpacingMultiplier() {
        return this.collapsingTextHelper.getLineSpacingMultiplier();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @RequiresApi(value=23)
    public void setHyphenationFrequency(int hyphenationFrequency) {
        this.collapsingTextHelper.setHyphenationFrequency(hyphenationFrequency);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @RequiresApi(value=23)
    public int getHyphenationFrequency() {
        return this.collapsingTextHelper.getHyphenationFrequency();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @RequiresApi(value=23)
    public void setStaticLayoutBuilderConfigurer(@Nullable StaticLayoutBuilderConfigurer staticLayoutBuilderConfigurer) {
        this.collapsingTextHelper.setStaticLayoutBuilderConfigurer(staticLayoutBuilderConfigurer);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setRtlTextDirectionHeuristicsEnabled(boolean rtlTextDirectionHeuristicsEnabled) {
        this.collapsingTextHelper.setRtlTextDirectionHeuristicsEnabled(rtlTextDirectionHeuristicsEnabled);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isRtlTextDirectionHeuristicsEnabled() {
        return this.collapsingTextHelper.isRtlTextDirectionHeuristicsEnabled();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setForceApplySystemWindowInsetTop(boolean forceApplySystemWindowInsetTop) {
        this.forceApplySystemWindowInsetTop = forceApplySystemWindowInsetTop;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isForceApplySystemWindowInsetTop() {
        return this.forceApplySystemWindowInsetTop;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setExtraMultilineHeightEnabled(boolean extraMultilineHeightEnabled) {
        this.extraMultilineHeightEnabled = extraMultilineHeightEnabled;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isExtraMultilineHeightEnabled() {
        return this.extraMultilineHeightEnabled;
    }

    public void setScrimVisibleHeightTrigger(@IntRange(from=0L) int height) {
        if (this.scrimVisibleHeightTrigger != height) {
            this.scrimVisibleHeightTrigger = height;
            this.updateScrimVisibility();
        }
    }

    public int getScrimVisibleHeightTrigger() {
        if (this.scrimVisibleHeightTrigger >= 0) {
            return this.scrimVisibleHeightTrigger + this.topInsetApplied + this.extraMultilineHeight;
        }
        int insetTop = this.lastInsets != null ? this.lastInsets.getSystemWindowInsetTop() : 0;
        int minHeight = ViewCompat.getMinimumHeight((View)this);
        if (minHeight > 0) {
            return Math.min(minHeight * 2 + insetTop, this.getHeight());
        }
        return this.getHeight() / 3;
    }

    public void setTitlePositionInterpolator(@Nullable TimeInterpolator interpolator2) {
        this.collapsingTextHelper.setPositionInterpolator(interpolator2);
    }

    @Nullable
    public TimeInterpolator getTitlePositionInterpolator() {
        return this.collapsingTextHelper.getPositionInterpolator();
    }

    public void setScrimAnimationDuration(@IntRange(from=0L) long duration) {
        this.scrimAnimationDuration = duration;
    }

    public long getScrimAnimationDuration() {
        return this.scrimAnimationDuration;
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -1);
    }

    public FrameLayout.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected FrameLayout.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    final void updateScrimVisibility() {
        if (this.contentScrim != null || this.statusBarScrim != null) {
            this.setScrimsShown(this.getHeight() + this.currentOffset < this.getScrimVisibleHeightTrigger());
        }
    }

    final int getMaxOffsetForPinChild(@NonNull View child) {
        ViewOffsetHelper offsetHelper = CollapsingToolbarLayout.getViewOffsetHelper(child);
        LayoutParams lp = (LayoutParams)child.getLayoutParams();
        return this.getHeight() - offsetHelper.getLayoutTop() - child.getHeight() - lp.bottomMargin;
    }

    private void updateContentDescriptionFromTitle() {
        this.setContentDescription(this.getTitle());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @RequiresApi(value=23)
    public static interface StaticLayoutBuilderConfigurer
    extends com.google.android.material.internal.StaticLayoutBuilderConfigurer {
    }

    private class OffsetUpdateListener
    implements AppBarLayout.OnOffsetChangedListener {
        OffsetUpdateListener() {
        }

        @Override
        public void onOffsetChanged(AppBarLayout layout2, int verticalOffset) {
            CollapsingToolbarLayout.this.currentOffset = verticalOffset;
            int insetTop = CollapsingToolbarLayout.this.lastInsets != null ? CollapsingToolbarLayout.this.lastInsets.getSystemWindowInsetTop() : 0;
            int z = CollapsingToolbarLayout.this.getChildCount();
            block4: for (int i = 0; i < z; ++i) {
                View child = CollapsingToolbarLayout.this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                ViewOffsetHelper offsetHelper = CollapsingToolbarLayout.getViewOffsetHelper(child);
                switch (lp.collapseMode) {
                    case 1: {
                        offsetHelper.setTopAndBottomOffset(MathUtils.clamp(-verticalOffset, 0, CollapsingToolbarLayout.this.getMaxOffsetForPinChild(child)));
                        continue block4;
                    }
                    case 2: {
                        offsetHelper.setTopAndBottomOffset(Math.round((float)(-verticalOffset) * lp.parallaxMult));
                        continue block4;
                    }
                }
            }
            CollapsingToolbarLayout.this.updateScrimVisibility();
            if (CollapsingToolbarLayout.this.statusBarScrim != null && insetTop > 0) {
                ViewCompat.postInvalidateOnAnimation((View)CollapsingToolbarLayout.this);
            }
            int height = CollapsingToolbarLayout.this.getHeight();
            int expandRange = height - ViewCompat.getMinimumHeight((View)CollapsingToolbarLayout.this) - insetTop;
            int scrimRange = height - CollapsingToolbarLayout.this.getScrimVisibleHeightTrigger();
            CollapsingToolbarLayout.this.collapsingTextHelper.setFadeModeStartFraction(Math.min(1.0f, (float)scrimRange / (float)expandRange));
            CollapsingToolbarLayout.this.collapsingTextHelper.setCurrentOffsetY(CollapsingToolbarLayout.this.currentOffset + expandRange);
            CollapsingToolbarLayout.this.collapsingTextHelper.setExpansionFraction((float)Math.abs(verticalOffset) / (float)expandRange);
        }
    }

    public static class LayoutParams
    extends FrameLayout.LayoutParams {
        private static final float DEFAULT_PARALLAX_MULTIPLIER = 0.5f;
        public static final int COLLAPSE_MODE_OFF = 0;
        public static final int COLLAPSE_MODE_PIN = 1;
        public static final int COLLAPSE_MODE_PARALLAX = 2;
        int collapseMode = 0;
        float parallaxMult = 0.5f;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.CollapsingToolbarLayout_Layout);
            this.collapseMode = a.getInt(R.styleable.CollapsingToolbarLayout_Layout_layout_collapseMode, 0);
            this.setParallaxMultiplier(a.getFloat(R.styleable.CollapsingToolbarLayout_Layout_layout_collapseParallaxMultiplier, 0.5f));
            a.recycle();
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }

        public LayoutParams(int width, int height, int gravity) {
            super(width, height, gravity);
        }

        public LayoutParams(@NonNull ViewGroup.LayoutParams p) {
            super(p);
        }

        public LayoutParams(@NonNull ViewGroup.MarginLayoutParams source) {
            super(source);
        }

        @RequiresApi(value=19)
        public LayoutParams(@NonNull FrameLayout.LayoutParams source) {
            super(source);
        }

        @RequiresApi(value=19)
        public LayoutParams(@NonNull LayoutParams source) {
            super((FrameLayout.LayoutParams)source);
            this.collapseMode = source.collapseMode;
            this.parallaxMult = source.parallaxMult;
        }

        public void setCollapseMode(int collapseMode) {
            this.collapseMode = collapseMode;
        }

        public int getCollapseMode() {
            return this.collapseMode;
        }

        public void setParallaxMultiplier(float multiplier) {
            this.parallaxMult = multiplier;
        }

        public float getParallaxMultiplier() {
            return this.parallaxMult;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface TitleCollapseMode {
    }
}

