/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.appbar;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.OverScroller;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.math.MathUtils;
import androidx.core.view.ViewCompat;
import com.google.android.material.appbar.ViewOffsetBehavior;

abstract class HeaderBehavior<V extends View>
extends ViewOffsetBehavior<V> {
    private static final int INVALID_POINTER = -1;
    @Nullable
    private Runnable flingRunnable;
    OverScroller scroller;
    private boolean isBeingDragged;
    private int activePointerId = -1;
    private int lastMotionY;
    private int touchSlop = -1;
    @Nullable
    private VelocityTracker velocityTracker;

    public HeaderBehavior() {
    }

    public HeaderBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public boolean onInterceptTouchEvent(@NonNull CoordinatorLayout parent, @NonNull V child, @NonNull MotionEvent ev) {
        int y;
        if (this.touchSlop < 0) {
            this.touchSlop = ViewConfiguration.get((Context)parent.getContext()).getScaledTouchSlop();
        }
        if (ev.getActionMasked() == 2 && this.isBeingDragged) {
            if (this.activePointerId == -1) {
                return false;
            }
            int pointerIndex = ev.findPointerIndex(this.activePointerId);
            if (pointerIndex == -1) {
                return false;
            }
            y = (int)ev.getY(pointerIndex);
            int yDiff = Math.abs(y - this.lastMotionY);
            if (yDiff > this.touchSlop) {
                this.lastMotionY = y;
                return true;
            }
        }
        if (ev.getActionMasked() == 0) {
            this.activePointerId = -1;
            int x = (int)ev.getX();
            y = (int)ev.getY();
            boolean bl = this.isBeingDragged = this.canDragView(child) && parent.isPointInChildBounds((View)child, x, y);
            if (this.isBeingDragged) {
                this.lastMotionY = y;
                this.activePointerId = ev.getPointerId(0);
                this.ensureVelocityTracker();
                if (this.scroller != null && !this.scroller.isFinished()) {
                    this.scroller.abortAnimation();
                    return true;
                }
            }
        }
        if (this.velocityTracker != null) {
            this.velocityTracker.addMovement(ev);
        }
        return false;
    }

    @Override
    public boolean onTouchEvent(@NonNull CoordinatorLayout parent, @NonNull V child, @NonNull MotionEvent ev) {
        boolean consumeUp = false;
        switch (ev.getActionMasked()) {
            case 2: {
                int activePointerIndex = ev.findPointerIndex(this.activePointerId);
                if (activePointerIndex == -1) {
                    return false;
                }
                int y = (int)ev.getY(activePointerIndex);
                int dy = this.lastMotionY - y;
                this.lastMotionY = y;
                this.scroll(parent, child, dy, this.getMaxDragOffset(child), 0);
                break;
            }
            case 6: {
                int newIndex = ev.getActionIndex() == 0 ? 1 : 0;
                this.activePointerId = ev.getPointerId(newIndex);
                this.lastMotionY = (int)(ev.getY(newIndex) + 0.5f);
                break;
            }
            case 1: {
                if (this.velocityTracker != null) {
                    consumeUp = true;
                    this.velocityTracker.addMovement(ev);
                    this.velocityTracker.computeCurrentVelocity(1000);
                    float yvel = this.velocityTracker.getYVelocity(this.activePointerId);
                    this.fling(parent, child, -this.getScrollRangeForDragFling(child), 0, yvel);
                }
            }
            case 3: {
                this.isBeingDragged = false;
                this.activePointerId = -1;
                if (this.velocityTracker == null) break;
                this.velocityTracker.recycle();
                this.velocityTracker = null;
            }
        }
        if (this.velocityTracker != null) {
            this.velocityTracker.addMovement(ev);
        }
        return this.isBeingDragged || consumeUp;
    }

    int setHeaderTopBottomOffset(CoordinatorLayout parent, V header, int newOffset) {
        return this.setHeaderTopBottomOffset(parent, header, newOffset, Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    int setHeaderTopBottomOffset(CoordinatorLayout parent, V header, int newOffset, int minOffset, int maxOffset) {
        int curOffset = this.getTopAndBottomOffset();
        int consumed = 0;
        if (minOffset != 0 && curOffset >= minOffset && curOffset <= maxOffset && curOffset != (newOffset = MathUtils.clamp(newOffset, minOffset, maxOffset))) {
            this.setTopAndBottomOffset(newOffset);
            consumed = curOffset - newOffset;
        }
        return consumed;
    }

    int getTopBottomOffsetForScrollingSibling() {
        return this.getTopAndBottomOffset();
    }

    final int scroll(CoordinatorLayout coordinatorLayout, V header, int dy, int minOffset, int maxOffset) {
        return this.setHeaderTopBottomOffset(coordinatorLayout, header, this.getTopBottomOffsetForScrollingSibling() - dy, minOffset, maxOffset);
    }

    final boolean fling(CoordinatorLayout coordinatorLayout, @NonNull V layout2, int minOffset, int maxOffset, float velocityY) {
        if (this.flingRunnable != null) {
            layout2.removeCallbacks(this.flingRunnable);
            this.flingRunnable = null;
        }
        if (this.scroller == null) {
            this.scroller = new OverScroller(layout2.getContext());
        }
        this.scroller.fling(0, this.getTopAndBottomOffset(), 0, Math.round(velocityY), 0, 0, minOffset, maxOffset);
        if (this.scroller.computeScrollOffset()) {
            this.flingRunnable = new FlingRunnable(this, coordinatorLayout, layout2);
            ViewCompat.postOnAnimation(layout2, this.flingRunnable);
            return true;
        }
        this.onFlingFinished(coordinatorLayout, layout2);
        return false;
    }

    void onFlingFinished(CoordinatorLayout parent, V layout2) {
    }

    boolean canDragView(V view) {
        return false;
    }

    int getMaxDragOffset(@NonNull V view) {
        return -view.getHeight();
    }

    int getScrollRangeForDragFling(@NonNull V view) {
        return view.getHeight();
    }

    private void ensureVelocityTracker() {
        if (this.velocityTracker == null) {
            this.velocityTracker = VelocityTracker.obtain();
        }
    }

    private static class FlingRunnable
    implements Runnable {
        private final CoordinatorLayout parent;
        private final V layout;
        final /* synthetic */ HeaderBehavior this$0;

        FlingRunnable(CoordinatorLayout parent, V layout2) {
            this.this$0 = var1_1;
            this.parent = parent;
            this.layout = layout2;
        }

        @Override
        public void run() {
            if (this.layout != null && this.this$0.scroller != null) {
                if (this.this$0.scroller.computeScrollOffset()) {
                    this.this$0.setHeaderTopBottomOffset(this.parent, this.layout, this.this$0.scroller.getCurrY());
                    ViewCompat.postOnAnimation(this.layout, this);
                } else {
                    this.this$0.onFlingFinished(this.parent, this.layout);
                }
            }
        }
    }
}

