/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.appbar;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.math.MathUtils;
import androidx.core.view.GravityCompat;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowInsetsCompat;
import com.google.android.material.appbar.ViewOffsetBehavior;
import java.util.List;

abstract class HeaderScrollingViewBehavior
extends ViewOffsetBehavior<View> {
    final Rect tempRect1 = new Rect();
    final Rect tempRect2 = new Rect();
    private int verticalLayoutGap = 0;
    private int overlayTop;

    public HeaderScrollingViewBehavior() {
    }

    public HeaderScrollingViewBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public boolean onMeasureChild(@NonNull CoordinatorLayout parent, @NonNull View child, int parentWidthMeasureSpec, int widthUsed, int parentHeightMeasureSpec, int heightUsed) {
        List<View> dependencies;
        View header;
        int childLpHeight = child.getLayoutParams().height;
        if ((childLpHeight == -1 || childLpHeight == -2) && (header = this.findFirstDependency(dependencies = parent.getDependencies(child))) != null) {
            int availableHeight = View.MeasureSpec.getSize((int)parentHeightMeasureSpec);
            if (availableHeight > 0) {
                WindowInsetsCompat parentInsets;
                if (ViewCompat.getFitsSystemWindows(header) && (parentInsets = parent.getLastWindowInsets()) != null) {
                    availableHeight += parentInsets.getSystemWindowInsetTop() + parentInsets.getSystemWindowInsetBottom();
                }
            } else {
                availableHeight = parent.getHeight();
            }
            int height = availableHeight + this.getScrollRange(header);
            int headerHeight = header.getMeasuredHeight();
            if (this.shouldHeaderOverlapScrollingChild()) {
                child.setTranslationY((float)(-headerHeight));
            } else {
                child.setTranslationY(0.0f);
                height -= headerHeight;
            }
            int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)(childLpHeight == -1 ? 0x40000000 : Integer.MIN_VALUE));
            parent.onMeasureChild(child, parentWidthMeasureSpec, widthUsed, heightMeasureSpec, heightUsed);
            return true;
        }
        return false;
    }

    @Override
    protected void layoutChild(@NonNull CoordinatorLayout parent, @NonNull View child, int layoutDirection) {
        List<View> dependencies = parent.getDependencies(child);
        View header = this.findFirstDependency(dependencies);
        if (header != null) {
            CoordinatorLayout.LayoutParams lp = (CoordinatorLayout.LayoutParams)child.getLayoutParams();
            Rect available = this.tempRect1;
            available.set(parent.getPaddingLeft() + lp.leftMargin, header.getBottom() + lp.topMargin, parent.getWidth() - parent.getPaddingRight() - lp.rightMargin, parent.getHeight() + header.getBottom() - parent.getPaddingBottom() - lp.bottomMargin);
            WindowInsetsCompat parentInsets = parent.getLastWindowInsets();
            if (parentInsets != null && ViewCompat.getFitsSystemWindows((View)parent) && !ViewCompat.getFitsSystemWindows(child)) {
                available.left += parentInsets.getSystemWindowInsetLeft();
                available.right -= parentInsets.getSystemWindowInsetRight();
            }
            Rect out = this.tempRect2;
            GravityCompat.apply(HeaderScrollingViewBehavior.resolveGravity(lp.gravity), child.getMeasuredWidth(), child.getMeasuredHeight(), available, out, layoutDirection);
            int overlap = this.getOverlapPixelsForOffset(header);
            child.layout(out.left, out.top - overlap, out.right, out.bottom - overlap);
            this.verticalLayoutGap = out.top - header.getBottom();
        } else {
            super.layoutChild(parent, child, layoutDirection);
            this.verticalLayoutGap = 0;
        }
    }

    protected boolean shouldHeaderOverlapScrollingChild() {
        return false;
    }

    float getOverlapRatioForOffset(View header) {
        return 1.0f;
    }

    final int getOverlapPixelsForOffset(View header) {
        return this.overlayTop == 0 ? 0 : MathUtils.clamp((int)(this.getOverlapRatioForOffset(header) * (float)this.overlayTop), 0, this.overlayTop);
    }

    private static int resolveGravity(int gravity) {
        return gravity == 0 ? 0x800033 : gravity;
    }

    @Nullable
    abstract View findFirstDependency(List<View> var1);

    int getScrollRange(@NonNull View v) {
        return v.getMeasuredHeight();
    }

    final int getVerticalLayoutGap() {
        return this.verticalLayoutGap;
    }

    public final void setOverlayTop(int overlayTop) {
        this.overlayTop = overlayTop;
    }

    public final int getOverlayTop() {
        return this.overlayTop;
    }
}

