/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.badge;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.PluralsRes;
import androidx.annotation.Px;
import androidx.annotation.RestrictTo;
import androidx.annotation.StringRes;
import androidx.annotation.StyleRes;
import androidx.annotation.StyleableRes;
import androidx.annotation.XmlRes;
import com.google.android.material.R;
import com.google.android.material.drawable.DrawableUtils;
import com.google.android.material.internal.ThemeEnforcement;
import com.google.android.material.resources.MaterialResources;
import com.google.android.material.resources.TextAppearance;
import java.io.Serializable;
import java.util.Locale;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class BadgeState {
    private static final String BADGE_RESOURCE_TAG = "badge";
    private final State overridingState;
    private final State currentState = new State();
    final float badgeRadius;
    final float badgeWithTextRadius;
    final float badgeWidth;
    final float badgeHeight;
    final float badgeWithTextWidth;
    final float badgeWithTextHeight;
    final int horizontalInset;
    final int horizontalInsetWithText;
    int offsetAlignmentMode;

    BadgeState(Context context, @XmlRes int badgeResId, @AttrRes int defStyleAttr, @StyleRes int defStyleRes, @Nullable State storedState) {
        if (storedState == null) {
            storedState = new State();
        }
        if (badgeResId != 0) {
            storedState.badgeResId = badgeResId;
        }
        TypedArray a = this.generateTypedArray(context, storedState.badgeResId, defStyleAttr, defStyleRes);
        Resources res = context.getResources();
        this.badgeRadius = a.getDimensionPixelSize(R.styleable.Badge_badgeRadius, -1);
        this.horizontalInset = context.getResources().getDimensionPixelSize(R.dimen.mtrl_badge_horizontal_edge_offset);
        this.horizontalInsetWithText = context.getResources().getDimensionPixelSize(R.dimen.mtrl_badge_text_horizontal_edge_offset);
        this.badgeWithTextRadius = a.getDimensionPixelSize(R.styleable.Badge_badgeWithTextRadius, -1);
        this.badgeWidth = a.getDimension(R.styleable.Badge_badgeWidth, res.getDimension(R.dimen.m3_badge_size));
        this.badgeWithTextWidth = a.getDimension(R.styleable.Badge_badgeWithTextWidth, res.getDimension(R.dimen.m3_badge_with_text_size));
        this.badgeHeight = a.getDimension(R.styleable.Badge_badgeHeight, res.getDimension(R.dimen.m3_badge_size));
        this.badgeWithTextHeight = a.getDimension(R.styleable.Badge_badgeWithTextHeight, res.getDimension(R.dimen.m3_badge_with_text_size));
        this.offsetAlignmentMode = a.getInt(R.styleable.Badge_offsetAlignmentMode, 1);
        this.currentState.alpha = storedState.alpha == -2 ? 255 : storedState.alpha;
        if (storedState.number != -2) {
            this.currentState.number = storedState.number;
        } else if (a.hasValue(R.styleable.Badge_number)) {
            this.currentState.number = a.getInt(R.styleable.Badge_number, 0);
        } else {
            this.currentState.number = -1;
        }
        if (storedState.text != null) {
            this.currentState.text = storedState.text;
        } else if (a.hasValue(R.styleable.Badge_badgeText)) {
            this.currentState.text = a.getString(R.styleable.Badge_badgeText);
        }
        this.currentState.contentDescriptionForText = storedState.contentDescriptionForText;
        this.currentState.contentDescriptionNumberless = storedState.contentDescriptionNumberless == null ? context.getString(R.string.mtrl_badge_numberless_content_description) : storedState.contentDescriptionNumberless;
        this.currentState.contentDescriptionQuantityStrings = storedState.contentDescriptionQuantityStrings == 0 ? R.plurals.mtrl_badge_content_description : storedState.contentDescriptionQuantityStrings;
        this.currentState.contentDescriptionExceedsMaxBadgeNumberRes = storedState.contentDescriptionExceedsMaxBadgeNumberRes == 0 ? R.string.mtrl_exceed_max_badge_number_content_description : storedState.contentDescriptionExceedsMaxBadgeNumberRes;
        this.currentState.isVisible = storedState.isVisible == null || storedState.isVisible != false;
        this.currentState.maxCharacterCount = storedState.maxCharacterCount == -2 ? a.getInt(R.styleable.Badge_maxCharacterCount, -2) : storedState.maxCharacterCount;
        this.currentState.maxNumber = storedState.maxNumber == -2 ? a.getInt(R.styleable.Badge_maxNumber, -2) : storedState.maxNumber;
        this.currentState.badgeShapeAppearanceResId = storedState.badgeShapeAppearanceResId == null ? a.getResourceId(R.styleable.Badge_badgeShapeAppearance, R.style.ShapeAppearance_M3_Sys_Shape_Corner_Full) : storedState.badgeShapeAppearanceResId.intValue();
        this.currentState.badgeShapeAppearanceOverlayResId = storedState.badgeShapeAppearanceOverlayResId == null ? a.getResourceId(R.styleable.Badge_badgeShapeAppearanceOverlay, 0) : storedState.badgeShapeAppearanceOverlayResId.intValue();
        this.currentState.badgeWithTextShapeAppearanceResId = storedState.badgeWithTextShapeAppearanceResId == null ? a.getResourceId(R.styleable.Badge_badgeWithTextShapeAppearance, R.style.ShapeAppearance_M3_Sys_Shape_Corner_Full) : storedState.badgeWithTextShapeAppearanceResId.intValue();
        this.currentState.badgeWithTextShapeAppearanceOverlayResId = storedState.badgeWithTextShapeAppearanceOverlayResId == null ? a.getResourceId(R.styleable.Badge_badgeWithTextShapeAppearanceOverlay, 0) : storedState.badgeWithTextShapeAppearanceOverlayResId.intValue();
        this.currentState.backgroundColor = storedState.backgroundColor == null ? BadgeState.readColorFromAttributes(context, a, R.styleable.Badge_backgroundColor) : storedState.backgroundColor;
        this.currentState.badgeTextAppearanceResId = storedState.badgeTextAppearanceResId == null ? a.getResourceId(R.styleable.Badge_badgeTextAppearance, R.style.TextAppearance_MaterialComponents_Badge) : storedState.badgeTextAppearanceResId.intValue();
        if (storedState.badgeTextColor != null) {
            this.currentState.badgeTextColor = storedState.badgeTextColor;
        } else if (a.hasValue(R.styleable.Badge_badgeTextColor)) {
            this.currentState.badgeTextColor = BadgeState.readColorFromAttributes(context, a, R.styleable.Badge_badgeTextColor);
        } else {
            TextAppearance textAppearance = new TextAppearance(context, this.currentState.badgeTextAppearanceResId);
            this.currentState.badgeTextColor = textAppearance.getTextColor().getDefaultColor();
        }
        this.currentState.badgeGravity = storedState.badgeGravity == null ? a.getInt(R.styleable.Badge_badgeGravity, 8388661) : storedState.badgeGravity.intValue();
        this.currentState.badgeHorizontalPadding = storedState.badgeHorizontalPadding == null ? a.getDimensionPixelSize(R.styleable.Badge_badgeWidePadding, res.getDimensionPixelSize(R.dimen.mtrl_badge_long_text_horizontal_padding)) : storedState.badgeHorizontalPadding.intValue();
        this.currentState.badgeVerticalPadding = storedState.badgeVerticalPadding == null ? a.getDimensionPixelSize(R.styleable.Badge_badgeVerticalPadding, res.getDimensionPixelSize(R.dimen.m3_badge_with_text_vertical_padding)) : storedState.badgeVerticalPadding.intValue();
        this.currentState.horizontalOffsetWithoutText = storedState.horizontalOffsetWithoutText == null ? a.getDimensionPixelOffset(R.styleable.Badge_horizontalOffset, 0) : storedState.horizontalOffsetWithoutText.intValue();
        this.currentState.verticalOffsetWithoutText = storedState.verticalOffsetWithoutText == null ? a.getDimensionPixelOffset(R.styleable.Badge_verticalOffset, 0) : storedState.verticalOffsetWithoutText.intValue();
        this.currentState.horizontalOffsetWithText = storedState.horizontalOffsetWithText == null ? a.getDimensionPixelOffset(R.styleable.Badge_horizontalOffsetWithText, this.currentState.horizontalOffsetWithoutText.intValue()) : storedState.horizontalOffsetWithText.intValue();
        this.currentState.verticalOffsetWithText = storedState.verticalOffsetWithText == null ? a.getDimensionPixelOffset(R.styleable.Badge_verticalOffsetWithText, this.currentState.verticalOffsetWithoutText.intValue()) : storedState.verticalOffsetWithText.intValue();
        this.currentState.largeFontVerticalOffsetAdjustment = storedState.largeFontVerticalOffsetAdjustment == null ? a.getDimensionPixelOffset(R.styleable.Badge_largeFontVerticalOffsetAdjustment, 0) : storedState.largeFontVerticalOffsetAdjustment.intValue();
        this.currentState.additionalHorizontalOffset = storedState.additionalHorizontalOffset == null ? 0 : storedState.additionalHorizontalOffset;
        this.currentState.additionalVerticalOffset = storedState.additionalVerticalOffset == null ? 0 : storedState.additionalVerticalOffset;
        this.currentState.autoAdjustToWithinGrandparentBounds = storedState.autoAdjustToWithinGrandparentBounds == null ? a.getBoolean(R.styleable.Badge_autoAdjustToWithinGrandparentBounds, false) : storedState.autoAdjustToWithinGrandparentBounds.booleanValue();
        a.recycle();
        if (storedState.numberLocale == null) {
            this.currentState.numberLocale = Build.VERSION.SDK_INT >= 24 ? Locale.getDefault(Locale.Category.FORMAT) : Locale.getDefault();
        } else {
            this.currentState.numberLocale = storedState.numberLocale;
        }
        this.overridingState = storedState;
    }

    private TypedArray generateTypedArray(Context context, @XmlRes int badgeResId, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        AttributeSet attrs = null;
        int style2 = 0;
        if (badgeResId != 0) {
            attrs = DrawableUtils.parseDrawableXml(context, badgeResId, BADGE_RESOURCE_TAG);
            style2 = attrs.getStyleAttribute();
        }
        if (style2 == 0) {
            style2 = defStyleRes;
        }
        return ThemeEnforcement.obtainStyledAttributes(context, attrs, R.styleable.Badge, defStyleAttr, style2, new int[0]);
    }

    State getOverridingState() {
        return this.overridingState;
    }

    boolean isVisible() {
        return this.currentState.isVisible;
    }

    void setVisible(boolean visible) {
        this.overridingState.isVisible = visible;
        this.currentState.isVisible = visible;
    }

    boolean hasNumber() {
        return this.currentState.number != -1;
    }

    int getNumber() {
        return this.currentState.number;
    }

    void setNumber(int number) {
        this.overridingState.number = number;
        this.currentState.number = number;
    }

    void clearNumber() {
        this.setNumber(-1);
    }

    boolean hasText() {
        return this.currentState.text != null;
    }

    String getText() {
        return this.currentState.text;
    }

    void setText(String text) {
        this.overridingState.text = text;
        this.currentState.text = text;
    }

    void clearText() {
        this.setText(null);
    }

    int getAlpha() {
        return this.currentState.alpha;
    }

    void setAlpha(int alpha) {
        this.overridingState.alpha = alpha;
        this.currentState.alpha = alpha;
    }

    int getMaxCharacterCount() {
        return this.currentState.maxCharacterCount;
    }

    void setMaxCharacterCount(int maxCharacterCount) {
        this.overridingState.maxCharacterCount = maxCharacterCount;
        this.currentState.maxCharacterCount = maxCharacterCount;
    }

    int getMaxNumber() {
        return this.currentState.maxNumber;
    }

    void setMaxNumber(int maxNumber) {
        this.overridingState.maxNumber = maxNumber;
        this.currentState.maxNumber = maxNumber;
    }

    @ColorInt
    int getBackgroundColor() {
        return this.currentState.backgroundColor;
    }

    void setBackgroundColor(@ColorInt int backgroundColor) {
        this.overridingState.backgroundColor = backgroundColor;
        this.currentState.backgroundColor = backgroundColor;
    }

    @ColorInt
    int getBadgeTextColor() {
        return this.currentState.badgeTextColor;
    }

    void setBadgeTextColor(@ColorInt int badgeTextColor) {
        this.overridingState.badgeTextColor = badgeTextColor;
        this.currentState.badgeTextColor = badgeTextColor;
    }

    @StyleRes
    int getTextAppearanceResId() {
        return this.currentState.badgeTextAppearanceResId;
    }

    void setTextAppearanceResId(@StyleRes int textAppearanceResId) {
        this.overridingState.badgeTextAppearanceResId = textAppearanceResId;
        this.currentState.badgeTextAppearanceResId = textAppearanceResId;
    }

    int getBadgeShapeAppearanceResId() {
        return this.currentState.badgeShapeAppearanceResId;
    }

    void setBadgeShapeAppearanceResId(int shapeAppearanceResId) {
        this.overridingState.badgeShapeAppearanceResId = shapeAppearanceResId;
        this.currentState.badgeShapeAppearanceResId = shapeAppearanceResId;
    }

    int getBadgeShapeAppearanceOverlayResId() {
        return this.currentState.badgeShapeAppearanceOverlayResId;
    }

    void setBadgeShapeAppearanceOverlayResId(int shapeAppearanceOverlayResId) {
        this.overridingState.badgeShapeAppearanceOverlayResId = shapeAppearanceOverlayResId;
        this.currentState.badgeShapeAppearanceOverlayResId = shapeAppearanceOverlayResId;
    }

    int getBadgeWithTextShapeAppearanceResId() {
        return this.currentState.badgeWithTextShapeAppearanceResId;
    }

    void setBadgeWithTextShapeAppearanceResId(int shapeAppearanceResId) {
        this.overridingState.badgeWithTextShapeAppearanceResId = shapeAppearanceResId;
        this.currentState.badgeWithTextShapeAppearanceResId = shapeAppearanceResId;
    }

    int getBadgeWithTextShapeAppearanceOverlayResId() {
        return this.currentState.badgeWithTextShapeAppearanceOverlayResId;
    }

    void setBadgeWithTextShapeAppearanceOverlayResId(int shapeAppearanceOverlayResId) {
        this.overridingState.badgeWithTextShapeAppearanceOverlayResId = shapeAppearanceOverlayResId;
        this.currentState.badgeWithTextShapeAppearanceOverlayResId = shapeAppearanceOverlayResId;
    }

    int getBadgeGravity() {
        return this.currentState.badgeGravity;
    }

    void setBadgeGravity(int badgeGravity) {
        this.overridingState.badgeGravity = badgeGravity;
        this.currentState.badgeGravity = badgeGravity;
    }

    @Px
    int getBadgeHorizontalPadding() {
        return this.currentState.badgeHorizontalPadding;
    }

    void setBadgeHorizontalPadding(@Px int horizontalPadding) {
        this.overridingState.badgeHorizontalPadding = horizontalPadding;
        this.currentState.badgeHorizontalPadding = horizontalPadding;
    }

    @Px
    int getBadgeVerticalPadding() {
        return this.currentState.badgeVerticalPadding;
    }

    void setBadgeVerticalPadding(@Px int verticalPadding) {
        this.overridingState.badgeVerticalPadding = verticalPadding;
        this.currentState.badgeVerticalPadding = verticalPadding;
    }

    @Dimension(unit=1)
    int getHorizontalOffsetWithoutText() {
        return this.currentState.horizontalOffsetWithoutText;
    }

    void setHorizontalOffsetWithoutText(@Dimension(unit=1) int offset) {
        this.overridingState.horizontalOffsetWithoutText = offset;
        this.currentState.horizontalOffsetWithoutText = offset;
    }

    @Dimension(unit=1)
    int getVerticalOffsetWithoutText() {
        return this.currentState.verticalOffsetWithoutText;
    }

    void setVerticalOffsetWithoutText(@Dimension(unit=1) int offset) {
        this.overridingState.verticalOffsetWithoutText = offset;
        this.currentState.verticalOffsetWithoutText = offset;
    }

    @Dimension(unit=1)
    int getHorizontalOffsetWithText() {
        return this.currentState.horizontalOffsetWithText;
    }

    void setHorizontalOffsetWithText(@Dimension(unit=1) int offset) {
        this.overridingState.horizontalOffsetWithText = offset;
        this.currentState.horizontalOffsetWithText = offset;
    }

    @Dimension(unit=1)
    int getVerticalOffsetWithText() {
        return this.currentState.verticalOffsetWithText;
    }

    void setVerticalOffsetWithText(@Dimension(unit=1) int offset) {
        this.overridingState.verticalOffsetWithText = offset;
        this.currentState.verticalOffsetWithText = offset;
    }

    @Dimension(unit=1)
    int getLargeFontVerticalOffsetAdjustment() {
        return this.currentState.largeFontVerticalOffsetAdjustment;
    }

    void setLargeFontVerticalOffsetAdjustment(@Dimension(unit=1) int offsetAdjustment) {
        this.overridingState.largeFontVerticalOffsetAdjustment = offsetAdjustment;
        this.currentState.largeFontVerticalOffsetAdjustment = offsetAdjustment;
    }

    @Dimension(unit=1)
    int getAdditionalHorizontalOffset() {
        return this.currentState.additionalHorizontalOffset;
    }

    void setAdditionalHorizontalOffset(@Dimension(unit=1) int offset) {
        this.overridingState.additionalHorizontalOffset = offset;
        this.currentState.additionalHorizontalOffset = offset;
    }

    @Dimension(unit=1)
    int getAdditionalVerticalOffset() {
        return this.currentState.additionalVerticalOffset;
    }

    void setAdditionalVerticalOffset(@Dimension(unit=1) int offset) {
        this.overridingState.additionalVerticalOffset = offset;
        this.currentState.additionalVerticalOffset = offset;
    }

    CharSequence getContentDescriptionForText() {
        return this.currentState.contentDescriptionForText;
    }

    void setContentDescriptionForText(CharSequence contentDescription) {
        this.overridingState.contentDescriptionForText = contentDescription;
        this.currentState.contentDescriptionForText = contentDescription;
    }

    CharSequence getContentDescriptionNumberless() {
        return this.currentState.contentDescriptionNumberless;
    }

    void setContentDescriptionNumberless(CharSequence contentDescriptionNumberless) {
        this.overridingState.contentDescriptionNumberless = contentDescriptionNumberless;
        this.currentState.contentDescriptionNumberless = contentDescriptionNumberless;
    }

    @PluralsRes
    int getContentDescriptionQuantityStrings() {
        return this.currentState.contentDescriptionQuantityStrings;
    }

    void setContentDescriptionQuantityStringsResource(@PluralsRes int stringsResource) {
        this.overridingState.contentDescriptionQuantityStrings = stringsResource;
        this.currentState.contentDescriptionQuantityStrings = stringsResource;
    }

    @StringRes
    int getContentDescriptionExceedsMaxBadgeNumberStringResource() {
        return this.currentState.contentDescriptionExceedsMaxBadgeNumberRes;
    }

    void setContentDescriptionExceedsMaxBadgeNumberStringResource(@StringRes int stringsResource) {
        this.overridingState.contentDescriptionExceedsMaxBadgeNumberRes = stringsResource;
        this.currentState.contentDescriptionExceedsMaxBadgeNumberRes = stringsResource;
    }

    Locale getNumberLocale() {
        return this.currentState.numberLocale;
    }

    void setNumberLocale(Locale locale) {
        this.overridingState.numberLocale = locale;
        this.currentState.numberLocale = locale;
    }

    boolean isAutoAdjustedToGrandparentBounds() {
        return this.currentState.autoAdjustToWithinGrandparentBounds;
    }

    void setAutoAdjustToGrandparentBounds(boolean autoAdjustToGrandparentBounds) {
        this.overridingState.autoAdjustToWithinGrandparentBounds = autoAdjustToGrandparentBounds;
        this.currentState.autoAdjustToWithinGrandparentBounds = autoAdjustToGrandparentBounds;
    }

    private static int readColorFromAttributes(Context context, @NonNull TypedArray a, @StyleableRes int index) {
        return MaterialResources.getColorStateList(context, a, index).getDefaultColor();
    }

    public static final class State
    implements Parcelable {
        private static final int BADGE_NUMBER_NONE = -1;
        private static final int NOT_SET = -2;
        @XmlRes
        private int badgeResId;
        @ColorInt
        private Integer backgroundColor;
        @ColorInt
        private Integer badgeTextColor;
        @StyleRes
        private Integer badgeTextAppearanceResId;
        @StyleRes
        private Integer badgeShapeAppearanceResId;
        @StyleRes
        private Integer badgeShapeAppearanceOverlayResId;
        @StyleRes
        private Integer badgeWithTextShapeAppearanceResId;
        @StyleRes
        private Integer badgeWithTextShapeAppearanceOverlayResId;
        private int alpha = 255;
        @Nullable
        private String text;
        private int number = -2;
        private int maxCharacterCount = -2;
        private int maxNumber = -2;
        private Locale numberLocale;
        @Nullable
        private CharSequence contentDescriptionForText;
        @Nullable
        private CharSequence contentDescriptionNumberless;
        @PluralsRes
        private int contentDescriptionQuantityStrings;
        @StringRes
        private int contentDescriptionExceedsMaxBadgeNumberRes;
        private Integer badgeGravity;
        private Boolean isVisible = true;
        @Px
        private Integer badgeHorizontalPadding;
        @Px
        private Integer badgeVerticalPadding;
        @Dimension(unit=1)
        private Integer horizontalOffsetWithoutText;
        @Dimension(unit=1)
        private Integer verticalOffsetWithoutText;
        @Dimension(unit=1)
        private Integer horizontalOffsetWithText;
        @Dimension(unit=1)
        private Integer verticalOffsetWithText;
        @Dimension(unit=1)
        private Integer additionalHorizontalOffset;
        @Dimension(unit=1)
        private Integer additionalVerticalOffset;
        @Dimension(unit=1)
        private Integer largeFontVerticalOffsetAdjustment;
        private Boolean autoAdjustToWithinGrandparentBounds;
        public static final Parcelable.Creator<State> CREATOR = new Parcelable.Creator<State>(){

            @NonNull
            public State createFromParcel(@NonNull Parcel in) {
                return new State(in);
            }

            @NonNull
            public State[] newArray(int size) {
                return new State[size];
            }
        };

        public State() {
        }

        State(@NonNull Parcel in) {
            this.badgeResId = in.readInt();
            this.backgroundColor = (Integer)in.readSerializable();
            this.badgeTextColor = (Integer)in.readSerializable();
            this.badgeTextAppearanceResId = (Integer)in.readSerializable();
            this.badgeShapeAppearanceResId = (Integer)in.readSerializable();
            this.badgeShapeAppearanceOverlayResId = (Integer)in.readSerializable();
            this.badgeWithTextShapeAppearanceResId = (Integer)in.readSerializable();
            this.badgeWithTextShapeAppearanceOverlayResId = (Integer)in.readSerializable();
            this.alpha = in.readInt();
            this.text = in.readString();
            this.number = in.readInt();
            this.maxCharacterCount = in.readInt();
            this.maxNumber = in.readInt();
            this.contentDescriptionForText = in.readString();
            this.contentDescriptionNumberless = in.readString();
            this.contentDescriptionQuantityStrings = in.readInt();
            this.badgeGravity = (Integer)in.readSerializable();
            this.badgeHorizontalPadding = (Integer)in.readSerializable();
            this.badgeVerticalPadding = (Integer)in.readSerializable();
            this.horizontalOffsetWithoutText = (Integer)in.readSerializable();
            this.verticalOffsetWithoutText = (Integer)in.readSerializable();
            this.horizontalOffsetWithText = (Integer)in.readSerializable();
            this.verticalOffsetWithText = (Integer)in.readSerializable();
            this.largeFontVerticalOffsetAdjustment = (Integer)in.readSerializable();
            this.additionalHorizontalOffset = (Integer)in.readSerializable();
            this.additionalVerticalOffset = (Integer)in.readSerializable();
            this.isVisible = (Boolean)in.readSerializable();
            this.numberLocale = (Locale)in.readSerializable();
            this.autoAdjustToWithinGrandparentBounds = (Boolean)in.readSerializable();
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(@NonNull Parcel dest, int flags) {
            dest.writeInt(this.badgeResId);
            dest.writeSerializable((Serializable)this.backgroundColor);
            dest.writeSerializable((Serializable)this.badgeTextColor);
            dest.writeSerializable((Serializable)this.badgeTextAppearanceResId);
            dest.writeSerializable((Serializable)this.badgeShapeAppearanceResId);
            dest.writeSerializable((Serializable)this.badgeShapeAppearanceOverlayResId);
            dest.writeSerializable((Serializable)this.badgeWithTextShapeAppearanceResId);
            dest.writeSerializable((Serializable)this.badgeWithTextShapeAppearanceOverlayResId);
            dest.writeInt(this.alpha);
            dest.writeString(this.text);
            dest.writeInt(this.number);
            dest.writeInt(this.maxCharacterCount);
            dest.writeInt(this.maxNumber);
            dest.writeString(this.contentDescriptionForText != null ? this.contentDescriptionForText.toString() : null);
            dest.writeString(this.contentDescriptionNumberless != null ? this.contentDescriptionNumberless.toString() : null);
            dest.writeInt(this.contentDescriptionQuantityStrings);
            dest.writeSerializable((Serializable)this.badgeGravity);
            dest.writeSerializable((Serializable)this.badgeHorizontalPadding);
            dest.writeSerializable((Serializable)this.badgeVerticalPadding);
            dest.writeSerializable((Serializable)this.horizontalOffsetWithoutText);
            dest.writeSerializable((Serializable)this.verticalOffsetWithoutText);
            dest.writeSerializable((Serializable)this.horizontalOffsetWithText);
            dest.writeSerializable((Serializable)this.verticalOffsetWithText);
            dest.writeSerializable((Serializable)this.largeFontVerticalOffsetAdjustment);
            dest.writeSerializable((Serializable)this.additionalHorizontalOffset);
            dest.writeSerializable((Serializable)this.additionalVerticalOffset);
            dest.writeSerializable((Serializable)this.isVisible);
            dest.writeSerializable((Serializable)this.numberLocale);
            dest.writeSerializable((Serializable)this.autoAdjustToWithinGrandparentBounds);
        }
    }
}

