/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.behavior;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import androidx.annotation.Dimension;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.google.android.material.R;
import com.google.android.material.animation.AnimationUtils;
import com.google.android.material.motion.MotionUtils;
import java.util.LinkedHashSet;

public class HideBottomViewOnScrollBehavior<V extends View>
extends CoordinatorLayout.Behavior<V> {
    @NonNull
    private final LinkedHashSet<OnScrollStateChangedListener> onScrollStateChangedListeners = new LinkedHashSet();
    private static final int DEFAULT_ENTER_ANIMATION_DURATION_MS = 225;
    private static final int DEFAULT_EXIT_ANIMATION_DURATION_MS = 175;
    private static final int ENTER_ANIM_DURATION_ATTR = R.attr.motionDurationLong2;
    private static final int EXIT_ANIM_DURATION_ATTR = R.attr.motionDurationMedium4;
    private static final int ENTER_EXIT_ANIM_EASING_ATTR = R.attr.motionEasingEmphasizedInterpolator;
    private int enterAnimDuration;
    private int exitAnimDuration;
    private TimeInterpolator enterAnimInterpolator;
    private TimeInterpolator exitAnimInterpolator;
    public static final int STATE_SCROLLED_DOWN = 1;
    public static final int STATE_SCROLLED_UP = 2;
    private int height = 0;
    @ScrollState
    private int currentState = 2;
    private int additionalHiddenOffsetY = 0;
    @Nullable
    private ViewPropertyAnimator currentAnimator;

    public HideBottomViewOnScrollBehavior() {
    }

    public HideBottomViewOnScrollBehavior(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    public boolean onLayoutChild(@NonNull CoordinatorLayout parent, @NonNull V child, int layoutDirection) {
        ViewGroup.MarginLayoutParams paramsCompat = (ViewGroup.MarginLayoutParams)child.getLayoutParams();
        this.height = child.getMeasuredHeight() + paramsCompat.bottomMargin;
        this.enterAnimDuration = MotionUtils.resolveThemeDuration(child.getContext(), ENTER_ANIM_DURATION_ATTR, 225);
        this.exitAnimDuration = MotionUtils.resolveThemeDuration(child.getContext(), EXIT_ANIM_DURATION_ATTR, 175);
        this.enterAnimInterpolator = MotionUtils.resolveThemeInterpolator(child.getContext(), ENTER_EXIT_ANIM_EASING_ATTR, AnimationUtils.LINEAR_OUT_SLOW_IN_INTERPOLATOR);
        this.exitAnimInterpolator = MotionUtils.resolveThemeInterpolator(child.getContext(), ENTER_EXIT_ANIM_EASING_ATTR, AnimationUtils.FAST_OUT_LINEAR_IN_INTERPOLATOR);
        return super.onLayoutChild(parent, child, layoutDirection);
    }

    public void setAdditionalHiddenOffsetY(@NonNull V child, @Dimension int offset) {
        this.additionalHiddenOffsetY = offset;
        if (this.currentState == 1) {
            child.setTranslationY((float)(this.height + this.additionalHiddenOffsetY));
        }
    }

    @Override
    public boolean onStartNestedScroll(@NonNull CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View directTargetChild, @NonNull View target, int nestedScrollAxes, int type) {
        return nestedScrollAxes == 2;
    }

    @Override
    public void onNestedScroll(CoordinatorLayout coordinatorLayout, @NonNull V child, @NonNull View target, int dxConsumed, int dyConsumed, int dxUnconsumed, int dyUnconsumed, int type, @NonNull int[] consumed) {
        if (dyConsumed > 0) {
            this.slideDown(child);
        } else if (dyConsumed < 0) {
            this.slideUp(child);
        }
    }

    public boolean isScrolledUp() {
        return this.currentState == 2;
    }

    public void slideUp(@NonNull V child) {
        this.slideUp(child, true);
    }

    public void slideUp(@NonNull V child, boolean animate) {
        if (this.isScrolledUp()) {
            return;
        }
        if (this.currentAnimator != null) {
            this.currentAnimator.cancel();
            child.clearAnimation();
        }
        this.updateCurrentState(child, 2);
        int targetTranslationY = 0;
        if (animate) {
            this.animateChildTo(child, targetTranslationY, this.enterAnimDuration, this.enterAnimInterpolator);
        } else {
            child.setTranslationY((float)targetTranslationY);
        }
    }

    public boolean isScrolledDown() {
        return this.currentState == 1;
    }

    public void slideDown(@NonNull V child) {
        this.slideDown(child, true);
    }

    public void slideDown(@NonNull V child, boolean animate) {
        if (this.isScrolledDown()) {
            return;
        }
        if (this.currentAnimator != null) {
            this.currentAnimator.cancel();
            child.clearAnimation();
        }
        this.updateCurrentState(child, 1);
        int targetTranslationY = this.height + this.additionalHiddenOffsetY;
        if (animate) {
            this.animateChildTo(child, targetTranslationY, this.exitAnimDuration, this.exitAnimInterpolator);
        } else {
            child.setTranslationY((float)targetTranslationY);
        }
    }

    private void updateCurrentState(@NonNull V child, @ScrollState int state) {
        this.currentState = state;
        for (OnScrollStateChangedListener listener2 : this.onScrollStateChangedListeners) {
            listener2.onStateChanged((View)child, this.currentState);
        }
    }

    private void animateChildTo(@NonNull V child, int targetY, long duration, TimeInterpolator interpolator2) {
        this.currentAnimator = child.animate().translationY((float)targetY).setInterpolator(interpolator2).setDuration(duration).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                HideBottomViewOnScrollBehavior.this.currentAnimator = null;
            }
        });
    }

    public void addOnScrollStateChangedListener(@NonNull OnScrollStateChangedListener listener2) {
        this.onScrollStateChangedListeners.add(listener2);
    }

    public void removeOnScrollStateChangedListener(@NonNull OnScrollStateChangedListener listener2) {
        this.onScrollStateChangedListeners.remove(listener2);
    }

    public void clearOnScrollStateChangedListeners() {
        this.onScrollStateChangedListeners.clear();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static @interface ScrollState {
    }

    public static interface OnScrollStateChangedListener {
        public void onStateChanged(@NonNull View var1, @ScrollState int var2);
    }
}

